/*
  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer
 
  $Id: mutex.h,v 1.7 2004/06/21 09:34:35 taku-ku Exp $;

  Copyright (C) 2001-2004 Taku Kudo <taku-ku@is.aist-nara.ac.jp>
  This is free software with ABSOLUTELY NO WARRANTY.
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/  
#ifndef _MECAB_MUTEX_H
#define _MECAB_MUTEX_H

#include <string>
#include <stdexcept>
#include <iostream>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef MECAB_USE_MUTEX_LOCK 
#ifdef HAVE_PTHREAD_H
#define _USE_PTHREAD_MUTEX
#include <pthread.h>
#else
#if defined (_WIN32) && !defined (__CYGWIN__)
#ifdef HAVE_WINDOWS_H
#include <windows.h>
#endif
#define _USE_WINDOWS_MUTEX
#endif
#endif
#endif

namespace MeCab {
  
  class Mutex {

   private:
#ifdef _USE_PTHREAD_MUTEX
    pthread_mutex_t mutex;
#else
#ifdef _USE_WINDOWS_MUTEX
    CRITICAL_SECTION mutex;
#endif
#endif     
  std::string _what;

  public:
    const char *what () { return _what.c_str(); };

#ifdef _USE_PTHREAD_MUTEX      
    Mutex ()       { pthread_mutex_init (&mutex, NULL); }
   ~Mutex ()       { unlock (); }
    bool lock ()   { pthread_mutex_lock   (&mutex); return true; }
    bool unlock () { pthread_mutex_unlock (&mutex); return true; }
#else
#ifdef _USE_WINDOWS_MUTEX
    Mutex ()       { InitializeCriticalSection(&mutex); }
    ~Mutex ()      { unlock (); DeleteCriticalSection (&mutex);    }
    bool lock ()   { EnterCriticalSection (&mutex); return true; }
    bool unlock () { LeaveCriticalSection (&mutex); return true; }
#else
    Mutex () { _what = "Mutex::Mutex():  Mutex does not run on this machine"; };
    ~Mutex () {};
    bool lock ()   { return false; }
    bool unlock () { return false; }
#endif
#endif
  };
}

#endif
