/*
 *	$Id: kik_unistd.c,v 1.3 2003/07/17 10:56:06 seiichi Exp $
 */

#include  "kik_unistd.h"

#include  <time.h>
#include  <unistd.h>	/* select */

#ifdef  USE_WIN32API
#include  <windows.h>
#endif

/* --- global functions --- */

#ifndef  HAVE_USLEEP

int
__kik_usleep(
	u_int  microseconds
	)
{
#ifndef USE_WIN32API
	struct timeval  tval ;
	
	tval.tv_usec = microseconds % 1000000 ;
	tval.tv_sec = microseconds / 1000000 ;

	if( select( 0 , NULL , NULL , NULL , &tval) == 0)
	{
		return  0 ;
	}
	else
	{
		return  -1 ;
	}
#else
	Sleep(microseconds / 1000);
	return  0 ;
#endif /* USE_WIN32API */
}

#endif

#ifndef  HAVE_UNSETENV

void
__kik_unsetenv(
	char *  name
	)
{
}

#endif
