/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: datatype.c,v 1.13 2004/08/27 18:32:53 ostborn Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "config.h"
#include "mdatatypes.h"
#include "datatype.h"

/* begin of Netmask */

int mdata_Netmask_to_xml(gzFile *d, mdata *data) {
/*
 * #define WR(x,f) \
 *	fprintf(fd, "<%s>%"#f"</%s>\n", #x, data->data.netmask.x, #x);
 *
 *      WR(count, d);
 *      WR(grouped, d);
 * #undef WR
 */
	return 0;
}

int mdata_Netmask_free(mdata *data) {
	if (!data) return -1;
	if (data->type != M_DATA_TYPE_NETMASK) return -1;

	return 0;
}



int mdata_Netmask_setdata(mdata *data, const char *str,
			  unsigned int net_id,
			  unsigned long hostmask,
			  unsigned long netmask) {

	data->key = str;
	assert(data->key);

	if (data->type == M_DATA_TYPE_UNSET)
		data->type		= M_DATA_TYPE_NETMASK;

	data->data.netmask.id	        = net_id;
	data->data.netmask.hostmask	= hostmask;
	data->data.netmask.netmask	= netmask;

	return 0;
}

int mdata_Netmask_from_xml(void *user_data, int tagtype, const xmlChar *value, const xmlChar **attrs) {
#if 0
	long id = 0, hostmask = 0, netmask = 0;
	int i;

	/* add your definitions here */
	const mdata_values data_values[] = {
		{ "id", M_DATA_FIELDTYPE_LONG },
		{ "hostmask", M_DATA_FIELDTYPE_LONG },
		{ "netmask", M_DATA_FIELDTYPE_LONG },

		{ NULL, M_DATA_FIELDTYPE_UNSET }
	};

#endif
	return 0;
}



int mdata_Netmask_append(mdata *dst, mdata *src) {
	fprintf(stderr, "%s.%d: (netmask) abstract function 'append' !!\n", __FILE__, __LINE__);

	return 0;
}

mdata *mdata_Netmask_init() {
	mdata *data = mdata_init();
	assert(data);

	data->key		= NULL;
	data->type		= M_DATA_TYPE_NETMASK;

#ifdef DEBUG_DATATYPES
	fprintf(stderr, "%s.%d: got %ld (%d)\n", __FILE__, __LINE__, data->id, data->type);
#endif
/* init specifics */

	data->data.netmask.id        	= 0;
	data->data.netmask.hostmask	= 0;
	data->data.netmask.netmask	= 0;

	return data;
}

mdata *mdata_Netmask_copy(mdata *src) {
	mdata *data = mdata_Netmask_init();
	assert(data);

	fprintf(stderr, "%s.%d: (netmask) abstract function 'copy' !!\n", __FILE__, __LINE__);

/*
	mdata_Netmask_setdata(data, src->key, src->data.netmask.count, src->data.netmask.grouped);
*/
	return data;
}

mdata *mdata_Netmask_create(const char *str,
			    unsigned int net_id,
			    unsigned long hostmask,
			    unsigned long netmask) {

	mdata *data = mdata_Netmask_init();
	assert(data);
	mdata_Netmask_setdata(data, str, net_id, hostmask, netmask);

	return data;
}

/* end of Netmask */
