/*
 * Multi Gnome Terminal, 
 * (C) 2000 The Free Software Foundation 
 * using 
 * Michael Zucchi's zvt widget and 
 * Gnome Terminal sources
 * (C) 1998, 1999 The Free Software Foundation
 * 
 *
 * Multi Gnome Terminal author:
 *          De Michele Cristiano
 *
 * A NOTE ABOUT MULTIGNOMETERMINAL: 
 *   MultiGnomeTerminal development was started by De Michele Cristiano 
 *   on 03/08/2001 modifying gnome-core-1.4.0.4 sources of gnome-terminal.
 * 
 * Gnome Terminal authors:
 *          Miguel de Icaza (GNOME terminal)
 *          Erik Troan      (various configuration enhancements)
 *          Michael Zucchi  (zvt widget, various updates and enhancements)
 *
 * 
 * Other contributors of gnome-terminal: George Lebl, Jeff Garzik, Jay Painter,
 * Christopher Blizzard, Jens Lautenbacher, Tom Tromey, Tristan Tarant,
 * Jonathan Blandford, Cody Russell, Nat Friedman, Jacob Berkman,
 * John Harper, and Hans-Andreas Engel
 */
#include "mgt.h"

/* define to 'x' to enable copious debug of this module */
#define d(x)  
#define rd(x)   
#define rrd(x) 
#define rrrd(x)  
/* In case old gnome-libs */
#ifndef ZVT_TERM_DO_LASTLOG
#   define ZVT_TERM_DO_LASTLOG 4
#endif
void gtk_flush_all_events(void);
extern struct splitw_t {
  GtkWidget* term_to_split;
  int type;  
} splitw;


extern void free_classlist(GList *cl);
extern GList *winclass_list(void);
extern GList *tabclass_list(void);

extern void tb_new_shell(GtkWidget* w, GSList** ptl);
extern void tb_new_root(GtkWidget* w, GSList** ptl);
extern void tb_new_mc(GtkWidget* w, GSList** ptl);
extern void tb_remove_book(GtkWidget *w, GSList** ptl);
extern void tb_change_title(GtkWidget* w, GSList** ptl);
extern void tb_tab_right(GtkWidget* w, GSList** ptl);
extern void tb_tab_left(GtkWidget* w, GSList** ptl);
extern void tb_remove_book(GtkWidget *w, GSList** ptl);
extern void tb_change_title(GtkWidget* w, GSList** ptl);
extern void ok_close_app(GtkWidget* app);
extern void free_str_array(char** ptr);
extern void edit_commands(GtkWidget* w, gpointer data);
extern void edit_keybindings(GtkWidget* w, gpointer data);
extern void set_titles (GtkWidget *app, int from_page, int to_page);
void rebuild_menubar_from_arrays(GnomeApp* app);
void set_hints (GtkWidget *widget);


extern ZvtTerm* current_term(GSList** p_term_list);
void update_prefs(preferences_t* prefs, struct terminal_config* cfg);

/* The program environment */
extern char **environ;		

/* Initial geometry */
char *initial_global_geometry = NULL;
extern int flush_disabled;

/* Window icon */
/*static char *window_icon = GNOME_ICONDIR"/mgt/multignometerm.png";*/

char **env;
/* is there pixmap compiled into zvt */
gboolean zvt_pixmap_support = FALSE;

/* small hack? whether they specified --login 
   or --nologin on the command line */
gboolean cmdline_login;


/* Initial command */
char **initial_command = NULL;

/* This is the terminal associated with the initial command, or NULL
   if there isn't one.  */
GtkWidget *initial_term = NULL;

/* A list of all the open terminals */
GList *terminals = 0;

int use_terminal_factory   = FALSE;
int start_terminal_factory = FALSE;

/* current new terminal window id */
static int terminal_id = 0;

/*
 * These are the indices for the toggle items in the popup menu.  If
 * you change the popup menus, these macros MUST be updated to reflect
 * the changes.
 */
#define POPUP_MENU_INDEX_COMMANDS 3 
#define POPUP_MENU_TOGGLE_INDEX_BONDED 12
#define POPUP_MENU_TOGGLE_INDEX_MENUBAR 13 
#define POPUP_MENU_TOGGLE_INDEX_TOOLBAR 14
#define POPUP_MENU_TOGGLE_INDEX_BUTTONBAR 15

#define POPUP_MENU_TOGGLE_INDEX_SECURE  16
/* eek, multi-conditaional for backward compatability *sigh* */
#ifdef ZVT_TERM_MATCH_SUPPORT
# ifdef HAVE_ZVT_TERM_RESET
#  define POPUP_MENU_DYNAMIC_INDEX 19 
#  define POPUP_MENU_LAST_INDEX 20
# else
#  define POPUP_MENU_DYNAMIC_INDEX 17
#  define POPUP_MENU_LAST_INDEX 18
# endif
#endif

/*
 * Exported interfaces, for Gtk modules that hook
 * into the gnome terminal
 */
void close_window_cmd   (void *unused, GSList **p_term_list);
void save_preferences_cmd (gchar *prefix, struct terminal_config* cfg);
void color_cmd            (void);
void toggle_menubar_cmd   (GtkWidget *widget, GSList **p_term_list);
void toggle_toolbar_cmd   (GtkWidget *widget, GSList **p_term_list);
void toggle_buttonbar_cmd   (GtkWidget *widget, GSList **p_term_list);

void paste_cmd            (GtkWidget *widget, GSList **p_term_list);
void preferences_cmd      (GtkWidget *widget, GSList **p_term_list);
void toggle_secure_keyboard_cmd (GtkWidget *w, GSList **p_term_list);

extern GtkWidget *new_window        (char **cmd, struct terminal_config *cfg_in, 
				     struct win_config *wincfg_in,
				     const gchar *geometry, int termid, 
				     char** su_names,
				     char** su_paths, char** su_cmds, 
				     char** su_classes,
				     char* nome_term,
				     char* start_dir);
GtkWidget *new_terminal     (GtkWidget *widget, GSList **p_term_list); 

static void parse_an_arg (poptContext state,
			  enum poptCallbackReason reason,
			  const struct poptOption *opt,
			  const char *arg, void *data);

void set_hints (GtkWidget *widget);
void toggle_app_items(GtkWidget* app, struct win_config* wincfg)
{
  GtkCheckMenuItem* toggle_item;
  toggle_item = GTK_CHECK_MENU_ITEM (gtk_object_get_data(GTK_OBJECT(app), "toggle_menubar"));
  toggle_item->active = !wincfg->menubar_hidden;
  toggle_item = GTK_CHECK_MENU_ITEM (gtk_object_get_data(GTK_OBJECT(app), "toggle_toolbar"));
  toggle_item->active = !wincfg->toolbar_hidden;
  toggle_item = GTK_CHECK_MENU_ITEM (gtk_object_get_data(GTK_OBJECT(app), "toggle_buttonbar"));
  toggle_item->active = !wincfg->buttonbar_hidden;
}

int mgt_get_tty(ZvtTerm* term, char** retpwd)
{

#if defined(HAVE_KVM_H)/* SUNOS */
  return -1;
#elif defined(HAVE_PROCINFO_H)/* AIX */
  return -1;
#else
  char tty[PATH_MAX];
  char proc_path[PATH_MAX+1];
  int linklen=0;

  sprintf(proc_path,"/proc/%ld/fd/1", (long) term->vx->vt.childpid);
  rd(printf("procpath: %s childpid: %ld\n", proc_path, (long) term->vx->vt.childpid));
  if ((linklen=readlink(proc_path, tty, sizeof(tty))) != -1)
    {
      tty[linklen]='\0'; /* readlink does not 0-terminate the string */
      rd(printf("tty: %s\n", tty));
      *retpwd = g_strdup(tty);
      return linklen;
    }
  else
    {
      *retpwd = NULL;
      return -1; 
    }
#endif
}

int mgt_get_cwd(ZvtTerm* term, char** retpwd)
{

#if defined(HAVE_KVM_H)/* SUNOS */
#if 0
  kvm_t *kd;
  struct proc *cur_proc;
  struct user *user;
  int cnt;

  char	u_dbuf[DIRSIZ+1];

  if ((kd=kvm_open(NULL,NULL,NULL,O_RDONLY,NULL))==NULL)
    return -1;

  if (!(cur_proc = kvm_getproc(kd, KERN_PROC_PID, (int)term->vx->vt.childpid), &cnt))
    return -1;
  if (!(user = kvm_getu(kd, cur_proc)))
    return -1;

  kvm_close(kd);
#endif
  return -1;
#elif defined(HAVE_PROCINFO_H)/* AIX */
  return -1;
#else
  char pwd[PATH_MAX];
  char proc_path[PATH_MAX+1];
  int linklen=0;

  sprintf(proc_path,"/proc/%ld/cwd", (long) term->vx->vt.childpid);
  rd(printf("procpath: %s\n", proc_path));
  if ((linklen=readlink(proc_path, pwd, sizeof(pwd))) != -1)
    {
      rd(printf("pwd: %s\n", pwd));
      pwd[linklen]='\0'; /* readlink does not 0-terminate the string */
      *retpwd = g_strdup(pwd);
      return linklen;
    }
  else
    {
      *retpwd = NULL;
      return -1; 
    }
#endif
}
const char *NONE_CMD="\tNone\t";

/* 06/12/01 Added save/restore all tabs */
void save_tabs(char* prefix, GtkWidget* app)
{
  gchar **bak_cmds, **bak_cmds_names, *cmd, *cmd_name, **bak_cmds_paths, 
  **bak_cmds_classes, *cmd_path, *cmd_class;
  GtkWidget* term, *tab;
  int n, ptl_len;
  struct terminal_config* cfg;
  GSList** plist, *tl, **tablist, **tab_terms, *tt;
  
  gnome_config_push_prefix(prefix);
  plist = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  tablist = gtk_object_get_data(GTK_OBJECT(app), "tablist");
  tl = *tablist; 
  ptl_len = g_slist_length(*plist);
  bak_cmds = malloc(sizeof(char*)*(ptl_len+1));
  bak_cmds_names = malloc(sizeof(char*)*(ptl_len+1));
  bak_cmds_paths = malloc(sizeof(char*)*(ptl_len+1));
  bak_cmds_classes = malloc(sizeof(char*)*(ptl_len+1));
  n = 0;
  while(tl)
    {
      tab = GTK_WIDGET(tl->data);
      tab_terms = gtk_object_get_data(GTK_OBJECT(tab), "tab_terms");
      tt = *tab_terms;
      while (tt)
	{
	  term = GTK_WIDGET(tt->data);
	  if (ZVT_TERM(term)->view_of)
	    {
	      tt=tt->next;
	      continue;
	    }
	  cmd = gtk_object_get_data(GTK_OBJECT(term), "start_cmd");
	  cmd_path = gtk_object_get_data(GTK_OBJECT(term), "startpath");	
	  cmd_name = gtk_object_get_data(GTK_OBJECT(term), "mtermname");
	  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
	  cmd_class = cfg->class;
	  if (cmd)
	    bak_cmds[n] = g_strdup(cmd);
	  else
	    bak_cmds[n] = g_strdup(NONE_CMD);
	  
	  bak_cmds_names[n] = g_strdup(cmd_name);
	  /* Sonny2k: smart path saving: in linux systems save current path */
	  if (mgt_get_cwd(ZVT_TERM(term), &(bak_cmds_paths[n]))==-1)
	    bak_cmds_paths[n] = g_strdup(cmd_path);
	  bak_cmds_classes[n] = g_strdup(cmd_class); 
	  tt = tt->next;
	  n++;
	}
      tl=tl->next;
    }
  bak_cmds[n] = NULL;
  bak_cmds_names[n] = NULL;
  bak_cmds_paths[n] = NULL;
  bak_cmds_classes[n] = NULL; 
  gnome_config_set_vector("bak_cmds", n, (const char* const*) bak_cmds);
  gnome_config_set_vector("bak_cmds_names", n, (const char* const*) bak_cmds_names);
  gnome_config_set_vector("bak_cmds_paths", n, (const char* const*) bak_cmds_paths);
  gnome_config_set_vector("bak_cmds_classes", n, (const char* const*) bak_cmds_classes);
  gnome_config_sync ();
  gnome_config_pop_prefix ();
  /* check this */
  free_str_array(bak_cmds);
  free_str_array(bak_cmds_names);
  free_str_array(bak_cmds_paths);
  free_str_array(bak_cmds_classes);
}
struct terminal_config * load_config (char *class);

void set_all_undefined(GSList** ptl);
void safe_cmd_vector(char*** no, char ***pa, char***co, char ***cl, int n);
void
new_term_in_window(char** cmd, struct terminal_config *cfg_in, const gchar *geometry, int termid, GSList** p_term_list, char* nome_term, char* start_dir);
char** vector_dup(char** v);
  struct terminal_config * terminal_config_dup (struct terminal_config *cfg);
void terminal_config_free(struct terminal_config *cfg);

GtkWidget* load_tabs(gchar *prefix, 
		     char **cmd, struct terminal_config *cfg, 
		     struct win_config *wincfg,
		     const gchar *geometry, int termid)

{
  gchar** bak_cmds, **bak_cmds_names, **bak_cmds_paths, **bak_cmds_classes,
  **su_names, **su_paths, **su_cmds, *lprefix, **su_classes;
  int n, num_cmds, num_su, num_cmds2, num_su2;
  gchar **ncmd, *term_path;
  GSList** ptl=NULL;
  GtkWidget* app=NULL;
  struct terminal_config *realcfg;

  flush_disabled = 0;
  lprefix = g_strdup_printf("/MultiTerminal/%s/", wincfg->class); 
  gnome_config_push_prefix(lprefix);
  gnome_config_get_vector("su_cmds", &num_su2, &su_cmds);
  gnome_config_get_vector("su_names", &num_su, &su_names);
  gnome_config_get_vector("su_paths", &num_su2, &su_paths); 
  gnome_config_get_vector("su_classes", &num_su2, &su_classes);
  if (!wincfg->window_title) 
    wincfg->window_title = g_strdup("MGT");

  safe_cmd_vector(&su_names, &su_paths, &su_cmds, &su_classes, num_su);

  gnome_config_pop_prefix();
  if (!wincfg->restore_tabs 
      && (wincfg->no_startuptabs || !su_names[0]))
    {
      app = new_window(cmd?vector_dup(cmd):NULL, 
		       cfg, wincfg, geometry, termid, 
		       su_names, su_paths, su_cmds, su_classes,
		       "Shell", NULL);
      geometry = NULL;
      free_str_array(su_cmds);
      free_str_array(su_names);
      free_str_array(su_paths); 
      free_str_array(su_classes);
      flush_disabled = 0;
      return app;
    }

  gnome_config_push_prefix(prefix);

  gnome_config_get_vector("bak_cmds", &num_cmds2, &bak_cmds);
  gnome_config_get_vector("bak_cmds_names", &num_cmds, &bak_cmds_names);
  gnome_config_get_vector("bak_cmds_paths", &num_cmds2, &bak_cmds_paths);
  gnome_config_get_vector("bak_cmds_classes", &num_cmds2, &bak_cmds_classes);
  safe_cmd_vector(&bak_cmds_names, &bak_cmds_paths, &bak_cmds, &bak_cmds_classes, num_cmds);

  gnome_config_pop_prefix(); 

  g_free(lprefix);


  if (bak_cmds_names[0]==NULL && 
      (wincfg->no_startuptabs || su_names[0]==NULL))
    {

      app = new_window(cmd?vector_dup(cmd):NULL, 
		       cfg, wincfg, geometry, termid, 
		       su_names, su_paths, su_cmds, su_classes, "Shell", NULL);

      free_str_array(su_cmds);
      free_str_array(su_names);
      free_str_array(su_paths); 
      free_str_array(su_classes);
      free_str_array(bak_cmds);
      free_str_array(bak_cmds_names);
      free_str_array(bak_cmds_paths); 
      free_str_array(bak_cmds_classes);
      flush_disabled = 0;
      return app;
    }

  if (!wincfg->window_title) 
    wincfg->window_title = g_strdup("MGT");

  if (wincfg->restore_tabs)
    {
      /* now reopen terms, possibly re-executing commands */
      n = 0;
      while (bak_cmds_names[n])
	{
	  if (wincfg->restore_commands)
	    {
	      if (!strcmp(bak_cmds[n], NONE_CMD))
		ncmd = NULL;
	      else
		ncmd = g_strsplit(bak_cmds[n], " ", 0);
	      /*printf("eseguo: %s\n", bak_cmds[n]);*/
	    }
	  else if (bak_cmds[n+1]==NULL && cmd)
	    {
	      ncmd = vector_dup(cmd);
	    }	  
	  else
	    ncmd = NULL;
	  if (wincfg->restore_classes && bak_cmds_classes[n] && 
	      strcmp(bak_cmds_classes[n], "None"))
	    {
	      char *tclass;
	      tclass = g_strdup(bak_cmds_classes[n]);
	      prefix = g_strdup_printf("/MultiTerminal/%s/", tclass);
	      gnome_config_push_prefix(prefix);
	      realcfg = load_config(tclass);
	      gnome_config_pop_prefix();
	      g_free(prefix);
	      g_free(tclass);
	    }
	  else
	    realcfg = terminal_config_dup(cfg);
	  if (wincfg->restorepaths)
    	    term_path = bak_cmds_paths[n];
	  else
	    term_path = NULL;
	  if (n==0)
	    {
	      app = new_window(ncmd, realcfg, wincfg, geometry, termid,
			       su_names, su_paths, su_cmds, su_classes,
			       bak_cmds_names[n], term_path);
	      ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
	      /* 
		 w = ZVT_TERM((*ptl)->data)->vx->vt.width;
		 h = ZVT_TERM((*ptl)->data)->vx->vt.height;
		 printf("(%d,%d)\n",w, h );
		 zvt_term_set_size(ZVT_TERM((*ptl)->data), w, h);*/
	    }
	  else
	    {
	      new_term_in_window(ncmd, realcfg, geometry, 1, ptl, bak_cmds_names[n],
				 term_path);
	    }
	  if (realcfg)
	    terminal_config_free(realcfg);
	  if (ncmd)
	    g_strfreev(ncmd);
	  n++;
	}
      /* and now startup tabs */
    }

  if (!wincfg->no_startuptabs)
    {    
      n = 0;
      while (su_names[n])
	{
	  ncmd = g_strsplit(su_cmds[n], " ", 0);
	  if (su_classes[n] && strcmp(su_classes[n], "None"))
	    {
	      char *tclass;
	      if (!strcasecmp(su_classes[n], _("Default")))
	      	tclass = g_strdup("Config");
	      else
		tclass = g_strdup_printf("Class-%s", su_classes[n]);	
	      prefix = g_strdup_printf("/MultiTerminal/%s/", tclass);
	      gnome_config_push_prefix(prefix);
	      realcfg = load_config(tclass);
	      gnome_config_pop_prefix();
	      g_free(prefix);
	      g_free(tclass);
	    }
	  else
	    realcfg = terminal_config_dup(cfg);

	  if (n==0 && !app)
	    {
	      app = new_window(ncmd, realcfg, wincfg, geometry, termid, 
			       su_names, su_paths, su_cmds, su_classes,
			       su_names[n], su_paths[n]);
	      ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
	    }
	  else
	    {
	      new_term_in_window(ncmd, realcfg, geometry, 1, ptl, su_names[n],
				 su_paths[n]);
	    }
	  if (realcfg)
	    terminal_config_free(realcfg);
	  if (ncmd)
	    g_strfreev(ncmd);
	  n++;
	}
    }

  free_str_array(su_cmds);
  free_str_array(su_names);
  free_str_array(su_paths); 
  free_str_array(su_classes);
  free_str_array(bak_cmds);
  free_str_array(bak_cmds_names);
  free_str_array(bak_cmds_paths); 
  free_str_array(bak_cmds_classes);
  geometry = NULL;

#if 0
  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  /*term=GTK_WIDGET((*ptl)->data);
    gtk_widget_grab_focus(GTK_WIDGET(term));*/
  tmp = *ptl;
  pp = 0;
  while(tmp)
    {
      term = GTK_WIDGET(tmp->data);
      GTK_WIDGET_SET_FLAGS(GTK_WIDGET(term), GTK_VISIBLE);
      GTK_WIDGET_SET_FLAGS(GTK_WIDGET(term), GTK_MAPPED);
      /*state = gtk_object_get_data(GTK_OBJECT(term), "term_state");
	new_out = gtk_object_get_data(GTK_OBJECT(term), "new_out");
       *new_out = FALSE;
       *state = UNDEFINED;
       set_tab_label(GTK_NOTEBOOK(nb), ZVT_TERM(term), ptl, UNCHANGED);
       gtk_widget_grab_focus(GTK_WIDGET(term));*/
      tmp = tmp->next;
      pp++;
    }
#endif
  if (!app)
    {
      app = new_window(cmd?vector_dup(cmd):NULL, 
		       cfg, wincfg, geometry, termid, 
		       su_names, su_paths, su_cmds, su_classes, "Shell", NULL);
    }
  flush_disabled = 0;
  gtk_widget_show(app);

  /* CHECK THIS: it might cause resize problems at startup, depending on
   * WM used */
  /*gtk_widget_set_usize(app, app->allocation.width, app->allocation.height);*/
  return app;
}

  static void
about_terminal_cmd (void)
{
  static GtkWidget *about = NULL;

  const gchar *authors[] = {
    N_("Multi Gnome Terminal (MGT) author: "),
    N_("    Cristiano De Michele <demichel@na.infn.it>"),
    N_("Contributors:"), 
    N_("    Guillermo Ontanon <gontanon@dragon-lance.net>"),
    N_("    Soeren Sonnenburg <sonnenburg@informatik.hu-berlin.de>"),
    N_("    Erik Bourget <ebourg@po-box.mcgill.ca>"),
    N_("Documentation:"),
    N_("    Hal Burgiss <hburgiss@foobox.net>"),
    N_("MGT is based on original work by:"),
    N_("    Michael Zucchi <zucchi@zedzone.mmc.com.au> (original zvt widget)"),
    N_("    Miguel de Icaza <miguel@kernel.org> (basic GnomeTerminal)"),
    N_("    Erik Troan <ewt@redhat.com>"),
    NULL
  };

  if (about != NULL)
    {
      gdk_window_show(about->window);
      gdk_window_raise(about->window);
      return;
    }

#ifdef ENABLE_NLS
  authors[0]=_(authors[0]);
  authors[1]=_(authors[1]);
  authors[2]=_(authors[2]);
#endif

  about = gnome_about_new (_("Multi Gnome Terminal"), VERSION,
			   "(C) 2001,2002 Cristiano De Michele",
			   authors,
			   _("The enhanced GNOME terminal emulation program."),
			   NULL);
  gtk_signal_connect (GTK_OBJECT (about), "destroy",
		      GTK_SIGNAL_FUNC (gtk_widget_destroyed), &about);
  gtk_widget_show (about);
}

void terminal_config_free(struct terminal_config* cfg);

#if 0
  static void
close_all_cmd (void)
{
  while (terminals)
    close_window_cmd (0, terminals->data);
}
#endif

/*
 * Keep a copy of the current font name
 */
  void
gnome_term_set_font (ZvtTerm *term, char *font_name, char *boldfont_name,
		     const int use_bold)
{
  char *s;
  GdkFont *font, *boldfont;

  struct terminal_config *cfg;

  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");

  if (cfg->use_fontset)
    {
      font = gdk_fontset_load (font_name);
      boldfont = gdk_fontset_load(boldfont_name);
    }
  else
    {
      font = gdk_font_load (font_name);
      boldfont = gdk_font_load(boldfont_name);
   }
  if (font) {
#ifdef ZVT_TERM_EMBOLDEN_SUPPORT
    if (zvt_term_get_capabilities(term) & ZVT_TERM_EMBOLDEN_SUPPORT &&
	use_bold)
      {
	if (cfg->use_boldfont)
	  zvt_term_set_fonts  (term, font, boldfont);
	else
	  zvt_term_set_fonts  (term, font, 0);

      }
    else
#endif
      zvt_term_set_fonts  (term, font, font);
  }
  s = gtk_object_get_user_data (GTK_OBJECT (term));
  if (s)
    g_free (s);
  gtk_object_set_user_data (GTK_OBJECT (term), g_strdup (font_name));
}

/* This really should be in GTK+
*/
  static gint
option_menu_get_history (GtkOptionMenu *option_menu)
{
  GtkWidget *active_widget;

  g_return_val_if_fail (GTK_IS_OPTION_MENU (option_menu), -1);

  active_widget = gtk_menu_get_active (GTK_MENU (option_menu->menu));

  if (active_widget)
    return g_list_index (GTK_MENU_SHELL (option_menu->menu)->children,
			 active_widget);
  else
    return -1;
}

/* Popular palettes */
gushort linux_red[] = { 0x0000, 0xaaaa, 0x0000, 0xaaaa, 0x0000, 0xaaaa, 0x0000, 0xaaaa,
  0x5555, 0xffff, 0x5555, 0xffff, 0x5555, 0xffff, 0x5555, 0xffff,
  0x0,    0x0 };
gushort linux_grn[] = { 0x0000, 0x0000, 0xaaaa, 0x5555, 0x0000, 0x0000, 0xaaaa, 0xaaaa,
  0x5555, 0x5555, 0xffff, 0xffff, 0x5555, 0x5555, 0xffff, 0xffff,
  0x0,    0x0 };
gushort linux_blu[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa,
  0x5555, 0x5555, 0x5555, 0x5555, 0xffff, 0xffff, 0xffff, 0xffff,
  0x0,    0x0 };

gushort xterm_red[] = { 0x0000, 0x6767, 0x0000, 0x6767, 0x0000, 0x6767, 0x0000, 0x6868,
  0x2a2a, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff,
  0x0,    0x0 };

gushort xterm_grn[] = { 0x0000, 0x0000, 0x6767, 0x6767, 0x0000, 0x0000, 0x6767, 0x6868,
  0x2a2a, 0x0000, 0xffff, 0xffff, 0x0000, 0x0000, 0xffff, 0xffff,
  0x0,    0x0 };
gushort xterm_blu[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0x6767, 0x6767, 0x6767, 0x6868,
  0x2a2a, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff,
  0x0,    0x0 };

gushort rxvt_red[] = { 0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff,
  0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff,
  0x0,    0x0 };
gushort rxvt_grn[] = { 0x0000, 0x0000, 0xffff, 0xffff, 0x0000, 0x0000, 0xffff, 0xffff,
  0x0000, 0x0000, 0xffff, 0xffff, 0x0000, 0x0000, 0xffff, 0xffff,
  0x0,    0x0 };
gushort rxvt_blu[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff,
  0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff,
  0x0,    0x0 };

/* point to the other tables */
gushort *scheme_red[] = { linux_red, xterm_red, rxvt_red, rxvt_red };
gushort *scheme_blue[] = { linux_blu, xterm_blu, rxvt_blu, rxvt_blu };
gushort *scheme_green[] = { linux_grn, xterm_grn, rxvt_grn, rxvt_grn };

  void
set_color_scheme (ZvtTerm *term, struct terminal_config *color_cfg) 
{
  GdkColor c;
  gushort red[20],green[20],blue[20];
  int i;
  gushort *r, *b, *g;

  switch (color_cfg->color_type){
  default:		/* and 0 */
    color_cfg->color_type = 0;
  case PALETTE_LINUX:
  case PALETTE_XTERM:
  case PALETTE_RXVT:
    r = scheme_red[color_cfg->color_type];
    g = scheme_green[color_cfg->color_type];
    b = scheme_blue[color_cfg->color_type];
    for (i=0;i<18;i++) {
      red[i] = r[i];
      green[i] = g[i];
      blue[i] = b[i];
    }
    break;
  case PALETTE_CUSTOM:
    for (i=0;i<18;i++) {
      red[i] = color_cfg->palette[i].red;
      green[i] = color_cfg->palette[i].green;
      blue[i] = color_cfg->palette[i].blue;
    }
    break;
  }

  switch (color_cfg->color_set){
    /* White on black */
  case COLORS_WHITE_ON_BLACK:
    red   [16] = red [7];
    blue  [16] = blue [7];
    green [16] = green [7];
    red   [17] = red [0];
    blue  [17] = blue [0];
    green [17] = green [0];
    break;

    /* black on white */
  case COLORS_BLACK_ON_WHITE:
    red   [16] = red [0];
    blue  [16] = blue [0];
    green [16] = green [0];
    red   [17] = red [7];
    blue  [17] = blue [7];
    green [17] = green [7];
    break;

    /* Green on black */
  case COLORS_GREEN_ON_BLACK:
    red   [17] = 0;
    green [17] = 0;
    blue  [17] = 0;
    red   [16] = 0;
    green [16] = 0xffff;
    blue  [16] = 0;
    break;

    /* Black on light yellow */
  case COLORS_BLACK_ON_LIGHT_YELLOW:
    red   [16] = 0;
    green [16] = 0;
    blue  [16] = 0;
    red   [17] = 0xffff;
    green [17] = 0xffff;
    blue  [17] = 0xdddd;
    break;

    /* Custom foreground, custom background */
  case COLORS_CUSTOM:
    for (i=16;i<18;i++) {
      red[i] = color_cfg->palette[i].red;
      green[i] = color_cfg->palette[i].green;
      blue[i] = color_cfg->palette[i].blue;
    }
    break;
  }
  /* text shadow */ 
  red[18]   = color_cfg->palette[18].red;
  green[18] = color_cfg->palette[18].green;
  blue[18]  = color_cfg->palette[18].blue;
  /* color bold */ 
  red[19]   = color_cfg->palette[19].red;
  green[19] = color_cfg->palette[19].green;
  blue[19]  = color_cfg->palette[19].blue;
  zvt_term_set_color_scheme (term, red, green, blue);
  c.pixel = term->colors [17];

  gdk_window_set_background (GTK_WIDGET (term)->window, &c);
  gtk_widget_queue_draw (GTK_WIDGET (term));
}

/* FINIRE!!!! */
extern GdkColor colors[];
extern gint hardset_entries[NUM_HARDSET+1];
struct win_config * 
load_winconfig (char *class)
{
  char *p;
  struct win_config *wincfg = g_malloc (sizeof (*wincfg));
  int colour_count;
  char **colours;
  int i;
  wincfg->class = g_strdup (class);

  p = gnome_config_get_string ("tab_position=top");
  if (g_strcasecmp (p, "bottom") == 0)
    wincfg->tab_position = GTK_POS_BOTTOM;
  else if(g_strcasecmp (p, "right") == 0)
    wincfg->tab_position = GTK_POS_RIGHT;
  else if(g_strcasecmp (p, "left") == 0)
    wincfg->tab_position = GTK_POS_LEFT;
  else
    wincfg->tab_position = GTK_POS_TOP;
  wincfg->tab_hidden = gnome_config_get_bool ("tab_hidden=false");
  wincfg->maxch             = gnome_config_get_int  ("maxch=20");
  wincfg->titled_tabs       = gnome_config_get_bool ("titled_tabs=0");
  wincfg->menubar_hidden = !gnome_config_get_bool ("menubar=true");
  wincfg->toolbar_hidden = !gnome_config_get_bool ("toolbar=false");
  wincfg->buttonbar_hidden = !gnome_config_get_bool ("buttonbar=true");
  wincfg->close_confirm = !gnome_config_get_bool("close_confirm=true");
  wincfg->restore_commands = gnome_config_get_bool("restore_commands=false");
  wincfg->restore_tabs =  gnome_config_get_bool("restore_tabs=false");
  wincfg->no_startuptabs = gnome_config_get_bool("nosutabs=true");
  wincfg->no_numprefix = gnome_config_get_bool("no_numprefix=false");
  wincfg->no_nbborder = gnome_config_get_bool("no_nbborder=false");
  wincfg->window_title =gnome_config_get_string("win_title=MGT");
  wincfg->window_icon = gnome_config_get_string("window_icon=" GNOME_ICONDIR 
						"/mgt/multignometerm.png");

  wincfg->login_shell = gnome_config_get_bool("login_shell=true");
  wincfg->autosavetabs = gnome_config_get_bool("autosavetabs=false");
  wincfg->restorepaths = gnome_config_get_bool("restore_paths=false");
  wincfg->restore_classes=gnome_config_get_bool("restore_classes=false");
  /* ADDED here defaults for notify colors */
  wincfg->palette[0].red = colors[4].red;
  wincfg->palette[0].green = colors[4].green;
  wincfg->palette[0].blue =colors[4].blue;
  wincfg->palette[1].red = colors[12].red;
  wincfg->palette[1].green = colors[12].green;
  wincfg->palette[1].blue = colors[12].blue;
  wincfg->window_id = 0;
  /* load the palette, if none, then 'default' to safe (linux) pallete */
  gnome_config_get_vector("winpalette", &colour_count, &colours);
  for (i=0;i<2;i++) {
    if (i<colour_count)
      gdk_color_parse(colours[i], &wincfg->palette[i]);
  }
  g_free(colours);

  return wincfg;
}


struct terminal_config * 
load_config (char *class)
{
  char *p;
  char *fore_color = NULL;
  char *back_color = NULL;
  struct terminal_config *cfg = g_malloc (sizeof (*cfg));
  int colour_count;
  char **colours;
  int i;
  char* font_key;
  /* It's very odd that these are here */
  cfg->font = NULL;
  cfg->class = g_strdup (class);

  cfg->scrollback = gnome_config_get_int ("scrollbacklines=100");
  /* Translators, translate this font to one that's good for 
   * your language
   */
  font_key = 
    g_strconcat ("font=",
		 _("-*-fixed-medium-r-normal--14-*-*-*-*-*-*-*,*-r-*"), 
		 NULL);
  cfg->font    = gnome_config_get_string (font_key);
  g_free (font_key);
 
  font_key = 
    g_strconcat ("boldfont=",
		 _("-*-fixed-medium-r-normal--14-*-*-*-*-*-*-*,*-r-*"), 
		 NULL);
  cfg->boldfont = gnome_config_get_string (font_key);
  g_free (font_key);
  
  cfg->no_border = gnome_config_get_bool("no_border=true");
  cfg->wordclass  = gnome_config_get_string ("wordclass=-A-Za-z0-9,./?%&#");
  cfg->update_records = 0;
  if (gnome_config_get_bool ("do_utmp=true"))
    cfg->update_records |= ZVT_TERM_DO_UTMP_LOG;
  if (gnome_config_get_bool ("do_wtmp=true"))
    cfg->update_records |= ZVT_TERM_DO_WTMP_LOG;
  if (gnome_config_get_bool ("do_lastlog=true"))
    cfg->update_records |= ZVT_TERM_DO_LASTLOG;
  
  #ifdef SHADING
  cfg->shading = gnome_config_get_int("shading=190");
  cfg->contrast = gnome_config_get_int("contrast=256");
  cfg->gamma = gnome_config_get_int("gamma=256");
  cfg->rtint = gnome_config_get_int("rtint=256");
  cfg->gtint = gnome_config_get_int("gtint=256");
  cfg->btint = gnome_config_get_int("btint=256");
  cfg->tintback = gnome_config_get_bool("tintback=false");
  cfg->adj_contrast = gnome_config_get_bool("adj_contrast=false");
  cfg->gamma_correction = gnome_config_get_bool("gamma_correction=false");
  cfg->image_mode = gnome_config_get_int("image_mode=0");
#endif
  p = gnome_config_get_string ("scrollpos=right");
  if (g_strcasecmp (p, "left") == 0)
    cfg->scrollbar_position = SCROLLBAR_LEFT;
  else if (g_strcasecmp (p, "right") == 0)
    cfg->scrollbar_position = SCROLLBAR_RIGHT;
  else
    cfg->scrollbar_position = SCROLLBAR_HIDDEN;
  p = gnome_config_get_string ("color_scheme=linux");
  if (g_strcasecmp (p, "linux") == 0)
    cfg->color_type = PALETTE_LINUX;
  else if (g_strcasecmp (p, "xterm") == 0)
    cfg->color_type = PALETTE_XTERM;
  else if (g_strcasecmp (p, "rxvt") == 0)
    cfg->color_type = PALETTE_RXVT;
  else if (g_strcasecmp (p, "custom") == 0)
    cfg->color_type = PALETTE_CUSTOM;
  else
    cfg->color_type = PALETTE_LINUX;

  cfg->keyboard_secured  = FALSE;

  cfg->bell              = gnome_config_get_bool ("bell_silenced=0");
  cfg->blink             = gnome_config_get_bool ("blinking=0");
  cfg->swap_keys         = gnome_config_get_bool ("swap_del_and_backspace=0");
#ifdef HAVE_ZVT_DEL_IS_DEL
  cfg->del_is_del        = gnome_config_get_bool ("del_is_del=0");
#endif
  cfg->use_bold          = gnome_config_get_bool ("use_bold=true");
  cfg->use_boldfont      = gnome_config_get_bool ("use_boldfont=false");
  cfg->bold_color        = gnome_config_get_bool ("bold_color=false");
  cfg->use_im            = gnome_config_get_bool ("use_im=false");
  cfg->use_fontset       = gnome_config_get_bool ("use_fontset=false");
  cfg->font_shadow       = gnome_config_get_bool ("font_shadow=false"); 
#ifdef ZVT_BACKGROUND_SCROLL
  cfg->scroll_background = gnome_config_get_bool ("scroll_background=0");
#endif
  /* Default colors in the case the color set is the custom one */
  fore_color = gnome_config_get_string ("foreground=gray");
  back_color = gnome_config_get_string ("background=black");
  cfg->color_set = gnome_config_get_int ("color_set=0");
  /* ====== */
  cfg->scroll_key = gnome_config_get_bool ("scrollonkey=true");
  cfg->scroll_out = gnome_config_get_bool ("scrollonoutput=false");

  cfg->transparent = gnome_config_get_bool ("transparent=false");
  cfg->shaded = gnome_config_get_bool ("shaded=false");
  cfg->background_pixmap = gnome_config_get_bool ("background_pixmap=false");
  cfg->pixmap_file = gnome_config_get_string ("pixmap_file");

  cfg->termname = NULL;

  if (g_strcasecmp (fore_color, back_color) == 0)
    /* don't let them set identical foreground and background colors */
    cfg->color_set = 0;
  else {
    if (!gdk_color_parse (fore_color, &cfg->palette[16])
	|| !gdk_color_parse (back_color, &cfg->palette[17])){
      /* or illegal colors */
      cfg->color_set = 0;
    }
  }
  /* default bold color = default foreground color */
  cfg->palette[19].red = colors[18].red;
  cfg->palette[19].green = colors[18].green;
  cfg->palette[19].blue = colors[18].blue;

  /* shadow */	
  cfg->palette[18].red = colors[1].red;
  cfg->palette[18].green = colors[1].green;
  cfg->palette[18].blue = colors[1].blue;

  /* load the palette, if none, then 'default' to safe (linux) pallete */
  gnome_config_get_vector("palette", &colour_count, &colours);
  for (i=0;i<20;i++) {
    if (i<colour_count)
      gdk_color_parse(colours[i], &cfg->palette[i]);
    else if (i<16) {
      cfg->palette[i].red = linux_red[i];
      cfg->palette[i].green = linux_grn[i];
      cfg->palette[i].blue = linux_blu[i];
    }
  }
  g_free(colours);

  return cfg;
}

void set_styles(struct win_config* cfg);
void set_tab_color (GtkWidget* term);
  static struct win_config *
win_gather_changes (struct win_config* newcfg, GtkWidget* app)
{
  winprefs_t *winprefs;
  gushort r, g, b;
  gchar *p;
  int i;
  winprefs = (winprefs_t*)gtk_object_get_data(GTK_OBJECT(app), "winprefs");
  memset (newcfg, 0, sizeof (*newcfg));
  p = gtk_entry_get_text(GTK_ENTRY(winprefs->maxch)); 
  newcfg->maxch = atoi(p);		       
  newcfg->titled_tabs    = GTK_TOGGLE_BUTTON (winprefs->titled_tabs)->active;
  newcfg->menubar_hidden = GTK_TOGGLE_BUTTON (winprefs->menubar_checkbox)->active;
  /* ADD */
  newcfg->toolbar_hidden = GTK_TOGGLE_BUTTON (winprefs->toolbar_checkbox)->active;
  newcfg->buttonbar_hidden = GTK_TOGGLE_BUTTON (winprefs->buttonbar_checkbox)->active;
  newcfg->close_confirm = GTK_TOGGLE_BUTTON (winprefs->close_dialog_checkbox)->active;
  newcfg->restore_tabs =  GTK_TOGGLE_BUTTON (winprefs->chk_reopentabs)->active;
  newcfg->restore_commands = GTK_TOGGLE_BUTTON(winprefs->chk_restorecmds)->active;
  newcfg->restore_classes = GTK_TOGGLE_BUTTON(winprefs->chk_restoreclasses)->active;
  newcfg->tab_hidden = 0;
  newcfg->restorepaths = GTK_TOGGLE_BUTTON(winprefs->chk_restorepaths)->active;
  newcfg->no_numprefix = GTK_TOGGLE_BUTTON(winprefs->no_numprefix)->active;
  newcfg->autosavetabs = GTK_TOGGLE_BUTTON(winprefs->autosavetabs)->active;
  newcfg->no_nbborder =GTK_TOGGLE_BUTTON(winprefs->no_nbborder)->active;
  newcfg->login_shell = GTK_TOGGLE_BUTTON(winprefs->login_checkbox)->active;

  p = gtk_entry_get_text(GTK_ENTRY(winprefs->tab_position));
  if (g_strcasecmp (p, "bottom") == 0)
    newcfg->tab_position = GTK_POS_BOTTOM;
  else if(g_strcasecmp (p, "right") == 0)
    newcfg->tab_position = GTK_POS_RIGHT;
  else if(g_strcasecmp (p, "left") == 0)
    newcfg->tab_position = GTK_POS_LEFT;
  else if(g_strcasecmp (p, "top") == 0)
    newcfg->tab_position = GTK_POS_TOP;
  else
    newcfg->tab_hidden = 1;
  newcfg->window_title = g_strdup(gtk_entry_get_text(GTK_ENTRY(winprefs->win_title)));

  newcfg->login_shell = GTK_TOGGLE_BUTTON (winprefs->login_checkbox)->active;
  if (!strcasecmp (gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (winprefs->class_box)->entry)),
	       _("Default")))
    newcfg->class = g_strdup ("Win-Config");
  else
    newcfg->class = g_strconcat ("Win-Class-", gtk_entry_get_text 
				 (GTK_ENTRY (GTK_COMBO (winprefs->class_box)->entry)), NULL);

  /* MODIFIED 18->20 */
  for (i=0;i<2;i++) {
    gnome_color_picker_get_i16 (GNOME_COLOR_PICKER (winprefs->palette[i]), &r, &g,
				&b, NULL);
    newcfg->palette[i].red   = r;
    newcfg->palette[i].green = g;
    newcfg->palette[i].blue  = b;
  }

  set_styles(newcfg);	
  return newcfg;
}


  static struct terminal_config *
gather_changes (struct terminal_config* newcfg, GtkWidget* app)
{
  preferences_t *prefs;
  gushort r, g, b;
  int i;
  int sp;
#ifdef SHADING
  GtkAdjustment* adj;
#endif
  prefs = (preferences_t*)gtk_object_get_data(GTK_OBJECT(app), "prefs");
  memset (newcfg, 0, sizeof (*newcfg));
  newcfg->bell           = GTK_TOGGLE_BUTTON (prefs->bell_checkbox)->active;
  newcfg->blink          = GTK_TOGGLE_BUTTON (prefs->blink_checkbox)->active;
  newcfg->swap_keys      = GTK_TOGGLE_BUTTON (prefs->swapkeys_checkbox)->active;
  newcfg->use_im         = GTK_TOGGLE_BUTTON (prefs->use_im_checkbox)->active;
  newcfg->use_fontset    = GTK_TOGGLE_BUTTON (prefs->use_fontset_checkbox)->active;
#ifdef HAVE_ZVT_DEL_IS_DEL
  newcfg->del_is_del     = GTK_TOGGLE_BUTTON (prefs->del_is_del_checkbox)->active;
#endif
  newcfg->font_shadow = GTK_TOGGLE_BUTTON(prefs->font_shadow)->active;

  newcfg->scroll_out     = GTK_TOGGLE_BUTTON (prefs->scroll_out_checkbox)->active;
  newcfg->scroll_key     = GTK_TOGGLE_BUTTON (prefs->scroll_kbd_checkbox)->active;
  newcfg->scrollback = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (prefs->scrollback_spin));
  newcfg->use_bold = GTK_TOGGLE_BUTTON(prefs->use_bold_checkbox)->active;
  newcfg->use_boldfont = GTK_TOGGLE_BUTTON(prefs->use_boldfont)->active;
  newcfg->bold_color = GTK_TOGGLE_BUTTON(prefs->bold_color_checkbox)->active;

  newcfg->transparent = GTK_TOGGLE_BUTTON (prefs->transparent_checkbox)->active;
  newcfg->shaded = GTK_TOGGLE_BUTTON (prefs->shaded_checkbox)->active;
#ifdef SHADING
  newcfg->tintback = GTK_TOGGLE_BUTTON(prefs->tinted_checkbox)->active;
  adj = gtk_range_get_adjustment (GTK_RANGE(prefs->shaded_hscale));
  newcfg->shading = 512 - ((int) 512*((double)(adj->value+100))/200);

  newcfg->update_records = 0;
  if (GTK_TOGGLE_BUTTON(prefs->utmp_checkbox)->active)
    newcfg->update_records |= ZVT_TERM_DO_UTMP_LOG;
   
  if (GTK_TOGGLE_BUTTON(prefs->wtmp_checkbox)->active)
    newcfg->update_records |= ZVT_TERM_DO_WTMP_LOG;
  
  if (GTK_TOGGLE_BUTTON(prefs->lastlog_checkbox)->active)
    newcfg->update_records |= ZVT_TERM_DO_LASTLOG;

  newcfg->adj_contrast = GTK_TOGGLE_BUTTON(prefs->contrast_checkbox)->active;
  adj = gtk_range_get_adjustment (GTK_RANGE(prefs->contrast_hscale));
  newcfg->contrast = ((int) 512*((double)(adj->value+100))/200);

  newcfg->no_border = GTK_TOGGLE_BUTTON(prefs->no_border)->active;
  newcfg->gamma_correction = GTK_TOGGLE_BUTTON(prefs->gamma_checkbox)->active;
  adj = gtk_range_get_adjustment (GTK_RANGE(prefs->gamma_hscale));
  newcfg->gamma = ((int) 512*((double)(adj->value+100))/200);

  gnome_color_picker_get_i16 (GNOME_COLOR_PICKER (prefs->tinted_colorpicker),
			      &r, &g,
			      &b, NULL);

  newcfg->rtint = (int)( 512 * ((double)r) / 65535);
  newcfg->gtint = (int)( 512 * ((double)g) / 65535);
  newcfg->btint = (int)( 512 * ((double)b) / 65535);
  newcfg->image_mode = option_menu_get_history(GTK_OPTION_MENU (prefs->om_imgmode));
  rd(printf("IMAGE MODE: %d\n", newcfg->image_mode));
#endif
  newcfg->background_pixmap = GTK_TOGGLE_BUTTON (prefs->pixmap_checkbox)->active;
  newcfg->pixmap_file  = g_strdup (gtk_entry_get_text (GTK_ENTRY (prefs->pixmap_entry)));
  newcfg->wordclass = g_strdup (gtk_entry_get_text (GTK_ENTRY (prefs->wordclass_entry)));
  sp = option_menu_get_history (GTK_OPTION_MENU (prefs->scrollbar));
  newcfg->scrollbar_position = sp;
#ifdef ZVT_BACKGROUND_SCROLL
  newcfg->scroll_background = GTK_TOGGLE_BUTTON (prefs->pixmap_scrollable_checkbox)->active
    && newcfg->background_pixmap;
#endif
  newcfg->font  = g_strdup (gtk_entry_get_text (GTK_ENTRY (prefs->font_entry)));
  newcfg->boldfont = g_strdup (gtk_entry_get_text (GTK_ENTRY (prefs->boldfont_entry)));
  if (!strcasecmp (gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (prefs->class_box)->entry)),
	       _("Default")))
    newcfg->class = g_strdup ("Config");
  else
    newcfg->class = g_strconcat ("Class-", gtk_entry_get_text 
				 (GTK_ENTRY (GTK_COMBO (prefs->class_box)->entry)), NULL);

  newcfg->color_type = option_menu_get_history (GTK_OPTION_MENU (prefs->color_scheme));
  newcfg->color_set  = option_menu_get_history (GTK_OPTION_MENU (prefs->def_fore_back));

  /* MODIFIED 18->20 */
  for (i=0;i<20;i++) {
    gnome_color_picker_get_i16 (GNOME_COLOR_PICKER (prefs->palette[i]), &r, &g,
				&b, NULL);
    newcfg->palette[i].red   = r;
    newcfg->palette[i].green = g;
    newcfg->palette[i].blue  = b;
  }

  return newcfg;
}

  struct terminal_config *
terminal_config_dup (struct terminal_config *cfg)
{
  struct terminal_config *n;

  n = g_malloc (sizeof (*n));
  *n = *cfg;
  n->class = g_strdup (cfg->class);
  n->font = g_strdup  (cfg->font);
  n->wordclass = g_strdup  (cfg->wordclass);
  n->termname = g_strdup  (cfg->termname);

  return n;
}

  void
terminal_config_free (struct terminal_config *cfg)
{
  g_free (cfg->class);
  g_free (cfg->font);
  g_free (cfg->wordclass);
  g_free (cfg->termname);
  g_free (cfg);
}

  struct win_config *
win_config_dup (struct win_config *wincfg)
{
  struct win_config *n;

  n = g_malloc (sizeof (*n));
  *n = *wincfg;
  n->class = g_strdup (wincfg->class);
  return n;
}

  void
win_config_free (struct win_config *wincfg)
{
  g_free (wincfg->class);
  g_free (wincfg);
}


/* prototype */
void hide_toolbar(GnomeApp* app, gboolean htb);
void hide_buttonbar(GnomeApp* app, gboolean hbb);
void hide_menubar  (GnomeApp* app, gboolean hmb);


char * trunc_string (char * s, int len);

  int
apply_changes (ZvtTerm *term, struct terminal_config *newcfg)
{
  GtkWidget *scrollbar = gtk_object_get_data (GTK_OBJECT (term), "scrollbar");
  GtkWidget *box       = scrollbar->parent;
  GnomeApp *app = GNOME_APP (gtk_widget_get_toplevel (GTK_WIDGET (term)));
  GSList** ptl, *tmp;
  struct _zvtprivate *zp;
#ifdef SHADING
  GdkImlibColorModifier mod, rmod, gmod, bmod;
#endif
  struct terminal_config *cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
  gint w,h;

  w =  GTK_WIDGET(app)->allocation.width;
  h =  GTK_WIDGET(app)->allocation.height;

  terminal_config_free (cfg);
  cfg = terminal_config_dup (newcfg);
  gtk_object_set_data (GTK_OBJECT (term), "config", cfg);

  term->bold_color = cfg->bold_color;
  gnome_term_set_font (term, cfg->font, cfg->boldfont, cfg->use_bold);
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  tmp = *ptl; 
  if (!cfg->no_border)
    zvt_term_set_shadow_type(ZVT_TERM(term), GTK_SHADOW_IN);
  else
    zvt_term_set_shadow_type(ZVT_TERM(term), GTK_SHADOW_NONE);
  zvt_term_text_shadow(term, cfg->font_shadow?1:0);

  zvt_term_set_wordclass (term, (guchar *)cfg->wordclass);
  zvt_term_set_bell(term, !cfg->bell);
  zvt_term_set_blink (term, cfg->blink);
  zvt_term_set_scroll_on_keystroke (term, cfg->scroll_key);
  zvt_term_set_scroll_on_output (term, cfg->scroll_out);
  zvt_term_set_scrollback (term, cfg->scrollback);

  zvt_term_set_del_key_swap (term, cfg->swap_keys);
  zvt_term_set_open_im (term, cfg->use_im);
#ifdef HAVE_ZVT_DEL_IS_DEL
  zvt_term_set_del_is_del (term, cfg->del_is_del);
#endif
#ifdef SHADING
  mod.contrast = cfg->contrast;
  mod.gamma = cfg->gamma;
  mod.brightness = cfg->shading;
  rmod.contrast = rmod.gamma = 256;
  gmod.contrast = gmod.gamma = 256;
  bmod.contrast = bmod.gamma = 256;
  rmod.brightness = cfg->rtint;
  gmod.brightness = cfg->gtint;
  bmod.brightness = cfg->btint;
  term->tintback = cfg->tintback;
  term->adj_contrast = cfg->adj_contrast;
  term->gamma_correction = cfg->gamma_correction;
   if (!cfg->scroll_background)
    {
      zp = gtk_object_get_data(GTK_OBJECT(term), "_zvtprivate");
      zp->scroll_position = 0;
    }
  zvt_term_set_shading(term, mod, rmod, gmod, bmod);
  zvt_term_set_image_mode(term, cfg->image_mode); 
#endif
  if (zvt_pixmap_support && cfg->background_pixmap) {
    int flags;
#ifdef ZVT_BACKGROUND_SCROLL
    flags = cfg->shaded?ZVT_BACKGROUND_SHADED:0;
    flags |= cfg->scroll_background?ZVT_BACKGROUND_SCROLL:0;
#else
    flags = cfg->shaded;
#endif
    zvt_term_set_background (term,
			     cfg->pixmap_file,
			     cfg->transparent, flags, 1);
  } else if (zvt_pixmap_support && cfg->transparent)
    zvt_term_set_background (term,
			     NULL,
			     cfg->transparent, cfg->shaded, 1);
  else
    zvt_term_set_background (term, NULL, 0, 0, 1);

  if (cfg->scrollbar_position == SCROLLBAR_HIDDEN)
    gtk_widget_hide (scrollbar);
  else {
    gtk_box_set_child_packing (GTK_BOX (box), scrollbar,
			       FALSE, TRUE, 0,
			       (cfg->scrollbar_position == SCROLLBAR_LEFT) ?
			       GTK_PACK_START : GTK_PACK_END);
    gtk_widget_show (scrollbar);
  }

  set_color_scheme (term, cfg);

  return 0;
}
extern void set_tab_label(GtkNotebook *nb, GtkWidget*tab, int state);
extern int get_tab_state(GtkWidget* tab);
void save_preferences_cmd (gchar *prefix, struct terminal_config* cfg);
#if 0
void reread_cmds(GtkWidget* app, char* class);
#endif
void apply_global_chgs(GtkWidget* app, struct win_config *wincfg)
{
  GtkWidget *notebook, *tab;
  ZvtTerm *term;
  gchar tmp[256], *ttitle;
  GSList** ptl, **tabl, *tl;
  struct win_config *oldcfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  int page_num; 
  tabl = gtk_object_get_data(GTK_OBJECT(app), "tablist");
  notebook = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");

  win_config_free(oldcfg);
  gtk_object_set_data(GTK_OBJECT(app), "winconfig", win_config_dup(wincfg));
  if (wincfg->menubar_hidden)
    hide_menubar (GNOME_APP(app), TRUE);
  else 
    hide_menubar (GNOME_APP(app), FALSE);

  if (wincfg->toolbar_hidden)
    hide_toolbar(GNOME_APP(app), TRUE);
  else
    hide_toolbar(GNOME_APP(app), FALSE);

  if (wincfg->buttonbar_hidden)
    {
      hide_buttonbar(GNOME_APP(app), TRUE);	    
    }
  else
    {	  
      hide_buttonbar(GNOME_APP(app), FALSE);	    

    }

  set_titles(app, 0, 0); 
  tl = *tabl;
  while (tl)
    {
      tab = GTK_WIDGET(tl->data);
      set_tab_label(GTK_NOTEBOOK(notebook), tab, UNCHANGED);
      set_tab_label(GTK_NOTEBOOK(notebook), tab, get_tab_state(tab));
      tl = tl->next;  
    }
  if (!wincfg->no_nbborder)
    GTK_NOTEBOOK(notebook)->style_border = TRUE;
  else
    GTK_NOTEBOOK(notebook)->style_border = FALSE;

  /* ADD 29/09/01 <erik> */
  gtk_notebook_set_show_tabs(GTK_NOTEBOOK(notebook), !wincfg->tab_hidden);
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook),
			   wincfg->tab_position);

  term = current_term(ptl);
  ttitle  = gtk_object_get_data(GTK_OBJECT(term), "termtitle");
  if (wincfg->no_numprefix)
    sprintf(tmp, "%s - [ %s ]", wincfg->window_title, ttitle);
  else
    {
      tab = gtk_object_get_data(GTK_OBJECT(term),"tab");
      page_num = gtk_notebook_page_num(GTK_NOTEBOOK(notebook), tab);
      sprintf(tmp, "%s - [ %d-%s ]", wincfg->window_title, page_num + 1, ttitle);
    }
  gtk_window_set_title (GTK_WINDOW(app), tmp);
}
void mgt_do_resize(GtkWidget*app);
int compute_extra_width(GtkWidget* pane)
{
  int w1 = 0, w2 = 0; 
  GtkWidget* c1, *c2;
  
  if (GTK_IS_HBOX(pane))
    {
      ZvtTerm *term = ZVT_TERM(gtk_object_get_data(GTK_OBJECT(pane), "term")); 
      GtkWidget* widget = GTK_WIDGET(term);
      return GTK_WIDGET(term)->allocation.width - 
	(2 * widget->style->klass->xthickness) - 2*term->XPADDING -
	term->charwidth*term->grid_width;
    }

  c1 = GTK_PANED(pane)->child1;
  c2 = GTK_PANED(pane)->child2;
  if (c1 && (GTK_IS_HBOX(c1) || GTK_IS_PANED(c1)))
    {
      w1 = compute_extra_width(GTK_WIDGET(c1));
    }

  if (c2 && (GTK_IS_HBOX(c2) || GTK_IS_PANED(c2)))
    {
      w2 = compute_extra_width(GTK_WIDGET(c2));
    }

  if (GTK_IS_VPANED(pane))
    return MIN(w1, w2);
    
  return w1+w2; 
}

int compute_extra_height(GtkWidget* pane)
{
  int w1 = 0, w2 = 0; 
  GtkWidget* c1, *c2;
  
  if (GTK_IS_HBOX(pane))
    {
      ZvtTerm *term = ZVT_TERM(gtk_object_get_data(GTK_OBJECT(pane), "term")); 
      GtkWidget* widget = GTK_WIDGET(term);
      return GTK_WIDGET(term)->allocation.height - 
	(2 * widget->style->klass->ythickness) - 2*term->YPADDING -
	term->charheight*term->grid_height;
    }

  c1 = GTK_PANED(pane)->child1;
  c2 = GTK_PANED(pane)->child2;
  if (c1 && (GTK_IS_HBOX(c1) || GTK_IS_PANED(c1)))
    {
      w1 = compute_extra_height(GTK_WIDGET(c1));
    }

  if (c2 && (GTK_IS_HBOX(c2) || GTK_IS_PANED(c2)))
    {
      w2 = compute_extra_height(GTK_WIDGET(c2));
    }

  
  if (GTK_IS_VPANED(pane))
    return w1+w2;
  else
    return MIN(w1,w2); 
}

void adjust_app_size(GtkWidget *w, gpointer data)
{
  int xw, xh;
  GSList** ptl = (GSList**) data;
  GtkWidget* tab;
  ZvtTerm *term;
  GtkWidget* app = gtk_widget_get_toplevel(GTK_WIDGET((*ptl)->data));
  GtkWidget* root_pane;
  term = current_term(ptl);
  tab  = gtk_object_get_data(GTK_OBJECT(term), "tab");
  root_pane = GTK_PANED(gtk_object_get_data(GTK_OBJECT(tab), "root_pane"))->child1;
  xw = compute_extra_width(root_pane);
  xh = compute_extra_height(root_pane);
  rrd(printf("xw:%d, xh:%d\n", xw, xh));
  if (((double)xw)/term->charwidth >= 0.5)
    xw = -(term->charwidth-xw);
  if (((double)xh)/term->charheight >= 0.5)
    xh = -(term->charheight-xh);
  gtk_widget_set_usize(app, app->allocation.width-xw, app->allocation.height-xh);
}
void rebuild_buttonbar_menu( GtkWidget  *window);
void win_apply_to_all_wins(GtkWidget* app, struct win_config* wincfg)
{
  int aw, ah;
  GSList** ptl;
  GList *lapp;
  GtkWidget *oapp, *notebook;
  struct win_config *oldcfg;
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  lapp = terminals;

  while (lapp)
    {
      oapp = GTK_WIDGET(lapp->data);
      ptl = gtk_object_get_data(GTK_OBJECT(oapp), "ptermlist");
      oldcfg = gtk_object_get_data(GTK_OBJECT(oapp), "winconfig");
      /* app has been already changed */
      notebook = gtk_object_get_data(GTK_OBJECT(oapp), "notebook");
      aw = oapp->allocation.width;
      ah = oapp->allocation.height;
      GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(oapp),GTK_VISIBLE); 
      /* apply only to window with the same class */
      if (!strcasecmp(oldcfg->class, wincfg->class))
	{
	  apply_global_chgs(GTK_WIDGET(oapp), wincfg);
	}
      GTK_WIDGET_SET_FLAGS(GTK_WIDGET(oapp),GTK_VISIBLE); 
      /* ADD 29/09/01 <erik> */
      gtk_widget_set_usize(GTK_WIDGET(oapp), aw, ah);
      mgt_do_resize(oapp);
      lapp = lapp->next;
    }
}

void apply_to_all_wins(GtkWidget* app, struct terminal_config* cfg)
{
  int n, aw, ah;
  GSList** ptl;
  GSList* tmp;
  GList *lapp;
  ZvtTerm* term;
  GtkWidget *oapp, *notebook;
  struct terminal_config *newcfg, *oldcfg;
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  lapp = terminals;

  term = ZVT_TERM((*ptl)->data);

  while (lapp)
    {
      oapp = GTK_WIDGET(lapp->data);
      ptl = gtk_object_get_data(GTK_OBJECT(oapp), "ptermlist");
      tmp = *ptl;
      term = ZVT_TERM(tmp->data);
      oldcfg = gtk_object_get_data(GTK_OBJECT(term), "config");
      /* app has been already changed */
      notebook = gtk_object_get_data(GTK_OBJECT(oapp), "notebook");
      GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(oapp),GTK_VISIBLE); 
      /* apply only to window with the same class */
      n = 0;
      aw = oapp->allocation.width;
      ah = oapp->allocation.height;
      while (tmp)
	{
	  term = ZVT_TERM(tmp->data);
	  oldcfg = gtk_object_get_data(GTK_OBJECT(term), "config");
	  if (!strcasecmp(oldcfg->class, cfg->class))
	    {
	      oldcfg = gtk_object_get_data(GTK_OBJECT(term), "config");
	      newcfg = terminal_config_dup(cfg);
	      apply_changes (term, newcfg);
	      terminal_config_free (newcfg);
	    }
	  tmp = tmp->next;
	  n++;
	}
      GTK_WIDGET_SET_FLAGS(GTK_WIDGET(oapp),GTK_VISIBLE); 
      /* ADD 29/09/01 <erik> */
      tmp = *ptl;
      gtk_widget_set_usize(GTK_WIDGET(oapp), aw, ah);
      mgt_do_resize(oapp);
      /* assume the screen is filled with background? */
      vt_update_rect (current_term(ptl)->vx, 17, 0, 0,
		      current_term(ptl)->vx->vt.width,
		      current_term(ptl)->vx->vt.height);
      lapp = lapp->next;
    }
}

void pref_apply_to_all_wins(void)
{
  GList* all_app;
  GtkWidget* oapp;

  /* apply to all windows */
  all_app = terminals;
  while (all_app)
    {
      oapp = GTK_WIDGET(all_app->data);
      rebuild_menubar_from_arrays(GNOME_APP(oapp));
      all_app = all_app->next;
    }
}
void
save_winprefs_cmd(gchar* prefix, struct win_config* wincfg);
static void win_apply_changes_cmd (GtkWidget *widget, int page, GSList** p_term_list)
{
  struct win_config *wincfg;
  GtkWidget* app, *term;
  winprefs_t* winprefs;
  char *prefix, *winclass;
  if (page != -1) return;
  term = GTK_WIDGET((*p_term_list)->data);
  app = gtk_widget_get_toplevel(term);
  winprefs = gtk_object_get_data(GTK_OBJECT(app), "winprefs");

  wincfg = g_malloc0(sizeof(struct win_config)); 
  win_gather_changes(wincfg, app);
  win_apply_to_all_wins(app, wincfg);
  if (!strcasecmp (gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (winprefs->class_box)->entry)),
	       _("Default")))
    winclass = g_strdup ("Win-Config");
  else
    winclass = g_strconcat ("Win-Class-", 
			 gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (winprefs->class_box)->entry)), NULL);

  prefix = g_strdup_printf("/MultiTerminal/%s/", winclass);

  save_winprefs_cmd (prefix, wincfg);
  win_config_free(wincfg);
  g_free(winclass);
  g_free(prefix);

}

static void apply_changes_cmd (GtkWidget *widget, int page, GSList** p_term_list)
{
  struct terminal_config *cfg;
  GtkWidget* app, *term;
  preferences_t* prefs;
  char *prefix, *class;
  if (page != -1) return;
  term = GTK_WIDGET((*p_term_list)->data);
  app = gtk_widget_get_toplevel(term);
  prefs = gtk_object_get_data(GTK_OBJECT(app), "prefs");

  cfg = g_malloc0(sizeof(struct terminal_config)); 
  gather_changes(cfg, app);
  apply_to_all_wins(app, cfg);
  if (!strcasecmp (gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (prefs->class_box)->entry)),
	       _("Default")))
    class = g_strdup ("Config");
  else
    class = g_strconcat ("Class-", 
			 gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (prefs->class_box)->entry)), NULL);

  prefix = g_strdup_printf("/MultiTerminal/%s/", class);

  save_preferences_cmd (prefix, cfg);
  terminal_config_free(cfg);
  g_free(class);
  g_free(prefix);

}

void rebuild_buttonbar_menu( GtkWidget  *window);

void apply_global_chgs(GtkWidget* app, struct win_config *wincfg);
void update_winprefs(winprefs_t* winprefs, struct win_config* wincfg)
{
  char mch[10];
  char* win_title;
  int i;
  if (winprefs->class)
    g_free(winprefs->class);
  winprefs->class = g_strdup(wincfg->class);

  if (!strcmp(wincfg->class,"Win-Config"))
    win_title = g_strdup("Windows Preferences - Default");
  else
    win_title = g_strdup_printf("Windows Preferences - %s",
				gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(winprefs->class_box)->entry)));

  gtk_window_set_title(GTK_WINDOW(winprefs->prop_win),win_title);
  g_free(win_title);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winprefs->menubar_checkbox),
				wincfg->menubar_hidden ? 1 : 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winprefs->toolbar_checkbox),
				wincfg->toolbar_hidden ? 1 : 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winprefs->buttonbar_checkbox),
				wincfg->buttonbar_hidden ? 1 : 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winprefs->chk_reopentabs),
				wincfg->restore_tabs ? 1 : 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winprefs->chk_restorepaths),
				wincfg->restorepaths ? 1 : 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winprefs->chk_restoreclasses),
				wincfg->restore_classes ? 1 : 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winprefs->chk_restorecmds),
				wincfg->restore_commands ? 1 : 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winprefs->titled_tabs),
				wincfg->titled_tabs ? 1 : 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winprefs->autosavetabs),
				wincfg->autosavetabs ? 1 : 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winprefs->no_numprefix),
				wincfg->no_numprefix ? 1 : 0);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winprefs->no_nbborder),
				wincfg->no_nbborder ? 1 : 0);
				
  sprintf(mch, "%d",wincfg->maxch);
  gtk_entry_set_text(GTK_ENTRY(winprefs->maxch), mch);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winprefs->login_checkbox),
				wincfg->login_shell ? 1 : 0);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winprefs->close_dialog_checkbox),
				wincfg->close_confirm ? 1 : 0);
  if (wincfg->tab_hidden)
    {
      gtk_entry_set_text (GTK_ENTRY(winprefs->tab_position), "none");
    }
  else
    {
      gtk_entry_set_text (GTK_ENTRY(winprefs->tab_position),
			  wincfg->tab_position == GTK_POS_BOTTOM ? "bottom" :
			  wincfg->tab_position == GTK_POS_LEFT   ? "left"   :
			  wincfg->tab_position == GTK_POS_RIGHT  ? "right"  : "top");
    }
  gtk_entry_set_text(GTK_ENTRY(winprefs->win_title), wincfg->window_title?
		     wincfg->window_title:"MGT");

  for (i=0;i<2;i++) 
    {
      gnome_color_picker_set_i16(GNOME_COLOR_PICKER(winprefs->palette[i]), 
				 wincfg->palette[i].red,
				 wincfg->palette[i].green, wincfg->palette[i].blue, 0);
    }
}

void update_prefs(preferences_t* prefs, struct terminal_config* cfg)
{
  GtkWidget* b5;
  char* win_title;
#ifdef SHADING
  GtkAdjustment* adj;
#endif
  int i;
  if (prefs->class)
    g_free(prefs->class);
  prefs->class = g_strdup(cfg->class);


  if (!strcmp(cfg->class,"Config"))
    win_title = g_strdup("Preferences - Default");
  else
    win_title = g_strdup_printf("Preferences - %s",
				gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(prefs->class_box)->entry)));

  gtk_window_set_title(GTK_WINDOW(prefs->prop_win),win_title);
  g_free(win_title);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->use_bold_checkbox),
				cfg->use_bold ? 1 : 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->use_boldfont),
				cfg->use_boldfont ? 1 : 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->bold_color_checkbox),
				cfg->bold_color ? 1 : 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->blink_checkbox),
				cfg->blink ? 1 : 0);
  
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->utmp_checkbox),
				(cfg->update_records & ZVT_TERM_DO_UTMP_LOG) ? 1 : 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->wtmp_checkbox),
				(cfg->update_records & ZVT_TERM_DO_WTMP_LOG) ? 1 : 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->lastlog_checkbox),
				(cfg->update_records & ZVT_TERM_DO_LASTLOG) ? 1 : 0);
	
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->no_border),
				cfg->no_border ? 1 : 0);
				
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->font_shadow),
				cfg->font_shadow ? 1 : 0);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->bell_checkbox),
				cfg->bell ? 1 : 0);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->swapkeys_checkbox),
				cfg->swap_keys ? 1 : 0);
#ifdef HAVE_ZVT_DEL_IS_DEL
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->del_is_del_checkbox),
				cfg->del_is_del ? 1 : 0);
#endif
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->use_im_checkbox),
				cfg->use_im ? 1 : 0);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->use_fontset_checkbox),
				cfg->use_fontset ? 1 : 0);

  /* FONT */
  gtk_entry_set_text (GTK_ENTRY (prefs->wordclass_entry),
		      cfg->wordclass);
  gtk_entry_set_text (GTK_ENTRY (prefs->font_entry),
		      cfg->font);
  gtk_entry_set_position (GTK_ENTRY (prefs->font_entry), 0);
  gnome_font_picker_set_font_name(GNOME_FONT_PICKER(prefs->picker),
				  gtk_entry_get_text(GTK_ENTRY (prefs->font_entry)));
  /* BOLDFONT */
  gtk_entry_set_text (GTK_ENTRY (prefs->boldfont_entry),
		      cfg->boldfont);
  gtk_entry_set_position (GTK_ENTRY (prefs->boldfont_entry), 0);
  gnome_font_picker_set_font_name(GNOME_FONT_PICKER(prefs->boldpicker),
				  gtk_entry_get_text(GTK_ENTRY (prefs->boldfont_entry)));


  if (cfg->background_pixmap)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->pixmap_checkbox),
				  1);
  else if (cfg->transparent)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->transparent_checkbox),
				  1);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->back_none), 
				  1);

  gtk_entry_set_text (GTK_ENTRY (prefs->pixmap_entry),
		      cfg->pixmap_file?cfg->pixmap_file:"");
#ifdef ZVT_BACKGROUND_SCROLL
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->pixmap_scrollable_checkbox),
				cfg->scroll_background ? 1 : 0);
#endif
#ifdef SHADING
  gtk_option_menu_set_history (GTK_OPTION_MENU (prefs->om_imgmode), cfg->image_mode);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->tinted_checkbox),
				cfg->tintback ? 1 : 0);
  b5 = prefs->tinted_colorpicker;
  gnome_color_picker_set_i16(GNOME_COLOR_PICKER(b5), 
			     (int) 65535*(((double)cfg->rtint) / 512),
			     (int) 65535*(((double)cfg->gtint) / 512), 
			     (int) 65535*(((double)cfg->btint) / 512), 0);
  adj = gtk_range_get_adjustment(GTK_RANGE(prefs->shaded_hscale));
  gtk_adjustment_set_value(adj, 
			   (int)(100*((double)(256 - cfg->shading))/256));
#endif
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->shaded_checkbox),
				cfg->shaded ? 1 : 0);

  adj = gtk_range_get_adjustment(GTK_RANGE(prefs->contrast_hscale));
  gtk_adjustment_set_value(adj, 
			   (int)(100*((double)(cfg->contrast - 256))/256));

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->gamma_checkbox),
				cfg->gamma_correction ? 1 : 0);

  adj = gtk_range_get_adjustment(GTK_RANGE(prefs->gamma_hscale));
  gtk_adjustment_set_value(adj, 
			   (int)(100*((double)(cfg->gamma - 256))/256));

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->contrast_checkbox),
				cfg->adj_contrast ? 1 : 0);

  gtk_option_menu_set_history (GTK_OPTION_MENU (prefs->color_scheme), cfg->color_type);

  for (i=0;i<20;i++) 
    {
      gnome_color_picker_set_i16(GNOME_COLOR_PICKER(prefs->palette[i]), cfg->palette[i].red,
				 cfg->palette[i].green, cfg->palette[i].blue, 0);
    }

  gtk_option_menu_set_history (GTK_OPTION_MENU (prefs->def_fore_back), cfg->color_set);

  gtk_option_menu_set_history (GTK_OPTION_MENU (prefs->scrollbar), cfg->scrollbar_position);

  gtk_spin_button_set_value (GTK_SPIN_BUTTON (prefs->scrollback_spin), (gfloat)cfg->scrollback);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->scroll_kbd_checkbox),
				cfg->scroll_key);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->scroll_out_checkbox),
				cfg->scroll_out);

}
/* this is the PREFS window destroy event ... */
  static void
win_window_destroy (GtkWidget *w, GSList** p_term_list)
{
  winprefs_t *winprefs;
  GList* lapp;

  /* NOTE: 
     prefs is the same for all terminal in the same window (GnomeApp) */
  winprefs = gtk_object_get_data (GTK_OBJECT (terminals->data), "winprefs");
  g_free(winprefs->class);
  g_free (winprefs);

  lapp = terminals;
  while (lapp)
    {
      gtk_object_set_data(GTK_OBJECT(lapp->data), "winprefs", NULL);
      lapp = lapp->next;
    }
}

/* this is the PREFS window destroy event ... */
  static void
window_destroy (GtkWidget *w, GSList** p_term_list)
{
  preferences_t *prefs;
  GList* lapp;

  /* NOTE: 
     prefs is the same for all terminal in the same window (GnomeApp) */
  prefs = gtk_object_get_data (GTK_OBJECT (terminals->data), "prefs");

  gtk_signal_disconnect_by_data (GTK_OBJECT (prefs->pixmap_entry), prefs);
  g_free(prefs->class);
  g_free (prefs);

  lapp = terminals;
  while (lapp)
    {
      gtk_object_set_data(GTK_OBJECT(lapp->data), "prefs", NULL);
      lapp = lapp->next;
    }
}
/* 
 * Set the sensitivity of the Image tab of the property  
 * dialog based on the values of the checkbuttons
 */

  static void
wincheck_image_options_sensitivity (winprefs_t *winprefs)
{
  gboolean has_titledtabs = GTK_TOGGLE_BUTTON(winprefs->titled_tabs)->active;	
  gtk_widget_set_sensitive (winprefs->lbl_maxch, has_titledtabs);
  gtk_widget_set_sensitive (winprefs->maxch, has_titledtabs);
}

/* 
 * Set the sensitivity of the Image tab of the property  
 * dialog based on the values of the checkbuttons
 */
  static void
check_image_options_sensitivity (preferences_t *prefs)
{
  gboolean has_background = GTK_TOGGLE_BUTTON (prefs->pixmap_checkbox)->active;
  gboolean has_transparency = GTK_TOGGLE_BUTTON (prefs->transparent_checkbox)->active;
  gboolean use_boldfont = GTK_TOGGLE_BUTTON(prefs->use_boldfont)->active;
#ifdef SHADING
  gboolean is_tinted = GTK_TOGGLE_BUTTON (prefs->tinted_checkbox)->active;
  gboolean is_shaded = GTK_TOGGLE_BUTTON (prefs->shaded_checkbox)->active;
  gboolean adj_contrast = GTK_TOGGLE_BUTTON (prefs->contrast_checkbox)->active;
  gboolean gamma_corr = GTK_TOGGLE_BUTTON (prefs->gamma_checkbox)->active;

  gtk_widget_set_sensitive (prefs->om_imgmode, has_background);
  gtk_widget_set_sensitive (prefs->tinted_checkbox,
			    has_background || has_transparency);
  gtk_widget_set_sensitive (prefs->tinted_colorpicker, (has_background ||
							has_transparency) &&  (is_tinted));
  gtk_widget_set_sensitive (prefs->shaded_hscale, (has_background ||
						   has_transparency) && (is_shaded));
  gtk_widget_set_sensitive (prefs->contrast_hscale, (has_background ||
						   has_transparency) && (adj_contrast));

  gtk_widget_set_sensitive (prefs->gamma_hscale, (has_background ||
						   has_transparency) && (gamma_corr));

  gtk_widget_set_sensitive (prefs->perclbl, (has_background || has_transparency) 
			    && (is_shaded));
#endif	
  gtk_widget_set_sensitive(prefs->font_shadow, has_background || has_transparency);

  gtk_widget_set_sensitive (prefs->pixmap_label, has_background);
  gtk_widget_set_sensitive (prefs->pixmap_file_entry, has_background);
  gtk_widget_set_sensitive (prefs->shaded_checkbox,
			    has_background || has_transparency);
  gtk_widget_set_sensitive (prefs->contrast_checkbox,
			    has_background || has_transparency);
  gtk_widget_set_sensitive (prefs->gamma_checkbox,
			    has_background || has_transparency);

  gtk_widget_set_sensitive (prefs->boldpicker, use_boldfont);
  gtk_widget_set_sensitive (prefs->boldfont_entry, use_boldfont);
  gtk_widget_set_sensitive (prefs->boldfont_label, use_boldfont);

#ifdef ZVT_BACKGROUND_SCROLL
  gtk_widget_set_sensitive (prefs->pixmap_scrollable_checkbox,
			    has_background);
#endif
}

/*
 * Called when something has changed on the properybox
 */
  static void
prop_changed (GtkWidget *w, preferences_t *prefs)
{
  if (w != GTK_WIDGET (GTK_COMBO (prefs->class_box)->entry)) 
    prefs->changed = 1;
  gnome_property_box_changed (GNOME_PROPERTY_BOX (prefs->prop_win));

  check_image_options_sensitivity (prefs);
}
  static void
win_prop_changed (GtkWidget *w, winprefs_t *winprefs)
{
  if (w != GTK_WIDGET (GTK_COMBO (winprefs->class_box)->entry)) 
    winprefs->changed = 1;
  gnome_property_box_changed (GNOME_PROPERTY_BOX (winprefs->prop_win));

  wincheck_image_options_sensitivity (winprefs);
}


  static void
color_changed (GtkWidget *w, int r, int g, int b, int a, preferences_t *prefs)
{
  prop_changed (w, prefs);
}

  static void
font_changed (GtkWidget *w, preferences_t *prefs)
{
  char *font;
  GtkWidget *peer;
  if (GNOME_IS_FONT_PICKER(w)){
    font = gnome_font_picker_get_font_name (GNOME_FONT_PICKER(w));
    peer = gtk_object_get_user_data (GTK_OBJECT(w));
    if (font)
      gtk_entry_set_text (GTK_ENTRY(peer), font);
  } else {
    font = gtk_entry_get_text (GTK_ENTRY(w));
    peer = gtk_object_get_user_data (GTK_OBJECT(w));
    gnome_font_picker_set_font_name (GNOME_FONT_PICKER(peer), font);
    prop_changed (w, prefs);
  }
}

/*
   static void
   prop_changed_zvt (void *data, char *font_name) 
   { 
   ZvtTerm *term = ZVT_TERM (data); 
   preferences_t *prefs; 

   prefs = gtk_object_get_data (GTK_OBJECT (term), "prefs"); 
   gtk_entry_set_text (GTK_ENTRY (prefs->font_entry), font_name); 
   gtk_entry_set_position (GTK_ENTRY (prefs->font_entry), 0); 
   } 
   */ 

typedef struct {
  GnomePropertyBox *box;
  preferences_t	 *prefs;
} lambda_t;

  static void
check_color_sensitivity (preferences_t *prefs)
{
  int idxc = option_menu_get_history (GTK_OPTION_MENU (prefs->def_fore_back));
  gboolean sensc = (idxc == COLORS_CUSTOM);
  int idx = option_menu_get_history (GTK_OPTION_MENU (prefs->color_scheme));
  gboolean sens = (idx == PALETTE_CUSTOM);

  int i;
  gtk_widget_set_sensitive (GTK_WIDGET (prefs->fore_label), sensc);
  gtk_widget_set_sensitive (GTK_WIDGET (prefs->back_label), sensc);
  gtk_widget_set_sensitive (GTK_WIDGET (prefs->palette_label), sens);
  for (i=0;i<18;i++)
    gtk_widget_set_sensitive (GTK_WIDGET (prefs->palette[i]), i<16?sens:sensc);
}

  static void
set_active (GtkWidget *widget, lambda_t *t)
{
  check_color_sensitivity (t->prefs);
  t->prefs->changed = 1;
  gnome_property_box_changed (GNOME_PROPERTY_BOX (t->box));
}

  static void
set_active_im (GtkWidget *widget, lambda_t *t)
{
  gnome_property_box_changed (GNOME_PROPERTY_BOX (t->box));
}


static void
create_option_menu_data (GtkWidget *omenu,
			 GnomePropertyBox *box, preferences_t *prefs, char **menu_list, int item,
			 GtkSignalFunc func)
{
  GtkWidget *menu;
  lambda_t *t;
  int i = 0;

  menu = gtk_menu_new ();
  while (*menu_list){
    GtkWidget *entry;

    entry = gtk_menu_item_new_with_label (_(*menu_list));
    gtk_widget_show (entry);
    gtk_menu_append (GTK_MENU (menu), entry);
    menu_list++;
    i++;
  }
  gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
  gtk_option_menu_set_history (GTK_OPTION_MENU (omenu), item);
  gtk_widget_show (omenu);
  t = g_new (lambda_t, 1);
  t->box   = box;
  t->prefs = prefs;

  gtk_signal_connect_full (GTK_OBJECT (menu), 
			   "deactivate",
			   GTK_SIGNAL_FUNC (set_active), NULL,
			   t, (GtkDestroyNotify)g_free,
			   FALSE, FALSE);
}

  static void
create_option_menu (GtkWidget *omenu, GnomePropertyBox *box, preferences_t *prefs, char **menu_list, int item, GtkSignalFunc func)
{
  create_option_menu_data (omenu, box, prefs, menu_list, item, func);
}

char *color_scheme [] = {
  N_("Linux console"),
  N_("Color Xterm"),
  N_("rxvt"),
  N_("Custom"),
  NULL
};

char *fore_back_table [] = {
  N_("White on black"),
  N_("Black on white"),
  N_("Green on black"),
  N_("Black on light yellow"),
  N_("Custom colors"),
  NULL
};

char *scrollbar_position_list [] = {
  N_("Left"),
  N_("Right"),
  N_("Hidden"),
  NULL
};

#ifdef SHADING
char *image_modes [] = {
  N_("Scaled"),
  N_("Tiled"),
  NULL
};
#endif

/* called back to free the ColorSelector */
  static void
free_cs (GtkWidget *widget, GnomeColorPicker *cp)
{
}
  static void
save_winprefs (struct win_config *cfg)
{
  /* MODIFIED 18->20->21 */
  char *colours[2];
  int i;

  gnome_config_set_string ("tab_position",
			   cfg->tab_position == GTK_POS_BOTTOM ? "bottom" :
			   cfg->tab_position == GTK_POS_LEFT   ? "left"   :
			   cfg->tab_position == GTK_POS_RIGHT  ? "right"  : "top");
  gnome_config_set_bool ("tab_hidden", cfg->tab_hidden);

  gnome_config_set_int    ("maxch", cfg->maxch);
  gnome_config_set_bool   ("titled_tabs", cfg->titled_tabs);	
  gnome_config_set_bool   ("login_shell", cfg->login_shell);
  gnome_config_set_bool   ("menubar", !cfg->menubar_hidden);
  /* ADD */
  gnome_config_set_bool   ("toolbar", !cfg->toolbar_hidden);
  gnome_config_set_bool   ("buttonbar", !cfg->buttonbar_hidden);
  gnome_config_set_bool   ("close_confirm", !cfg->close_confirm);
  gnome_config_set_bool   ("restore_commands", cfg->restore_commands);
  gnome_config_set_bool   ("restore_tabs"    , cfg->restore_tabs); 
  gnome_config_set_bool   ("restore_paths"   , cfg->restorepaths);
  gnome_config_set_bool   ("restore_classes",  cfg->restore_classes);
  gnome_config_set_bool   ("autosavetabs"   , cfg->autosavetabs);
  /*gnome_config_set_bool   ("nosutabs", cfg->no_startuptabs);*/
  gnome_config_set_bool   ("no_numprefix"    , cfg->no_numprefix);
  gnome_config_set_bool   ("no_nbborder"     , cfg->no_nbborder);
  gnome_config_set_string ("win_title",  cfg->window_title);
  /* MODIFIED 18->20->21 */
  for (i=0;i<2;i++)
    colours[i] = g_strdup_printf ("rgb:%04x/%04x/%04x", cfg->palette[i].red,
				  cfg->palette[i].green, cfg->palette[i].blue);
  gnome_config_set_vector ("winpalette", 2, (const char **)colours);
  for (i=0;i<2;i++)
    g_free(colours[i]);

  gnome_config_sync ();
}

  static void
save_preferences (struct terminal_config *cfg)
{
  /* MODIFIED 18->20->21 */
  char *colours[20];
  int i;
  char *scheme[4] = { "linux", "xterm", "rxvt", "custom" };

  if (cfg->font)
    gnome_config_set_string ("font", cfg->font);

  if (cfg->boldfont)
    gnome_config_set_string ("boldfont", cfg->boldfont);

  if (cfg->wordclass)
    gnome_config_set_string ("wordclass", cfg->wordclass);
  gnome_config_set_bool("do_utmp", (cfg->update_records & ZVT_TERM_DO_UTMP_LOG) != 0);
  gnome_config_set_bool("do_wtmp", (cfg->update_records & ZVT_TERM_DO_WTMP_LOG) != 0);
  gnome_config_set_bool("do_lastlog", (cfg->update_records & ZVT_TERM_DO_LASTLOG) != 0);
#ifdef SHADING
  gnome_config_set_int("shading", cfg->shading);
  gnome_config_set_int("contrast",  cfg->contrast);
  gnome_config_set_int("gamma", cfg->gamma);
  gnome_config_set_int("rtint", cfg->rtint);
  gnome_config_set_int("gtint", cfg->gtint);
  gnome_config_set_int("btint", cfg->btint);
  gnome_config_set_bool("tintback", cfg->tintback);
  gnome_config_set_bool("adj_contrast", cfg->adj_contrast);
  gnome_config_set_bool("gamma_correction", cfg->gamma_correction);
  gnome_config_set_int("image_mode", cfg->image_mode);
#endif
  gnome_config_set_string ("scrollpos",
			   cfg->scrollbar_position == SCROLLBAR_LEFT ? "left" :
			   cfg->scrollbar_position == SCROLLBAR_RIGHT ? "right" : "hidden");
  gnome_config_set_bool   ("bell_silenced", cfg->bell);
  gnome_config_set_bool   ("blinking", cfg->blink);
  gnome_config_set_bool   ("swap_del_and_backspace", cfg->swap_keys);
#ifdef HAVE_ZVT_DEL_IS_DEL
  gnome_config_set_bool   ("del_is_del", cfg->del_is_del);
#endif
  gnome_config_set_bool   ("use_bold", cfg->use_bold);
  gnome_config_set_bool   ("use_boldfont", cfg->use_boldfont);
  gnome_config_set_bool   ("bold_color", cfg->bold_color);
  gnome_config_set_bool   ("use_im", cfg->use_im);
  gnome_config_set_bool   ("use_fontset", cfg->use_fontset); 
  gnome_config_set_int    ("scrollbacklines", cfg->scrollback);
  gnome_config_set_int    ("color_set", cfg->color_set);
  if (cfg->color_type>=4)
    cfg->color_type=4;
  gnome_config_set_string ("color_scheme", scheme[cfg->color_type]);
  gnome_config_set_bool   ("scrollonkey", cfg->scroll_key);
  gnome_config_set_bool   ("scrollonoutput", cfg->scroll_out);
  gnome_config_set_bool   ("transparent", cfg->transparent);
  gnome_config_set_bool   ("shaded", cfg->shaded);
  gnome_config_set_bool   ("no_border"       , cfg->no_border);     

  gnome_config_set_bool   ("font_shadow",      cfg->font_shadow);
#ifdef ZVT_BACKGROUND_SCROLL
  gnome_config_set_bool   ("scroll_background", cfg->scroll_background);
#endif
  gnome_config_set_bool   ("background_pixmap", cfg->background_pixmap);
  gnome_config_set_string ("pixmap_file", cfg->pixmap_file);

  /* MODIFIED 18->20->21 */
  for (i=0;i<20;i++)
    colours[i] = g_strdup_printf ("rgb:%04x/%04x/%04x", cfg->palette[i].red,
				  cfg->palette[i].green, cfg->palette[i].blue);
  gnome_config_set_vector ("palette", 20, (const char **)colours);
  for (i=0;i<20;i++)
    g_free(colours[i]);

  gnome_config_sync ();
}
void
save_winprefs_cmd(gchar* prefix, struct win_config* wincfg)
{
  /* Consider one terminal because settings are the same for all terminals*/
  gnome_config_push_prefix (prefix);
  save_winprefs (wincfg);
  gnome_config_sync();
  gnome_config_pop_prefix ();
}


  void
save_preferences_cmd(gchar* prefix, struct terminal_config* cfg)
{
  /* Consider one terminal because settings are the same for all terminals*/
  gnome_config_push_prefix (prefix);
  save_preferences (cfg);
  gnome_config_sync();
  gnome_config_pop_prefix ();
}

void save_winprefs_cmd_from_wincfg(struct win_config *wincfg)
{
  gchar* prefix;
  prefix = g_strdup_printf("/MultiTerminal/%s/", wincfg->class);
  save_winprefs_cmd(prefix, wincfg);
  g_free(prefix);
}
void save_preferences_cmd_from_cfg(struct terminal_config *cfg)
{
  gchar* prefix;
  prefix = g_strdup_printf("/MultiTerminal/%s/", cfg->class);
  save_preferences_cmd(prefix, cfg);
  g_free(prefix);
}
extern GdkColor colors[];
void terminal_help_cb(GtkWidget* w, gpointer data);

void default_cols(GtkWidget* w, gpointer data)
{
  winprefs_t* winprefs;
  winprefs = (winprefs_t*) data;
  gnome_color_picker_set_i16(GNOME_COLOR_PICKER(winprefs->palette[0]), colors[4].red,
			     colors[4].green, colors[4].blue, 0);
  gnome_color_picker_set_i16(GNOME_COLOR_PICKER(winprefs->palette[1]), colors[12].red,
			     colors[12].green, colors[12].blue, 0);
  gnome_property_box_changed (GNOME_PROPERTY_BOX (winprefs->prop_win));
}
  static void
phelp_cb (GtkWidget *w, gint tab, gpointer data)
{
#if 0
  GnomeHelpMenuEntry help_entry = { "multi-gnome-terminal",
    "config.html" };
    char *pages[] = { "config.html#CONFIG-GENERAL",
      "config.html#CONFIG-IMAGE",
      "config.html#CONFIG-COLOUR",
      "config.html#CONFIG-SCROLLING" };
      g_assert (tab < 4);
      help_entry.path = pages[tab];
      gnome_help_display(NULL, &help_entry);
#endif
      terminal_help_cb(w, data);
}
  static void
win_phelp_cb (GtkWidget *w, gint tab, gpointer data)
{
#if 0
  GnomeHelpMenuEntry help_entry = { "multi-gnome-terminal",
    "config.html" };
    char *pages[] = { "config.html#CONFIG-GENERAL",
      "config.html#CONFIG-IMAGE",
      "config.html#CONFIG-COLOUR",
      "config.html#CONFIG-SCROLLING" };
      g_assert (tab < 4);
      help_entry.path = pages[tab];
      gnome_help_display(NULL, &help_entry);
#endif
      terminal_help_cb(w, data);
}

void ok_remove_winclass(gchar* class, winprefs_t* winprefs)
{
  char *prefix = g_strdup_printf ("/MultiTerminal/Win-Class-%s/", class);
  GtkList* l;
  GList *rl = NULL;
  char *some_class;
  int aw, ah, n;
  gchar *removed_class;
  struct win_config*  wincfg;
  GList *lapp;
  GSList** ptl;
  GSList* tmp;
  GtkWidget *oapp, *notebook;
  struct win_config *oldcfg;

  removed_class = g_strdup_printf("Win-Class-%s", class);
  gnome_config_clean_section(prefix);
  gnome_config_sync();  

  l = GTK_LIST(GTK_COMBO (winprefs->class_box)->list);
  gtk_list_clear_items(l, 0, -1);
  rl = winclass_list();
  if(rl)
    gtk_combo_set_popdown_strings (GTK_COMBO (winprefs->class_box), rl);

  some_class = _("Default");
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (winprefs->class_box)->entry), some_class);

  free_classlist(rl);
  g_free(prefix);
  
  prefix = "/MultiTerminal/Win-Config/";
  /*gtk_signal_emit_by_name(GTK_WIDGET(GTK_COMBO (prefs->class_box)->entry), "changed");*/
  gnome_config_push_prefix(prefix);
  wincfg = load_winconfig ("Win-Config");
  gnome_config_pop_prefix ();
  update_winprefs(winprefs, wincfg);
  /* we need to switch to default terminal class after having removed the current one */
  lapp = terminals;
  while (lapp)
    {
      oapp = GTK_WIDGET(lapp->data);
      ptl = gtk_object_get_data(GTK_OBJECT(oapp), "ptermlist");
      tmp = *ptl;
      oldcfg = gtk_object_get_data(GTK_OBJECT(oapp), "winconfig");
      /* app has been already changed */
      if (!strcasecmp(oldcfg->class, removed_class))
	{ /* apply only to window with the same class */
	  printf("Here\n");
	  notebook = gtk_object_get_data(GTK_OBJECT(oapp), "notebook");
	  GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(oapp),GTK_VISIBLE); 
	  n = 0;
	  aw = oapp->allocation.width;
	  ah = oapp->allocation.height;
	  apply_global_chgs(GTK_WIDGET(oapp), wincfg);
	  GTK_WIDGET_SET_FLAGS(GTK_WIDGET(oapp),GTK_VISIBLE); 
	  /* ADD 29/09/01 <erik> */
	  tmp = *ptl;
	  gtk_widget_set_usize(GTK_WIDGET(oapp), aw, ah);
	  mgt_do_resize(oapp);
	}
      lapp = lapp->next;
    }
  pref_apply_to_all_wins();
  g_free(removed_class);	
  win_config_free(wincfg);
}



void ok_remove_tabclass(gchar* class, preferences_t* prefs)
{
  char *prefix = g_strdup_printf ("/MultiTerminal/Class-%s/", class);
  GtkList* l;
  GList *rl = NULL;
  char *some_class;
  int aw, ah, n;
  gchar *removed_class;
  struct terminal_config*  cfg;
  GList *lapp;
  GSList** ptl;
  GSList* tmp;
  ZvtTerm* term;
  GtkWidget *oapp, *notebook;
  struct terminal_config *newcfg, *oldcfg;

  removed_class = g_strdup_printf("Class-%s", class);
  gnome_config_clean_section(prefix);
  gnome_config_sync();  
  l = GTK_LIST(GTK_COMBO (prefs->class_box)->list);
  gtk_list_clear_items(l, 0, -1);
  rl = tabclass_list();
  if(rl)
    gtk_combo_set_popdown_strings (GTK_COMBO (prefs->class_box), rl);

  some_class = _("Default");
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (prefs->class_box)->entry), some_class);

  free_classlist(rl);
  g_free(prefix);
  
  prefix = "/MultiTerminal/Config/";
  /*gtk_signal_emit_by_name(GTK_WIDGET(GTK_COMBO (prefs->class_box)->entry), "changed");*/
  gnome_config_push_prefix(prefix);
  cfg = load_config ("Config");
  gnome_config_pop_prefix ();
  update_prefs(prefs, cfg);
  /* we need to switch to default terminal class after having removed the current one */
  lapp = terminals;
  while (lapp)
    {
      oapp = GTK_WIDGET(lapp->data);
      ptl = gtk_object_get_data(GTK_OBJECT(oapp), "ptermlist");
      tmp = *ptl;
      term = ZVT_TERM(tmp->data);
      oldcfg = gtk_object_get_data(GTK_OBJECT(term), "config");
      /* app has been already changed */
      if (!strcasecmp(oldcfg->class, removed_class))
	{ /* apply only to window with the same class */
	  printf("Here\n");
	  notebook = gtk_object_get_data(GTK_OBJECT(oapp), "notebook");
	  GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(oapp),GTK_VISIBLE); 
	  n = 0;
	  aw = oapp->allocation.width;
	  ah = oapp->allocation.height;
	  while (tmp)
	    {
	      term = ZVT_TERM(tmp->data);
	      oldcfg = gtk_object_get_data(GTK_OBJECT(term), "config");
	      newcfg = terminal_config_dup(cfg);
	      apply_changes (term, newcfg);
	      terminal_config_free (newcfg);
	      tmp = tmp->next;
	      n++;
	    }
	  GTK_WIDGET_SET_FLAGS(GTK_WIDGET(oapp),GTK_VISIBLE); 
	  /* ADD 29/09/01 <erik> */
	  tmp = *ptl;
	  gtk_widget_set_usize(GTK_WIDGET(oapp), aw, ah);
	  mgt_do_resize(oapp);
	}
      lapp = lapp->next;
    }
  pref_apply_to_all_wins();
  g_free(removed_class);	
  terminal_config_free(cfg);
}
void dlg_winclass_remove(gint reply, gpointer data)
{
  gchar* winclass;
  winprefs_t* winprefs;

  winprefs = (winprefs_t*) data; 

  winclass = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (winprefs->class_box)->entry));

  if (!reply)
    {
      ok_remove_winclass(winclass, winprefs);   
    }
}

void dlg_class_remove(gint reply, gpointer data)
{
  gchar* class;
  preferences_t* prefs;

  prefs = (preferences_t*) data; 

  class = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (prefs->class_box)->entry));

  if (!reply)
    {
      ok_remove_tabclass(class, prefs);   
    }
}
void  win_combo_list_select(GtkEditable *l,  gpointer data)
{
  winprefs_t *winprefs = (winprefs_t*)data;
  gchar* prefix;
  struct win_config* wincfg;
  gchar* class;

  if (!strcasecmp (gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (winprefs->class_box)->entry)),
	       _("Default")))
    class = g_strdup ("Win-Config");
  else
    class = g_strconcat ("Win-Class-", 
			 gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (winprefs->class_box)->entry)), NULL);

  prefix = g_strdup_printf("/MultiTerminal/%s/", class);
  /* printf("selected:%s prefsclass:%s\n",class,
     prefs->class);
     */
  if (strcasecmp(class, winprefs->class))
    {
      gnome_config_push_prefix(prefix);
      wincfg = load_winconfig (class);
      gnome_config_pop_prefix ();
      update_winprefs(winprefs, wincfg);
      pref_apply_to_all_wins();
    }
  g_free(prefix);
  g_free(class);
}

void  combo_list_select(GtkEditable *l,  gpointer data)
{
  preferences_t *prefs = (preferences_t*)data;
  gchar* prefix;
  struct terminal_config* cfg;
  gchar* class;

  if (!strcasecmp (gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (prefs->class_box)->entry)),
	       _("Default")))
    class = g_strdup ("Config");
  else
    class = g_strconcat ("Class-", 
			 gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (prefs->class_box)->entry)), NULL);

  prefix = g_strdup_printf("/MultiTerminal/%s/", class);
  /* printf("selected:%s prefsclass:%s\n",class,
     prefs->class);
     */
  if (strcasecmp(class, prefs->class))
    {
      gnome_config_push_prefix(prefix);
      cfg = load_config (class);
      gnome_config_pop_prefix ();
      update_prefs(prefs, cfg);
      pref_apply_to_all_wins();
    }
  g_free(prefix);
  g_free(class);
}
int my_gnome_config_has_class(char* str);
void new_winclass_create(gchar* string, gpointer data)
{
  struct win_config* wincfg;
  GtkWidget* app;
  winprefs_t* winprefs;
  GtkWidget* win = (GtkWidget*) data;
  gchar *class, *prefix;
  GList* rl;
  GtkList *l;
  if (!string)
    return;
  if (strlen(string)==0)
    return;
  winprefs = gtk_object_get_data(GTK_OBJECT(win), "winprefs");
  app = gtk_object_get_data(GTK_OBJECT(win), "app");
  if (!strcasecmp (string, _("Default")))
    class = g_strdup ("Win-Config");
  else
    class = g_strconcat ("Win-Class-", string, NULL);

  prefix = g_strdup_printf("/MultiTerminal/%s/", class);

  if (gnome_config_has_section(prefix))
    {
      gnome_config_drop_all();
      gnome_warning_dialog("Class you entered already exists!");
      g_free(class);
      g_free(prefix);
      return;
    }
  gnome_config_drop_all();
  /* new class */
  wincfg = g_malloc0(sizeof(struct win_config)); 
  /* inherit settings from current class */
  win_gather_changes(wincfg, app);
  wincfg->class = g_strdup(class);
  save_winprefs_cmd (prefix, wincfg);

  l = GTK_LIST(GTK_COMBO (winprefs->class_box)->list);
  gtk_list_clear_items(l, 0, -1);
  rl = winclass_list();
  if(rl)
    gtk_combo_set_popdown_strings (GTK_COMBO (winprefs->class_box), rl);

  free_classlist(rl);
  g_free(class);
  g_free(prefix);
}


void new_class_create(gchar* string, gpointer data)
{
  struct terminal_config* cfg;
  GtkWidget* app;
  preferences_t* prefs;
  GtkWidget* win = (GtkWidget*) data;
  gchar *class, *prefix;
  GList* rl;
  GtkList *l;
  if (!string)
    return;
  if (strlen(string)==0)
    return;
  prefs = gtk_object_get_data(GTK_OBJECT(win), "prefs");
  app = gtk_object_get_data(GTK_OBJECT(win), "app");
  if (!strcasecmp (string, _("Default")) || 
      !strcasecmp(string, _("multi-gnome-terminal")) )
    class = g_strdup ("Config");
  else
    class = g_strconcat ("Class-", string, NULL);

  prefix = g_strdup_printf("/MultiTerminal/%s/", class);

  if (gnome_config_has_section(prefix))
    {
      gnome_config_drop_all();
      gnome_warning_dialog("Class you entered already exists!");
      g_free(class);
      g_free(prefix);
      return;
    }
  gnome_config_drop_all();
  /* new class */
  cfg = g_malloc0(sizeof(struct terminal_config)); 
  /* inherit settings from current class */
  gather_changes(cfg, app);
  cfg->class = g_strdup(class);
  save_preferences_cmd (prefix, cfg);

  l = GTK_LIST(GTK_COMBO (prefs->class_box)->list);
  gtk_list_clear_items(l, 0, -1);
  rl = tabclass_list();
  if(rl)
    gtk_combo_set_popdown_strings (GTK_COMBO (prefs->class_box), rl);

  free_classlist(rl);
  g_free(class);
  g_free(prefix);
}

void new_winclass_cb(GtkWidget* w, gpointer data)
{
  GtkWidget* app = (GtkWidget*)data;
  GtkWindow *win;
  GtkWidget* dlg;

  win = GTK_WINDOW(gtk_widget_get_toplevel(w));
  gtk_object_set_data(GTK_OBJECT(win), "app", app);
  dlg = gnome_request_dialog(FALSE, "New Window Class Name", NULL, 32, 
			     (GnomeStringCallback)new_winclass_create, (gpointer)win,
			     NULL);
  gtk_window_set_modal(GTK_WINDOW(dlg), TRUE);
}


void new_class_cb(GtkWidget* w, gpointer data)
{
  GtkWidget* app = (GtkWidget*)data;
  GtkWindow *win;
  GtkWidget* dlg;

  win = GTK_WINDOW(gtk_widget_get_toplevel(w));
  gtk_object_set_data(GTK_OBJECT(win), "app", app);
  dlg = gnome_request_dialog(FALSE, "New class name", NULL, 32, 
			     (GnomeStringCallback)new_class_create, (gpointer)win,
			     NULL);
  gtk_window_set_modal(GTK_WINDOW(dlg), TRUE);
}
void remove_winclass_cb(GtkWidget* w, gpointer data)
{
  winprefs_t* winprefs;
  char* tclass;
  GtkWidget* conf_win;  

  winprefs = (winprefs_t*) data;

  tclass = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (winprefs->class_box)->entry));

  if (!strcasecmp (tclass, _("Default")))
    {
      /* non si puo' eliminare la classe di default o multi-gnome-terminal*/
      conf_win = gnome_warning_dialog(_("You can't eliminate this Window Class!"));
      return ;
    }

  conf_win = gnome_ok_cancel_dialog_modal
    ("Really remove this Window Class?", dlg_winclass_remove, 
     (gpointer)winprefs);
}

void remove_class_cb(GtkWidget* w, gpointer data)
{
  preferences_t* prefs;
  char* tclass;
  GtkWidget* conf_win;  

  prefs = (preferences_t*) data;

  tclass = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (prefs->class_box)->entry));

  if (!strcasecmp (tclass, _("Default")) ||
      !strcasecmp (tclass, "multi-gnome-terminal"))
    {
      /* non si puo' eliminare la classe di default o multi-gnome-terminal*/
      conf_win = gnome_warning_dialog(_("You can't eliminate this Class!"));
      return ;
    }

  conf_win = gnome_ok_cancel_dialog_modal
    ("Really remove this Class?", dlg_class_remove, 
     (gpointer)prefs);
}
#include <ctype.h>
void 
insert_text_handler (GtkEditable *editable,
		     const gchar *text,
		     gint         length,
		     gint        *position,
		     gpointer     data)
{
  int i;

  for (i=0; i<length; i++)
    if (!isdigit(text[i]))
      {
	gtk_signal_emit_stop_by_name (GTK_OBJECT (editable), "insert_text");
	return;
      }
}
void
win_preferences_cmd (GtkWidget *widget, GSList **p_term_list)
{
  GtkWidget *b3, *b4;
  winprefs_t *winprefs = NULL;
  GList *class_list = NULL;
  char *some_class;
  struct win_config *wincfg;
  GtkWidget *app, *classrmv_but, *classnew_but;
  GtkWidget* term;
  GladeXML *gui;
  gchar *glade_file;
  GList *lapp;

  term = GTK_WIDGET(current_term(p_term_list));
#if 0
  /* Is a property window for this terminal already running? */
  if (gtk_object_get_data (GTK_OBJECT (term), "newcfg"))
    return;
#endif	
  app = gtk_widget_get_toplevel (GTK_WIDGET (term));

  winprefs = gtk_object_get_data (GTK_OBJECT (app), "winprefs");

  if (winprefs)
    {
      if (app)
	gtk_window_set_transient_for (GTK_WINDOW (winprefs->prop_win),
				      GTK_WINDOW (app));
      /* Raise and possibly uniconify the property box */
      gdk_window_show (winprefs->prop_win->window);
      return;
    }
  wincfg = gtk_object_get_data (GTK_OBJECT (app), "winconfig");

  winprefs = g_new0 (winprefs_t, 1);
  winprefs->changed = 0;

  winprefs->class = g_strdup(wincfg->class);

  glade_file = GNOME_TERMINAL_GLADEDIR "/win_prefs.glade";

  gui = glade_xml_new (glade_file, "winprefs");
  if (!gui) {
    g_warning ("Error loading `%s'", glade_file);
    return;
  }

  glade_xml_signal_autoconnect (gui);

  winprefs->prop_win = glade_xml_get_widget (gui, "winprefs");
  /* NOTE: modal to avoid problems */
  /*gtk_window_set_modal(GTK_WINDOW(prefs->prop_win), TRUE);*/

  lapp = terminals;
  while (lapp)
    {
      gtk_object_set_data(GTK_OBJECT(lapp->data), "winprefs", winprefs);
      lapp = lapp->next;
    }
  term = GTK_WIDGET((*p_term_list)->data);

  if (app)
    gtk_window_set_transient_for (GTK_WINDOW (winprefs->prop_win),
				  GTK_WINDOW (app));

  /* ============================================================================= */
  classrmv_but = glade_xml_get_widget (gui, "classrmv_but");
  gtk_signal_connect (GTK_OBJECT (classrmv_but), "clicked",
		      GTK_SIGNAL_FUNC (remove_winclass_cb), winprefs);

  classnew_but = glade_xml_get_widget (gui, "classnew_but");
  gtk_signal_connect (GTK_OBJECT (classnew_but), "clicked",
		      GTK_SIGNAL_FUNC (new_winclass_cb), app);

  winprefs->class_box = glade_xml_get_widget (gui, "class-box");

  class_list = winclass_list();

  if(class_list)
    gtk_combo_set_popdown_strings (GTK_COMBO (winprefs->class_box), class_list);
  gtk_signal_connect (GTK_OBJECT(GTK_COMBO(winprefs->class_box)->entry), "changed",
		      (GtkSignalFunc)win_combo_list_select, winprefs);
  if (!strcmp (wincfg->class, "Win-Config")) 
    some_class = _("Default");
  else
    some_class = wincfg->class + 10;
  /*printf("wincfg->class:%s some_class:%s\n", wincfg->class, some_class);*/
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (winprefs->class_box)->entry), some_class);
  gtk_signal_connect (GTK_OBJECT (GTK_COMBO (winprefs->class_box)->entry), "changed",
		      GTK_SIGNAL_FUNC (win_prop_changed), winprefs);
  free_classlist(class_list);

  winprefs->win_title = glade_xml_get_widget (gui, "wintitle-entry");

  /* Show menu bar */
  winprefs->menubar_checkbox = glade_xml_get_widget (gui, "menubar-checkbox");
  /*
     gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->menubar_checkbox),
     cfg->menubar_hidden ? 1 : 0);
     */
  gtk_signal_connect (GTK_OBJECT (winprefs->menubar_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (win_prop_changed), winprefs);
#if 1
  /* Show tool bar */
  winprefs->toolbar_checkbox = glade_xml_get_widget (gui, "toolbar-checkbox");

  gtk_signal_connect (GTK_OBJECT (winprefs->toolbar_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (win_prop_changed), winprefs);
  /* Show button bar */
  winprefs->buttonbar_checkbox = glade_xml_get_widget (gui, "buttonbar-checkbox");
  gtk_signal_connect (GTK_OBJECT (winprefs->buttonbar_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (win_prop_changed), winprefs);

  winprefs->chk_reopentabs =  glade_xml_get_widget (gui, "chk_reopentabs");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winprefs->chk_reopentabs),
				wincfg->restore_tabs ? 1 : 0);
  gtk_signal_connect (GTK_OBJECT (winprefs->chk_reopentabs), "toggled",
		      GTK_SIGNAL_FUNC (win_prop_changed), winprefs);

  winprefs->chk_restorecmds =  glade_xml_get_widget (gui, "chk_restorecmds");
  gtk_signal_connect (GTK_OBJECT (winprefs->chk_restorecmds), "toggled",
		      GTK_SIGNAL_FUNC (win_prop_changed), winprefs);

  winprefs->chk_restorepaths=  glade_xml_get_widget (gui, "chk_restorepaths");
  gtk_signal_connect (GTK_OBJECT (winprefs->chk_restorepaths), "toggled",
		      GTK_SIGNAL_FUNC (win_prop_changed), winprefs);

  winprefs->chk_restoreclasses=  glade_xml_get_widget (gui, "chk_restoreclasses");
  gtk_signal_connect (GTK_OBJECT (winprefs->chk_restoreclasses), "toggled",
		      GTK_SIGNAL_FUNC (win_prop_changed), winprefs);

  winprefs->titled_tabs = glade_xml_get_widget(gui, "titled-tabs");
  gtk_signal_connect (GTK_OBJECT (winprefs->titled_tabs), "toggled",
		      GTK_SIGNAL_FUNC (win_prop_changed), winprefs);

  winprefs->autosavetabs = glade_xml_get_widget(gui, "chk_autosavetabs");
  gtk_signal_connect (GTK_OBJECT (winprefs->autosavetabs), "toggled",
		      GTK_SIGNAL_FUNC (win_prop_changed), winprefs);

  winprefs->no_numprefix = glade_xml_get_widget(gui, "chk_noprefix");
  gtk_signal_connect (GTK_OBJECT (winprefs->no_numprefix), "toggled",
		      GTK_SIGNAL_FUNC (win_prop_changed), winprefs);

  winprefs->no_nbborder = glade_xml_get_widget(gui, "chk_nonbborder");
  gtk_signal_connect (GTK_OBJECT (winprefs->no_nbborder), "toggled",
		      GTK_SIGNAL_FUNC (win_prop_changed), winprefs);
 
  gtk_signal_connect (GTK_OBJECT (winprefs->titled_tabs), "toggled",
		      GTK_SIGNAL_FUNC(win_prop_changed), winprefs);

  winprefs->lbl_maxch = glade_xml_get_widget(gui, "lbl-maxch");

  winprefs->maxch = glade_xml_get_widget(gui, "entry-maxch");
  gtk_signal_connect (GTK_OBJECT(winprefs->maxch), "insert-text",
		      GTK_SIGNAL_FUNC( insert_text_handler ), winprefs);
  gtk_signal_connect (GTK_OBJECT(winprefs->maxch), "changed", 
		      GTK_SIGNAL_FUNC(win_prop_changed), winprefs);	
#endif

  /* --login by default */
  winprefs->login_checkbox = glade_xml_get_widget (gui, "login-by-default-checkbox");
  gtk_signal_connect (GTK_OBJECT (winprefs->login_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (win_prop_changed), winprefs);

  winprefs->close_dialog_checkbox = glade_xml_get_widget (gui, "close-dialog");
  gtk_signal_connect (GTK_OBJECT (winprefs->close_dialog_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (win_prop_changed), winprefs);

  /* tab position */
  winprefs->tab_position = glade_xml_get_widget (gui, "tab-position");
  gtk_signal_connect (GTK_OBJECT (winprefs->tab_position), "changed",
		      GTK_SIGNAL_FUNC(win_prop_changed), winprefs);

  wincheck_image_options_sensitivity (winprefs);

  /* Color palette */
  /* Terminal changing/changed color */
  winprefs->lbl_termchgn = glade_xml_get_widget(gui, "lbl_termchgn");
  winprefs->palette[0] = glade_xml_get_widget(gui, "cp_changing");
  b3 = winprefs->palette[0];
  gtk_signal_connect(GTK_OBJECT(b3), "destroy", GTK_SIGNAL_FUNC(free_cs), 
		     winprefs->palette[0]);
  winprefs->lbl_termchgd = glade_xml_get_widget(gui, "lbl_termchgd");
  winprefs->palette[1] = glade_xml_get_widget(gui, "cp_changed");
  b4 = winprefs->palette[1];
  gtk_signal_connect(GTK_OBJECT(b4), "destroy", GTK_SIGNAL_FUNC(free_cs), 
		     winprefs->palette[1]);

  winprefs->but_default = glade_xml_get_widget(gui, "but_default");	
  gtk_signal_connect(GTK_OBJECT(winprefs->but_default), "clicked", 
		     GTK_SIGNAL_FUNC(default_cols), winprefs);

  /* ADDED */
  gtk_widget_set_sensitive(GTK_WIDGET (winprefs->lbl_termchgd), 1);
  gtk_widget_set_sensitive(GTK_WIDGET (winprefs->lbl_termchgn), 1);

  /* connect the property box signals */
  gtk_signal_connect (GTK_OBJECT (winprefs->prop_win), "apply",
		      GTK_SIGNAL_FUNC (win_apply_changes_cmd), p_term_list);

  gtk_signal_connect (GTK_OBJECT (winprefs->prop_win), "destroy",
		      GTK_SIGNAL_FUNC (win_window_destroy), p_term_list);
  gtk_signal_connect (GTK_OBJECT (winprefs->prop_win), "help",
		      GTK_SIGNAL_FUNC (win_phelp_cb), NULL);

  gtk_object_set_data(GTK_OBJECT(winprefs->prop_win), "winprefs", winprefs);
  update_winprefs(winprefs, wincfg);
  gtk_object_unref (GTK_OBJECT (gui));

}

  void
preferences_cmd (GtkWidget *widget, GSList **p_term_list)
{
  GtkWidget *picker, *b10, *b5, *b4, *b1, *b2, *label, *r;
  preferences_t *prefs = NULL;
  GList *class_list = NULL;
  char *some_class;
  struct terminal_config *cfg;
  int i;
  GtkWidget *app, *classrmv_but, *classnew_but;
  GtkWidget* term;
  GladeXML *gui;
  gchar *glade_file;
  GList *lapp;
#ifdef SHADING
  GtkAdjustment* adj;
#endif

  term = GTK_WIDGET(current_term(p_term_list));
#if 0
  /* Is a property window for this terminal already running? */
  if (gtk_object_get_data (GTK_OBJECT (term), "newcfg"))
    return;
#endif	
  app = gtk_widget_get_toplevel (GTK_WIDGET (term));

  prefs = gtk_object_get_data (GTK_OBJECT (app), "prefs");

  if (prefs)
    {
      if (app)
	gtk_window_set_transient_for (GTK_WINDOW (prefs->prop_win),
				      GTK_WINDOW (app));
      /* Raise and possibly uniconify the property box */
      gdk_window_show (prefs->prop_win->window);
      return;
    }
  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");

  prefs = g_new0 (preferences_t, 1);
  prefs->changed = 0;

  prefs->class = g_strdup(cfg->class);

  glade_file = GNOME_TERMINAL_GLADEDIR "/multi-gnome-terminal.glade";

  gui = glade_xml_new (glade_file, "prefs");
  if (!gui) {
    g_warning ("Error loading `%s'", glade_file);
    return;
  }

  glade_xml_signal_autoconnect (gui);

  prefs->prop_win = glade_xml_get_widget (gui, "prefs");
  /* NOTE: modal to avoid problems */
  /*gtk_window_set_modal(GTK_WINDOW(prefs->prop_win), TRUE);*/

  lapp = terminals;
  while (lapp)
    {
      gtk_object_set_data(GTK_OBJECT(lapp->data), "prefs", prefs);
      lapp = lapp->next;
    }
  term = GTK_WIDGET((*p_term_list)->data);

  if (app)
    gtk_window_set_transient_for (GTK_WINDOW (prefs->prop_win),
				  GTK_WINDOW (app));

  /* FONT */
  prefs->font_entry = glade_xml_get_widget (gui, "font-entry");
  /*gtk_entry_set_text (GTK_ENTRY (prefs->font_entry),
    gtk_object_get_user_data (GTK_OBJECT (term)));
    gtk_entry_set_position (GTK_ENTRY (prefs->font_entry), 0);*/
  gtk_signal_connect (GTK_OBJECT (prefs->font_entry), "changed",
		      GTK_SIGNAL_FUNC (font_changed), prefs);
  gnome_dialog_editable_enters (GNOME_DIALOG (prefs->prop_win),
				GTK_EDITABLE (prefs->font_entry));

  prefs->picker = picker = glade_xml_get_widget (gui, "font-picker");
  /*gnome_font_picker_set_font_name(GNOME_FONT_PICKER(picker),
    gtk_entry_get_text(GTK_ENTRY (prefs->font_entry)));
    */
  gnome_font_picker_set_mode(GNOME_FONT_PICKER (picker),
			     GNOME_FONT_PICKER_MODE_USER_WIDGET);

  gtk_signal_connect (GTK_OBJECT (picker), "font_set",
		      GTK_SIGNAL_FUNC (font_changed), prefs);
  label = gtk_label_new (_("Browse..."));
  /* TODO:  understand better and put this stuff in update prefs */
  gnome_font_picker_uw_set_widget(GNOME_FONT_PICKER(picker), GTK_WIDGET(label));
  gtk_widget_show (label);

  gtk_object_set_user_data(GTK_OBJECT(picker), GTK_OBJECT(prefs->font_entry)); 
  gtk_object_set_user_data (GTK_OBJECT(prefs->font_entry), GTK_OBJECT(picker)); 
  /* ============================================================================= */
  /* BOLD FONT */
  prefs->boldfont_entry = glade_xml_get_widget (gui, "boldfont-entry");
  /*gtk_entry_set_text (GTK_ENTRY (prefs->font_entry),
    gtk_object_get_user_data (GTK_OBJECT (term)));
    gtk_entry_set_position (GTK_ENTRY (prefs->font_entry), 0);*/
  gtk_signal_connect (GTK_OBJECT (prefs->boldfont_entry), "changed",
		      GTK_SIGNAL_FUNC (font_changed), prefs);
  gnome_dialog_editable_enters (GNOME_DIALOG (prefs->prop_win),
				GTK_EDITABLE (prefs->boldfont_entry));

  prefs->boldpicker = picker = glade_xml_get_widget (gui, "boldfont-picker");
  /*gnome_font_picker_set_font_name(GNOME_FONT_PICKER(picker),
    gtk_entry_get_text(GTK_ENTRY (prefs->font_entry)));
    */
  gnome_font_picker_set_mode(GNOME_FONT_PICKER (picker),
			     GNOME_FONT_PICKER_MODE_USER_WIDGET);

  prefs->boldfont_label = glade_xml_get_widget (gui, "boldfont-label");
  gtk_signal_connect (GTK_OBJECT (picker), "font_set",
		      GTK_SIGNAL_FUNC (font_changed), prefs);
  label = gtk_label_new (_("Browse..."));
  /* TODO:  understand better and put this stuff in update prefs */
  gnome_font_picker_uw_set_widget(GNOME_FONT_PICKER(picker), GTK_WIDGET(label));
  gtk_widget_show (label);

  gtk_object_set_user_data(GTK_OBJECT(picker), GTK_OBJECT(prefs->boldfont_entry)); 
  gtk_object_set_user_data (GTK_OBJECT(prefs->boldfont_entry), GTK_OBJECT(picker)); 
  
  
  /* ============================================================================= */
  classrmv_but = glade_xml_get_widget (gui, "classrmv_but");
  gtk_signal_connect (GTK_OBJECT (classrmv_but), "clicked",
		      GTK_SIGNAL_FUNC (remove_class_cb), prefs);

  classnew_but = glade_xml_get_widget (gui, "classnew_but");
  gtk_signal_connect (GTK_OBJECT (classnew_but), "clicked",
		      GTK_SIGNAL_FUNC (new_class_cb), app);

  prefs->class_box = glade_xml_get_widget (gui, "class-box");

  class_list = tabclass_list();
  if(class_list)
    gtk_combo_set_popdown_strings (GTK_COMBO (prefs->class_box), class_list);
  gtk_signal_connect (GTK_OBJECT(GTK_COMBO(prefs->class_box)->entry), "changed",
		      (GtkSignalFunc)combo_list_select, prefs);
  if (!strcmp (cfg->class, "Config")) 
    some_class = _("Default");
  else
    some_class = cfg->class + 6;
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (prefs->class_box)->entry), some_class);
  gtk_signal_connect (GTK_OBJECT (GTK_COMBO (prefs->class_box)->entry), "changed",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);
  free_classlist(class_list);
  /* Toggle the use of bold */
  prefs->use_bold_checkbox = glade_xml_get_widget (gui, "use-bold-checkbox");
  /*	
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->use_bold_checkbox),
	cfg->use_bold ? 1 : 0);
	*/
#ifdef ZVT_TERM_EMBOLDEN_SUPPORT
  if (!(zvt_term_get_capabilities(ZVT_TERM(term)) & ZVT_TERM_EMBOLDEN_SUPPORT))
#endif
    gtk_widget_set_sensitive (prefs->use_bold_checkbox, FALSE);

  gtk_signal_connect (GTK_OBJECT (prefs->use_bold_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);
  /* logs */
  prefs->utmp_checkbox = glade_xml_get_widget (gui, "chk-utmp");
  gtk_signal_connect (GTK_OBJECT (prefs->utmp_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);
  prefs->wtmp_checkbox = glade_xml_get_widget (gui, "chk-wtmp");
  gtk_signal_connect (GTK_OBJECT (prefs->wtmp_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);
  prefs->lastlog_checkbox = glade_xml_get_widget (gui, "chk-lastlog");
  gtk_signal_connect (GTK_OBJECT (prefs->lastlog_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);
  /* Toggle the use of bold */
  prefs->use_boldfont = glade_xml_get_widget (gui, "use-boldfont-checkbox");
  /*	
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->use_bold_checkbox),
	cfg->use_bold ? 1 : 0);
	*/
#ifdef ZVT_TERM_EMBOLDEN_SUPPORT
  if (!(zvt_term_get_capabilities(ZVT_TERM(term)) & ZVT_TERM_EMBOLDEN_SUPPORT))
#endif
    gtk_widget_set_sensitive (prefs->use_boldfont, FALSE);

  gtk_signal_connect (GTK_OBJECT (prefs->use_boldfont), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);


  prefs->bold_color_checkbox = glade_xml_get_widget (gui, "bold-color-checkbox");
  gtk_signal_connect (GTK_OBJECT (prefs->bold_color_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);


  /* Blinking status */
  prefs->blink_checkbox = glade_xml_get_widget (gui, "blink-checkbox");
  /*
     gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->blink_checkbox),
     ZVT_TERM(term)->blink_enabled ? 1 : 0);
     */
  gtk_signal_connect (GTK_OBJECT (prefs->blink_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);

  prefs->no_border = glade_xml_get_widget(gui, "chk_noborder");
  gtk_signal_connect (GTK_OBJECT (prefs->no_border), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);
 
  prefs->font_shadow = glade_xml_get_widget(gui, "font_shadow");

  gtk_signal_connect (GTK_OBJECT (prefs->font_shadow), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);

  /* Toggle the bell */
  prefs->bell_checkbox = glade_xml_get_widget (gui, "bell-checkbox");
  gtk_signal_connect (GTK_OBJECT (prefs->bell_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);

  /* Swap keys */
  prefs->swapkeys_checkbox = glade_xml_get_widget (gui, "swapkeys-checkbox");
  gtk_signal_connect (GTK_OBJECT (prefs->swapkeys_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);

#ifdef HAVE_ZVT_DEL_IS_DEL
  /* Delete key: Send DEL/^H or kdch1 (Esc[3~) */
  prefs->del_is_del_checkbox = glade_xml_get_widget (gui, "del-is-del-checkbox");
  gtk_signal_connect (GTK_OBJECT (prefs->del_is_del_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);
#endif

  /* Use XInput Method */
  prefs->use_im_checkbox = glade_xml_get_widget (gui, "open-im-checkbox");
  gtk_signal_connect (GTK_OBJECT (prefs->use_im_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);

  /* Use fontset_load */
  prefs->use_fontset_checkbox = glade_xml_get_widget (gui, "multibyte-checkbox");
  gtk_signal_connect (GTK_OBJECT (prefs->use_fontset_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);

  /* Word selection class */
  prefs->wordclass_entry = glade_xml_get_widget (gui, "wordclass-entry");
  gtk_signal_connect (GTK_OBJECT (prefs->wordclass_entry), "changed",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);
  gnome_dialog_editable_enters (GNOME_DIALOG (prefs->prop_win),
				GTK_EDITABLE (prefs->wordclass_entry));


  /* Image page */
  /* if pixmap support isn't in zvt, we still create the widgets for
     the page, so that we can query them later, but they won't be shown
     so the user can't change them */
  if (!zvt_pixmap_support) {
    GtkWidget *image_table = glade_xml_get_widget (gui, "image-table");
    gtk_widget_hide (image_table);
  }

  prefs->back_none = r = glade_xml_get_widget (gui, "background-none-checkbox");

  /* Background Pixmap checkbox */
  prefs->pixmap_checkbox = glade_xml_get_widget (gui, "pixmap-checkbox");
  gtk_signal_connect (GTK_OBJECT (prefs->pixmap_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);

  /* Background pixmap filename */
  prefs->pixmap_label = glade_xml_get_widget (gui, "pixmap-label");

  prefs->pixmap_file_entry = glade_xml_get_widget (gui, "pixmap-file-entry");
  prefs->pixmap_entry =
    gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(prefs->pixmap_file_entry));
  gtk_entry_set_position (GTK_ENTRY (prefs->pixmap_entry), 0);
  gtk_signal_connect (GTK_OBJECT (prefs->pixmap_entry), "changed",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);

  prefs->perclbl = glade_xml_get_widget(gui, "perclbl");
  /* Scrollable pixmap */
#ifdef ZVT_BACKGROUND_SCROLL
  prefs->pixmap_scrollable_checkbox = glade_xml_get_widget (gui, "pixmap-scrollable-checkbox");
  gtk_signal_connect (GTK_OBJECT (prefs->pixmap_scrollable_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);
#else
  gtk_widget_hide (glade_xml_get_widget (gui, "pixmap-scrollable-checkbox"));
#endif
#ifdef SHADING
  prefs->om_imgmode = glade_xml_get_widget(gui, "om_imgmode");
  create_option_menu (prefs->om_imgmode,
		      GNOME_PROPERTY_BOX (prefs->prop_win), prefs,
		      image_modes, cfg->image_mode, GTK_SIGNAL_FUNC (set_active_im));

#endif	
  /* Transparency */
  prefs->transparent_checkbox = glade_xml_get_widget (gui, "transparent-checkbox");
  gtk_signal_connect (GTK_OBJECT (prefs->transparent_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);
#ifdef SHADING
  prefs->tinted_checkbox = glade_xml_get_widget(gui, "tinted-checkbox");
  gtk_signal_connect (GTK_OBJECT (prefs->tinted_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);
  prefs->tinted_colorpicker  = glade_xml_get_widget(gui, "tinted-colorpicker");
  b5 = prefs->tinted_colorpicker;
  gtk_signal_connect (GTK_OBJECT( b5 ), "destroy",
		      GTK_SIGNAL_FUNC (free_cs), prefs->tinted_colorpicker);
  gtk_signal_connect (GTK_OBJECT ( prefs->tinted_colorpicker ), "color_set",
		      GTK_SIGNAL_FUNC (color_changed), prefs);

  /* Shaded */
  prefs->shaded_hscale = glade_xml_get_widget(gui, "shaded-hscale");
  adj = gtk_range_get_adjustment(GTK_RANGE(prefs->shaded_hscale));
  gtk_signal_connect(GTK_OBJECT(adj), "value-changed", 
		     GTK_SIGNAL_FUNC (prop_changed),
		     prefs);
#endif
  prefs->shaded_checkbox = glade_xml_get_widget (gui, "shaded-checkbox");
  gtk_signal_connect (GTK_OBJECT (prefs->shaded_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);


  /* Adjust Contrast */
  prefs->contrast_hscale = glade_xml_get_widget(gui, "contrast-hscale");
  adj = gtk_range_get_adjustment(GTK_RANGE(prefs->contrast_hscale));
  gtk_signal_connect(GTK_OBJECT(adj), "value-changed", 
		     GTK_SIGNAL_FUNC (prop_changed),
		     prefs);
  
  prefs->contrast_checkbox = glade_xml_get_widget (gui, "contrast-checkbox");
  gtk_signal_connect (GTK_OBJECT (prefs->contrast_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);
  
  /* Gamma Correction */
  prefs->gamma_hscale = glade_xml_get_widget(gui, "gamma-hscale");
  adj = gtk_range_get_adjustment(GTK_RANGE(prefs->gamma_hscale));
  gtk_signal_connect(GTK_OBJECT(adj), "value-changed", 
		     GTK_SIGNAL_FUNC (prop_changed),
		     prefs);
  
  prefs->gamma_checkbox = glade_xml_get_widget (gui, "gamma-checkbox");
  gtk_signal_connect (GTK_OBJECT (prefs->gamma_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);


  check_image_options_sensitivity (prefs);
  /* Color page */

  /* Color palette */
  prefs->color_scheme = glade_xml_get_widget (gui, "color-scheme-optionmenu");
  create_option_menu (prefs->color_scheme,
		      GNOME_PROPERTY_BOX (prefs->prop_win), prefs,
		      color_scheme, cfg->color_type, GTK_SIGNAL_FUNC (set_active));
  gtk_object_set_user_data (GTK_OBJECT (prefs->color_scheme), GINT_TO_POINTER (cfg->color_type));

  prefs->lbl_boldcolor = glade_xml_get_widget(gui, "lbl_boldcolor");
  prefs->palette[19] = glade_xml_get_widget(gui, "bold_color");
  b4 = prefs->palette[19];
  gtk_signal_connect(GTK_OBJECT(b4), "destroy", GTK_SIGNAL_FUNC(free_cs), 
		     prefs->palette[19]);

  prefs->lbl_shadow = glade_xml_get_widget(gui, "lbl_shadow");
  prefs->palette[18] = glade_xml_get_widget(gui, "cp_shadow");
  b10 = prefs->palette[18];
  gtk_signal_connect(GTK_OBJECT(b10), "destroy", GTK_SIGNAL_FUNC(free_cs), 
		     prefs->palette[18]);


  prefs->fore_label = glade_xml_get_widget (gui, "foreground-label");

  prefs->palette[16] = glade_xml_get_widget (gui, "foreground-colorpicker");
  b1 = prefs->palette[16];
  gtk_signal_connect (GTK_OBJECT (b1), "destroy", GTK_SIGNAL_FUNC (free_cs), prefs->palette[16]);

  prefs->back_label = glade_xml_get_widget (gui, "background-label");

  prefs->palette[17] = glade_xml_get_widget (gui, "background-colorpicker");
  b2 = prefs->palette[17];
  gtk_signal_connect (GTK_OBJECT (b2), "destroy", GTK_SIGNAL_FUNC (free_cs), prefs->palette[17]);

  prefs->palette_label = glade_xml_get_widget (gui, "palette-label");

  for (i=0;i<20;i++) {
    if (i<16) {
      gchar *widget_name;

      widget_name = g_strdup_printf ("palette-%d-colorpicker", i);
      prefs->palette[i] = glade_xml_get_widget (gui, widget_name);
      g_free (widget_name);
    }
    gnome_color_picker_set_i16(GNOME_COLOR_PICKER(prefs->palette[i]), cfg->palette[i].red,
			       cfg->palette[i].green, cfg->palette[i].blue, 0);
    gtk_signal_connect (GTK_OBJECT (prefs->palette[i]), "color_set",
			GTK_SIGNAL_FUNC (color_changed), prefs);
  }

  /* default foreground/background selector */
  prefs->def_fore_back = glade_xml_get_widget (gui, "fore-background-optionmenu");
  create_option_menu_data (prefs->def_fore_back,
			   GNOME_PROPERTY_BOX (prefs->prop_win), prefs,
			   fore_back_table, cfg->color_set, GTK_SIGNAL_FUNC (set_active));

  check_color_sensitivity (prefs);
  /* Scrolling page */

  /* Scrollbar position */
  prefs->scrollbar = glade_xml_get_widget (gui, "scrollbar-optionmenu");
  create_option_menu (prefs->scrollbar,
		      GNOME_PROPERTY_BOX (prefs->prop_win), prefs,
		      scrollbar_position_list,
		      cfg->scrollbar_position, GTK_SIGNAL_FUNC (set_active));
  gtk_object_set_user_data(GTK_OBJECT(prefs->scrollbar), GINT_TO_POINTER(cfg->scrollbar_position));

  /* Scroll back */
  prefs->scrollback_spin = glade_xml_get_widget (gui, "scrollback-spin");
  gtk_signal_connect (GTK_OBJECT (prefs->scrollback_spin), "changed",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);
  gnome_dialog_editable_enters (GNOME_DIALOG (prefs->prop_win),
				GTK_EDITABLE (prefs->scrollback_spin));

  /* Scroll on keystroke checkbox */
  prefs->scroll_kbd_checkbox = glade_xml_get_widget (gui, "scroll-kbd-checkbox");
  gtk_signal_connect (GTK_OBJECT (prefs->scroll_kbd_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);

  /* Scroll on output checkbox */
  prefs->scroll_out_checkbox = glade_xml_get_widget (gui, "scroll-out-checkbox");
  gtk_signal_connect (GTK_OBJECT (prefs->scroll_out_checkbox), "toggled",
		      GTK_SIGNAL_FUNC (prop_changed), prefs);

  update_prefs(prefs, cfg);

  /* connect the property box signals */
  gtk_signal_connect (GTK_OBJECT (prefs->prop_win), "apply",
		      GTK_SIGNAL_FUNC (apply_changes_cmd), p_term_list);

  gtk_signal_connect (GTK_OBJECT (prefs->prop_win), "destroy",
		      GTK_SIGNAL_FUNC (window_destroy), p_term_list);
  gtk_signal_connect (GTK_OBJECT (prefs->prop_win), "help",
		      GTK_SIGNAL_FUNC (phelp_cb), NULL);

  gtk_object_set_data(GTK_OBJECT(prefs->prop_win), "prefs", prefs);
  gtk_object_unref (GTK_OBJECT (gui));


}

#define NEED_UNUSED_FUNCTIONS
#ifdef NEED_UNUSED_FUNCTIONS
  static void
color_ok (GtkWidget *w)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (w));
}

  void
color_cmd (void)
{
  GtkWidget *c;

  c = gtk_color_selection_dialog_new (_("Color selector"));
  gtk_window_set_policy(GTK_WINDOW(c), FALSE, FALSE, TRUE);
  gtk_signal_connect (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (c)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC (color_ok), c);
  gtk_widget_hide (GTK_COLOR_SELECTION_DIALOG (c)->cancel_button);
  gtk_widget_hide (GTK_COLOR_SELECTION_DIALOG (c)->help_button);
  gtk_widget_show (c);
}
#endif

GnomeUIInfo tab_radio_item[] = {
  GNOMEUIINFO_RADIOLIST(NULL), 
  GNOMEUIINFO_END};
GnomeUIInfo win_radio_item[] = {
  GNOMEUIINFO_RADIOLIST(NULL), 
  GNOMEUIINFO_END};

extern void tb_save_tabs(GtkWidget* w, GSList** ptl);

extern void tb_bonded(GtkWidget *w, GSList** ptl);
extern void tb_unbonded(GtkWidget*w, GSList** ptl);

GnomeUIInfo gnome_terminal_terminal_menu [] = {
  GNOMEUIINFO_MENU_NEW_ITEM (N_("_New Window"), N_("Creates a new terminals window"), new_terminal, NULL),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_STOCK(N_("Remove Term "), N_("Remove current terminal"), tb_remove_book, GNOME_STOCK_PIXMAP_REMOVE),
  GNOMEUIINFO_ITEM_STOCK(N_("Change Title"), N_("Change Title of current terminal"), tb_change_title,  GNOME_STOCK_MENU_PREF),
  GNOMEUIINFO_ITEM_STOCK(N_("Save Terminals"), N_("Save all terminals for the actual class"), tb_save_tabs,  GNOME_STOCK_MENU_SAVE),
  GNOMEUIINFO_ITEM_STOCK(N_("All bonded"), N_("Set all terminals as bonded "), tb_bonded,  GNOME_STOCK_MENU_ATTACH),
  GNOMEUIINFO_ITEM_STOCK(N_("All unbonded"), N_("Set all terminals as unbonded "), tb_unbonded,  GNOME_STOCK_MENU_ATTACH),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_TOGGLEITEM (N_("Show _menubar"), N_("Toggles whether or not the menubar is displayed."), toggle_menubar_cmd, NULL),
  GNOMEUIINFO_TOGGLEITEM (N_("Show _toolbar"), N_("Toggles whether or not the toolbar is displayed."), toggle_toolbar_cmd, NULL),
  GNOMEUIINFO_TOGGLEITEM (N_("Show _buttonbar"), N_("Toggles whether or not the buttonbar is displayed."), toggle_buttonbar_cmd, NULL),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_STOCK (N_("_Close Window"), NULL, close_window_cmd,
			  GNOME_STOCK_MENU_EXIT),
  GNOMEUIINFO_END
};


void toggle_bonded_cmd(GtkWidget* widget, GSList **ptl)
{
  ZvtTerm* term;
  term = current_term(ptl);
  term->bonded = !term->bonded;
}

void toggle_menubar_cmd (GtkWidget *widget, GSList **p_term_list)
{
  GnomeApp *app;
  GtkWidget* term=NULL;
  gint w, h;	
  struct win_config *wincfg=NULL;
  /* NOTE: set properly all terminals!!!*/
  term = GTK_WIDGET((*p_term_list)->data);
  app = GNOME_APP (gtk_widget_get_toplevel (GTK_WIDGET (term)));
  wincfg = gtk_object_get_data (GTK_OBJECT (app), "winconfig");

  wincfg->menubar_hidden = ! wincfg->menubar_hidden;
   
  w = GTK_WIDGET(app)->allocation.width;
  h = GTK_WIDGET(app)->allocation.height;
  /* the following hide/show avoid geometry problems 
     if the menubar is created in hide_menubar,
     i.e. if this is the first time we are showing the menubar
     */
  GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 
  if (wincfg->menubar_hidden)
    hide_menubar(app, TRUE);	  
  else
    hide_menubar (app, FALSE);

  /* update other toggle item */
  toggle_app_items(GTK_WIDGET(app), wincfg);
  GTK_WIDGET_SET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 
  /* term->p_term_list */
  save_winprefs_cmd_from_wincfg (wincfg);
  /* NOTE: here we put term instead of app because
     in this way the term size is correctly set */
  gtk_widget_set_usize(GTK_WIDGET(app), w, h);
  gtk_widget_queue_resize(GTK_WIDGET(app));
  gtk_widget_grab_focus(GTK_WIDGET(current_term(p_term_list)));
}

  void
toggle_toolbar_cmd (GtkWidget *widget, GSList **p_term_list)
{
  GtkWidget *app;
  GtkWidget* term=NULL;
  gint w, h;	
  struct win_config *wincfg=NULL;

  term = GTK_WIDGET((*p_term_list)->data);
  app = gtk_widget_get_toplevel (GTK_WIDGET (term));
  wincfg = gtk_object_get_data (GTK_OBJECT (app), "winconfig");
  wincfg->toolbar_hidden = ! wincfg->toolbar_hidden;

  /* FIXME: here it crashes sometime */
  term = GTK_WIDGET(current_term(p_term_list));	
  w = app->allocation.width;
  h = app->allocation.height;
  GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 
  if (wincfg->toolbar_hidden)
    hide_toolbar (GNOME_APP(app), TRUE);
  else
    hide_toolbar (GNOME_APP(app), FALSE);
  GTK_WIDGET_SET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 
  /* term->p_term_list */
  save_winprefs_cmd_from_wincfg (wincfg);
  /*gtk_widget_queue_resize(GTK_WIDGET(app));*/
  gtk_widget_set_usize(app, w, h);
  gtk_widget_queue_resize(GTK_WIDGET(app));
  gtk_widget_grab_focus(GTK_WIDGET(term));
}

  void
toggle_buttonbar_cmd (GtkWidget *widget, GSList **p_term_list)
{
  GnomeApp *app;
  GtkWidget* term=NULL;
  gint w, h;	
  struct win_config *wincfg=NULL;

  term = GTK_WIDGET((*p_term_list)->data);
  app = GNOME_APP (gtk_widget_get_toplevel (GTK_WIDGET (term)));
  /* NOTE:  set properly all terminals !!!*/
  wincfg = gtk_object_get_data (GTK_OBJECT (app), "winconfig");

  wincfg->buttonbar_hidden = ! wincfg->buttonbar_hidden;
  w = GTK_WIDGET(app)->allocation.width;
  h = GTK_WIDGET(app)->allocation.height;

  GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 
  if (wincfg->buttonbar_hidden)
    hide_buttonbar(app, TRUE);
  else
    hide_buttonbar(app, FALSE);
  GTK_WIDGET_SET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 
  /* term->p_term_list */
  save_winprefs_cmd_from_wincfg (wincfg);
  gtk_widget_set_usize(GTK_WIDGET(app), w, h);
  gtk_widget_queue_resize(GTK_WIDGET(app));
}



#ifdef HAVE_ZVT_TERM_RESET
  void
reset_terminal_soft_cmd (GtkWidget *widget, GSList **p_term_list) 
{
  /* fare in modo di resettare il terminale attuale */
  ZvtTerm *term;
  term = current_term(p_term_list);
  zvt_term_reset(term, 0);
}


/* could also possible clear the buffer? */
  void
reset_terminal_hard_cmd (GtkWidget *widget, GSList **p_term_list) 
{
  ZvtTerm* term;
  term = current_term(p_term_list);
  zvt_term_reset(term, 1);
}
#endif

int get_buf_lines(char **p)
{
  int x = 0;
  while (p[x])
    {
      x++;
    }  
  return x;
}

  void
select_matched(ZvtTerm *term, int sx, int sy, int ex, int ey)
{
  struct _vtx *vx;
  int yref;

  /* here we simulate pressing of left mouse+movement+rightmouse,
   * indeed I got the code from zvt_term_button_press() :) */
  vx = term->vx;

  yref = vx->vt.scrollbacklines;
  rrd(printf("yref: %d scrollbackoffset: %d scrollbacklines:%d (%d,%d)-(%d,%d)\n", 
	   yref, vx->vt.scrollbackoffset,vx->vt.scrollbacklines,
	   sx, sy, ex, ey));
  vx->selectiontype = VT_SELTYPE_CHAR|VT_SELTYPE_BYSTART;

  if (!vx->selected)
    {
      vx->selstartxold = sx;
      vx->selstartyold = sy - yref;
      vx->selendxold = sx;
      vx->selendyold = sy - yref;
      vx->selected = 1;
    }
  vx->selstartx = sx;
  vx->selstarty = sy - yref;
  vx->selendx = sx;
  vx->selendy = sy - yref;
  vt_fix_selection(vx);
  rrd(printf("dopo primo fix sel (%d,%d)-(%d,%d)\n", vx->selstartx, vx->selstarty,
	     vx->selendx, vx->selendy));
  rrd(printf("dopo primo fix sel (%d,%d)-(%d,%d)\n", vx->selstartxold, vx->selstartyold,
	     vx->selendxold, vx->selendyold));
  vx->selinitstartx = vx->selstartx;
  vx->selinitstarty = vx->selstarty;
  vx->selinitendx = vx->selstartx;
  vx->selinitendy = vx->selstarty;
  vt_draw_selection(vx);

  rrd(printf("sy: %d ey: %d\n", sy-yref, ey-yref)); 
  vx->selectiontype = VT_SELTYPE_MOVED|VT_SELTYPE_CHAR|VT_SELTYPE_BYSTART;

  vx->selendx = ex;
  vx->selendy = ey - yref;

  vt_fix_selection(vx);
  rrd(printf("DOPO SECONDO FIX SEL (%d,%d)-(%d,%d)\n", vx->selstartx, vx->selstarty,
	     vx->selendx, vx->selendy));
  rrd(printf("DOPO SECONDO fix sel (%d,%d)-(%d,%d)\n", vx->selstartxold, vx->selstartyold,
	     vx->selendxold, vx->selendyold));
  vt_draw_selection(vx);
  vx->selectiontype = VT_SELTYPE_NONE;
  /* stop selection */
}
extern char *vt_expand_line(struct vt_line *l, int size, int start, int end, char *out);

int mgt_get_lines(ZvtTerm *term, char **buf)
{
  struct _vtx *vx;
  struct vt_line *sb, *cs;
  int i, totlines;
  
  g_return_val_if_fail (term != NULL, 0);
  g_return_val_if_fail (ZVT_IS_TERM (term), 0);

  vx = term->vx;
  totlines = vx->vt.scrollbacklines + vx->vt.height;

  sb = (struct vt_line*)vx->vt.scrollback.head;
  i = 0; 
  while(sb && i < vx->vt.scrollbacklines)
    {
      vt_expand_line(sb, 1, 0, vx->vt.width, buf[i]);
      sb = sb->next;
      i++;
    }
  i = vx->vt.scrollbacklines;
  cs = (struct vt_line*)vx->vt.lines.head;
  while(cs && i < totlines)
    {
      vt_expand_line(cs, 1, 0, vx->vt.width, buf[i]);
      cs = cs->next;
      i++;
    }
  return i; /* this is the number of lines */
}

char** get_all_lines(ZvtTerm* term)
{
  int totlines;
  char** buf;
  int i;
  struct _vtx* vx = term->vx;
  totlines = vx->vt.scrollbacklines + vx->vt.height;
  buf = malloc(sizeof(char*)*(totlines+1));
  buf[totlines] = NULL;
  buf[0] = malloc(sizeof(char*)*totlines*(vx->vt.width+1));
  i = 1;
  while (i < totlines)
    {
      buf[i] = buf[0]+i*(vx->vt.width+1)*sizeof(char*);
      i++;
    }
  mgt_get_lines(term, buf);
  return buf;
}

gboolean search(ZvtTerm* term, gchar* string, int start_line, 
		int start_x, gboolean forward,
		gboolean wrap_around, gboolean case_sensitive, int *newline, int* new_x)

{
  char *pl=NULL, *pl_ini = NULL;
  char **buflines;
  gfloat value, lower, upper;
  int yadj=0, start, nl_ini, nl, tot_lines, len;
  gboolean match, nofound;
  struct _vtx *vx;
  /*
     buf = zvt_term_get_buffer(term, NULL, VT_SELTYPE_LINE,
     0, -term->vx->vt.scrollbackmax, 0, term->vx->vt.height); 

     buflines = g_strsplit(buf, "\n", 0);
     free(buf);
     */
  vx = term->vx;
  buflines = get_all_lines(term);
  rrd(printf("got lines!\n"));
  len = strlen(string);
  tot_lines = get_buf_lines(buflines);
 
  /* following conditions on start_line start_x values may be true
   * if one decreases the scrollback lines while searching for some text 
   * anyway check that they don't cause any problem */  
  if (start_line >= tot_lines)
    {
      start_line = 0;
      vx->selstartyold = 0;
      vx->selendyold = 0;
    }
  if (start_x >= term->vx->vt.width)
    {
      start_x = 0;
      vx->selstartxold = 0;
      vx->selendxold = 0; 
    }
  rrd(printf("start_x: %d start_y:%d\n", start_x, start_line));
  if (start_line != -1)
    nl = nl_ini = start_line;
  else
    {
      if (forward)
	nl = nl_ini = 0;
      else
	nl = nl_ini = tot_lines - 1;
    }
  match = FALSE;
  nofound = FALSE;
  if (start_x != -1 && strlen(buflines[nl]) >= start_x)
    pl_ini = pl = buflines[nl] + start_x;
  else
    {
      pl_ini = pl =  buflines[nl];
      start_x = 0; 
    }
  if (forward)
    pl++; 
  else
    pl--;
  while(buflines[nl])
    {
      while ((forward && (pl-buflines[nl]+len) <= strlen(buflines[nl])) ||
	     (!forward && pl>=buflines[nl]))
	{
	  if (case_sensitive)
	    { 
	      if (!strncmp(pl, string, len))	    
		{
		  match = TRUE;
		  break;
		}
	    }
	  else
	    {
	      if (!strncasecmp(pl, string, len))	    
		{
		  match = TRUE;
		  break;
		}
	    }
	  if (nl == nl_ini && (pl - buflines[nl]) == start_x)
	    {
	      nofound = TRUE;
	      break;
	    }
	  if (forward)
	    pl++;
	  else
	    pl--;
	}
      if (nofound || match)
	break;
      if (forward)
	{
	  nl++;
	  if (nl >= tot_lines)
	    {
	      if (wrap_around)
		nl = 0;
	      else
		{
		  /*g_strfreev(buflines);*/
		  *newline = nl_ini;
		  *new_x = pl_ini - buflines[nl_ini];
		  g_free(buflines[0]);
		  g_free(buflines);
		  return FALSE;
		}
	    }
	  pl = buflines[nl];

	}
      else
	{
	  nl--;
	  if (nl < 0) 
	    {
	      if (wrap_around)
		nl = tot_lines - 1;
	      else
		{
		  /*g_strfreev(buflines);*/\
		  *newline = nl_ini;
		  *new_x = pl_ini - buflines[nl_ini];
		  g_free(buflines[0]);
		  g_free(buflines); 
		  return FALSE; 
		}
	    }
	  pl = buflines[nl] + strlen(buflines[nl]) - len;
	}

    }

  rd(printf("backoffset:%d nl: %d adj:%d sbl:%d\n", term->vx->vt.scrollbackoffset,
	 nl, yadj, term->vx->vt.scrollbacklines));
  if (match)
    {
      if (!pl)
	{
	  /*g_strfreev(buflines);*/
	  g_free(buflines[0]);
	  g_free(buflines);
	  *newline = -1;
	  *new_x = -1;
	  return TRUE;
	}
      /* match line is nl */
      start = pl - buflines[nl];
      d(printf("totlines: %d Match line: %d\n", tot_lines, nl));
      upper = term->adjustment->upper;
      lower = term->adjustment->lower;
      value = (((float)nl) / ((float)tot_lines)) *  (upper - lower); 
      gtk_adjustment_set_value (term->adjustment, (int)value);
      select_matched(term, start, nl+yadj, start+len, nl+yadj);
      d(printf("upper: %f lower: %f value: %f\n", upper, lower, value));
      *new_x = pl - buflines[nl];
      *newline = nl;
      g_free(buflines[0]);
      g_free(buflines);
      /*g_strfreev(buflines);*/
      return TRUE;
    }
  else
    {
      g_free(buflines[0]);
      g_free(buflines);
      /*g_strfreev(buflines);*/
      *newline = -1;
      *new_x = -1;
      return FALSE;
    }
}

void store_search_data(struct search_data_struct* sds)
{
  GtkWidget* term, *app;
  struct stored_sdata *sapp;

  term = (*(sds->ptl))->data;
  app = gtk_widget_get_toplevel(term);
  sapp = gtk_object_get_data(GTK_OBJECT(app), "store_search_data");
  sapp->case_sensitive = GTK_TOGGLE_BUTTON(sds->case_sensitive)->active;
  sapp->back = GTK_TOGGLE_BUTTON(sds->back)->active;
  sapp->wrap_around =  GTK_TOGGLE_BUTTON(sds->wrap_around)->active;
  sapp->start_line = sds->start_line;
  sapp->start_x = sds->start_x;
  if (sapp->text)
    g_free(sapp->text);
  sapp->text = g_strdup(gtk_entry_get_text(GTK_ENTRY(sds->text)));
}

void but_search_clicked(GtkWidget* button, gpointer user_data)
{
  struct search_data_struct *sdata = (struct search_data_struct*) user_data;
  struct stored_sdata* sapp;
  char* string;
  int line, col;
  GtkWidget *term, *app;

  string = gtk_entry_get_text(GTK_ENTRY(sdata->text)); 
  term = GTK_WIDGET(current_term(sdata->ptl));
  app = gtk_widget_get_toplevel(term);
  sapp = gtk_object_get_data(GTK_OBJECT(app), "store_search_data");
  if (sapp)
    {
      sdata->start_line = sapp->start_line;
      sdata->start_x = sapp->start_x;
    }
  if (strlen(string)==0)
    return;
  d(printf("search: %s start: %d start_x: %d wrap: %d case:%d forw: %d\n", 
	   string, sdata->start_line, sdata->start_x,
	   GTK_TOGGLE_BUTTON(sdata->wrap_around)->active, 
	   GTK_TOGGLE_BUTTON(sdata->case_sensitive)->active,
	   !(GTK_TOGGLE_BUTTON(sdata->back)->active)
	  ));
  if (!search(ZVT_TERM(term), string, sdata->start_line, sdata->start_x,
	      !(GTK_TOGGLE_BUTTON(sdata->back)->active),
	      GTK_TOGGLE_BUTTON(sdata->wrap_around)->active,
	      GTK_TOGGLE_BUTTON(sdata->case_sensitive)->active, &line, &col))
    gnome_ok_dialog("The text you entered was not found!");

  sdata->start_line = line;
  sdata->start_x = col;

  store_search_data(sdata);

}
void but_cancel_clicked(GtkWidget* button, gpointer user_data)
{
  GtkWidget* win;

  win = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(win);
}

void search_destroy(GtkWidget* widget, gpointer user_data)
{
  struct search_data_struct* sdata= (struct search_data_struct*)user_data;
  GtkWidget* app, *term;
  GSList** ptl;
  ptl = sdata->ptl;
  term = GTK_WIDGET((*ptl)->data);
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  gtk_object_set_data(GTK_OBJECT(app), "search_win", NULL);
  free(user_data);
  /* do nothing? */
}

void search_txt_activate(GtkWidget* w, gpointer data)
{
  but_search_clicked(w, data);
}
void search_txt_changed(GtkWidget* w, gpointer data)
{
  struct search_data_struct* sdata = data;
  sdata->start_line = -1;
}

void search_cmd(GtkWidget* widget, GSList** p_term_list)
{
  ZvtTerm* term;
  GladeXML* gui;
  GtkWidget* win, *but_search, *but_cancel, *text, *chk_case, *chk_wrap, *chk_back;
  GtkWidget* app;
  gchar *glade_file;
  struct search_data_struct* sdata;
  struct stored_sdata* lastdata;
  GSList** ptl;

  term = ZVT_TERM((*p_term_list)->data);
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  ptl = p_term_list; 

  if (gtk_object_get_data(GTK_OBJECT(app), "search_win"))
    return; /* search window already opened */

  sdata = malloc(sizeof(struct search_data_struct));

  lastdata = gtk_object_get_data(GTK_OBJECT(app), "store_search_data");

  if (!lastdata)
    {
      lastdata = malloc(sizeof(struct stored_sdata));
      gtk_object_set_data(GTK_OBJECT(app), "store_search_data", lastdata);
      lastdata->start_line = -1;
      lastdata->start_x = -1;
      lastdata->wrap_around = FALSE;
      lastdata->case_sensitive = FALSE;
      lastdata->back = FALSE;
      lastdata->text = NULL;
    }

  glade_file = GNOME_TERMINAL_GLADEDIR "/search.glade";
  /* TODO: open search window and properly set search args  */
  gui = glade_xml_new(glade_file, "search");
  if (!gui) {
    g_warning ("Error loading `%s'", glade_file);
    return;
  }

  glade_xml_signal_autoconnect(gui);
  win = glade_xml_get_widget(gui, "search");
  gtk_object_set_data(GTK_OBJECT(app), "search_win", win);

  text = glade_xml_get_widget(gui, "text");
  if (lastdata->text)
    {
      gtk_entry_set_text(GTK_ENTRY(text), lastdata->text);
      gtk_entry_select_region(GTK_ENTRY(text), 0, -1);
    }
  gtk_window_set_focus(GTK_WINDOW(win), GTK_WIDGET(text));
  gtk_signal_connect(GTK_OBJECT(text), "activate", (GtkSignalFunc)search_txt_activate, 
		     (gpointer)sdata);
  gtk_signal_connect(GTK_OBJECT(text), "changed", (GtkSignalFunc) search_txt_changed,
		     (gpointer)sdata);

  chk_case = glade_xml_get_widget(gui, "chk_case");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_case), lastdata->case_sensitive);
  chk_back = glade_xml_get_widget(gui, "chk_back");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_back), lastdata->back);
  chk_wrap = glade_xml_get_widget(gui, "chk_wrap");

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_wrap), lastdata->wrap_around);
  but_search = glade_xml_get_widget(gui, "but_search");

  sdata->ptl = ptl;
  sdata->wrap_around = chk_wrap;
  sdata->back = chk_back;
  sdata->case_sensitive = chk_case;
  sdata->text = text;
  sdata->start_line = lastdata->start_line; 
  sdata->start_x = lastdata->start_x;
  gtk_signal_connect(GTK_OBJECT(but_search), "clicked", 
		     (GtkSignalFunc) but_search_clicked, (gpointer)sdata);

  but_cancel = glade_xml_get_widget(gui, "but_cancel");
  gtk_signal_connect(GTK_OBJECT(but_cancel), "clicked", (GtkSignalFunc) but_cancel_clicked, (gpointer) sdata);

  gtk_signal_connect(GTK_OBJECT(win), "destroy", (GtkSignalFunc) search_destroy, (gpointer) sdata);

  gtk_widget_grab_focus(GTK_WIDGET(text));
  /*search(term, "demichel", 0, TRUE, FALSE, FALSE);*/
  /* TODO: search text in current term buffer here*/

  gtk_object_unref(GTK_OBJECT(gui));

}

void search_again_cmd(GtkWidget* widget, GSList** p_term_list)
{
  /* TODO: search text again
NOTE: do as mozilla does, it simply calls search window with the search
string already set */
  GtkWidget* app;
  ZvtTerm* term;
  struct stored_sdata* lastdata;
  char* string;
  int line, col;

  term = current_term(p_term_list);
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));

  lastdata = gtk_object_get_data(GTK_OBJECT(app), "store_search_data");
  if (!lastdata)
    return;

  string = lastdata->text; 
  if (!string)
    return;

  if(!search(term, string, lastdata->start_line, lastdata->start_x,
	     !lastdata->back, lastdata->wrap_around,
	     lastdata->case_sensitive, &line, &col))
    gnome_ok_dialog("The text you entered was not found!");

  lastdata->start_line = line;
  lastdata->start_x = col;
}

  static guint32
get_current_event_time (void)
{
  GdkEvent *event;
  guint32 event_time = GDK_CURRENT_TIME;

  event = gtk_get_current_event ();

  if (event) {
    switch (event->type) {
    case GDK_MOTION_NOTIFY:
      event_time = event->motion.time;
      break;
    case GDK_BUTTON_PRESS:
    case GDK_2BUTTON_PRESS:
    case GDK_3BUTTON_PRESS:
    case GDK_BUTTON_RELEASE:
      event_time = event->button.time;
      break;
    case GDK_KEY_PRESS:
    case GDK_KEY_RELEASE:
      event_time = event->key.time;
      break;
    case GDK_ENTER_NOTIFY:
    case GDK_LEAVE_NOTIFY:
      event_time = event->crossing.time;
      break;
    case GDK_PROPERTY_NOTIFY:
      event_time = event->property.time;
      break;
    case GDK_SELECTION_CLEAR:
    case GDK_SELECTION_REQUEST:
    case GDK_SELECTION_NOTIFY:
      event_time = event->selection.time;
      break;
    case GDK_PROXIMITY_IN:
    case GDK_PROXIMITY_OUT:
      event_time = event->proximity.time;
      break;
    case GDK_CLIENT_EVENT:
    case GDK_CONFIGURE:
    case GDK_DELETE:
    case GDK_DESTROY:
    case GDK_DRAG_ENTER:
    case GDK_DRAG_LEAVE:
    case GDK_DRAG_MOTION:
    case GDK_DRAG_STATUS:
    case GDK_DROP_FINISHED:
    case GDK_DROP_START:
    case GDK_EXPOSE:
    case GDK_FOCUS_CHANGE:
    case GDK_MAP:
    case GDK_NOTHING:
    case GDK_NO_EXPOSE:
    case GDK_UNMAP:
    case GDK_VISIBILITY_NOTIFY:
      break;
    }

    gdk_event_free (event);
  }

  return event_time;
}

#ifdef COPY_CMD
static GdkAtom clipboard_atom; 

  static void
clipboard_init (void)
{
  clipboard_atom = gdk_atom_intern ("CLIPBOARD", FALSE);
}


#if 0
  static gboolean
selection_clear (GtkWidget *widget, GdkEventSelection *event, ZvtTerm *term)
{
  if (! gtk_selection_clear (widget, event))
    return FALSE;

  if (event->selection == clipboard_atom) {
    gtk_object_remove_data (GTK_OBJECT (term), "clipboard");
    gtk_signal_emit_stop_by_name (GTK_OBJECT (widget),
				  "selection_clear_event");
  }

  return TRUE;
}

static void
selection_get (GtkWidget *widget, GtkSelectionData *selection_data,
	       guint info, guint time, ZvtTerm *term)
{
  char *str;

  if (selection_data->selection != clipboard_atom)
    return;
  str = gtk_object_get_data (GTK_OBJECT (term), "clipboard");
  if (!str)
    return;
  gtk_selection_data_set (selection_data,
			  GDK_SELECTION_TYPE_STRING,
			  8, (guchar *) str, strlen (str));
  gtk_signal_emit_stop_by_name (GTK_OBJECT (widget),
				"selection_get");
}
#endif
  void
configure_term_clipboard (ZvtTerm *term)
{
#if 0
  gtk_signal_connect (GTK_OBJECT (term), "selection_clear_event",
		      GTK_SIGNAL_FUNC (selection_clear), term);

  gtk_signal_connect (GTK_OBJECT (term), "selection_get",
		      GTK_SIGNAL_FUNC (selection_get), term);
#endif

  gtk_selection_add_target (GTK_WIDGET (term),
			    clipboard_atom,
			    GDK_SELECTION_TYPE_STRING,
			    0);
}
#if 0
  static void
copy_cmd (GtkWidget *widget, GSList** p_term_list)
{
  ZvtTerm* term;
  int len;
  char* seldata;
  struct _zvtprivate *zp = _ZVT_PRIVATE(widget);

  /* AGGIUNTA 17/08/01 */
  if (p_term_list == NULL)
    return;

  term = current_term(p_term_list);
  if (term->vx->selection_size == 0)
    return;

  if (!gtk_selection_owner_set (GTK_WIDGET (term),
				clipboard_atom,
				get_current_event_time ()))
    return;

  gtk_object_set_data_full (GTK_OBJECT (term),
			    "clipboard",
			    g_strndup ((char *) term->vx->selection_data,
				       term->vx->selection_size),
			    g_free);
}
#endif
#endif
extern  int
request_paste (GtkWidget *widget, int type, gint32 time);

  void
paste_cmd (GtkWidget *widget, GSList** p_term_list)
{
  /* AGGIUNTA 17/08/01 */
  ZvtTerm* term;
  if (p_term_list == NULL)
    return;

  term = current_term(p_term_list);
#if 0
  if (clipboard_atom == GDK_NONE)
    return;
  gtk_selection_convert (GTK_WIDGET (term),
			 clipboard_atom,
			 GDK_SELECTION_TYPE_STRING,
			 get_current_event_time ());
#else
  request_paste(GTK_WIDGET(term), 0, get_current_event_time ());
#endif
}

  void
toggle_secure_keyboard_cmd (GtkWidget *w, GSList **p_term_list) 
{
  struct terminal_config *cfg=NULL;
  /*
     17/08/01: set secure keyboard for all terminals of the current window (GnomeApp)
     */
  ZvtTerm *term=NULL;
  GSList *next;
  next = *p_term_list;

  /* NOTE: set properly all terminals */
  while (next)
    { 
      term = ZVT_TERM(next->data);
      cfg = gtk_object_get_data (GTK_OBJECT (term), "config");

      cfg->keyboard_secured = ! cfg->keyboard_secured;
      next = next->next;
    }	 

  if (cfg->keyboard_secured)
    gdk_keyboard_grab (term->term_window, TRUE, GDK_CURRENT_TIME);
  else
    gdk_keyboard_ungrab (GDK_CURRENT_TIME);

}
int remove_mgt_tty(gpointer data)
{
  if (data)
    {
      unlink ((char*)data);
      g_free(data);
    }
  return 0;
}
#define sd(x) 
#ifdef ZVT_TERM_MATCH_SUPPORT
  static void
load_url_cmd (GtkWidget *widget, GSList  **p_term_list) 
{
  char *url, *url_type;
  ZvtTerm* term;
  term = current_term(p_term_list);

  url = gtk_object_get_data (GTK_OBJECT (term), "matchstr");
  url_type = gtk_object_get_data(GTK_OBJECT(term), "matchtype");

  sd(printf("PID: %d\n", term->vx->vt.childpid));
  sd(printf("URL: %s URL type: %s\n", url, url_type));	  

  if (url)
    {
      char *term_tty;
      int got_tty;
      char *pp=NULL;
      if ((got_tty = mgt_get_tty(term, &term_tty))!=-1)
	{
	  char *home;
	  FILE *f; 
	  home = getenv("HOME");
	  /* write tty device of term in file $HOME/mgt_tty */
	  pp = g_strdup_printf("%s/.mgt_tty", home);
	  rd(printf("path:%s term_tty: %s\n", pp, term_tty));
	  if ((f = fopen(pp, "w")));
	    {
	      fprintf(f, "%s", term_tty);
	      fclose(f);
	    }
	  g_free(term_tty);
	}
      if (!strcmp(url_type, "file"))
	{
	  if (url[0]=='/' || url[0]=='~') {
	    char* home=getenv("HOME");
	    int homelen= home ? strlen(home) : 0;
	    char* murl=malloc(strlen(url)+strlen("file://")+homelen+1);
	    strcpy(murl, "file://");
	    
	    if (url[0]=='~' && homelen>0) {
	      strcat(murl, home);
	      url++;
	    }
	    
	    strcat(murl, url);
	    gnome_url_show(murl);
	    free(murl);
	  }
	  else if (url[0]=='.' && strlen(url)>1 && url[1]=='/')
	    {
	      char* pwd;
	      int linklen = 0;
	      if ((linklen=mgt_get_cwd(term, &pwd))!=-1)
		{
		  char* murl=malloc(strlen(url)+strlen("file://")+linklen+1);
		  sprintf(murl, "file://%s%s", pwd, &url[1]); /* skip the .  from ./path */
		  sd(printf("MURL: %s PWD: %s\n", murl, pwd));
		  gnome_url_show(murl);
		  free(murl);
		  free(pwd);
		}
	    }
#if 0
	  else
	    {
	      char* pwd;
	      int linklen = 0;
	      if ((linklen=mgt_get_cwd(term, &pwd))!=-1)
		{
		  char* murl=malloc(strlen(url)+strlen("file://")+linklen+2);
		  sprintf(murl, "file://%s/%s", pwd, &url[0]); /* skip the .  from ./path */
		  sd(printf("MURL: %s PWD: %s\n", murl, pwd));
		  gnome_url_show(murl);
		  free(murl);
		  free(pwd);
		}
	    }
#endif
	}
      else if (!strcmp(url_type, "email address"))
	{
	  if (strchr(url, '@') && !strstr(url, "mailto")) 
	    {
	      char* murl=malloc(strlen(url)+strlen("mailto:")+1);
	      strcpy(murl, "mailto:");
	      strcat(murl, url);
	      sd(printf("MURL: %s\n", url));    
	      gnome_url_show(murl);
	      free(murl);
	    }
	  else if (strchr(url, '@'))
	    {
	      char* murl=malloc(strlen(url)+strlen("mailto:")+1);
	      strcpy(murl, "mailto:");
	      strcat(murl, url);
	      gnome_url_show(murl);
	      free(murl);
	    }
	}
      else
	{
	  gnome_url_show(url);
	}
      if (got_tty)
	{
	  /* delete .mgt_tty file if mgt-helper wasn't called */
	  gtk_timeout_add(500, remove_mgt_tty, (gpointer)pp);
	}
    }
}
#endif
/* FILL THESE */
void
on_add_button_clicked                  (GtkButton       *button,
					gpointer         user_data)
{
  GtkEntry *tn, *tc, *tp, *tcl;
  GtkCList *l;
  char *riga[4], *name;
  int r;

  tn = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_name"));
  tc = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_command"));
  tp = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_path"));
  tcl =GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_class"));

  /*l = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(button), "lista_cmd"));*/
  l = GTK_CLIST(user_data);

  riga[0] = gtk_entry_get_text(tn);
  riga[1] = gtk_entry_get_text(tp);
  if (strlen(riga[1])==0)
    riga[1] = "None";

  riga[2] = gtk_entry_get_text(tc);
  riga[3] = gtk_entry_get_text(tcl);
  if (strlen(riga[3])==0)
    riga[3] = "None";
  /* Get the number of rows in the clist object */

  if (!strlen(riga[0]) || !strlen(riga[2]))
    return;

  r = 0;
  while(gtk_clist_get_text(l, r, 0, &name))
    {
      if (!strcmp(name, riga[0]))
	{
	  gtk_clist_set_text(l, r, 1, riga[1]);
	  gtk_clist_set_text(l, r, 2, riga[2]);
	  gtk_clist_set_text(l, r, 3, riga[3]);
	  return;
	} 
      r++;
    }

  gtk_clist_append(l, riga);

}
extern int clist_selrow(GtkCList* l);

void
on_update_button_clicked                  (GtkButton       *button,
					   gpointer         user_data)
{
  GtkEntry *tn, *tc, *tp, *tcl;
  GtkCList *l;
  char *riga[4];
  int cr;

  tn = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_name"));
  tp = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_path"));
  tc = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_command"));
  tcl = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_class"));
  /*l = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(button), "lista_cmd"));*/
  l = GTK_CLIST(user_data);
  if ((cr = clist_selrow(l))==-1)
    return;

  riga[0] = gtk_entry_get_text(tn);
  riga[1] = gtk_entry_get_text(tp);
  if (strlen(riga[1]) == 0)
    riga[1] = "None";
  riga[2] = gtk_entry_get_text(tc);
  riga[3] = gtk_entry_get_text(tcl);
  if (strlen(riga[3]) == 0)
    riga[3] = "None";
  /* Get the number of rows in the clist object */

  if (!strlen(riga[0]) || !strlen(riga[2]))
    return;

  gtk_clist_set_text(l, cr, 0, riga[0]);
  gtk_clist_set_text(l, cr, 1, riga[1]);
  gtk_clist_set_text(l, cr, 2, riga[2]);
  gtk_clist_set_text(l, cr, 3, riga[3]); 
#if 0
  gtk_clist_remove(l, cr);
  gtk_clist_insert(l, cr, riga);
#endif
}

void
on_remove_button_clicked               (GtkButton       *button,
					gpointer         user_data)
{
  GtkCList *l;
  int cr;

  /*l = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(button), "lista_cmd"));*/
  l = GTK_CLIST(user_data);
  if ((cr = clist_selrow(l))==-1)
    return;

  gtk_clist_remove(l, cr);
}

extern gboolean
parse_path( gchar          *str,
	    gchar         **item);
void
su_add_button_clicked                  (GtkButton       *button,
					gpointer         user_data)
{
  GtkEntry *tn, *tc, *tp, *tcl;
  GtkCList *l;
  char *riga[4], *item = NULL;

  tn = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_name"));
  tc = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_command"));
  tp = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_path"));
  tcl =GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_class")); 
  /*l = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(button), "lista_cmd"));*/
  l = GTK_CLIST(user_data);

  riga[0] = gtk_entry_get_text(tn);
  riga[1] = gtk_entry_get_text(tp);
  if (strlen(riga[1])==0)
    riga[1] = "None";

  riga[2] = gtk_entry_get_text(tc);
  /* Get the number of rows in the clist object */
  riga[3] = gtk_entry_get_text(tcl);
  if (strlen(riga[3])==0)
    riga[3] = "None";
  if (!strlen(riga[0]) || !strlen(riga[2]))
    return;

  /* strip path from commands names */ 
  if (!parse_path(riga[0], &item))
    item = g_strdup(riga[0]);

  riga[0] = item;
  gtk_clist_append(l, riga);

  if (item)
    g_free(item);
}

void
su_update_button_clicked                  (GtkButton       *button,
					   gpointer         user_data)
{
  GtkEntry *tn, *tc, *tp, *tcl;
  GtkCList *l;
  char *riga[4], *item = NULL;
  int cr;

  tn = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_name"));
  tp = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_path"));
  tc = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_command"));
  tcl =GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_class"));

  /*l = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(button), "lista_cmd"));*/
  l = GTK_CLIST(user_data);
  if ((cr = clist_selrow(l))==-1)
    return;
  riga[0] = gtk_entry_get_text(tn);
  riga[1] = gtk_entry_get_text(tp);
  if (strlen(riga[1]) == 0)
    riga[1] = "None";
  riga[2] = gtk_entry_get_text(tc);
  riga[3] = gtk_entry_get_text(tcl);
  if (strlen(riga[3]) == 0)
    riga[3] = "None";

  /* Get the number of rows in the clist object */

  if (!strlen(riga[0]) || !strlen(riga[2]))
    return;

  /* strip path from commands names */ 
  if (!parse_path(riga[0], &item))
    item = g_strdup(riga[0]);

  riga[0] = item;
#if 0
  gtk_clist_remove(l, *p_cr);
  gtk_clist_insert(l, *p_cr, riga);
#endif
  gtk_clist_set_text(l, cr, 0, riga[0]);
  gtk_clist_set_text(l, cr, 1, riga[1]);
  gtk_clist_set_text(l, cr, 2, riga[2]);
  gtk_clist_set_text(l, cr, 3, riga[3]);
  if (item)
    g_free(item);
}


void on_su_get_clicked(GtkButton *button, 
		       gpointer user_data)
{
  GtkCList* lc, *lsu;
  int cr;
  char *riga[4], *item = NULL;

  lsu = GTK_CLIST(user_data);
  lc = gtk_object_get_data(GTK_OBJECT(button),"lista_cmd");
  if ((cr = clist_selrow(lc))==-1)
    return;

  gtk_clist_get_text(lc, cr, 0, &riga[0]);
  gtk_clist_get_text(lc, cr, 1, &riga[1]); 
  gtk_clist_get_text(lc, cr, 2, &riga[2]);
  gtk_clist_get_text(lc, cr, 3, &riga[3]);

  if (!strlen(riga[0]) || !strlen(riga[2]))
    return;

  /* strip path from commands names */ 
  if (!parse_path(riga[0], &item))
    item = g_strdup(riga[0]);

  riga[0] = item;
  gtk_clist_append(lsu, riga);
  if (item)
    g_free(item);
}
#define	ROW_ELEMENT(clist, row)	(((row) == (clist)->rows - 1) ? \
				 (clist)->row_list_end : \
				 g_list_nth ((clist)->row_list, (row)))


void on_clear_button_clicked   (GtkButton       *button,
				gpointer         user_data)
{
  GtkEntry *tn, *tc, *tp, *tcl;
  tn = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_name"));
  tc = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_command")); 
  tp = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_path")); 
  tcl =GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_class"));
  gtk_entry_set_text(tn, "");
  gtk_entry_set_text(tc, "");
  gtk_entry_set_text(tp, "");
  gtk_entry_set_text(tcl, "None");

}


void on_edit_button_clicked                  (GtkButton       *button,
					      gpointer         user_data)
{
  GtkEntry *tn, *tc, *tp, *tcl;
  GtkCList* l;
  GtkCListRow* lrow;
  int row;
  char *name,*command, *path, *class;

  l = GTK_CLIST(user_data);
  if ((row = clist_selrow(l))==-1)
    return;
  
  lrow = ROW_ELEMENT(l,row)->data;

  if (lrow)
    {
      tn = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_name"));
      tc = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_command"));  
      tp = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_path")); 
      tcl= GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "txt_class"));
      name = GTK_CELL_TEXT(lrow->cell[0])->text;
      path = GTK_CELL_TEXT(lrow->cell[1])->text;
      command = GTK_CELL_TEXT(lrow->cell[2])->text;     
      class =GTK_CELL_TEXT(lrow->cell[3])->text;
      gtk_entry_set_text(tn, name);
      gtk_entry_set_text(tc, command);
      gtk_entry_set_text(tp, path);
      gtk_entry_set_text(tcl, class);
    }
}

void ec_destroy(GtkWidget* win, gpointer user_data)
{
  gtk_object_remove_data(GTK_OBJECT(win), "chk_hardset");
  gtk_object_set_data(GTK_OBJECT(user_data), "tabs_win", NULL);
}

void
on_cancel_button_clicked               (GtkButton       *button,
					gpointer         user_data)
{
  GtkWidget* win;
  win = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(win);
}

/*static GnomeUIInfo* custom_submenu;*/
/* If you change the menu you must change also the following define accordingly */
GnomeUIInfo custom_submenu_void [] =
{
  GNOMEUIINFO_END
};

extern void new_shell(GSList** p_term_list, guint action);
extern void new_root(GSList** p_term_list, guint action);
extern void new_mc(GSList** p_term_list, guint action);
extern void remove_term(GtkWidget* term);

void popup_new_shell(GtkWidget* w, gpointer data)
{
  new_shell((GSList**) data,0);
  gtk_flush_all_events();
}

void popup_new_root(GtkWidget* w, gpointer data)
{
  new_root((GSList**) data,0);
  gtk_flush_all_events();
}

void popup_new_mc(GtkWidget* w, gpointer data)
{
  new_mc((GSList**) data,0);
  gtk_flush_all_events();
}

void popup_remove_tab(GtkWidget *w, gpointer data)
{
  GtkWidget* term;

  remove_term( GTK_WIDGET(current_term(((GSList**)data))));
  term = GTK_WIDGET(current_term(((GSList**)data)));
  gtk_widget_grab_focus(term);
}

extern void change_title_page(GtkWidget* widget, gpointer data, int page);

void popup_change_title(GtkWidget *w, gpointer data)
{
  GSList** ptl;
  ZvtTerm* ct;
  GtkWidget* nb, *app;
  ptl = (GSList**) data;
  ct = current_term(ptl);
  app = gtk_widget_get_toplevel(GTK_WIDGET(ct));
  nb = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(app), "notebook"));
  change_title_page(w, (gpointer) nb, -1);
}


#if 0
void popup_new_shell(GtkWidget* w, gpointer data)
{
  new_shell((GSList**) data,0);
}

void popup_new_root(GtkWidget* w, gpointer data)
{
  new_root((GSList**) data,0);
}

void popup_new_mc(GtkWidget* w, gpointer data)
{
  new_mc((GSList**) data,0);
}
#endif

/*
 * Warning:
 * 
 *   If you change the layout of the popup menus, you must update the
 *   value of the POPUP_MENU_TOGGLE_INDEX_* macros to reflect the new
 *   menu item indices.
 */
GnomeUIInfo mgt_settings_subtree [] = {
  GNOMEUIINFO_ITEM_STOCK (N_("Tab Preferences"), NULL,
			  preferences_cmd, GNOME_STOCK_MENU_PREF),
  GNOMEUIINFO_ITEM_STOCK (N_("Win Preferences"), NULL,
			  win_preferences_cmd, GNOME_STOCK_MENU_PREF),
  GNOMEUIINFO_ITEM_STOCK (N_("_Edit Commands..."), NULL, edit_commands,
			  GNOME_STOCK_MENU_PREF),
  GNOMEUIINFO_ITEM_STOCK (N_("_Keybindings..."),   NULL, edit_keybindings,
			  GNOME_STOCK_MENU_PREF),
  GNOMEUIINFO_ITEM_NONE (N_("_Adjust size"),   NULL, adjust_app_size),
  GNOMEUIINFO_END
};

GnomeUIInfo gnome_terminal_popup_menu [] = {
  GNOMEUIINFO_MENU_NEW_ITEM (N_("_New Window"), N_("Creates a new terminal window"), new_terminal, NULL),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_STOCK (N_("_New Shell"), N_("Creates a new tab executing bash"), popup_new_shell, GNOME_STOCK_PIXMAP_ADD),
  GNOMEUIINFO_ITEM_STOCK (N_("_New Root"), N_("Creates a new root terminal"), popup_new_root, GNOME_STOCK_PIXMAP_ADD),
  GNOMEUIINFO_ITEM_STOCK (N_("_mc"), N_("Creates a new tab executing mc"), popup_new_mc, GNOME_STOCK_PIXMAP_ADD),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_STOCK (N_("Remove Term"), N_("remove current term"), popup_remove_tab, GNOME_STOCK_PIXMAP_REMOVE),
  GNOMEUIINFO_ITEM_STOCK (N_("Change Title"), N_("Change title of current tab"), popup_change_title, GNOME_STOCK_MENU_PREF),
  GNOMEUIINFO_SEPARATOR,
  /*GNOMEUIINFO_MENU_PREFERENCES_ITEM(preferences_cmd, NULL),*/
  GNOMEUIINFO_SUBTREE(N_("Settings"), mgt_settings_subtree),
  GNOMEUIINFO_SUBTREE (N_("Tab Class"), tab_radio_item),
  GNOMEUIINFO_SUBTREE (N_("Win Class"), win_radio_item),
  GNOMEUIINFO_TOGGLEITEM (N_("_Bonded Terminal"), N_("Toggles whether or not the terminal is bonded to other ones."),
			  toggle_bonded_cmd, NULL),

  GNOMEUIINFO_TOGGLEITEM (N_("_Show menubar"), N_("Toggles whether or not the menubar is displayed."),
			  toggle_menubar_cmd, NULL),

  GNOMEUIINFO_TOGGLEITEM (N_("_Show toolbar"), N_("Toggles whether or not the toolbar is displayed."),
			  toggle_toolbar_cmd, NULL),
  GNOMEUIINFO_TOGGLEITEM (N_("_Show buttonbar"), N_("Toggles whether or not the buttonbar is displayed."),
			  toggle_buttonbar_cmd, NULL),

  GNOMEUIINFO_TOGGLEITEM (N_("_Secure keyboard"),
			  N_("Toggles whether or not the keyboard is grabbed by the terminal."),
			  toggle_secure_keyboard_cmd, NULL),
#ifdef HAVE_ZVT_TERM_RESET
  GNOMEUIINFO_ITEM_STOCK (N_("_Reset Terminal"), NULL, reset_terminal_soft_cmd,
			  GNOME_STOCK_PIXMAP_TEXT_STRIKEOUT),
  GNOMEUIINFO_ITEM_STOCK (N_("Reset and _Clear"), NULL, reset_terminal_hard_cmd,
			  GNOME_STOCK_PIXMAP_CLEAR),
#endif
#ifdef ZVT_TERM_MATCH_SUPPORT
  GNOMEUIINFO_END,	/* used as a free slot for dymanic menu item */
#endif
  GNOMEUIINFO_END
};
  char *
my_gnome_unconditional_datadir_file (const char *filename)
{
  char *ret;
  ret = malloc(512*sizeof(char));
  strcpy(ret, GNOMEDATADIR);
  strcat(ret, "/share/");
  strcat(ret, filename);
  return ret;
}


  gchar *
my_gnome_help_file_find_file (gchar *app, gchar *path)
{
  GList *language_list;
  GString *buf;

  gchar *res= NULL;
  gchar *p, c = 0;

  language_list= gnome_i18n_get_language_list ("LC_MESSAGES");
  while (!res && language_list)
    {
      const gchar *lang;

      lang= language_list->data;
      buf= g_string_new (NULL);
      g_string_sprintf (buf, "gnome/help/%s/%s/%s", app, lang, path);
      res= (gchar *)my_gnome_unconditional_datadir_file (buf->str);
      p = strrchr (res, '#');
      if (p) {
	c = *p;
	*p = '\0';
      }
      g_string_free (buf, TRUE);

      if (!g_file_exists (res))
	{
	  g_free (res);
	  res = NULL;
	}

      if (c && res){
	*p = c;
	c = 0;
      }

      language_list = language_list->next;
    }

  return res;
}


  gchar *
my_gnome_help_file_path(gchar *app, gchar *path)
{
  gchar *res;
  GString *buf;

  res = my_gnome_help_file_find_file (app, path);

  /* If we found no document on the language depending datadirs, we
     return a non existing file from a default datadir.  It's non
     existing, because 'C' is always included in a language list.  */

  if (!res)
    {
      buf = g_string_new(NULL);
      g_string_sprintf(buf, "gnome/help/%s/C/%s", app, path);
      res = (gchar *)my_gnome_unconditional_datadir_file(buf->str);
      g_string_free(buf, TRUE);
    }

  return res;
}


  void
my_gnome_help_display (void *ignore, GnomeHelpMenuEntry *ref)
{
  gchar *file, *url;

  g_assert(ref != NULL);
  g_assert(ref->path != NULL);
  g_assert(ref->name != NULL);

  file = my_gnome_help_file_path (ref->name, ref->path);

  if (!file)
    return;

  url = alloca (strlen (file)+10);
  strcpy (url,"ghelp:");
  strcat (url, file);
  gnome_help_goto (ignore, url);
  g_free (file);
}


void terminal_help_cb(GtkWidget* w, gpointer data)
{
  GnomeHelpMenuEntry help_entry = { "multi-gnome-terminal",
    "index.html" };

    my_gnome_help_display(NULL, &help_entry);
}

#ifdef ZVT_TERM_MATCH_SUPPORT
GnomeUIInfo gnome_terminal_popup_menu_url [] = {
  GNOMEUIINFO_ITEM_NONE (N_("_Open in browser"), NULL, load_url_cmd),
};

GnomeUIInfo gnome_terminal_popup_menu_file [] = {
  GNOMEUIINFO_ITEM_NONE (N_("_Open in file browser"), NULL, load_url_cmd),
};

GnomeUIInfo gnome_terminal_popup_menu_mail [] = {
  GNOMEUIINFO_ITEM_NONE (N_("_Send mail"), NULL, load_url_cmd),
};

#endif
/* TODO: replace GNOMEUIINFO_HELP with a  GNOMEUUINFO_ITEM_INFO calling a callback
   which uses my_gnome_url_show */

/*	GNOMEUIINFO_HELP ("gnome-terminal"),*/
GnomeUIInfo gnome_terminal_help_menu [] = {
  GNOMEUIINFO_ITEM_STOCK(N_("Terminal Help"), NULL, terminal_help_cb, 
			 GNOME_STOCK_PIXMAP_HELP),
  GNOMEUIINFO_MENU_ABOUT_ITEM(about_terminal_cmd, NULL),
  GNOMEUIINFO_END
};

#define NOSC_GNOMEUIINFO_MENU_PASTE_ITEM(cb, data)                               \
{ GNOME_APP_UI_ITEM_CONFIGURABLE, NULL, NULL,                       \
  (gpointer)cb, (gpointer)(data), NULL,                             \
    GNOME_APP_PIXMAP_NONE, NULL,                                      \
    NULL, (GdkModifierType) 0, NULL }

    GnomeUIInfo gnome_terminal_edit [] = {
      /*GNOMEUIINFO_MENU_PASTE_ITEM(paste_cmd, NULL),*/
      GNOMEUIINFO_ITEM_STOCK(N_("_Search"), NULL, search_cmd,  
			     GNOME_STOCK_MENU_SEARCH),
      GNOMEUIINFO_ITEM_STOCK(N_("_Search Again"), NULL, search_again_cmd,  
			     GNOME_STOCK_MENU_SEARCH),
#ifdef BROKEN_COPY_CMD
      GNOMEUIINFO_ITEM_NONE(N_("_Copy"), NULL, copy_cmd),
#endif
      GNOMEUIINFO_ITEM_STOCK(N_("_Paste"), NULL, paste_cmd,  
			     GNOME_STOCK_MENU_PASTE),
      GNOMEUIINFO_END
    };


GnomeUIInfo gnome_terminal_settings_menu [] = {
  GNOMEUIINFO_ITEM_STOCK (N_("Tab Preferences"), NULL,
			  preferences_cmd, GNOME_STOCK_MENU_PREF),
  GNOMEUIINFO_ITEM_STOCK (N_("Win Preferences"), NULL,
			  win_preferences_cmd, GNOME_STOCK_MENU_PREF),
    {
      GNOME_APP_UI_SUBTREE_STOCK, N_("Tab Class"), NULL,
      tab_radio_item ,NULL, NULL, (GnomeUIPixmapType) 0,
      NULL, 0, (GdkModifierType) 0, NULL
    },	
    {
      GNOME_APP_UI_SUBTREE_STOCK, N_("Win Class"), NULL,
      win_radio_item ,NULL, NULL, (GnomeUIPixmapType) 0,
      NULL, 0, (GdkModifierType) 0, NULL
    },	
  /*GNOMEUIINFO_SUBTREE(N_("Class"), radio_item),*/
  /*GNOMEUIINFO_ITEM_NONE (N_("_Edit Commands"), NULL, edit_commands),*/
  GNOMEUIINFO_ITEM_STOCK (N_("_Edit Commands..."), NULL, edit_commands,
			  GNOME_STOCK_MENU_PREF),
  GNOMEUIINFO_ITEM_STOCK (N_("_Keybindings..."),   NULL, edit_keybindings,
			  GNOME_STOCK_MENU_PREF),
  GNOMEUIINFO_ITEM_NONE (N_("_Adjust size"), NULL, adjust_app_size),
#ifdef HAVE_ZVT_TERM_RESET
  GNOMEUIINFO_ITEM_STOCK (N_("_Reset Terminal"), NULL, reset_terminal_soft_cmd,
			  GNOME_STOCK_PIXMAP_TEXT_STRIKEOUT),
  GNOMEUIINFO_ITEM_STOCK (N_("Reset and _Clear"), NULL, reset_terminal_hard_cmd,
			  GNOME_STOCK_PIXMAP_CLEAR),
#endif
  GNOMEUIINFO_ITEM_STOCK (N_("C_olor selector..."), NULL, color_cmd,
			  GNOME_STOCK_PIXMAP_COLORSELECTOR),
  GNOMEUIINFO_END
};

/* TENT: */
GnomeUIInfo gnome_terminal_toolbar[] = {
  /* N_("Tab Left"),*/
  GNOMEUIINFO_ITEM_FILE( NULL, N_("Reorder tabs moving the current one to left"), tb_tab_left,  "MGT_tb_back.png"),

  /* N_("Tab Right") */ 
  GNOMEUIINFO_ITEM_FILE(NULL, N_("Reorder tabs moving the current one to right"), tb_tab_right,  "MGT_tb_forward.png"),
  GNOMEUIINFO_SEPARATOR,
  /* TODO: set pixmaps properly here */
  /*GNOMEUIINFO_ITEM_STOCK(N_("New Shell"), N_("Open a new tab with bash"), tb_new_shell,
    GNOME_STOCK_PIXMAP_PREFERENCES),*/
  GNOMEUIINFO_ITEM_FILE(NULL, N_("Open a new tab with bash"), tb_new_shell,
			"MGT_tb_newshell.png"),
  /* N_("New Root") */
  GNOMEUIINFO_ITEM_FILE( NULL, N_("Open a new root tab"), tb_new_root,
			 "MGT_tb_newroot.png" ),
  GNOMEUIINFO_ITEM_FILE( NULL, N_("Open a new tab with mc"), tb_new_mc,
			 "MGT_tb_newmc.png" ),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_FILE(NULL, N_("Remove Terminal"), tb_remove_book, "MGT_tb_remove.png"),
  GNOMEUIINFO_ITEM_FILE(NULL, N_("Change Title"), tb_change_title,  "MGT_tb_title.png"),

  GNOMEUIINFO_END
};

GnomeUIInfo gnome_terminal_menu[] = {
    {
      GNOME_APP_UI_SUBTREE_STOCK, N_("File"), NULL,
      gnome_terminal_terminal_menu, NULL, NULL, (GnomeUIPixmapType) 0,
      NULL, 0, (GdkModifierType) 0, NULL
    },
    {
      GNOME_APP_UI_SUBTREE_STOCK, N_("New Term"), NULL,
      NULL, NULL, NULL, (GnomeUIPixmapType) 0,
      NULL, 0, (GdkModifierType) 0, NULL
    },	 
    {
      GNOME_APP_UI_SUBTREE_STOCK, N_("Edit"), NULL,
      gnome_terminal_edit, NULL, NULL, (GnomeUIPixmapType) 0, NULL, 0,
      (GdkModifierType) 0, NULL
    },
    {
      GNOME_APP_UI_SUBTREE_STOCK, N_("Settings"), NULL,
      gnome_terminal_settings_menu, NULL, NULL,
      (GnomeUIPixmapType) 0, NULL, 0, (GdkModifierType) 0, NULL
    },
    {
      GNOME_APP_UI_SUBTREE_STOCK, N_("Help"), NULL,
      gnome_terminal_help_menu, NULL, NULL, (GnomeUIPixmapType) 0,
      NULL, 0, (GdkModifierType) 0, NULL
    },
  GNOMEUIINFO_END
};

/*
 * Puts in *shell a pointer to the full shell pathname
 * Puts in *name the invocation name for the shell
 * *shell is newly allocated 
 * *name is newly allocated
 */
  void
get_shell_name (char **shell, char **name, gboolean isLogin)
{
  char *only_name;
  int len;

  *shell = gnome_util_user_shell ();
  g_assert (*shell != NULL);

  only_name = strrchr (*shell, '/');
  if (only_name != NULL)
    only_name++;
  else
    only_name = *shell;

  if (isLogin){
    len = strlen (only_name);

    *name  = g_malloc (len + 2);
    **name = '-';
    strcpy ((*name)+1, only_name); 
  } else {
    *name = g_strdup (only_name);
  }
}

void remove_book( GtkButton   *button, GtkNotebook *notebook );
void remove_term(GtkWidget* term);
void set_destroy_data(GtkWidget* app, GtkWidget* term);

  void
terminal_kill (GtkWidget *widget, void *data)
{
  /* 
     With Exit only one terminal is closed */
  GtkWidget *notebook, *app = gtk_widget_get_toplevel (GTK_WIDGET (data));
  GSList** p_term_list;
  p_term_list = gtk_object_get_data(GTK_OBJECT(app),"ptermlist");
  notebook = gtk_object_get_data(GTK_OBJECT(app), "notebook");

  if (g_slist_length(*p_term_list)==1)
    {
      set_destroy_data(GTK_WIDGET(app), GTK_WIDGET((*p_term_list)->data));
      ok_close_app (GTK_WIDGET (app));
    }
  else
    {
      /* calling this func is wrong because can die also a terminal 
	 which is not the current one: FIX THIS BUG!!! */
      remove_term(widget);
      gtk_widget_grab_focus(GTK_WIDGET(current_term(p_term_list)));
    }
}

char * trunc_string (char * s, int len)
{

  if (strlen(s) < len)
    return s;

  s[len-1] = '\0';
  s[len-2] = s[len-3] = s[len-4] = '.';

  return s;


}

/* called for "title_changed" event.  Use it to change the window title */
  void
title_changed(ZvtTerm *term, VTTITLE_TYPE type, char *newtitle)
{
  GnomeApp *window = GNOME_APP (gtk_widget_get_toplevel (GTK_WIDGET (term)));
  XTextProperty text_prop;
  Atom aprop;
  char *pchEndPropName;
  GtkWidget* app, *child, *label, *tab;
  GSList** ptl;
  char *ttitle, xttitle[512], wt[512], *tname, wintitle[300], tmp2[300], *st;
  struct terminal_config* cfg;
  struct win_config *wincfg;
  int len, wtlen, ntlen;

  GtkNotebook* nb;
  int n, ii;
  switch(type){
  case VTTITLE_WINDOW:
  case VTTITLE_WINDOWICON:
    /* It makes no sense to change the window title in a multiterm
       terminal so here we change tabs title instead */
    app = gtk_widget_get_toplevel(GTK_WIDGET(term));
    wincfg= gtk_object_get_data(GTK_OBJECT(app), "winconfig");
    ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
    nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
    tab = gtk_object_get_data (GTK_OBJECT (term), "tab");
    n = gtk_notebook_page_num (nb, tab);

    /* and now set tab and popup menu properly */
    ttitle = gtk_object_get_data(GTK_OBJECT(term), "termtitle");
    tname = gtk_object_get_data(GTK_OBJECT(term), "mtermname");
    cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
    /* Some programs as vim stores the window title on start and
       re-store that one on exit */
    if (wincfg->window_title)
      strcpy(wt, trunc_string(wincfg->window_title,256));
    else
      strcpy(wt, "MGT"); 
    wtlen = strlen(wt);
    ntlen = strlen(newtitle);
    st = g_strndup(newtitle, wtlen);
    if (!(!strcmp(st,wt) && newtitle[wtlen+1]=='-'
	  && newtitle[wtlen+3]=='[' && newtitle[ntlen-1]==']'))
      /*if ((res = sscanf(newtitle, "%s - [ %d-%[^]]]",
	cfg->window_title, &ii, ttitle)) < 2)*/
      {
	/* This delete an extra space otherwise added to the end of newtitle */
	strcpy(ttitle, trunc_string(newtitle, 256));
      }
    else
      {
	strcpy(xttitle, trunc_string(newtitle+wtlen+3,256));
	if (wincfg->no_numprefix)
	  {
	    if (sscanf(xttitle, "[ %[^]]]",
		       ttitle)<1)
	      strcpy(ttitle, trunc_string(xttitle, 256));
	    else
	      {
		len = strlen(ttitle);
		ttitle[len-1] = '\0';
	      }
	  }
	else
	  {
	    if (sscanf(xttitle, "[ %d-%[^]]]",
		       &ii, ttitle)<2)
	      strcpy(ttitle, trunc_string(xttitle, 256));
	    else
	      {
		len = strlen(ttitle);
		ttitle[len-1] = '\0';
	      }
	  }
      }
    g_free(st);
    /*printf("wt: %s tt: %s newt: %s\n", cfg->window_title, ttitle, newtitle);*/

    /* And now set also tab if needed */
    if (wincfg->titled_tabs)
      {
	if (wincfg->no_numprefix)
	  sprintf(tmp2, "%s", ttitle);
	else
	  sprintf(tmp2, "%d-%s", n+1, ttitle); 

	child = gtk_notebook_get_nth_page(GTK_NOTEBOOK(nb), n);
	label = gtk_notebook_get_tab_label(GTK_NOTEBOOK(nb), child);
	gtk_label_set_text(GTK_LABEL(label), trunc_string(tmp2, wincfg->maxch));
	label = gtk_notebook_get_menu_label(GTK_NOTEBOOK(nb), child);
	gtk_label_set_text(GTK_LABEL(label), trunc_string(tmp2, wincfg->maxch));
      }

    if (n == gtk_notebook_get_current_page(nb))
      {  
	if (wincfg->no_numprefix)
	  sprintf(wintitle, "%s - [ %s ]", wt, ttitle);
	else
	  sprintf(wintitle, "%s - [ %d-%s ]", wt, n+1, ttitle);
	gtk_window_set_title((GtkWindow *)window, wintitle);
      }
    break;
    /* this is a enumeration, so we can't #ifdef check it */
    /* case VTTITLE_XPROPERTY: */
  case 3:
    pchEndPropName = strchr(newtitle,'=');
    if (pchEndPropName)
      *pchEndPropName = '\0';
    aprop = XInternAtom(GDK_DISPLAY(), newtitle, False);
    if (pchEndPropName == NULL) {
      /* no "=value" given, so delete the property */
      XDeleteProperty(GDK_DISPLAY(),
		      GDK_WINDOW_XWINDOW(GTK_WIDGET(window)->window),
		      aprop);
    } else {
      text_prop.value = pchEndPropName+1;
      text_prop.encoding = XA_STRING;
      text_prop.format = 8;
      text_prop.nitems = strlen(text_prop.value);
      XSetTextProperty(GDK_DISPLAY(),
		       GDK_WINDOW_XWINDOW(GTK_WIDGET(window)->window),
		       &text_prop,aprop);
    }
    break;
  default:
    break;
  }
}

  static gchar *
extract_filename (const gchar* uri)
{
  /* file uri with a hostname */
  if (strncmp (uri, "file://", strlen ("file://")) == 0) {
    char *hostname = g_strdup (&uri[strlen("file://")]);
    char *p = strchr (hostname, '/');
    char *path;
    char localhostname[1024];
    /* if we can't find the '/' this uri is bad */
    if(p == NULL) {
      g_free (hostname);
      return NULL;
    }
    /* if no hostname */
    if(p == hostname)
      return hostname;

    path = g_strdup (p);
    *p = '\0';

    /* if really local */
    if (g_strcasecmp (hostname, "localhost") == 0 ||
	g_strcasecmp (hostname, "localhost.localdomain") == 0) {
      g_free (hostname);
      return path;
    }

    /* ok get the hostname */
    if (gethostname (localhostname,
		     sizeof (localhostname)) < 0) {
      strcpy (localhostname, "");
    }

    /* if really local */
    if (localhostname[0] &&
	g_strcasecmp (hostname, localhostname) == 0) {
      g_free (hostname);
      return path;
    }

    g_free (hostname);
    g_free (path);
    return NULL;

    /* if the file doesn't have the //, we take it containing 
       a local path */
  } else if (strncmp(uri, "file:", strlen("file:"))==0) {
    const char *path = &uri[strlen("file:")];
    /* if empty bad */
    if(!*path) return NULL;
    return g_strdup(path);
  }
  return NULL;
}

static void  
drag_data_received  (GtkWidget *widget, GdkDragContext *context, 
		     gint x, gint y,
		     GtkSelectionData *selection_data, guint info,
		     guint time)
{
  ZvtTerm *term = ZVT_TERM (widget);
  int col, row, the_char;
  struct terminal_config *cfg;
  GtkWidget *app;

  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");

  switch (info) {
  case TARGET_STRING:
      {
	char *copy = g_malloc (selection_data->length+1);
	GList *uris, *l;

	strncpy (copy, selection_data->data, selection_data->length);
	copy [selection_data->length] = 0;

	uris = gnome_uri_list_extract_uris (copy);

	for (l = uris; l; l = l->next){
	  char *data = l->data;

	  if (strncmp (data, "file:", 5) == 0)
	    data += 5;

	  vt_writechild (&term->vx->vt, data, strlen (data));
	  vt_writechild (&term->vx->vt, " ", 1);
	}
	g_free (copy);
	gnome_uri_list_free_strings (uris);
	break;
      }
  case TARGET_COLOR:
      {
	guint16 *data = (guint16 *)selection_data->data;
	preferences_t *prefs;
	int i;

	if (selection_data->length != 8)
	  return;

	col = x / term->charwidth;
	row = y / term->charheight;

	/* Switch to custom colors and */
	cfg->color_set = COLORS_CUSTOM;
	/* Here by dragging a color you can set the foreground/background color
	   of the terminal */	   
	the_char = vt_get_attr_at (term->vx, col, row) & 0xff;
	if (the_char == ' ' || the_char == 0)
	  i=17;
	else
	  i=16;

	cfg->palette[i].red = data[0];
	cfg->palette[i].green = data[1];
	cfg->palette[i].blue = data[2];

	set_color_scheme (term, cfg);
	app = gtk_widget_get_toplevel(GTK_WIDGET(term));
	save_preferences_cmd_from_cfg(cfg);

	prefs  = gtk_object_get_data (GTK_OBJECT (term), "prefs");
	if (prefs) {
	  for (i=16;i<18;i++)
	    gnome_color_picker_set_i16 (GNOME_COLOR_PICKER (prefs->palette[i]),
					cfg->palette[i].red,
					cfg->palette[i].green,
					cfg->palette[i].blue, 0);
	  gtk_option_menu_set_history (GTK_OPTION_MENU (prefs->def_fore_back),
				       cfg->color_set);
	  check_color_sensitivity (prefs);
	}
	break;
      }
  case TARGET_BGIMAGE:
      {
	char *filename = (char *)selection_data->data;
	preferences_t *prefs;
	gboolean back_set;
	gboolean back_reset;

	if (filename != NULL &&
	    strstr (filename, RESET_IMAGE_NAME) != NULL) {
	  zvt_term_set_background (term, NULL, 0, 0, 1);

	  cfg->background_pixmap = FALSE;

	  /* Switch to white on black colors */
	  cfg->color_set = COLORS_WHITE_ON_BLACK;

	  set_color_scheme (term, cfg);
	  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
	  save_preferences_cmd_from_cfg (cfg);

	  back_set = FALSE;
	  back_reset = TRUE;
	} else if (zvt_pixmap_support &&
		   filename != NULL) {
	  int flags;

	  cfg->background_pixmap = TRUE;
	  cfg->transparent = FALSE;
	  g_free (cfg->pixmap_file);
	  cfg->pixmap_file = extract_filename (filename);

#ifdef ZVT_BACKGROUND_SCROLL
	  flags = cfg->shaded?ZVT_BACKGROUND_SHADED:0;
	  flags |= cfg->scroll_background?ZVT_BACKGROUND_SCROLL:0;
#else
	  flags = cfg->shaded;
#endif
	  zvt_term_set_background (term,
				   cfg->pixmap_file,
				   cfg->transparent, flags, 1);
	  back_set = TRUE;
	  back_reset = FALSE;
	} else {
	  zvt_term_set_background (term, NULL, 0, 0, 1);
	  cfg->background_pixmap = FALSE;

	  back_set = FALSE;
	  back_reset = FALSE;
	}

	prefs  = gtk_object_get_data (GTK_OBJECT (term), "prefs");
	if (prefs) {
	  if (back_reset) {
	    gtk_option_menu_set_history (GTK_OPTION_MENU (prefs->def_fore_back),
					 cfg->color_set);
	    check_color_sensitivity (prefs);
	  } else if (back_set) {
	    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->pixmap_checkbox), TRUE);
	    gtk_entry_set_text (GTK_ENTRY (prefs->pixmap_entry),
				cfg->pixmap_file ? cfg->pixmap_file : "");
	  } else {
	    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs->pixmap_checkbox), FALSE);
	  }
	}

	gtk_widget_queue_draw (GTK_WIDGET (term));
	break;
      }
  }
}

  void
configure_term_dnd (ZvtTerm *term)
{
  static GtkTargetEntry target_table[] = {
      { "text/uri-list", 0, TARGET_STRING},
      { "STRING",     0, TARGET_STRING },
      { "text/plain", 0, TARGET_STRING },
      { "application/x-color", 0, TARGET_COLOR },
      { "property/bgimage",    0, TARGET_BGIMAGE }
  };

  gtk_signal_connect (GTK_OBJECT (term), "drag_data_received",
		      GTK_SIGNAL_FUNC(drag_data_received), NULL);

  gtk_drag_dest_set (GTK_WIDGET (term),
		     GTK_DEST_DEFAULT_MOTION |
		     GTK_DEST_DEFAULT_HIGHLIGHT |
		     GTK_DEST_DEFAULT_DROP,
		     target_table, 4,
		     GDK_ACTION_COPY);
}
extern void new_shell_vappend(GSList** p_term_list, guint action);
extern void new_shell_happend(GSList** p_term_list, guint action);
extern void new_shell_window(GSList** p_term_list, guint action);
extern void new_hmc(GSList** p_term_list, guint action);
extern void new_vmc(GSList** p_term_list, guint action);
extern void new_wmc(GSList** p_term_list, guint action);
extern void new_hroot(GSList** p_term_list, guint action);
extern void new_vroot(GSList** p_term_list, guint action);
extern void new_wroot(GSList** p_term_list, guint action);
extern void cb_hview(GSList** ptl, guint action);
extern void cb_vview(GSList** ptl, guint action);


void vsplit_with(GSList** ptl, guint action);
void hsplit_with(GSList** ptl, guint action);
void new_tab_with(GSList** ptl, guint action);

void gtk_flush_all_events(void);
/* application preferences */
extern struct app_config_t app_config;

/*static gchar* attach_data_key = "gtk-menu-attach-data";*/
void new_shell_with_command_bb(GSList** ptl, gint action);
extern void add_commands_items(char** cmds_names, GtkItemFactoryEntry* cm, int def, char *rstr);
extern GtkItemFactoryEntry menu_items[];
extern GtkItemFactoryEntry* 
free_and_add_hardset (GtkWidget* app, char **cmds,
		      GtkItemFactory *item_factory,
		      int *hsitems,
		      int *nmenu_items, 
		      GtkItemFactoryEntry *static_menu, 
		      int tearoff, char *hsitems_str, 
		      char *menu_str);

void build_popup_commands(GdkEventButton *event, GSList** ptl, ZvtTerm* term)
{
  GtkWidget* mainmenu, *submenu;
  GtkItemFactoryEntry* cm;
  GtkWidget* app;
  GtkAccelGroup* accel_group;
  GtkItemFactory* item_factory;
  int nmenu_items, hsitems;
  char **cmds, **cmds_names; 
  /*
     GnomeUIInfo sm[] = { GNOME_APP_UI_ENDOFINFO, NULL, NULL, NULL, 
     NULL, NULL,(GnomeUIPixmapType) 0, NULL, 0,(GdkModifierType) 0, NULL };

     popupmenu = gnome_popup_menu_new(sm);*/
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  cmds = app_config.cmds;

  cmds_names = app_config.cmds_names;

  mainmenu = gtk_object_get_data(GTK_OBJECT(app), "popup_factory_widget"); 
  cm =       gtk_object_get_data(GTK_OBJECT(app), "popup_factory");
  if (mainmenu)
    {
      item_factory = gtk_item_factory_from_widget(mainmenu);
    }  
  else
    {
      accel_group = gtk_accel_group_new ();
      item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", 
					   accel_group);
    }
 
  cm = free_and_add_hardset(GTK_WIDGET(app), cmds_names, item_factory,
			    &hsitems, &nmenu_items,
			    menu_items, 0, "popup_num_hardset", "popup_factory");


  add_commands_items(cmds_names, cm, hsitems, "/MAIN/");

  gtk_item_factory_create_items (item_factory, nmenu_items, cm, ptl);
  submenu = gtk_item_factory_get_widget (item_factory, "/MAIN");
  mainmenu =gtk_item_factory_get_widget (item_factory, "<main>");
  gtk_object_set_data(GTK_OBJECT(app), "popup_factory_widget", mainmenu);  

  gnome_popup_menu_do_popup_modal (submenu, NULL, NULL, event, ptl);

  /*gtk_widget_destroy (submenu);*/

  /*gtk_flush_all_events();*/
  gtk_widget_grab_focus(GTK_WIDGET(current_term(ptl)));
}

void load_su_tabs(GtkWidget* app, char* prefix)
{
  char **su_cmds, **su_names, **su_paths, **su_classes;
  int num_su, num_su2;
 
  /* now load startup tabs */
  gnome_config_push_prefix(prefix);
  gnome_config_get_vector("su_cmds", &num_su2, &su_cmds);
  gnome_config_get_vector("su_names", &num_su, &su_names);
  gnome_config_get_vector("su_paths", &num_su2, &su_paths); 
  gnome_config_get_vector("su_classes", &num_su2, &su_classes);
  safe_cmd_vector(&su_names, &su_paths, &su_cmds, &su_classes, num_su);
  gnome_config_pop_prefix();
  gtk_object_set_data(GTK_OBJECT(app), "su_names", su_names);
  gtk_object_set_data(GTK_OBJECT(app), "su_cmds", su_cmds);
  gtk_object_set_data(GTK_OBJECT(app), "su_paths", su_paths);
  gtk_object_set_data(GTK_OBJECT(app), "su_classes", su_classes);
}

int backpix_in_use(GtkWidget* app, GtkWidget* tab, char* class);
void remove_backpix(GtkWidget *app, ZvtTerm *term, GdkPixmap* backpix);
void tab_profile_cb(GtkWidget* widget, gpointer data)
{
  GtkWidget* app;
  GtkWidget* notebook, *tab;
  GSList** ptl, *tmp, **tab_terms;
  gchar* prefix;
  ZvtTerm* term;
  int n, aw, ah;
  GdkPixmap* oldbackpix;
  struct terminal_config *cfg, *load_cfg, *newcfg;
  GtkLabel* lab;
  char* class, *oldclass;

  if (!widget || !data)
    return;
  if (!(GTK_CHECK_MENU_ITEM(widget)->active))
    return;

  ptl = (GSList**) data;  
  n = 0;	
  term = ZVT_TERM((*ptl)->data);
  app = gtk_widget_get_toplevel(GTK_WIDGET(term)); 
   
  notebook = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  if (!notebook)
    return;
  tab = gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), 
				  gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)));
  tab_terms = gtk_object_get_data(GTK_OBJECT(tab), "tab_terms");
  term = ZVT_TERM((*tab_terms)->data);
  aw = app->allocation.width;
  ah = app->allocation.height;
  lab = GTK_LABEL(GTK_BIN(widget)->child);  
  gtk_label_get(lab, &class);

  if (!strcasecmp (class, _("Default")))
    class = g_strdup ("Config");
  else
    class = g_strconcat ("Class-", 
			 class, NULL);

  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");

  if (!strcasecmp(cfg->class, class))
    {
      /* if the class is unchanged do nothing */
      /*printf ("the same class!\n");*/
      g_free(class);
      return;
    }
  rd(printf("class: %s cfg->class: %s\n", class, cfg->class));
  prefix = g_strdup_printf ("/MultiTerminal/%s/", class);

  gnome_config_push_prefix (prefix);
  load_cfg = load_config (class);
  rrd(printf("[PROFILE_CB]set class: %s font: %s\n", class, load_cfg->font));
  gnome_config_pop_prefix();
  tmp = *tab_terms;
  oldbackpix = term->background.pix;
  oldclass = g_strdup(cfg->class);
#if 0
  while (tmp)
    {
      term = ZVT_TERM(tmp->data);
      printf("SET TO ZERO BACKPIX term: %p\n", term);
      term->background.pix = NULL;
      tmp = tmp->next;
    }
#endif
#if 1
  tmp = *tab_terms;
  while (tmp)
    {
      if (!GTK_WIDGET_DRAWABLE(GTK_WIDGET(tmp->data)))
	{
	  rrd(printf("term: %p NOT DRAWABLE\n", term));
	  goto out;
	}
      tmp = tmp->next;
    }
#endif
  tmp = *tab_terms;
  GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 
  while (tmp)
    {
      term = ZVT_TERM(tmp->data);
      cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
      newcfg = terminal_config_dup(load_cfg);
      apply_changes(term, newcfg);
      terminal_config_free(newcfg);
      n++;
      tmp = tmp->next;
    }
  GTK_WIDGET_SET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 
  gtk_widget_set_usize(app, aw, ah);
  
  mgt_do_resize(app);
  if (oldbackpix && !backpix_in_use(app, tab, oldclass))
    {
      rrrd(printf("[PROFILE_CB]unref backpix %p class: %s\n", oldbackpix, oldclass));
      remove_backpix(app, term, oldbackpix);
      ((GdkWindowPrivate*)oldbackpix)->ref_count = 1;
      gdk_pixmap_unref(oldbackpix);
    }
out:
  g_free(oldclass);
  g_free (prefix);
  g_free(class);	
  terminal_config_free(load_cfg);
}

void win_profile_cb(GtkWidget* widget, gpointer data)
{
  GtkWidget* app;
  GtkWidget* notebook, *tab;
  GSList** ptl;
  gchar* prefix;
  ZvtTerm* term;
  int n, aw, ah;
  struct win_config *load_cfg, *wincfg;
  GtkLabel* lab;
  char* class;

  if (!widget || !data)
    return;
  if (!(GTK_CHECK_MENU_ITEM(widget)->active))
    return;

  ptl = (GSList**) data;  
  n = 0;	
  term = ZVT_TERM((*ptl)->data);
  app = gtk_widget_get_toplevel(GTK_WIDGET(term)); 
   
  notebook = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  if (!notebook)
    return;
  tab = gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), 
				  gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)));
  aw = app->allocation.width;
  ah = app->allocation.height;
  lab = GTK_LABEL(GTK_BIN(widget)->child);  
  gtk_label_get(lab, &class);

  if (!strcasecmp (class, _("Default")))
    class = g_strdup ("Win-Config");
  else
    class = g_strconcat ("Win-Class-", 
			 class, NULL);

  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  if (!strcasecmp(wincfg->class, class))
    {
      /* if the class is unchanged do nothing */
      /*printf ("the same class!\n");*/
      g_free(class);
      return;
    }
  prefix = g_strdup_printf ("/MultiTerminal/%s/", class);

  gnome_config_push_prefix (prefix);
  load_cfg = load_winconfig (class);
  d(printf("set class: %s font: %s\n", class, load_cfg->font));
  gnome_config_pop_prefix();
  GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 
  load_su_tabs(app, prefix);
  apply_global_chgs(GTK_WIDGET(app), load_cfg);
  GTK_WIDGET_SET_FLAGS(GTK_WIDGET(app),GTK_VISIBLE); 
  gtk_widget_set_usize(app, aw, ah);
  mgt_do_resize(app);
  g_free (prefix);
  g_free(class);	
  win_config_free(load_cfg);
}
int my_gnome_config_has_class(char* str)
{
  char *foostr;
  int ret;
  gnome_config_push_prefix(str);
  foostr = gnome_config_get_string("scrollpos=noclass");
  printf("str: %s foostr:%s\n", str, foostr);
  if (!strcmp(foostr,"noclass"))
    ret = 0;
  else 
    ret = 1;
  gnome_config_pop_prefix();
  return ret;
}


int my_gnome_config_has_common(char* str)
{
  char *foostr;
  int ret;
  gnome_config_push_prefix(str);
  foostr = gnome_config_get_string("popup_mod=None");
  printf("str: %s foostr:%s\n", str, foostr);
  if (!strcmp(foostr,"None"))
    ret = 0;
  else 
    ret = 1;
  gnome_config_pop_prefix();
  return ret;
}
void add_winprofiles(gpointer* moreinfo, GtkWidget *app, GSList** ptl, int *active)

{
  GtkWidget *term;
  GnomeUIInfo* submenu;
  void *iter;
  char *class, * some_class;
  GList *class_list = NULL, *cl;
  int nc, i; 
  struct win_config *wincfg;

  GnomeUIInfo end_menu = { GNOME_APP_UI_ENDOFINFO, NULL, NULL, NULL, NULL, NULL,(GnomeUIPixmapType) 0, NULL, 0,(GdkModifierType) 0, NULL };
  if (!app)
    app = gtk_widget_get_toplevel(GTK_WIDGET((*ptl)->data));
  term = GTK_WIDGET(current_term(ptl));
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  class = wincfg->class;

  nc=0; 
  *active = 0;
  gnome_config_drop_all();
  iter = gnome_config_init_iterator_sections ("/MultiTerminal");
  while (gnome_config_iterator_next (iter, &some_class, NULL)){
    if (!strcmp (some_class, "Win-Config") || 
	!strncmp (some_class, "Win-Class-", 10))
      {
	if (!strcasecmp(some_class, class))
	  *active = nc;
	if (!strcasecmp (some_class, "Win-Config")) 
	  {
	    g_free(some_class);
	    some_class = g_strdup(_("Default"));
	  }
	else
	  {
	    char *oc = some_class; 
	    some_class = g_strdup(oc + 10);
	    g_free(oc);
	  }
	/*printf("some_class: %s\n", some_class);*/
	class_list = g_list_append(class_list, some_class);
	nc++;
      }
  }
  
  if (!class_list)
    {
      class_list = g_list_append(class_list, g_strdup(_("Default")));
      nc = 1;
    }
  nc++; 
  if (*moreinfo)
    {
      int x = 0;
      GnomeUIInfo* cm;
      cm = (GnomeUIInfo*) *moreinfo;
      while (cm[x].type != GNOME_APP_UI_ENDOFINFO)
	{
	  g_free(cm[x].label);
	  x++;
	}
      g_free(*moreinfo);
    }
  submenu = (GnomeUIInfo*)malloc(sizeof(GnomeUIInfo)*nc);
  /*printf("nc: %d\n", nc);*/
  i = 0;
  cl = class_list;
  while (cl)  
    {
      submenu[i].type = GNOME_APP_UI_ITEM;
      submenu[i].label = (char*) cl->data; 
      submenu[i].hint = NULL;
      submenu[i].moreinfo = win_profile_cb;
      submenu[i].user_data = ptl;
      submenu[i].unused_data = NULL;
      submenu[i].pixmap_type = 0;
      submenu[i].pixmap_info = NULL;
      submenu[i].accelerator_key = 0;
      submenu[i].ac_mods = 0;
      submenu[i].widget = NULL;
      i++;
      cl = cl->next;
    }
  memcpy(submenu+i, &end_menu, sizeof(GnomeUIInfo));

  *moreinfo = submenu;
  g_list_free(class_list);

}

void add_tabprofiles(gpointer* moreinfo, GtkWidget *app, GSList** ptl, int *active)

{
  GtkWidget *term;
  GnomeUIInfo* submenu;
  void *iter;
  char *class, * some_class;
  GList *class_list = NULL, *cl;
  int nc, i; 
  struct terminal_config *cfg;
  GnomeUIInfo end_menu = { GNOME_APP_UI_ENDOFINFO, NULL, NULL, NULL, NULL, NULL,(GnomeUIPixmapType) 0, NULL, 0,(GdkModifierType) 0, NULL };
#if 0
  submenu = (GnomeUIInfo*)malloc(sizeof(GnomeUIInfo));
  memcpy(submenu, &end_menu, sizeof(GnomeUIInfo));
  *moreinfo = submenu;
  return NULL;
#endif
  if (!app)
    app = gtk_widget_get_toplevel(GTK_WIDGET((*ptl)->data));
  term = GTK_WIDGET(current_term(ptl));
  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
  class = cfg->class;

  nc=0; 
  *active = 0;
  gnome_config_drop_all();
  iter = gnome_config_init_iterator_sections ("/MultiTerminal");
  while (gnome_config_iterator_next (iter, &some_class, NULL)){
    if (!strcmp (some_class, "Config") || !strncmp (some_class, "Class-", 6)){
      if (!strcasecmp(some_class, class))
	*active = nc;
      if (!strcasecmp (some_class, "Config")) 
	{
	  g_free(some_class);
	  some_class = g_strdup(_("Default"));
	}
      else
	{
	  char *oc = some_class; 
	  some_class = g_strdup(oc + 6);
	  g_free(oc);
	}
      /*printf("some_class: %s\n", some_class);*/
      class_list = g_list_append(class_list, some_class);
      nc++;
    }
  }
  if (!class_list)
    {
      class_list = g_list_append(class_list, g_strdup(_("Default")));
      nc = 1;
    }

  nc++; 
  if (*moreinfo)
    {
      int x = 0;
      GnomeUIInfo* cm;
      cm = (GnomeUIInfo*) *moreinfo;
      while (cm[x].type != GNOME_APP_UI_ENDOFINFO)
	{
	  g_free(cm[x].label);
	  x++;
	}
      g_free(*moreinfo);
    }
  submenu = (GnomeUIInfo*)malloc(sizeof(GnomeUIInfo)*nc);
  /*printf("nc: %d\n", nc);*/
  i = 0;
  cl = class_list;
  while (cl)  
    {
      submenu[i].type = GNOME_APP_UI_ITEM;
      submenu[i].label = (char*) cl->data; 
      submenu[i].hint = NULL;
      submenu[i].moreinfo = tab_profile_cb;
      submenu[i].user_data = ptl;
      submenu[i].unused_data = NULL;
      submenu[i].pixmap_type = 0;
      submenu[i].pixmap_info = NULL;
      submenu[i].accelerator_key = 0;
      submenu[i].ac_mods = 0;
      submenu[i].widget = NULL;
      i++;
      cl = cl->next;
    }
  memcpy(submenu+i, &end_menu, sizeof(GnomeUIInfo));

  *moreinfo = submenu;
  g_list_free(class_list);

}
extern void detach_term(GtkWidget* term, int preserve);
extern void attach_term(GtkWidget* term, int split_type);
void to_new_tab(GtkWidget* term);
void
create_view(GtkWidget* term, int split_type);
void check_boundaries(struct _vtx *vx, int *x, int *y);

void right_click_menu(GdkEventButton *event, GSList **p_term_list, ZvtTerm *term)
{
  GtkCheckMenuItem *toggle_item;
  GtkCheckMenuItem *check_item;
  int tab_active, win_active;
  GtkWidget *menu, *app;
  GnomeUIInfo *uiinfo;
  struct terminal_config *cfg;
  struct win_config *wincfg;

  uiinfo = gnome_terminal_popup_menu;

  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");

  tab_radio_item[0].moreinfo = NULL;
  win_radio_item[0].moreinfo = NULL;
  add_tabprofiles(&(tab_radio_item[0].moreinfo), 
	       NULL, p_term_list,  &tab_active);	
  add_winprofiles(&(win_radio_item[0].moreinfo), 
	       NULL, p_term_list, &win_active);	
  
  menu = gnome_popup_menu_new (gnome_terminal_popup_menu);

  gtk_object_set_data (GTK_OBJECT (menu), "gnome_popup_menu_do_popup_user_data", NULL);

  check_item = GTK_CHECK_MENU_ITEM( ((GnomeUIInfo*)tab_radio_item[0].moreinfo)[tab_active].widget);

  gtk_check_menu_item_set_active ( check_item, TRUE);
  
  check_item = GTK_CHECK_MENU_ITEM( ((GnomeUIInfo*)win_radio_item[0].moreinfo)[win_active].widget);

  gtk_check_menu_item_set_active ( check_item, TRUE);
  
  if (tab_radio_item[0].moreinfo)
    {
      int x = 0;
      GnomeUIInfo* cm;
      cm = (GnomeUIInfo*) tab_radio_item[0].moreinfo;
      while (cm[x].type != GNOME_APP_UI_ENDOFINFO)
	{
	  g_free(cm[x].label);
	  x++;
	}
      g_free(tab_radio_item[0].moreinfo);
    }
  if (win_radio_item[0].moreinfo)
    {
      int x = 0;
      GnomeUIInfo* cm;
      cm = (GnomeUIInfo*) win_radio_item[0].moreinfo;
      while (cm[x].type != GNOME_APP_UI_ENDOFINFO)
	{
	  g_free(cm[x].label);
	  x++;
	}
      g_free(win_radio_item[0].moreinfo);
    }

  
  tab_radio_item[0].moreinfo = NULL;
  win_radio_item[0].moreinfo = NULL;
  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");

  toggle_item = GTK_CHECK_MENU_ITEM (uiinfo [POPUP_MENU_TOGGLE_INDEX_BONDED].widget);
  toggle_item->active = term->bonded;

  /*
   * Set the toggle state for the "show menubar"
   * menu item.
   */
  toggle_item = GTK_CHECK_MENU_ITEM (uiinfo [POPUP_MENU_TOGGLE_INDEX_MENUBAR].widget);
  toggle_item->active = ! wincfg->menubar_hidden;

  /*
   * Set the toggle state for the "show toolbar"
   * menu item.
   */
  toggle_item = GTK_CHECK_MENU_ITEM (uiinfo [POPUP_MENU_TOGGLE_INDEX_TOOLBAR].widget);
  toggle_item->active = ! wincfg->toolbar_hidden;


  /*
   * Set the toggle state for the "show toolbar"
   * menu item.
   */
  toggle_item = GTK_CHECK_MENU_ITEM (uiinfo [POPUP_MENU_TOGGLE_INDEX_BUTTONBAR].widget);
  toggle_item->active = ! wincfg->buttonbar_hidden;


  /*
   * Set the toggle state for the secure keyboard
   * menu item.
   */
  toggle_item = GTK_CHECK_MENU_ITEM (uiinfo [POPUP_MENU_TOGGLE_INDEX_SECURE].widget);
  toggle_item->active = cfg->keyboard_secured;

  gnome_popup_menu_do_popup_modal (menu, NULL, NULL, event, p_term_list);

  gtk_widget_destroy (menu);
  
  /*gtk_flush_all_events();*/
  gtk_widget_grab_focus(GTK_WIDGET(current_term(p_term_list)));
  /*
   * The popup menu ungrabs the keyboard if it was grabbed,
   * so we grab it again here.
   */
  if (cfg->keyboard_secured)
    gdk_keyboard_grab (term->term_window, TRUE, GDK_CURRENT_TIME);

}
extern void
vtx_unrender_selection (struct _vtx *vx);

int selection_mode_off(ZvtTerm* term)
{
  if (term->vx->selected)
    {
#if 0
      int x, y;
      GtkWidget *w = GTK_WIDGET(term);
      term->vx->selected = 0;
      /* reset selection */
      x = ( x - ( w->style->klass->xthickness + 2 ) ) / term->charwidth;
      y = ( y - w->style->klass->ythickness ) / term->charheight;
      check_boundaries(term->vx, &x, &y);
      term->vx->selstartx = x;
      term->vx->selstarty = y;
      term->vx->selendx = x;
      term->vx->selendy = y;
      term->vx->selectiontype = VT_SELTYPE_NONE;
      vt_fix_selection(term->vx);
      vt_draw_selection(term->vx);
#endif
      vtx_unrender_selection(term->vx);
      return TRUE;
    }
  else
    return FALSE;
}

int
button_press (GtkWidget *widget, GdkEventButton *event, ZvtTerm *term)
{
  /* g.o. - we need to update the "active" term of the tab */
  GtkWidget* app, *te, *notebook, *tab;
  GSList** p_term_list, *tt;
  int popupmod;
  char *match_type = NULL;
#ifdef ZVT_TERM_MATCH_SUPPORT
  char *match;
  int x,y, pgno;
  GdkModifierType mask;
#endif
#ifdef ZVT_TERM_MATCH_SUPPORT
  gdk_window_get_pointer(widget->window, &x, &y, &mask);
  match = zvt_term_match_check(term, x/term->charwidth, y/term->charheight,(void**) &match_type);
  /* Terminal get focus clicking on it */
  gtk_widget_grab_focus(GTK_WIDGET(term));
  
  tab = gtk_object_get_data (GTK_OBJECT (term), "tab");
  gtk_object_set_data (GTK_OBJECT (tab), "active", term);
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  notebook = gtk_object_get_data (GTK_OBJECT (app), "notebook");
 
  rd(printf("tab (%dx%d)\n", tab->allocation.width, tab->allocation.height));

  pgno = gtk_notebook_page_num (GTK_NOTEBOOK (notebook), tab);
  
  set_titles (app, pgno, pgno);
  p_term_list = (GSList**) gtk_object_get_data(GTK_OBJECT(app), "ptermlist");

  /*printf("*ppmod: %d event->state: %d\n", *ppmod, event->state);*/
  switch (app_config.popupmod)
    {
      /*
	 case 3:
	 popupmod = GDK_MOD2_MASK; 
	 break;*/
    case 1:
      popupmod = GDK_SHIFT_MASK;
      break;
    case 2:
      popupmod = GDK_MOD1_MASK;
      break;
    default:
      popupmod = GDK_CONTROL_MASK;
    }

  /*
     if (event->type == GDK_2BUTTONPRESS && match)
     {
     gtk_signal_emit_stop_by_name (GTK_OBJECT (widget), "button_press_event");
     gnome_url_show (match);
     return TRUE;
     }
     */
  
  if (splitw.term_to_split) 
    {
      GtkWidget* tab1, *tab2;
      gtk_signal_emit_stop_by_name (GTK_OBJECT (widget), "button_press_event");
      if (event->button == 2 || event->button == 3)
	{
	  splitw.term_to_split = NULL;
	  return TRUE;
	}
      if (splitw.type == 2)
	{
	  if (g_slist_length(*p_term_list)==1 && splitw.term_to_split == app)
	    return TRUE;
	  detach_term(GTK_WIDGET(term), 1); 
	  to_new_tab(GTK_WIDGET(term));
	  return TRUE;  
	}
      tab1 = gtk_object_get_data(GTK_OBJECT(term), "tab");
      tab2 = gtk_object_get_data(GTK_OBJECT(splitw.term_to_split),"tab");
      if (tab1!=tab2 )
	{
	  GtkWidget* pane;
	  if (splitw.type == 3)
	    {
	      create_view(GTK_WIDGET(term), MGT_HORIZ_SPLIT);
	      return TRUE;
	    }
	  else if (splitw.type == 4)
	    {
	      create_view(GTK_WIDGET(term), MGT_VERT_SPLIT);
	      return TRUE;
	    }
	  pane = gtk_object_get_data(GTK_OBJECT(term), "pane");
	  detach_term(GTK_WIDGET(term), 1); 
	  attach_term(GTK_WIDGET(term), splitw.type?MGT_HORIZ_SPLIT:MGT_VERT_SPLIT);
      	  return TRUE;
	}
      splitw.term_to_split = NULL;
      return TRUE;
    }

  if (event->button == 2
      && (event->state & popupmod)
      && match) {
    char *tmp;
    gtk_signal_emit_stop_by_name (GTK_OBJECT (widget), "button_press_event");
    te = GTK_WIDGET(current_term(p_term_list));
    tmp = gtk_object_get_data(GTK_OBJECT(te), "matchstr");
    if (tmp)
      g_free(tmp);
    tmp = gtk_object_get_data(GTK_OBJECT(te), "matchtype");
    if (tmp)
      g_free(tmp);
    gtk_object_set_data (GTK_OBJECT (te), "matchstr", g_strdup(match));
    gtk_object_set_data (GTK_OBJECT (te), "matchtype", g_strdup(match_type));
    load_url_cmd(GTK_WIDGET(te) , p_term_list);
    return TRUE;
  }
  

#endif /* ZVT_TERM_MATCH_SUPPORT */

  if ( (event->button == 3 && !(event->state & popupmod) && term->vx->selected)
       || (term->vx->vt.mode & VTMODE_SEND_MOUSE))
    return FALSE;
  rd(printf("HERE NOT\n"));

  if ((event->state & popupmod) && event->button == 1)
    {
      gtk_signal_emit_stop_by_name (GTK_OBJECT (widget), "button_press_event");
      build_popup_commands(event, p_term_list, term);
      return TRUE;
    }
  if ((event->state & popupmod) && event->button == 2)
    {
      gtk_signal_emit_stop_by_name (GTK_OBJECT (widget), "button_press_event");
      /* reset selection */
      return selection_mode_off(term);
      
    }
 
#ifdef ZVT_TERM_MATCH_SUPPORT
  /* construct the popup menu properly */
  if (event->button != 3)
    return FALSE;

  gtk_signal_emit_stop_by_name (GTK_OBJECT (widget), "button_press_event");
  if (match) {
    char *tmp;
    if (!strcmp(match_type, "file"))
      {
	memcpy(&gnome_terminal_popup_menu[POPUP_MENU_DYNAMIC_INDEX],
	       &gnome_terminal_popup_menu_file[0],
	       sizeof(gnome_terminal_popup_menu_file));
      }
    else if (!strcmp(match_type, "email address"))
      {
	memcpy(&gnome_terminal_popup_menu[POPUP_MENU_DYNAMIC_INDEX],
	       &gnome_terminal_popup_menu_mail[0],
	       sizeof(gnome_terminal_popup_menu_mail));
      }
    else
      memcpy(&gnome_terminal_popup_menu[POPUP_MENU_DYNAMIC_INDEX],
	     &gnome_terminal_popup_menu_url[0],
	     sizeof(gnome_terminal_popup_menu_url));
    /*printf("DYNIDX: %d match: %s\n", POPUP_MENU_DYNAMIC_INDEX, match);*/
    /* BUG!!!: we must free match of every terminal */

    /*
       tmp = gtk_object_get_data(GTK_OBJECT (term), "matchstr");
       if (tmp)
       g_free(tmp);*/
    /* set all terminals */
    tt = *p_term_list;
    while (tt)
      {
	te = GTK_WIDGET(tt->data);
	tmp = gtk_object_get_data(GTK_OBJECT(te), "matchstr");
	if (tmp)
	  g_free(tmp);
	gtk_object_set_data (GTK_OBJECT (te), "matchstr", g_strdup(match));
	tmp = gtk_object_get_data(GTK_OBJECT(te), "matchtype");
	if (tmp)
	  g_free(tmp);
	gtk_object_set_data (GTK_OBJECT (te), "matchtype", g_strdup(match_type));
	tt = tt->next;
      }
  } else {
    /* make sure the optional menu isn't there */
    memcpy(&gnome_terminal_popup_menu[POPUP_MENU_DYNAMIC_INDEX],
	   &gnome_terminal_popup_menu[POPUP_MENU_LAST_INDEX],
	   sizeof(gnome_terminal_popup_menu[0]));
  }
#endif
  right_click_menu(event, p_term_list, term);
  
  return TRUE;
}

#define PADDING 2
/*#define MAX(x,y) (x>y)?x:y*/
int compute_width(GtkWidget* pane)
{
  int w1 = 0, w2 = 0; 
  GtkWidget* c1, *c2;
  
  if (GTK_IS_HBOX(pane))
    {
      ZvtTerm *term = ZVT_TERM(gtk_object_get_data(GTK_OBJECT(pane), "term")); 
      return term->charwidth*term->grid_width;
    }

  c1 = GTK_PANED(pane)->child1;
  c2 = GTK_PANED(pane)->child2;
  if (c1 && (GTK_IS_HBOX(c1) || GTK_IS_PANED(c1)))
    {
      w1 = compute_width(GTK_WIDGET(c1));
    }

  if (c2 && (GTK_IS_HBOX(c2) || GTK_IS_PANED(c2)))
    {
      w2 = compute_width(GTK_WIDGET(c2));
    }

  if (GTK_IS_VPANED(pane))
    return MIN(w1, w2);
    
  return w1+w2; 
}

int compute_height(GtkWidget* pane)
{
  int w1 = 0, w2 = 0; 
  GtkWidget* c1, *c2;
  
  if (GTK_IS_HBOX(pane))
    {
      ZvtTerm *term = ZVT_TERM(gtk_object_get_data(GTK_OBJECT(pane), "term")); 
      return term->charheight*term->grid_height;
    }

  c1 = GTK_PANED(pane)->child1;
  c2 = GTK_PANED(pane)->child2;
  if (c1 && (GTK_IS_HBOX(c1) || GTK_IS_PANED(c1)))
    {
      w1 = compute_height(GTK_WIDGET(c1));
    }

  if (c2 && (GTK_IS_HBOX(c2) || GTK_IS_PANED(c2)))
    {
      w2 = compute_height(GTK_WIDGET(c2));
    }

  
  if (GTK_IS_VPANED(pane))
    return w1+w2;
  else
    return MIN(w1,w2); 
}

void calc_hints(GtkWidget* app, GtkWidget *tab, ZvtTerm* term, GdkGeometry* hints)
{
  int extra_width, extra_height;
  GtkWidget* root_pane;

  extra_width = app->allocation.width - tab->allocation.width;
  extra_height = app->allocation.height - tab->allocation.height;
  root_pane = GTK_PANED(gtk_object_get_data(GTK_OBJECT(tab), "root_pane"))->child1;
  hints->base_width = GTK_WIDGET(tab)->allocation.width - compute_width(root_pane)+
    extra_width; 
  hints->base_height = GTK_WIDGET(tab)->allocation.height - compute_height(root_pane)+
    extra_height;
  
  hints->width_inc = term->charwidth;
  hints->height_inc = term->charheight;
  hints->min_width = hints->base_width + hints->width_inc;
  hints->min_height = hints->base_height + hints->height_inc;
}
void set_hints (GtkWidget *widget)
{
  ZvtTerm *term;
  GdkGeometry hints;
  int mask, bw_old, bh_old, cw_old, ch_old;
  GtkWidget* tab, *tab_old;
  GtkWidget *app, *root_pane, *nb;
  struct terminal_config* cfg;
  gpointer ap;
  g_assert (widget != NULL);

  rd(printf("setting hints\n"));

  app = gtk_widget_get_toplevel(widget);
  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  tab = gtk_notebook_get_nth_page(GTK_NOTEBOOK(nb),
	      			  gtk_notebook_get_current_page(GTK_NOTEBOOK(nb)));
  root_pane = GTK_PANED(gtk_object_get_data(GTK_OBJECT(tab), "root_pane"))->child1;
  if (widget!=tab)
    return;
  bw_old = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(app), "base_width"));
  bh_old = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(app), "base_height"));
  cw_old = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(app), "char_width")); 
  ch_old = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(app), "char_height"));
  ap = gtk_object_get_data(GTK_OBJECT(app), "tab_old");
  if (ap && GTK_IS_WIDGET(ap))
    tab_old = ap;
  else
    tab_old = NULL;

  ap = gtk_object_get_data(GTK_OBJECT(tab), "active");
  if (!ap || !ZVT_IS_TERM(ap))
    return;
  term = ZVT_TERM(ap);
  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
  g_assert (app != NULL);
  rd(printf("term_base_w: %d term_base_h: %d \n",
	 (GTK_WIDGET (term)->style->klass->xthickness * 2) + PADDING,
	 GTK_WIDGET (term)->style->klass->ythickness * 2) + PADDING);
  calc_hints(app, tab, term, &hints);

  rd(printf("cw: %d(%d) ch:%d(%d) base_width: %d base_height: %d obw:%d obh:%d\n", 
   	    compute_width(root_pane)/term->charwidth, 
   	    compute_width(root_pane),
   	    compute_height(root_pane)/term->charheight,
   	    compute_height(root_pane),
   	    hints.base_width, hints.base_height,
   	    (GTK_WIDGET (term)->style->klass->xthickness * 2) + PADDING,
   	    (GTK_WIDGET (term)->style->klass->ythickness * 2) + PADDING
  	   ));

  rd(printf("setting hints... switch_page:%d\n", term->pg_switched)); 
  mask =GDK_HINT_RESIZE_INC|GDK_HINT_MIN_SIZE|GDK_HINT_BASE_SIZE ;
#if 0
  if (gtk_object_get_data(GTK_OBJECT(app), "no_resize"))
    {
      printf("tab:%p IGNORING\n", tab);
      gtk_object_set_data(GTK_OBJECT(app), "no_resize", NULL);
      return;
    }
#endif
  /*if (tab_old == tab) 
    return;*/
  if (bw_old!=hints.base_width || bh_old!=hints.base_height || 
      cw_old !=  term->charwidth || ch_old != 
      term->charheight || tab_old != tab  )
    {
      rd(printf("[tab=%p]DOING SET HINTS bw_old: %d bw:%d bh_old:%d bh:%d, cw_old: %d cw: %d ch_old:%d ch:%d\n", tab, 
	     bw_old, hints.base_width , bh_old, hints.base_height,
	     cw_old, term->charwidth, ch_old, term->charheight));
      gtk_object_set_data(GTK_OBJECT(app),"base_width", 
			  GINT_TO_POINTER(hints.base_width));
      gtk_object_set_data(GTK_OBJECT(app),"base_height", 
			  GINT_TO_POINTER(hints.base_height));
      gtk_object_set_data(GTK_OBJECT(app),"char_width",GINT_TO_POINTER(term->charwidth)); 
      gtk_object_set_data(GTK_OBJECT(app),"char_height",GINT_TO_POINTER(term->charheight));
      gtk_object_set_data(GTK_OBJECT(app),"tab_old", GINT_TO_POINTER(tab));
      gdk_window_set_geometry_hints (app->window,
  				     &hints,
  				     mask);
      /*gtk_widget_queue_resize(GTK_WIDGET(app));*/
#if 0
      
      gtk_container_set_resize_mode(GTK_CONTAINER(app), GTK_RESIZE_IMMEDIATE);
      gtk_object_set_data(GTK_OBJECT(app), "no_resize", GINT_TO_POINTER(1));
      gtk_window_set_geometry_hints(GTK_WINDOW(app),
    				    GTK_WIDGET(tab),
    				    &hints,mask);
      gtk_container_set_resize_mode(GTK_CONTAINER(app), GTK_RESIZE_QUEUE);
#endif
    }
}

void set_all_undefined(GSList** ptl)
{
  GtkWidget *term;
  GSList* tmp;
  int *state,*new_out;
  tmp = *ptl;
  while(tmp)
    {
      term = GTK_WIDGET(tmp->data);
      if (!term || !ZVT_IS_TERM(term))
	{
	  tmp = tmp->next;
	  continue;
	}
      state = gtk_object_get_data(GTK_OBJECT(term), "term_state");
      new_out = gtk_object_get_data(GTK_OBJECT(term), "new_out");
      *new_out = FALSE;
      if (*state == UNCHANGED)
	*state = UNDEFINED;
      tmp = tmp->next;
    }
}

  void
term_change_pos(GtkWidget *widget)
{
  /* AGGIUNTA 19/08/01 */
  GtkWidget* term;
  GSList **p_term_list;
  static int x=-999;
  static int y=-999;
  int nx,ny;
  ZvtTerm* te;

  p_term_list = gtk_object_get_data(GTK_OBJECT(widget), "ptermlist");

  te = current_term(p_term_list);
  if (!te || !ZVT_IS_TERM(te))
    return;
  term = GTK_WIDGET(te);
  /* widget -> term */
  if(!term->window ||
     !ZVT_TERM(term)->transparent)
    return;


  gdk_window_get_position(term->window,&nx,&ny);

  if(nx!=x || ny!=y)
    {
      gtk_widget_queue_draw(term);

    }	
}

/* do this because gnome-terminal doesn't like an empty SHELL var  */
  void
show_shell_error_dialog (int errcode)
{
  char *tmpmsg, *errmsg;
  GtkWidget *dialog;

  perror ("Error: unable to fork");

  tmpmsg = errcode ? 
    g_strdup_printf(_("The error was: %s"), g_strerror(errcode)) : 
    _("If the SHELL environment variable is empty, or\n"
      "there is no specified in the passwd file for your user,\n"
      "one of these problems need to be corrected for the\n"
      "to run."); 

  errmsg =  g_strdup_printf(_("There has been an error while "
			      "trying to log in.\n\n%s"), tmpmsg);


  dialog = gnome_message_box_new (errmsg,
				  GNOME_MESSAGE_BOX_ERROR,
				  GNOME_STOCK_BUTTON_OK, NULL);

  gnome_dialog_run_and_close (GNOME_DIALOG (dialog));

  if (errcode) g_free(tmpmsg);
  g_free(errmsg);
}

/* do this because there have been only 5 bug reports about this */
  void
show_pty_error_dialog (int errcode)
{
  char *tmpmsg, *errmsg;
  GtkWidget *dialog;

  perror ("Error: unable to fork");

  tmpmsg = errcode ? 
    g_strdup_printf(_("The error was: %s"), g_strerror(errcode)) : 
    _("If you are using Linux 2.2.x with glibc 2.1.x, this\n"
      "is probably due to incorrectly setup Unix98 ptys.\n\n"
      "Please read linux/Documentation/Changes for how to\n"
      "set them up correctly.");

  errmsg =  g_strdup_printf(_("There has been an error while "
			      "trying to log in.\n\n%s"), tmpmsg);


  dialog = gnome_message_box_new (errmsg,
				  GNOME_MESSAGE_BOX_ERROR,
				  GNOME_STOCK_BUTTON_OK, NULL);

  gnome_dialog_run_and_close (GNOME_DIALOG (dialog));

  if (errcode) g_free(tmpmsg);
  g_free(errmsg);
}

void set_all_terms_size(GSList** ptl, gint x, gint y);

gint term_xc, term_yc;

gint delete( GtkWidget *widget,
	     GtkWidget *event,
	     gpointer   data )
{
  gtk_main_quit();
  return(FALSE);
}

char **env_copy;
int winid_pos;
int term_pos;

  GtkWidget *
new_terminal (GtkWidget *widget, GSList **p_term_list) 
{
  struct terminal_config *cfg;
  struct win_config *wincfg;
  char *prefix;
  /* AGGIUNTA 17/08/01 */
  ZvtTerm* term;
  GtkWidget* app, *newapp;
  term = current_term(p_term_list);
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
  prefix = g_strdup_printf("/MultiTerminal/%s/", wincfg->class);
  newapp = load_tabs(prefix, NULL, cfg, wincfg, NULL, terminal_id++);
  g_free(prefix);
  if (!wincfg->menubar_hidden)
    /* set toggle items */
    toggle_app_items(GTK_WIDGET(app), wincfg);
  return newapp;
}

  GtkWidget *
new_terminal_for_client (const char *geom)
{
  GtkWidget *app, *term, *w;
  GSList** ptl;
  char* prefix;
  struct terminal_config *cfg;
  struct win_config *wincfg;

  if (terminals != 0)
    {
      /*ZvtTerm *term = ZVT_TERM (gtk_object_get_data
	(GTK_OBJECT(terminals->data),
	"term"));*/
      app = GTK_WIDGET(terminals->data);
      ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
      term = GTK_WIDGET((*ptl)->data);
      cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
      wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
      prefix = g_strdup_printf("/MultiTerminal/%s/", wincfg->class);
      w = load_tabs(prefix, 
		    NULL, cfg, wincfg, geom ? geom :initial_global_geometry,
		    terminal_id++);
      g_free(prefix);
      /* set toggle items */
      if (!wincfg->menubar_hidden) 
	toggle_app_items(GTK_WIDGET(w), wincfg);
      return w;
    }
  else
    return 0;
}

  static void
load_factory_settings ()
{
  gchar *buf;

  buf = gnome_client_get_config_prefix (gnome_master_client ());
  gnome_config_push_prefix (buf);

  buf = g_strdup_printf ("factory/start=%d", start_terminal_factory);
  start_terminal_factory = gnome_config_get_int (buf);
  g_free (buf);

  buf = g_strdup_printf ("factory/use=%d", use_terminal_factory);
  use_terminal_factory = gnome_config_get_int (buf);
  g_free (buf);

  gnome_config_pop_prefix ();
}

static gboolean
load_session (GtkWidget** retapp)
{
  int num_terms, i;
  gboolean def;
  gchar *file;
  GtkWidget* app = NULL;

  *retapp = NULL;

  file = gnome_client_get_config_prefix (gnome_master_client());

  gnome_config_push_prefix (file);
  num_terms = gnome_config_get_int_with_default ("dummy/num_terms", 
						 &def);
  gnome_config_pop_prefix ();

  if (def || ! num_terms)
    return FALSE;

  for (i = num_terms - 1; i >= 0; i--){
    char *geom, **argv;
    struct terminal_config *cfg;
    struct win_config *wincfg;
    char *class, *class_path, *winclass;
    int argc;
    char *prefix = g_strdup_printf ("%s%d/", file, i);
    char *class_prefix;
    int termid;
    /* commands */
    gnome_config_push_prefix (prefix);
    /* NAUGHTY: The ICCCM requires that the WM stores
       all session data on geometry! */
    geom = gnome_config_get_string ("geometry");
    gnome_config_get_vector ("command", &argc, &argv);
    class_path = g_strconcat ("tabclass=", _("Default"), NULL);
    class = gnome_config_get_string(class_path);
    g_free (class_path);
    class_path = g_strconcat ("winclass=", _("Default"), NULL);
    winclass =  gnome_config_get_string(class_path);
    g_free (class_path);
    gnome_config_pop_prefix();

    /* now load class settings: now session is saved on a per class basis */
    class_prefix = g_strdup_printf("/MultiTerminal/%s/", class);
    gnome_config_push_prefix(class_prefix);
    cfg = load_config (class);
    gnome_config_pop_prefix();
    g_free(class_prefix);
    /* now load winclass settings: now session is saved on a per class basis */
    class_prefix = g_strdup_printf("/MultiTerminal/%s/", winclass);
    gnome_config_push_prefix(class_prefix);
    wincfg = load_winconfig (winclass);
    gnome_config_pop_prefix();
    g_free(class_prefix);

    /* do this now, since it is only done in a session */
      {
	char *ctmp;
	ctmp = gnome_config_get_string("termname=xterm");
	if(ctmp && *ctmp)
	  cfg->termname = g_strconcat("TERM=", ctmp, NULL);
	else
	  cfg->termname = g_strdup("TERM=xterm");
	g_free(ctmp);
      }
#if 0
    wincfg->window_title = gnome_config_get_string("window_title=MGT");
    wincfg->window_icon = gnome_config_get_string("window_icon=" GNOME_ICONDIR 
						  "/mgt/multignometerm.png");
#endif
    start_terminal_factory = gnome_config_get_bool ("start_terminal_factory=false");
    use_terminal_factory = gnome_config_get_bool ("use_terminal_factory=false");

    termid = gnome_config_get_int("terminal_id=-1");
    if (termid!=-1)
      terminal_id = termid;

    g_free(class);
    gnome_config_pop_prefix();
    app = load_tabs(prefix, argv, cfg, wincfg, 
		    geom, terminal_id++);
    g_free(prefix);
#if 0
    free_str_array(cmds);
    free_str_array(cmds_names);
#endif
    g_free(cfg);
    g_free (geom);
    if (i==0) {
      /* need to save the initial argv, because of the weird
	 way it is used elsewhere, with the initial term */
      initial_command = argv;
    } else {
      g_strfreev (argv);
    }
  }
  *retapp = app;
  return TRUE;
}

/* Save terminal in this session.  FIXME: should save all terminal
   windows, but currently does not.  */
static gint
save_session (GnomeClient *client, gint phase, GnomeSaveStyle save_style,
	      gint is_shutdown, GnomeInteractStyle interact_style,
	      gint is_fast, gpointer client_data)
{
  char *file = gnome_client_get_config_prefix (client);
  char *args[8];
  int i;
  GList *list;
  GSList** ptl;
  i = 0;
  for (list = terminals; list != NULL; list = list->next){

    gint width, height, x, y;
    GString *geom;
    struct terminal_config *cfg;			
    struct win_config *wincfg;
    ZvtTerm *term;
    GtkWidget *top;
    char *prefix;
    char *ctmp;

    top = gtk_widget_get_toplevel (GTK_WIDGET (list->data));
    prefix = g_strdup_printf ("%s%d/", file, i);

    /*term = ZVT_TERM (gtk_object_get_data (GTK_OBJECT(list->data), 
      "term"));
      */
    ptl = gtk_object_get_data(GTK_OBJECT(list->data), "ptermlist");
    wincfg = gtk_object_get_data(GTK_OBJECT(list->data), "winconfig");

    term = ZVT_TERM((*ptl)->data);	

    cfg = gtk_object_get_data (GTK_OBJECT (term), "config");

    /* Now MGT auto-saves tabs on a per class basis */
    /*lprefix = g_strdup_printf("/MultiTerminal/%s/", cfg->class);*/
    /*g_free(lprefix);*/
    save_tabs(prefix,GTK_WIDGET(list->data));
    gnome_config_push_prefix (prefix);
    /*
     * NAUGHTY: The ICCCM requires that the WM stores
     * all session data on geometry!
     */

    /*
     * we can't use gnome_geometry_string because we need
     * to calculate the terminal, not window size
     */
    gdk_window_get_origin (top->window, &x, &y);

    width = 
      (GTK_WIDGET (term)->allocation.width - 
       (GTK_WIDGET (term)->style->klass->xthickness * 2)) /
      term->charwidth;

    height = 
      (GTK_WIDGET (term)->allocation.height - 
       (GTK_WIDGET (term)->style->klass->ythickness * 2)) /
      term->charheight;

    geom = g_string_new ("");
    g_string_sprintf (geom, "%dx%d%+d%+d", width, height, x, y);
    gnome_config_set_string ("geometry", geom->str);
    g_string_free (geom, TRUE);

    gnome_config_set_string("tabclass", cfg->class);
    gnome_config_set_string("winclass", wincfg->class);
    gnome_config_set_int("terminal_id", wincfg->window_id);

    if (top == initial_term){
      int n;
      if (initial_command)	
	{
	  for (n = 0; initial_command[n]; ++n);
	  gnome_config_set_vector ("command", n,
				   (const char * const*) initial_command);
	}
    }

    /* do this now, since it is only done in a session */

    ctmp = NULL;
    if(cfg->termname) {
      ctmp = strchr(cfg->termname, '=');
      if(ctmp) ctmp++;
    }
    if(!ctmp)
      ctmp = "xterm";
    gnome_config_set_string("termname", ctmp);

#if 0
    gnome_config_set_string ("window_title",
			     wincfg->window_title != NULL ?
			     wincfg->window_title : _("MGT"));
    gnome_config_set_string ("window_icon",
			     wincfg->window_icon != NULL ?
			     wincfg->window_icon : GNOME_ICONDIR"/mgt/multignometerm.png");
#endif
    gnome_config_set_bool("start_terminal_factory", 
			  start_terminal_factory);
    gnome_config_set_bool("use_terminal_factory",
			  use_terminal_factory);

    gnome_config_pop_prefix ();
    g_free (prefix);

    ++i;
  }
  gnome_config_push_prefix (file);
  gnome_config_set_int ("dummy/num_terms", i);
  gnome_config_set_int ("factory/start", start_terminal_factory);
  gnome_config_set_int ("factory/use", use_terminal_factory);
  gnome_config_pop_prefix ();

  gnome_config_sync ();

  args[0] = "rm";
  args[1] = gnome_config_get_real_path (file);
  args[2] = NULL;
  gnome_client_set_discard_command (client, 2, args);

  return TRUE;
}

/* Keys for the ARGP parser, should be negative */
enum {
  FONT_KEY      	    = -1,
  NOLOGIN_KEY   	    = -2,
  LOGIN_KEY     	    = -3,
  GEOMETRY_KEY  	    = -4,
  COMMAND_KEY   	    = 'e',
  FORE_KEY      	    = -6,
  BACK_KEY      	    = -7,
  CLASS_KEY     	    = -8,
  DOUTMP_KEY    	    = -9,
  DONOUTMP_KEY  	    = -10,
  DOWTMP_KEY    	    = -11,
  DONOWTMP_KEY  	    = -12,
  TITLE_KEY     	    = -13,
  TERM_KEY            = -14,
  START_FACTORY_KEY   = -15,
  USE_FACTORY_KEY     = -16,
  DOLASTLOG_KEY       = -17,
  DONOLASTLOG_KEY     = -18,
  ICON_KEY            = -19,
  PIXMAP_KEY          = -20,
  SHADED_KEY          = -21,
  NOSHADED_KEY        = -22,
  TRANSPARENT_KEY     = -23,
  ADD_WINDOW_KEY      = -24,
  ADD_TAB_KEY         = -25,
  HSPLIT_KEY          = -26,
  VSPLIT_KEY          = -27,
  NAME_KEY            = -28, 
  PATH_KEY            = -29,
  CMD_KEY        = -30,
  TPREV_KEY      = -31,
  TNEXT_KEY      = -32,
  NEWAPP_KEY        = -33,
  NOWAIT_KEY       = -34,
  ADD_WINDOWWT_KEY = -35,
  WINCLASS_KEY     = -36,
#ifdef ZVT_BACKGROUND_SCROLL
  SOLID_KEY           = -37,
  BGSCROLL_PIXMAP_KEY   = -38,
  BGNOSCROLL_PIXMAP_KEY = -39
#else /* ZVT_BACKGRUOND_SCROLL */
  SOLID_KEY           = -37   /* No comma for fussy IBM AIX compiler */
#endif
};

static struct poptOption cb_options [] = {
    { NULL, '\0', POPT_ARG_CALLBACK, (gpointer)parse_an_arg, 0},

    { "tclass", 's', POPT_ARG_STRING, NULL, CLASS_KEY,
      N_("Tab class name"), N_("TCLASS")},
	
    { "wclass", 'S', POPT_ARG_STRING, NULL, WINCLASS_KEY,
      N_("Window class name"), N_("WCLASS")},

    { "font", '\0', POPT_ARG_STRING, NULL, FONT_KEY,
       N_("Specifies font name"), N_("FONT")},
#if 0
    { "nologin", '\0', POPT_ARG_NONE, NULL, NOLOGIN_KEY,
      N_("Do not start up shells as login shells"), NULL},

    { "login", '\0', POPT_ARG_NONE, NULL, LOGIN_KEY,
      N_("Start up shells as login shells"), NULL},
#endif      
    { "geometry", '\0', POPT_ARG_STRING, NULL, GEOMETRY_KEY,
      N_("Specifies the geometry for the main window"), N_("GEOMETRY")},

    { "command", 'e', POPT_ARG_STRING, NULL, COMMAND_KEY,
      N_("Execute this program instead of a shell"), N_("COMMAND")},

    { "execute", 'x', POPT_ARG_STRING, NULL, COMMAND_KEY,
      N_("Execute this program the same way as xterm does"), N_("COMMAND")},
#if 1
    { "foreground", '\0', POPT_ARG_STRING, NULL, FORE_KEY,
      N_("Foreground color"), N_("COLOR")},

    { "background", '\0', POPT_ARG_STRING, NULL, BACK_KEY,
      N_("Background color"), N_("COLOR")},

    { "solid", '\0', POPT_ARG_NONE, NULL, SOLID_KEY,
      N_("Solid background"), N_("SOLID") },	
      
    { "pixmap", '\0', POPT_ARG_STRING, NULL, PIXMAP_KEY,
      N_("Background pixmap"), N_("PIXMAP")},
#endif
#if 0
#ifdef ZVT_BACKGROUND_SCROLL
    { "bgscroll", '\0', POPT_ARG_NONE, NULL, BGSCROLL_PIXMAP_KEY,
      N_("Background pixmap scrolls"), N_("BGSCROLL")},
      
    { "bgnoscroll", '\0', POPT_ARG_NONE, NULL, BGNOSCROLL_PIXMAP_KEY,
      N_("Background pixmap does not scroll"), N_("BGNOSCROLL")},
#endif
#endif
#if 1
    { "shaded", '\0', POPT_ARG_NONE, NULL, SHADED_KEY,
      N_("Shade background"), N_("SHADED") },	
      
    { "noshaded", '\0', POPT_ARG_NONE, NULL, NOSHADED_KEY,
      N_("Do not shade background"), N_("NOSHADED") },	

    { "transparent", '\0', POPT_ARG_NONE, NULL, TRANSPARENT_KEY,
      N_("Transparent background"), N_("TRANSPARENT") },	
#endif
#if 0
    { "utmp", '\0', POPT_ARG_NONE, NULL, DOUTMP_KEY,
      N_("Update utmp entry"), N_("UTMP") },

    { "noutmp", '\0', POPT_ARG_NONE, NULL, DONOUTMP_KEY,
      N_("Do not update utmp entry"), N_("NOUTMP") },
      
    { "wtmp", '\0', POPT_ARG_NONE, NULL, DOWTMP_KEY,
      N_("Update wtmp entry"), N_("WTMP") },

    { "nowtmp", '\0', POPT_ARG_NONE, NULL, DONOWTMP_KEY,
      N_("Do not update wtmp entry"), N_("NOWTMP") },
      
    { "lastlog", '\0', POPT_ARG_NONE, NULL, DOLASTLOG_KEY,
      N_("Update lastlog entry"), N_("LASTLOG") },

    { "nolastlog", '\0', POPT_ARG_NONE, NULL, DONOLASTLOG_KEY,
      N_("Do not update lastlog entry"), N_("NOLASTLOG") },
#endif
#if 1
    { "title", 't', POPT_ARG_STRING, NULL, TITLE_KEY,
      N_("Set the window title"), N_("TITLE") },
#endif
    { "icon", '\0', POPT_ARG_STRING, NULL, ICON_KEY,
      N_("Set the window icon"), N_("ICON") },

    { "termname", '\0', POPT_ARG_STRING, NULL, TERM_KEY,
      N_("Set the TERM variable"), N_("TERMNAME") },
      
    { "start-factory-server", '\0', POPT_ARG_NONE, NULL, START_FACTORY_KEY,
      N_("Try to start a TerminalFactory"), NULL },
      
    { "use-factory", '\0', POPT_ARG_NONE, NULL, USE_FACTORY_KEY,
      N_("Try to create the terminal with the TerminalFactory"), NULL },

    { "add-window", 'w', POPT_ARG_NONE, NULL, ADD_WINDOW_KEY,
      N_("Create a new window"), NULL },
      
    { "add-window-wt", 'W', POPT_ARG_NONE, NULL, ADD_WINDOWWT_KEY,
      N_("Create a new window opening also startup and/or restoring saved terminals"), NULL },


    { "add-tab", 'T', POPT_ARG_NONE, NULL, ADD_TAB_KEY,
      N_("Create a new tab in current window with specified command, name and path"), NULL },
     
    { "hsplit", 'h', POPT_ARG_NONE, NULL, HSPLIT_KEY,
      N_("Split horizontally current term with specified command, name and path"), NULL },
     
    { "vsplit", 'v', POPT_ARG_NONE, NULL, VSPLIT_KEY,
      N_("Split vertically current term with specified command, name and path"), NULL },
      
    { "tpath", 'p', POPT_ARG_STRING, NULL, PATH_KEY,
      N_("Specify a path for creating a term"), N_("PATH") },
      
    { "tcommand", 'c', POPT_ARG_STRING, NULL, CMD_KEY,
      N_("Specify a command for creating a term"), N_("CMD") },
     
    { "tname", 'n', POPT_ARG_STRING, NULL, NAME_KEY,
      N_("Specify a name for creating a term"), N_("TAB_NAME") },
    
    { "tprev", 'P', POPT_ARG_NONE, NULL, TPREV_KEY,
      N_("Specify a name for creating a term"), NULL },

    { "tnext", 'N', POPT_ARG_NONE, NULL, TNEXT_KEY,
      N_("Specify a name for creating a term"), NULL },
     
    { "newapp", 'A', POPT_ARG_NONE, NULL, NEWAPP_KEY,
      N_("Create a new MGT app"), NULL },
     
    { "nowait", '\0', POPT_ARG_NONE, NULL, NOWAIT_KEY,
      N_("Create a new tab but don't wait untill it will be done"), NULL },
     
    { NULL, '\0', 0, NULL, 0}
};
#if 1 
GList *cl_terms = NULL;
struct term_struct 
{
 int type;
 char *name;
 char *path;
 char *cmd;
 char *tclass;
 char *wclass;
};
int mgt_add_terms = 0;
int mgt_new_app = 0;
int no_wait = 0;
#endif
struct cfgs_t 
{
  struct terminal_config *cfg;
  struct win_config *wincfg;
} cmdline_cfgs;
static void
parse_an_arg (poptContext state,
	      enum poptCallbackReason reason,
	      const struct poptOption *opt,
	      const char *arg, void *data)
{
  struct terminal_config *cfg = ((struct cfgs_t*)data)->cfg;
  struct win_config *wincfg = ((struct cfgs_t*)data)->wincfg;
  struct term_struct* one_term;
  struct term_struct *t;

  int key = opt->val;

  switch (key){
  case CLASS_KEY:
    if (!mgt_add_terms)
      {
	if (cfg->class)
	  free (cfg->class);
	if (!strcasecmp(arg,"Default"))
	  cfg->class = g_strdup("Config");
	else
	  cfg->class = g_strconcat ("Class-", arg, NULL);
      }
    else
      {
	if (!cl_terms)
	  {
	    mgt_add_terms = 1;
	    break;
	  }
	t = (struct term_struct*) g_list_last(cl_terms)->data;
	/*printf("name!!!:%s\n", arg);*/
	if (t)
	  {
	    if (!strcasecmp(arg,"Default"))
	      t->tclass = g_strdup("Config");
	    else
	      t->tclass = g_strconcat ("Class-", arg, NULL);
	  }
	break;
      }
    start_terminal_factory = FALSE;
    use_terminal_factory = FALSE;
    break;
  case WINCLASS_KEY:
    if (!mgt_add_terms)
      {
	if (wincfg->class)
	  free (wincfg->class);
	if (!strcasecmp(arg,"Default"))
	  wincfg->class = g_strdup("Win-Config");
	else
	  wincfg->class = g_strconcat ("Win-Class-", arg, NULL);
      }
    else
      {
	if (!cl_terms)
	  {
	    mgt_add_terms = 1;
	    break;
	  }
	t = (struct term_struct*) g_list_last(cl_terms)->data;
	/*printf("name!!!:%s\n", arg);*/
	if (t)
	  {
	    if (!strcasecmp(arg,"Default"))
	      t->wclass = g_strdup("Win-Config");
	    else
	      t->wclass = g_strconcat ("Win-Class-", arg, NULL);
	  }
	break;
      }
    start_terminal_factory = FALSE;
    use_terminal_factory = FALSE;
    break;
  case FONT_KEY:
    cfg->font = (char *)arg;
    start_terminal_factory = FALSE;
    use_terminal_factory = FALSE;
    break;
#if 0
  case LOGIN_KEY:
    cfg->invoke_as_login_shell = 1;
    cmdline_login = TRUE;
    start_terminal_factory = FALSE;
    use_terminal_factory = FALSE;
    break;
  case NOLOGIN_KEY:
    cfg->invoke_as_login_shell = 0;
    cmdline_login = TRUE;
    start_terminal_factory = FALSE;
    use_terminal_factory = FALSE;
    break;
#endif
  case GEOMETRY_KEY:
    initial_global_geometry = (char *)arg;
    break;
  case COMMAND_KEY:
      {
	char **foo;
	int x;

	poptParseArgvString((char *)arg,&x,&foo);
	initial_command=malloc((x+1)*sizeof(char *));
	initial_command[x]=NULL;
	while (x>0) {
	  x--;
	  initial_command[x]=foo[x];
	}

	start_terminal_factory = FALSE;
	use_terminal_factory = FALSE;
	break;
      }
  case FORE_KEY:
    cfg->user_fore_str = arg;
    start_terminal_factory = FALSE;
    use_terminal_factory = FALSE;
    break;
  case BACK_KEY:
    cfg->user_back_str = arg;
    start_terminal_factory = FALSE;
    use_terminal_factory = FALSE;
    break;
  case SOLID_KEY:
    cfg->background_pixmap = 0;
    cfg->transparent = 0;
    cfg->have_user_background = 1;
    start_terminal_factory = FALSE;
    use_terminal_factory = FALSE;
    break;
  case PIXMAP_KEY:
    cfg->background_pixmap = 1;
    cfg->transparent = 0;
    cfg->pixmap_file = g_strdup(arg);
    cfg->have_user_background = 1;
    start_terminal_factory = FALSE;
    use_terminal_factory = FALSE;
    break;
#ifdef ZVT_BACKGROUND_SCROLL
  case BGSCROLL_PIXMAP_KEY:
    cfg->scroll_background = 1;
    cfg->have_user_scroll_bg = 1;
    start_terminal_factory = FALSE;
    use_terminal_factory = FALSE;
    break;
  case BGNOSCROLL_PIXMAP_KEY:
    cfg->scroll_background = 0;
    cfg->have_user_scroll_bg = 1;
    start_terminal_factory = FALSE;
    use_terminal_factory = FALSE;
    break;
#endif
  case SHADED_KEY:
    cfg->shaded = 1;
    cfg->have_user_shaded = 1;
    start_terminal_factory = FALSE;
    use_terminal_factory = FALSE;
    break;
  case NOSHADED_KEY:
    cfg->shaded = 0;
    cfg->have_user_shaded = 1;
    start_terminal_factory = FALSE;
    use_terminal_factory = FALSE;
    break;
  case TRANSPARENT_KEY:
    cfg->background_pixmap = 0;
    cfg->transparent = 1;
    cfg->have_user_background = 1;
    start_terminal_factory = FALSE;
    use_terminal_factory = FALSE;
    break;
  case TITLE_KEY:
    wincfg->window_title = g_strdup(arg);
    start_terminal_factory = FALSE;
    use_terminal_factory = FALSE;
    break;
  case ICON_KEY:
    wincfg->window_icon = g_strdup(arg);
    start_terminal_factory = FALSE;
    use_terminal_factory = FALSE;
    break;
  case TERM_KEY:
    cfg->termname = g_strdup_printf("TERM=%s", arg);
    start_terminal_factory = FALSE;
    use_terminal_factory = FALSE;
    break;
  case START_FACTORY_KEY:
    start_terminal_factory = TRUE;
    break;
  case USE_FACTORY_KEY:
    use_terminal_factory = TRUE;
    break;
  case ADD_WINDOWWT_KEY:
    one_term = g_malloc0(sizeof(struct term_struct));
    one_term->type = MGT_NEW_WINWT;
    cl_terms = g_list_append(cl_terms, one_term);
    mgt_add_terms = 1;
    break;
  case ADD_WINDOW_KEY:
#if 1
    one_term = g_malloc0(sizeof(struct term_struct));
    one_term->type = MGT_NEW_WIN;
    cl_terms = g_list_append(cl_terms, one_term);
    mgt_add_terms = 1;
    break;
  case ADD_TAB_KEY:
    one_term = g_malloc0(sizeof(struct term_struct));
    /*printf("adding tab\n");*/ 
    one_term->type = MGT_NEW_TAB;
    cl_terms = g_list_append(cl_terms, one_term);
    mgt_add_terms = 1;
    break;
  case NAME_KEY:
    if (!cl_terms)
      {
	mgt_add_terms = 1;
	break;
      }
    t = (struct term_struct*) g_list_last(cl_terms)->data;
    /*printf("name!!!:%s\n", arg);*/
    if (t)
      t->name = g_strdup(arg); 
    break;
  case HSPLIT_KEY:
    /*printf("hsplit\n");*/
    one_term = g_malloc0(sizeof(struct term_struct));
    one_term->type = MGT_HORIZ_SPLIT;
    cl_terms = g_list_append(cl_terms, one_term);
    mgt_add_terms = 1;
    break;
  case VSPLIT_KEY:
    one_term = g_malloc0(sizeof(struct term_struct));
    one_term->type = MGT_VERT_SPLIT;
    cl_terms = g_list_append(cl_terms, one_term);
    mgt_add_terms = 1;
    break;
  case PATH_KEY:
    if (!cl_terms)
      {
	mgt_add_terms = 1;
	break;
      }
    t = (struct term_struct*) g_list_last(cl_terms)->data;
    /*printf("path!!!:%s\n", arg);*/
    if (t)
      t->path = g_strdup(arg); 
    break;
  case CMD_KEY:
    if (!cl_terms)
      {
	mgt_add_terms = 1;
	break;
      }
    t = (struct term_struct*) g_list_last(cl_terms)->data;
    /*printf("cmd!!!:%s\n", arg);*/
    if (t)
      {
	char* oldcmd = t->cmd;
	if (t->cmd)
	  {  
	    t->cmd = g_strconcat(oldcmd, " ", arg, NULL);
	    g_free(oldcmd);
	  }
	else
	  t->cmd = g_strdup(arg); 
      }
  break;
  case TPREV_KEY:
    one_term = g_malloc0(sizeof(struct term_struct));
    one_term->type = MGT_TPREV;
    cl_terms = g_list_append(cl_terms, one_term);
    mgt_add_terms = 1;
    break;
  case TNEXT_KEY:
    one_term = g_malloc0(sizeof(struct term_struct));
    one_term->type = MGT_TNEXT;
    cl_terms = g_list_append(cl_terms, one_term);
    mgt_add_terms = 1;
    break;
  case NEWAPP_KEY:
    mgt_new_app = 1;
#endif
  case NOWAIT_KEY:
    no_wait = 1;
    break;
  default:
    break;
  }
}

  static gint
session_die (gpointer client_data)
{
  gtk_exit(0); /*gtk_main_quit ();*/
  return TRUE;
}

extern int check_changed_buffers(gpointer data);
extern void load_appconfig(void);

int read_old_settings(char*** p_cmds, char***p_cmds_names, char* class,
		      struct terminal_config** p_cfg)
{
  /* This procedures read all setting from Terminal config file and put
     all in MultiTerminal file removing old entries from that one 
     In future MGT releases this casa */

  char *prefix;
  int n, num_cmds;

  if (!strcmp(class, "Config"))
    {
      /* Now multi-gnome-terminal class is the Default one */
      prefix = g_strdup_printf("/Terminal/Class-multi-gnome-terminal/");;
    }
  else
    {
      prefix = g_strdup_printf("/Terminal/Class-%s/", class);;
    }

  if (!gnome_config_has_section(prefix))
    {
      g_free(prefix);
      return 0;
    }
  gnome_config_drop_all();

  gnome_config_push_prefix(prefix);

  *p_cfg = load_config (class);

  /* Load all commands and their names */
  gnome_config_get_vector ("cmds", &num_cmds, p_cmds);
  gnome_config_get_vector ("cmds_names", &num_cmds, p_cmds_names);
  if ((*p_cmds == NULL) || (*p_cmds_names == NULL))
    {
      *p_cmds = malloc(sizeof(char*));
      *p_cmds_names = malloc(sizeof(char*));
      (*p_cmds)[0] = NULL;
      (*p_cmds_names)[0] = NULL;
    }
  else
    {
      if (num_cmds == 1)
	{
	  if (strlen((*p_cmds)[0])==0 && strlen((*p_cmds_names)[0])==0)
	    {
	      (*p_cmds)[0] = NULL;
	      (*p_cmds_names)[0] = NULL;
	    }
	}
    }
  gnome_config_clean_section(prefix);
  gnome_config_sync(); 
  gnome_config_pop_prefix();
  g_free(prefix);
  prefix = g_strdup_printf("/MultiTerminal/%s/", class);
  gnome_config_push_prefix(prefix);
  save_preferences(*p_cfg);
  gnome_config_pop_prefix();
  g_free(prefix);
  prefix = g_strdup_printf("/MultiTerminal/Common/");
  gnome_config_push_prefix(prefix);	

  n = 0;
  while((*p_cmds_names)[n])
    n++;
  gnome_config_set_vector("cmds", n, (const char* const*) *p_cmds);
  gnome_config_set_vector("cmds_names", n, (const char* const*) *p_cmds_names);
  gnome_config_pop_prefix();
  g_free(prefix);

  return 1;
}

void cl_fix(struct term_struct* t)
{
  if (!t->name || strlen(t->name)==0)
    t->name = g_strdup("Shell");
  if (!t->path || strlen(t->path)==0)
    t->path = g_strdup(" ");
  if (!t->cmd || strlen(t->cmd)==0)
    t->cmd = g_strdup(" ");
  if (!t->tclass || strlen(t->tclass)==0)
    t->tclass = g_strdup(" ");
  if (!t->wclass || strlen(t->wclass)==0)
    t->wclass = g_strdup(" ");
}
static void add_terms(char** initcmd)
{
  GList* tl;
  char *out = NULL, *xcmd;
  struct term_struct* t;
  tl = cl_terms;
  if (initcmd)
    xcmd = g_strjoinv(" ", initcmd);
  else 
    xcmd = NULL;
  while (tl)
    {
      t = (struct term_struct*)tl->data;
      cl_fix(t);
      if (!tl->next && xcmd)
	{
	  /* if this is the last entry use '-x ...' as command to execute in new term*/
	  g_free(t->cmd);
	  t->cmd = xcmd; 
	}
      switch (t->type)
	{
	case MGT_NEW_WINWT:
	  
	  out = g_strconcat("\033]WT;",t->name,"\t",t->path,"\t",t->cmd,"\t",
			    (t->tclass&&strlen(t->tclass)>0)?t->tclass:" ", "\t",
			    (t->wclass&&strlen(t->wclass)>0)?t->wclass:" ",
			    NULL);
	  d(printf("name: %s path:%s cmd:%s tclass:%s wclass:%s\n", 
		   t->name, t->path, t->cmd, 
		   t->tclass, t->wclass));
	  printf("%s%c",out, 0x07);
	  break;
	case MGT_NEW_WIN:
	  out = g_strconcat("\033]NW;",t->name,"\t",t->path,"\t",t->cmd,"\t",
			    (t->tclass&&strlen(t->tclass)>0)?t->tclass:" ", "\t",
			    (t->wclass&&strlen(t->wclass)>0)?t->wclass:" ",
			    NULL);
			    
	  d(printf("name: %s path:%s cmd:%s tclass:%s wclass: %s\n", 
		   t->name, t->path, t->cmd, t->tclass, t->wclass));
	  printf("%s%c",out, 0x07);
	  break;
	case MGT_NEW_TAB:
	  out = g_strconcat("\033]NT;",t->name,"\t",t->path,"\t",t->cmd, "\t",
			    t->tclass,
			    NULL);
	  d(printf("new tab name: %s path:%s cmd:%s tclass:%s\n", t->name, t->path, 
		   t->cmd, t->tclass));
	  printf("%s%c",out, 0x07);
	  break;
	case MGT_VERT_SPLIT:
	  out = g_strconcat("\033]VS;",t->name,"\t",t->path,"\t",t->cmd,NULL);
	  printf("%s%c",out, 0x07);
	  break;  
	case MGT_TPREV:
	  printf("\033]TP; %c", 0x07);
	  out = NULL;
	  break;
	case MGT_TNEXT:
	  printf("\033]TN; %c", 0x07);
	  out = NULL;
	  break;
	case MGT_HORIZ_SPLIT:
	default:
	  out = g_strconcat("\033]HS;",t->name,"\t",t->path,"\t",t->cmd,NULL);
	  printf("%s%c",out, 0x07);
	  break;
	}
      /* this is needed to have right size for last created term */
      if (out)
	g_free(out);
      tl = tl->next;
    }
  /* this means END: we need it to reset 'cl_last_app' attribure of a terminals 
   * which stores a pointer to last window opened by command line */
  if (!no_wait)
    printf("\033]EN;%c",0x07);
  else 
    printf("\033]NW;%c", 0x07);
 
  tl = cl_terms;
  while (tl)
    {
      t = (struct term_struct*)tl->data;
      if (t->name)
	g_free(t->name);
      if (t->path)
	g_free(t->path);
      if (t->cmd)
	g_free(t->cmd);
      if (t->tclass)
	g_free(t->tclass);
      if (t->wclass)
	g_free(t->wclass);
      g_free(tl->data);
      tl = tl->next;
    }
  g_list_free(cl_terms);
}

extern GtkWidget* vt_new_window(ZvtTerm* t, char* name, char *path, char*cmd, 
				char *tclass, char *wclass);
extern void vt_new_tab   (ZvtTerm* t, char* name, char *path, char*cmd, char *tclass);
extern void vt_hsplit    (ZvtTerm* t, char* name, char *path, char*cmd);
extern void vt_vsplit    (ZvtTerm* t, char* name, char *path, char*cmd);
extern void vt_tnext     (ZvtTerm* term);
extern void vt_tprev     (ZvtTerm* term); 

void newapp_add_terms(GtkWidget *app, ZvtTerm* te, char **initcmd) 
{
  GList* tl;
  char *xcmd;
  struct term_struct* t;
  GtkWidget *last_app = NULL; 
  
  tl = cl_terms;
  if (initcmd)
    xcmd = g_strjoinv(" ", initcmd);
  else 
    xcmd = NULL;
  while (tl)
    {
      t = (struct term_struct*)tl->data;
      cl_fix(t);
      if (!tl->next && xcmd)
	{
	  /* if this is the last entry use '-x ...' as command to execute in new term*/
	  g_free(t->cmd);
	  t->cmd = xcmd; 
	}
      switch (t->type)
	{
	case MGT_NEW_WIN:
	  last_app = vt_new_window(te, t->name, t->path, t->cmd, t->tclass, t->wclass); 
	  gtk_object_set_data(GTK_OBJECT(te), "cl_last_app", last_app);
	  break;
	case MGT_NEW_TAB:
	  vt_new_tab(te, t->name, t->path, t->cmd, t->tclass);
	  break;
	case MGT_VERT_SPLIT:
	  vt_vsplit(te, t->name, t->path, t->cmd);
	  break;  
	case MGT_TPREV:
	  vt_tprev(te);	
	  break;
	case MGT_TNEXT:
	  vt_tnext(te);
	  break;
	case MGT_HORIZ_SPLIT:
	default:
	  vt_hsplit(te, t->name, t->path, t->cmd); 
	  break;
	}
      /* this is needed to have right size for last created term */
      tl = tl->next;
    }
  /* this means END: we need it to reset 'cl_last_app' attribure of a terminals 
   * which stores a pointer to last window opened by command line */
  tl = cl_terms;
  while (tl)
    {
      t = (struct term_struct*)tl->data;
      if (t->name)
	g_free(t->name);
      if (t->path)
	g_free(t->path);
      if (t->cmd)
	g_free(t->cmd);
      if (t->tclass)
	g_free(t->tclass);
      if (t->wclass)
	g_free(t->wclass);
      g_free(tl->data);
      tl = tl->next;
    }
  g_list_free(cl_terms);
}
static int
main_terminal_program (int argc, char *argv [], char **environ)
{
  GnomeClient *client;
  CORBA_Object term=NULL;
  char *program_name;
  char *class, *winclass;
  struct terminal_config *default_config, *cmdline_config;
  struct win_config *cmdline_winconfig, *default_winconfig;
  int i, j;
  CORBA_ORB orb;
  CORBA_Environment ev;
  /* commands */
  char** cmds=NULL, **cmds_names=NULL, **cmds_paths=NULL;
  GtkWidget* app;
  char* prefix;

  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
  textdomain (PACKAGE);

  splitw.term_to_split = NULL;

  cmdline_login = FALSE;

  cmdline_config = g_new0 (struct terminal_config, 1);
  cmdline_winconfig = g_new0 (struct win_config, 1);
  cmdline_cfgs.cfg = cmdline_config;
  cmdline_cfgs.wincfg = cmdline_winconfig;
  
  cb_options[0].descrip = (char *)&cmdline_cfgs;

  /* pre-scan for -x and --execute options */
  for (i=1;i<argc;i++) {
    if (!strcmp (argv [i], "-x") || !(strcmp (argv [i], "--execute"))) {
      int last = i;
      i++;
      if (i == argc) {
	/* no arg!? let popt whinge about usage */
	break;
      }
      initial_command = malloc ((argc-i+1) * sizeof (char *));
      j = 0;
      while (i < argc) {
	initial_command [j] = argv [i];
	i++; 
	j++;
      }
      initial_command [j]=NULL;
      /* 'fool' popt into thinking we have less args */
      argc = last;
      use_terminal_factory = FALSE;
      break;
    }
  }

  CORBA_exception_init (&ev);
  orb = gnome_CORBA_init_with_popt_table (" multi-gnome-terminal", VERSION,
					  &argc, argv,
					  cb_options, 0, NULL,
					  0, &ev);
  env = environ;

  if (ev._major != CORBA_NO_EXCEPTION)
    exit (5);

  CORBA_exception_free (&ev);

  if (mgt_add_terms && !mgt_new_app)
    {
      char fine[64];
      /*printf("ADDING TERMS...\n");*/
      if (!cl_terms)
	return 0;
      add_terms(initial_command); 
      if (!no_wait)
	fgets(fine, 63, stdin);
      return 0;
    }
  gnome_window_icon_set_default_from_file (GNOME_ICONDIR"/mgt/multignometerm.png");

  /* since -x gets stripped out of the commands, this
     will make it override --use-factory */
  if (use_terminal_factory && initial_command)
    use_terminal_factory = FALSE;

  if(cmdline_config->user_back_str)
    gdk_color_parse (cmdline_config->user_back_str,
		     &cmdline_config->palette[17]);

  if(cmdline_config->user_fore_str)
    gdk_color_parse (cmdline_config->user_fore_str,
		     &cmdline_config->palette [16]);

  if (cmdline_config->class)
    {
      class = g_strdup(cmdline_config->class);
    }
  else
    {
#if 0 
      /* program_invocation_short_name is broken on non-glibc machines at the moment */
      program = program_invocation_short_name;
#else
      program_name = strrchr (argv[0], '/');
      if (!program_name) 
	program_name = argv[0];
      else
	program_name++;
#endif

      if (getenv ("GNOME_TERMINAL_CLASS"))
	class = g_strconcat ("Class-", getenv ("GNOME_TERMINAL_CLASS"), 
			     NULL);
      else if (strcmp (program_name, "multi-gnome-terminal"))
	class = g_strconcat ("Class-", program_name, NULL);
      else
	class = g_strdup ("Config");

      /* The class of multignometerm is always Class-multi-gnome-term */
      /*class = g_strconcat ("Class-", program_name, NULL);*/

    }

  if (cmdline_winconfig->class)
    {
      winclass = g_strdup(cmdline_winconfig->class);
    }
  else
    {
#if 0 
      /* program_invocation_short_name is broken on non-glibc machines at the moment */
      program = program_invocation_short_name;
#else
      program_name = strrchr (argv[0], '/');
      if (!program_name) 
	program_name = argv[0];
      else
	program_name++;
#endif

      if (getenv ("GNOME_TERMINAL_CLASS"))
	winclass = g_strconcat ("Win-Class-", getenv ("GNOME_TERMINAL_CLASS"), 
			     NULL);
      else if (strcmp (program_name, "multi-gnome-terminal"))
	winclass = g_strconcat ("Win-Class-", program_name, NULL);
      else
	winclass = g_strdup ("Win-Config");

      /* The class of multignometerm is always Class-multi-gnome-term */
      /*class = g_strconcat ("Class-", program_name, NULL);*/

    }


  /* If we find class in old config file or class is "Config"  
     read from new config file MultiTerminal */
  /*
  if (!read_old_settings(&cmds, &cmds_names, class, &default_config) ||
      !strcmp(class, "Config"))
    {
    */
  
  prefix = g_strdup_printf ("/MultiTerminal/%s/", class);
  if (!gnome_config_has_section(prefix))
    {
      g_free(prefix);
      prefix = g_strdup("/MultiTerminal/Config/");
      g_free (class);
      class = g_strdup("Config");
    }
  gnome_config_push_prefix (prefix);
  default_config = load_config (class);
  gnome_config_pop_prefix();
  /*g_free (class);*/
  g_free (prefix);
 
  prefix = g_strdup_printf ("/MultiTerminal/%s/", winclass);
  if (!gnome_config_has_section(prefix))
    {
      printf("class: %s prefix: %s\n", class, prefix);
      g_free(prefix);
      prefix = g_strdup("/MultiTerminal/Win-Config/");
      g_free (winclass);
      class = g_strdup("Win-Config");
    }

  gnome_config_push_prefix (prefix);
  default_winconfig = load_winconfig (winclass);
  gnome_config_pop_prefix();
  /*g_free (class);*/
  g_free (prefix);

  load_appconfig();
  
  /*}*/
  
  /* now to override the defaults */
  if (cmdline_config->font){
    free (default_config->font);
    default_config->font = g_strdup (cmdline_config->font);
  }

  /* override the title*/
  if (cmdline_winconfig->window_title) {
    default_winconfig->window_title = cmdline_winconfig->window_title;
  }

  /* override the icon*/
  if (cmdline_winconfig->window_icon) {
    default_winconfig->window_icon = cmdline_winconfig->window_icon;
  }

  if (cmdline_config->user_back_str){
    default_config->palette[17] = cmdline_config->palette[17];
    default_config->color_set = COLORS_CUSTOM;
  }
  if (cmdline_config->user_fore_str){
    default_config->palette[16] = cmdline_config->palette[16];
    default_config->color_set = COLORS_CUSTOM;
  }
  /* disallow identical foreground and background colors */
  if(default_config->color_set==COLORS_CUSTOM &&
     gdk_color_equal(&default_config->palette[16], 
		     &default_config->palette[17])) {
    default_config->color_set = 0;		
  }

  if (cmdline_config->have_user_background){
    default_config->background_pixmap = cmdline_config->background_pixmap;
    if(cmdline_config->background_pixmap) {
      default_config->pixmap_file = cmdline_config->pixmap_file;
    }
    default_config->transparent = cmdline_config->transparent;
  }

#ifdef ZVT_BACKGROUND_SCROLL
  if (cmdline_config->have_user_scroll_bg){
    default_config->scroll_background = cmdline_config->scroll_background;
  }
#endif

  if (cmdline_config->have_user_shaded){
    default_config->shaded = cmdline_config->shaded;
  }
#if 0
  /* if the default is different from the commandline, use the commandline */
  default_config->invoke_as_login_shell =
    cmdline_login ? cmdline_config->invoke_as_login_shell : 
    default_winconfig->login_by_default;
#endif
  default_config->termname = g_strdup(cmdline_config->termname);

  terminal_config_free (cmdline_config);
  win_config_free (cmdline_winconfig);

  load_factory_settings ();

  if (start_terminal_factory) {
    corba_init_server (orb);
    if (!has_terminal_factory)
      corba_activate_server ();
  }
#ifdef COPY_CMD
  clipboard_init ();
#endif
  if (!load_session (&app)) {
    gboolean has_term = FALSE;
    if (use_terminal_factory) {
      CORBA_Environment ev;
      CORBA_exception_init (&ev);
      term = create_terminal_via_factory
	(initial_global_geometry
	 ? initial_global_geometry : "80x24", &ev);
      if (ev._major != CORBA_NO_EXCEPTION)
	exit (5);
      if (term) {
	CORBA_Object_release (term, &ev);
	has_term = TRUE;
      }
      CORBA_exception_free (&ev);
    }
    if (!has_term) {
      prefix = g_strdup_printf ("/MultiTerminal/%s/", winclass);
      /*app = new_window (initial_command, default_config,
	initial_global_geometry,
	terminal_id++, cmds_names, cmds);
	*/
      /* load tabs here: CHECK WHETHER THE PREFIX IS RIGHT OR NOT!!! */
      app = load_tabs(prefix, initial_command, default_config,
		      default_winconfig, initial_global_geometry,
		      terminal_id++);
      if (mgt_new_app) 
	{
	  ZvtTerm* te;
	  GSList** ptl; 
	  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
	  te = ZVT_TERM((*ptl)->data);
	  /*printf("ADDING TERMS...\n");*/
	  gtk_flush_all_events();
	  newapp_add_terms(app, te, initial_command); 
	  /*fgets(fine, 63, stdin);*/
	}
      g_free(class);
      g_free(prefix);
    }
  }
  if (term)
    {
      return 0;	  
    }
  /* set toggle items */
  if (!default_winconfig->menubar_hidden && app) 
    {
      toggle_app_items(app, default_winconfig);
    }

  free_str_array(cmds);
  free_str_array(cmds_names);
  free_str_array(cmds_paths);
  terminal_config_free (default_config);
  win_config_free (default_winconfig);
  if (!terminals)
    return 0;

  client = gnome_master_client ();
  gtk_signal_connect (GTK_OBJECT (client), "save_yourself",
		      GTK_SIGNAL_FUNC (save_session), NULL);
  gtk_signal_connect (GTK_OBJECT (client), "die",
		      GTK_SIGNAL_FUNC (session_die), NULL);

  glade_gnome_init ();
#if 0
  while(1)
    {
      if (gtk_main_iteration_do(FALSE)==FALSE)
	{
	  /*gtk_exit(0);*/
	  break;
	}
    }
#endif
#if 0
  while(1)
    {
      while(gtk_events_pending())
	{
	  gtk_main_iteration();
	}
    }
#endif
  /* NOTA IMPORTANTE:
     se si lascia il while nudo e crudo l'applicazione si succhia
     il 100% della CPU, bisogna implementare il main loop in maniera 
     piu' simile a gtk_main e dunque bisogna procurarsi i sorgenti delle 
     librerie gtk! */ 
  /* restore all terminals if request */	

  gtk_timeout_add(1000, check_changed_buffers, (gpointer)&terminals);	
  gtk_main ();

  return 0;
}

extern char **environ;

  int
main (int argc, char *argv [])
{
  signal (SIGHUP, SIG_IGN);
  return main_terminal_program (argc, argv, environ);
}

/*
 * Local variables:
 * c-basic-offset: 8
 * End:
 */
