//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: alayout.h,v 1.1.1.1 2003/10/29 10:06:20 wschweer Exp $
//  (C) Copyright 2002 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __ALAYOUT_H__
#define __ALAYOUT_H__

#include <qlayout.h>
#include <qptrlist.h>

      //  tracklist:
      //
      //         0         1         2
      //   +-----------+--------+---------+
      //   | Trackinfo | vline  | header 4| 0
      //   |           |        +---------+
      //   |     ^     |        |   ^     |
      //   |           |        | <list>  | 1
      //   |     012   |   3    |    5    |
      //   +-----------+--------+---------+
      //   |             hline     6      | 2
      //   +------------------------------+
      //   | ttools        7              | 3
      //   +------------------------------+

//---------------------------------------------------------
//   TLLayout
//    arranger trackList layout manager
//---------------------------------------------------------

class TLLayout : public QLayout
      {
      QPtrList<QLayoutItem> ilist;
      QLayoutItem* li[8];

    public:
      TLLayout(QWidget *parent) : QLayout(parent, 0, -1) {}
      ~TLLayout();

      void addItem(QLayoutItem *item);

      void wadd(int idx, QWidget* w);
      virtual QSize sizeHint() const;
      virtual QSize minimumSize() const;
      virtual QSize maximumSize() const;
      QLayoutIterator iterator();
      void setGeometry(const QRect &rect);
      };
#endif
