//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: glyphs.cpp,v 1.1.1.1 2003/10/29 10:05:27 wschweer Exp $
//  (C) Copyright 1999,2000 Werner Schweer (ws@seh.de)
//=========================================================

#include <stdio.h>
#include "print.h"
#include "glyphs.h"

extern PsStatus pStatus;

struct Glyph {
      double x, y, w, h;      // bounding box
      const char* glyph;
      };

static Glyph glyphs[128] = {
      {
      0.0, -0.176,  0.513, 0.418,
      "0.420 0.238 moveto\n"
      "0.330 0.238 lineto\n"
      "0.330 0.230 0.334 0.348 0.418 0.386 curveto\n"
      "0.444 0.398 0.496 0.400 0.490 0.374 curveto\n"
      "0.488 0.362 0.462 0.370 0.452 0.360 curveto\n"
      "0.429 0.342 0.426 0.308 0.448 0.292 curveto\n"
      "0.478 0.276 0.521 0.292 0.514 0.344 curveto\n"
      "0.514 0.400 0.456 0.432 0.386 0.414 curveto\n"
      "0.258 0.380 0.232 0.240 0.234 0.238 curveto\n"
      "0.158 0.238 lineto\n"
      "0.158 0.210 lineto\n"
      "0.228 0.210 lineto\n"
      "0.228 0.208 0.172 -0.046 0.122 -0.117 curveto\n"
      "0.114 -0.133 0.096 -0.158 0.078 -0.158 curveto\n"
      "0.056 -0.162 0.046 -0.142 0.060 -0.139 curveto\n"
      "0.099 -0.138 0.113 -0.074 0.056 -0.059 curveto\n"
      "0.022 -0.052 -0.018 -0.102 0.007 -0.146 curveto\n"
      "0.026 -0.176 0.088 -0.188 0.134 -0.162 curveto\n"
      "0.244 -0.100 0.287 0.046 0.324 0.210 curveto\n"
      "0.420 0.210 lineto\n"
      "0.420 0.238 lineto\n"
      },

      {
      0.000, -0.148,  0.404, 0.292,
      "0.184 0.047 moveto\n"
      "0.203 0.016 0.218 0.006 0.248 0.004 curveto\n"
      "0.379 0.002 0.464 0.230 0.336 0.290 curveto\n"
      "0.280 0.310 0.228 0.262 0.211 0.246 curveto\n"
      "0.210 0.333 0.126 0.312 0.068 0.153 curveto\n"
      "0.089 0.147 lineto\n"
      "0.155 0.310 0.205 0.279 0.185 0.224 curveto\n"
      "0.040 -0.120 lineto\n"
      "0.000 -0.120 lineto\n"
      "0.000 -0.146 lineto\n"
      "0.157 -0.146 lineto\n"
      "0.157 -0.120 lineto\n"
      "0.117 -0.120 lineto\n"
      "0.184 0.047 lineto\n"
      "0.222 0.047 moveto\n"
      "0.160 0.086 0.245 0.261 0.321 0.268 curveto\n"
      "0.377 0.218 0.303 0.029 0.222 0.047 curveto\n"
      },

      {
      0.000,  0.000,  0.396, 0.297,
      "0.210 0.010 moveto\n"
      "0.243 0.184 0.262 0.219 0.295 0.246 curveto\n"
      "0.350 0.261 0.311 0.213 0.349 0.198 curveto\n"
      "0.398 0.181 0.431 0.252 0.368 0.291 curveto\n"
      "0.327 0.308 0.278 0.268 0.256 0.235 curveto\n"
      "0.303 0.336 0.172 0.345 0.072 0.198 curveto\n"
      "0.085 0.186 lineto\n"
      "0.123 0.248 0.206 0.312 0.185 0.239 curveto\n"
      "0.129 0.010 lineto\n"
      "0.210 0.010 lineto\n"
      },

      {
      0.000, -0.009,  0.236, 0.293,
      "0.148 0.066 moveto\n"
      "0.161 0.028 0.130 0.002 0.083 0.009 curveto\n"
      "0.032 0.038 0.107 0.045 0.077 0.088 curveto\n"
      "0.055 0.113 0.018 0.101 0.014 0.068 curveto\n"
      "0.019 -0.043 0.216 -0.041 0.208 0.076 curveto\n"
      "0.200 0.141 0.113 0.167 0.091 0.211 curveto\n"
      "0.072 0.255 0.134 0.297 0.172 0.268 curveto\n"
      "0.212 0.237 0.145 0.225 0.188 0.188 curveto\n"
      "0.223 0.179 0.242 0.199 0.236 0.224 curveto\n"
      "0.209 0.327 0.028 0.306 0.032 0.212 curveto\n"
      "0.037 0.149 0.142 0.116 0.148 0.066 curveto\n"
      },

      {
      -0.003, -0.009,  0.299, 0.287,
      "0.082 0.287 moveto\n"
      "0.052 0.222 lineto\n"
      "0.069 0.222 lineto\n"
      "0.089 0.240 lineto\n"
      "0.238 0.240 lineto\n"
      "-0.003 0.006 lineto\n"
      "0.034 0.006 lineto\n"
      "0.072 0.043 0.156 0.028 0.191 0.003 curveto\n"
      "0.274 -0.021 0.302 0.046 0.265 0.101 curveto\n"
      "0.251 0.117 0.219 0.118 0.205 0.093 curveto\n"
      "0.206 0.050 0.249 0.075 0.246 0.041 curveto\n"
      "0.206 0.000 0.196 0.113 0.092 0.061 curveto\n"
      "0.299 0.261 lineto\n"
      "0.299 0.287 lineto\n"
      "0.082 0.287 lineto\n"
      },

      {
      0.000, -0.012,  0.472, 0.292,
      "0.188 0.000 moveto\n"
      "0.271 0.226 lineto\n"
      "0.287 0.270 0.252 0.303 0.207 0.225 curveto\n"
      "0.120 0.000 lineto\n"
      "0.052 0.000 lineto\n"
      "0.157 0.261 lineto\n"
      "0.160 0.304 0.072 0.266 0.045 0.184 curveto\n"
      "0.027 0.184 lineto\n"
      "0.056 0.245 0.100 0.301 0.159 0.292 curveto\n"
      "0.188 0.286 0.200 0.262 0.200 0.243 curveto\n"
      "0.228 0.303 0.327 0.312 0.333 0.243 curveto\n"
      "0.373 0.317 0.488 0.303 0.468 0.236 curveto\n"
      "0.396 0.038 lineto\n"
      "0.386 0.001 0.435 0.024 0.460 0.074 curveto\n"
      "0.472 0.071 lineto\n"
      "0.429 -0.026 0.310 -0.065 0.335 0.019 curveto\n"
      "0.403 0.222 lineto\n"
      "0.424 0.273 0.375 0.291 0.346 0.228 curveto\n"
      "0.264 0.000 lineto\n"
      "0.186 0.000 lineto\n"
      },

      {
      0.000, -0.147,  0.404, 0.299,
      "0.184 0.047 moveto\n"
      "0.203 0.016 0.218 0.006 0.248 0.004 curveto\n"
      "0.379 0.002 0.464 0.230 0.336 0.290 curveto\n"
      "0.280 0.310 0.228 0.262 0.211 0.246 curveto\n"
      "0.205 0.285 0.168 0.304 0.138 0.296 curveto\n"
      "0.136 0.270 lineto\n"
      "0.162 0.278 0.190 0.257 0.185 0.224 curveto\n"
      "0.040 -0.120 lineto\n"
      "0.000 -0.120 lineto\n"
      "0.000 -0.145 lineto\n"
      "0.157 -0.145 lineto\n"
      "0.157 -0.120 lineto\n"
      "0.117 -0.120 lineto\n"
      "0.184 0.047 lineto\n"
      "0.222 0.047 moveto\n"
      "0.160 0.086 0.245 0.261 0.321 0.268 curveto\n"
      "0.377 0.218 0.303 0.029 0.222 0.047 curveto\n"
      },
/*ff*/      { 0.000, -0.176,   0.83, 0.418, 0 },
/*fff*/     { 0.000, -0.176,   1.13, 0.418, 0 },
/*pp*/      { 0.000, -0.148,    0.7, 0.292, 0 },
/*ppp*/     { 0.000, -0.148,    1.0, 0.292, 0 },
/*mp*/      { 0.000, -0.148,  0.781, 0.292, 0 },
/*mf*/      { 0.000, -0.176,  0.886, 0.418, 0 },
/*sfz*/     { 0.000, -0.176,  0.749, 0.418, 0 },
/*sf*/      { 0.000, -0.176,    0.6, 0.418, 0 },
/*sff*/     { 0.000, -0.176,  0.913, 0.418, 0 },
/*fp*/      { 0.000, -0.176,  0.668, 0.418, 0 },
/*pppp*/    { 0.000, -0.148,    1.3, 0.292, 0 },
/*sp*/      { 0.000, -0.148,   0.54, 0.293, 0 },
/*spp*/     { 0.000, -0.148,  0.844, 0.293, 0 },
/*sfp*/     { 0.000, -0.176,  0.754, 0.418, 0 },
/*rfz*/     { 0.000, -0.176,   0.99, 0.418, 0 },
/*ffff*/    { 0.000, -0.176,   1.44, 0.418, 0 },
/*fz*/      { 0.000, -0.176,   .663, 0.418, 0 },
/*ffp*/     { 0.000, -0.176,    .99, 0.418, 0 },
      { 0, 0, 0, 0, 0 }
      };

//---------------------------------------------------------
//   moveCoord
//---------------------------------------------------------

static void moveCoord(FILE* f, double x, double y)
      {
      fprintf(f, "gsave [1 0 0 1 %.2f %.2f] concat\n", x, y);
      }

//---------------------------------------------------------
//   genGlyph
//---------------------------------------------------------

static void genGlyph(FILE* f, int code)
      {
      if (pStatus.glyphExists[code])
            return;

      Glyph* glyph = &glyphs[code];

      double x;
      switch(code) {
            case G_f:
            case G_p:
            case G_r:
            case G_s:
            case G_z:
            case G_m:
            case G_P:
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "%s", glyph->glyph);
                  fprintf(f, "fill } def\n");
                  break;
            case G_ff:
                  genGlyph(f, G_f);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_f);
                  x = glyphs[G_f].w - 0.2;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_f);
                  fprintf(f, "} def\n");
                  break;
            case G_pp:
                  genGlyph(f, G_p);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_p);
                  x = glyphs[G_p].w - 0.1;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_p);
                  fprintf(f, "} def\n");
                  break;
            case G_ppp:
                  genGlyph(f, G_p);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_p);
                  x = glyphs[G_f].w - 0.1;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_p);
                  x += glyphs[G_f].w - 0.1;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_p);
                  fprintf(f, "} def\n");
                  break;
            case G_fff:
                  genGlyph(f, G_f);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_f);
                  x = glyphs[G_f].w - 0.2;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_f);
                  x += glyphs[G_f].w - 0.2;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_f);
                  fprintf(f, "} def\n");
                  break;
            case G_mp:
                  genGlyph(f, G_m);
                  genGlyph(f, G_p);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_m);
                  x = glyphs[G_m].w - 0.05;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_p);
                  fprintf(f, "} def\n");
                  break;
            case G_mf:
                  genGlyph(f, G_m);
                  genGlyph(f, G_f);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_m);
                  x = glyphs[G_m].w - 0.1;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_f);
                  fprintf(f, "} def\n");
                  break;
            case G_sfz:
                  genGlyph(f, G_s);
                  genGlyph(f, G_f);
                  genGlyph(f, G_z);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_s);
                  x = glyphs[G_s].w - 0.15;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_f);
                  x += glyphs[G_f].w - 0.15;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_z);
                  fprintf(f, "} def\n");
                  break;
            case G_sf:
                  genGlyph(f, G_s);
                  genGlyph(f, G_f);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_s);
                  x = glyphs[G_s].w - 0.15;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_f);
                  fprintf(f, "} def\n");
                  break;
            case G_sff:
                  genGlyph(f, G_s);
                  genGlyph(f, G_f);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_s);
                  x = glyphs[G_s].w - 0.15;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_f);
                  x += glyphs[G_f].w - 0.2;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_f);
                  fprintf(f, "} def\n");
                  break;
            case G_fp:
                  genGlyph(f, G_f);
                  genGlyph(f, G_P);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_f);
                  x = glyphs[G_f].w - 0.25;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_p);
                  fprintf(f, "} def\n");
                  break;
            case G_pppp:
                  genGlyph(f, G_p);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_p);
                  x = glyphs[G_p].w - 0.1;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_p);
                  x += glyphs[G_p].w - 0.1;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_p);
                  x += glyphs[G_p].w - 0.1;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_p);
                  fprintf(f, "} def\n");
                  break;
            case G_sp:
                  genGlyph(f, G_s);
                  genGlyph(f, G_p);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_s);
                  x = glyphs[G_s].w - 0.1;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_p);
                  fprintf(f, "} def\n");
                  break;
            case G_spp:
                  genGlyph(f, G_s);
                  genGlyph(f, G_p);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_s);
                  x = glyphs[G_s].w - 0.1;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_p);
                  x = glyphs[G_p].w - 0.1;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_p);
                  fprintf(f, "} def\n");
                  break;
            case G_sfp:
                  genGlyph(f, G_s);
                  genGlyph(f, G_f);
                  genGlyph(f, G_P);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_s);
                  x = glyphs[G_s].w - 0.1;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_f);
                  x = glyphs[G_f].w - 0.1;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_P);
                  fprintf(f, "} def\n");
                  break;
            case G_rfz:
                  genGlyph(f, G_r);
                  genGlyph(f, G_f);
                  genGlyph(f, G_z);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_r);
                  x = glyphs[G_r].w - 0.15;
                  moveCoord(f, x, -.3);
                  fprintf(f, "glyph%d grestore\n", G_f);
                  x = glyphs[G_f].w - 0.15;
                  moveCoord(f, x, 0.05);
                  fprintf(f, "glyph%d grestore\n", G_z);

                  fprintf(f, "} def\n");
                  break;
            case G_ffff:
                  genGlyph(f, G_f);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_f);
                  x = glyphs[G_f].w - 0.2;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_f);
                  x += glyphs[G_f].w - 0.2;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_f);
                  x += glyphs[G_f].w - 0.2;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_f);
                  fprintf(f, "} def\n");
                  break;
            case G_fz:
                  genGlyph(f, G_f);
                  genGlyph(f, G_z);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_f);
                  x = glyphs[G_f].w - 0.15;
                  moveCoord(f, x, 0.05);
                  fprintf(f, "glyph%d grestore\n", G_z);
                  fprintf(f, "} def\n");
                  break;
            case G_ffp:
                  genGlyph(f, G_f);
                  genGlyph(f, G_P);
                  fprintf(f, "/glyph%d {\n", code);
                  fprintf(f, "glyph%d\n", G_f);
                  x = glyphs[G_f].w - 0.25;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_f);
                  x += glyphs[G_f].w - 0.25;
                  moveCoord(f, x, 0.0);
                  fprintf(f, "glyph%d grestore\n", G_p);
                  fprintf(f, "} def\n");
                  break;
            default:
                  break;
            }
      pStatus.glyphExists[code] = true;
      }

//---------------------------------------------------------
//   printGlyph
//---------------------------------------------------------

void printGlyph(FILE* f, int code, double x, double y)
      {
      if (!pStatus.glyphExists[code])
            genGlyph(f, code);
      if (pStatus.glyphExists[code])
            fprintf(f, "gsave [24 0 0 -24 %.2f %.2f] concat glyph%d grestore\n",
               x, y, code);
      }

//---------------------------------------------------------
//   printGlyph
//    centered to x
//---------------------------------------------------------

void printGlyphC(FILE* f, int code, double x, double y)
      {
      if (!pStatus.glyphExists[code])
            genGlyph(f, code);
      x -= glyphs[code].w / 2.0 * 24.0;
      if (pStatus.glyphExists[code])
            fprintf(f, "gsave [24 0 0 -24 %.2f %.2f] concat glyph%d grestore\n",
               x, y, code);
      }

