/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 gnuupload.h  -  File upload controller definition
 
 the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

    begin                : Wed May 30 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#if !defined(__GNUUPLOAD_H_INCLUDED__)
#define __GNUUPLOAD_H_INCLUDED__

/////////////////////////////////////////////////////////////////////////////
// MGnuUpload

class MGnuDirector;
class MGnuShare;
class MGnuPreferences;
class MUploadFile;
class MUploadBuffer;

#define UPLERR_NONE         0
#define UPLERR_NODATA       1
#define UPLERR_SOCKET_EROR  2
#define UPLERR_BAD_PUSH     3
#define UPLERR_BUSY         4
#define UPLERR_NOT_FOUND    5
#define UPLERR_REM_CANCELED 6
#define UPLERR_CONNECT_FAIL 7
#define UPLERR_BAD_REQUEST  8
#define UPLERR_NO_RESPONSE  10
#define UPLERR_TOO_SLOW 11

class MGnuUpload : public MAsyncSocket, public SGnuUpload
{
// Attributes
public:

// Operations
public:
	MGnuUpload(MGnuDirector*);
	virtual ~MGnuUpload();

	void PushFile();
	void UploadFile(const CString& sHandshake, bool bLock = true);
	
	void Send_HttpOK();
	void Send_HttpBusy();
	void Send_HttpNotFound();

	void StatusUpdate(DWORD);
	void BandwidthTimer();
	void ForceDisconnect();
	void UpdateSelectFlags();
	void SetMaxRate(double dMR){m_dMaxRate = dMR;}

	void ResetState(bool bLock);
public:
	MMutex m_mutex;
protected:
	MUploadFile* m_pAFile;
	TSmartPtr<MUploadBuffer> m_pBuffer;
	//
	int    m_nFileIndexPush;
	CString m_sFilePath;
	CString m_sSha1;
	bool   m_bUriRequest;
	//
	int    m_nRequestedRange;
	int    m_nStartOffset;
	int    m_nStartTime;
	bool   m_bHttpOK;
	bool   m_bKeepAlive;

	bool   m_bBelowRateLimit;
	bool   m_bBufferReady;

	// Bandwidth
	DWORD  m_dwBytes60;      // Bytes received in past 60 seconds
	DWORD  m_dwSecBytes;     // Bytes sent in last second
	int    m_nSecNum;	     // Number of elements in array
	int    m_nSecsUnderLimit;
	int	   m_nSecsDead;
	double m_dMaxRate;
	DWORD  m_dwAvgBytes[60]; // Average bytes from last 60 seconds
	int    m_nSecPos;        // Position of next element insert

	//
	CString m_sHandshake;
	CString m_sTmpHandshake;

	// Overrides
public:
	public:
	virtual void OnClose(int nErrorCode);
	virtual void OnConnect(int nErrorCode);
	virtual void OnReceive(int nErrorCode);
	virtual void OnSend(int nErrorCode);
	
// async file notifiers
	void OnFileOpen(bool bLock = true);
	void OnFileRead(int Requested, int nRead, int nError);
	void OnFileError(int nError);
// used for pushes
	inline void SetHandshake(const CString& sHandshake) {m_sHandshake = sHandshake;}
protected:
	MGnuUpload();                        // no implementation
	MGnuUpload(const MGnuUpload& rSrc);  // no implementation
	
// Implementation
protected:
	MGnuDirector* m_pDirector;
	MGnuShare*    m_pShare;
	MGnuPreferences* m_pPrefs;
};

/////////////////////////////////////////////////////////////////////////////

#endif // __GNUUPLOAD_H_INCLUDED__

