/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

/* kaiser.f -- translated by f2c (version of 16 February 1991  0:35:15).
   You must link the resulting object file with the libraries:
	-lf2c -lm -lc   (in that order)
*/

#include "f2c.h"

/* ----------------------------------------------------------------------- */
/* SUBROUTINE:  KAISER */
/* KAISER WINDOW */
/* ----------------------------------------------------------------------- */

/* Subroutine */ int kaiser_(integer *nf, real *w, integer *n, integer *ieo, 
	real *beta)
{
    /* System generated locals */
    integer i__1;
    real r__1;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    static real xind;
    static integer i;
    static real xi, bes;
    extern real ino_(real *);


/*   NF = FILTER LENGTH IN SAMPLES */
/*    W = WINDOW ARRAY OF SIZE N */
/*    N = FILTER HALF LENGTH=(NF+1)/2 */
/*  IEO = EVEN ODD INDICATOR--IEO=0 IF NF EVEN */
/* BETA = PARAMETER OF KAISER WINDOW */

    /* Parameter adjustments */
    --w;

    /* Function Body */
    bes = ino_(beta);
    xind = (real) (*nf - 1) * (real) (*nf - 1);
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	xi = (real) (i - 1);
	if (*ieo == 0) {
	    xi += .5f;
	}
	xi = xi * 4.f * xi;
	r__1 = *beta * sqrt(1.f - xi / xind);
	w[i] = ino_(&r__1);
	w[i] /= bes;
/* L10: */
    }
    return 0;
} /* kaiser_ */


/* ----------------------------------------------------------------------- */
/* FUNCTION:  INO */
/* BESSEL FUNCTION FOR KAISER WINDOW */
/* ----------------------------------------------------------------------- */

real ino_(real *x)
{
    /* System generated locals */
    real ret_val;

    /* Local variables */
    static real e;
    static integer i;
    static real t, y, de, xi, sde;

    y = *x / 2.f;
    t = 1e-8f;
    e = 1.f;
    de = 1.f;
    for (i = 1; i <= 25; ++i) {
	xi = (real) i;
	de = de * y / xi;
	sde = de * de;
	e += sde;
	if (e * t - sde <= 0.f) {
	    goto L10;
	} else {
	    goto L20;
	}
L10:
	;
    }
L20:
    ret_val = e;
    return ret_val;
} /* ino_ */

