// selector.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// This object maintains the state of vertical insert-point lines and 
// highlighted edit-regions in Graphs.  It is also responsible for converting
// its current visual insert point and edit region into frame locations in the
// associated Data (this functionality will be separated into another class).
// Selector also is able to "quantize" the horizontal placement of the insert
// point and edit region to always fall on a visual sample boundry.

#ifndef SELECTOR_H
#ifdef __GNUG__
#pragma interface
#endif
#define SELECTOR_H

#include "localdefs.h"
#include "range.h"

class ScaledArea;
class Rubberband;
class Painter;
class Canvas;
class Perspective;

class Selector : public Resource {
public:
	Selector(ScaledArea *s);
	~Selector();
	void updateSelf(Coord l=0, Coord b=0, Coord r=0, Coord t=0);
	void markInsertPoint(Coord loc);
	void markEditRegion(Coord loc);
	void setInsert(Coord loc);
	void setInsertLocation(int point);
	void setRegion(const Range &);
	void setEditRegion(const Range &);
	boolean selectEdit();		// returns false if no point or region set
	void unSelect();
	void shift(int direction);
	void changeWidth(int direction);
	void collapseRegion(int direction);
	void selectVisible();
	void selectAll();
	int insertPoint();
	Range editRegion();
	int regionSelected() { return region_set; }
	boolean isSet() { return insert_set || region_set; }
protected:
	void redraw(Canvas *, Coord, Coord, Coord, Coord);
	void drawIndicator(Coord loc);
	void updateGraphics();
	void moveRegionTo(const Coord start, const Coord end);
	void setCoordsFromEditPoints(Coord *, Coord *);
	void setEditPointsFromCoords(const Coord, const Coord=0);
	Coord quantize(Coord);
	boolean graphAdjusted();
	boolean atBeginning();
	boolean atEnd();
	void cacheIsValid(boolean flag) { cacheValid = flag; }
	boolean cacheInvalid() { return cacheValid == false; }
	void newIndicator(Coord start, boolean region);
	void confine(boolean b) { confined = b; }
private:	
	ScaledArea *area;
	Perspective *shown;			// for comparison with current
	Rubberband *indicator;		// hairline or highlighted area
	int insertloc, regionloc;	// reference points for edits
	Coord currentXmin, currentXmax;
	Coord currentYmin, currentYmax;
	Coord xstart, xend;
	int width, height;
	boolean insert_set, region_set;
	boolean confined;
	boolean cacheValid;
};

#endif
