
function check_details(server,file_name_prepare,file_name_connection,file_name_profile,file_name_out,file_name_clean,test_prompt)
{
  if (!server.enabled)
  {
    print_test_skipped(test_prompt)
  }
  else
  {
    var name_draft_file=          "r\\" + file_name_out         + ".backup.draft.sql"
    var name_connection=          "t\\" + file_name_connection  + ".test.connection.xml"
    var name_prepared_connection= "t\\" + file_name_connection  + ".test.connection.prepared.xml"
    var name_backup_profile=      "t\\" + file_name_profile     + ".test.backup_profile.xml"

    var name_progress_log=        "r\\" + file_name_profile     + ".progress_log"
    var name_progress_log_etalon= "r\\" + file_name_profile     + ".progress_log.etalon"
    var name_progress_log_diff=   "r\\" + file_name_profile     + ".progress_log.diff"

    var name_output=              "r\\" + file_name_profile     + ".output"
    var name_output_etalon=       "r\\" + file_name_profile     + ".output.etalon"
    var name_output_diff=         "r\\" + file_name_profile     + ".output.diff"

    var name_backup=              "r\\" + file_name_out         + ".backup.sql"
    var name_backup_etalon=       "r\\" + file_name_out         + ".backup.etalon.sql"
    var name_backup_diff=         "r\\" + file_name_out         + ".backup.diff"

    server.prepare_connection_file(name_connection,name_prepared_connection)
    server.execute_script("t\\" + file_name_prepare + ".prepare.sql")
    var cmd_line=  "Debug\\test_make_backup.exe " + name_prepared_connection + " " + name_backup_profile
        cmd_line+= " " + name_draft_file + " 5 " + name_progress_log + " x"
    exec_everything_to_file(cmd_line,name_output)
    server.execute_script("t\\" + file_name_clean   + ".clean.sql")
    fso.GetFile(name_prepared_connection).Delete()

    discard_volatile_results(name_draft_file,name_backup)
  
    var fc_result1= compare_results(name_progress_log_etalon, name_progress_log,  name_progress_log_diff)
    var fc_result2= compare_results(name_output_etalon,       name_output,        name_output_diff)
    var fc_result3= compare_results(name_backup_etalon,       name_backup,        name_backup_diff)

    print_test_res(test_prompt,fc_result1+fc_result2+fc_result3)
  }
}

function check(server,file_name,test_prompt)
{
  check_details(server,file_name,file_name,file_name,file_name,file_name,test_prompt)
}

print_title("test make backup")

server_40.safe_start()
server_41.safe_start()
server_50.safe_start()

copy_dlls()

check(server_40,  "mysql_40_simple",  "simple backup of mysql-4.0")
check(server_41,  "mysql_41_simple",  "simple backup of mysql-4.1")
check(server_50,  "mysql_50_simple",  "simple backup of mysql-5.0")

check(server_41,  "mysql_41_utf8",    "simple backup of mysql-4.1 with utf8 symbols")
check(server_50,  "mysql_50_utf8",    "simple backup of mysql-5.0 with utf8 symbols")

check_details(server_40,"mysql_40_simple","mysql_40_simple","mysql_40_ansi","mysql_40_ansi","mysql_40_simple","simple backup of mysql-4.0 with ansi quotas")
check_details(server_41,"mysql_41_simple","mysql_41_simple","mysql_41_ansi","mysql_41_ansi","mysql_41_simple","simple backup of mysql-4.1 with ansi quotas")
check_details(server_50,"mysql_50_simple","mysql_50_simple","mysql_50_ansi","mysql_50_ansi","mysql_50_simple","simple backup of mysql-5.0 with ansi quotas")

server_40.safe_stop()
server_41.safe_stop()
server_50.safe_stop()

clear_dlls()
print_footer()
