package com.mysql.grt.modules;

import com.mysql.grt.*;
import com.mysql.grt.db.*;

public class JavaTestModule {

	/**
	 * Static function to return information about this class to the GRT
	 * environment
	 * 
	 * @return returns a GRT XML string containing the infos about this class
	 */
	public static String getModuleInfo() {
		return Grt.getModuleInfoXml(JavaTestModule.class, "");
	}

	public static String helloWorld() {
		Grt.getInstance().addMsg("Hello world!");

		return "Hello World!";
	}

	public static String upperCase(String str) {
		return str.toUpperCase();
	}

	public static int getListSize(GrtList list) {
		return list.size();
	}

	public static String concatStrings(String s1, String s2) {
		return s1 + s2;
	}

	public static void throwException() throws Exception {
		throw new Exception("Exception Test");
	}

	public static String getGlobalString(String objectPath) {
		Grt.getInstance().addMsg("Calling getGrtGlobalAsString.");
		Grt.getInstance().addMsgDetail(
				"applicationPath = " + Grt.getInstance().getApplicationPath());
		Grt.getInstance().addMsgDetail(
				"callback.class = "
						+ Grt.getInstance().getCallback().getClass().getName());

		return Grt.getInstance().getGrtGlobalAsString(objectPath);
	}
	
	public static void testCallbacks() {
		GrtHashMap root = (GrtHashMap) Grt.getInstance().getGrtGlobalAsObject("/");
		
		GrtStringList list = new GrtStringList();
		list.add("Item1");
		list.add("Item2");		
		root.addObject("stringList", list);
		
		GrtObject obj = new GrtObject(null);
		obj.setName("testObject");		
		root.addObject("object", obj);
		
		GrtStringHashMap map = new GrtStringHashMap();
		map.add("mike", "mzinner@mysql.com");
		map.add("alfredo", "alfredo@mysql.com");		
		root.addObject("emails", map);
		
		Catalog catalog = new Catalog(null);
		catalog.setName("sourceCatalog");
		
		SchemaList schemata = new SchemaList();
		catalog.setSchemata(schemata);
		
		Schema schema = new Schema(catalog);
		schema.setName("scott");
		schemata.add(schema);
		
		root.addObject("sourceCatalog", catalog);
	}
}