/* 
 * This file was taken from xnetload, with minor modifications.
 * The original comments are below
 *  
 * --------------------------------------------------------------------
 * This file is part of xnetload, a program to monitor network traffic,
 * and display it in an X window.
 *
 * Copyright (C) 1997 - 2000  R.F. Smith <rsmith@xs4all.nl>
 *
 * You can contact the author at the following address:
 *      email: rsmith@xs4all.nl
 * snail-mail: R.F. Smith
 *             Dr. Hermansweg 36
 *             5624 HR Eindhoven
 *             The Netherlands
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *
 */

#ifndef _DATA_H
#define _DATA_H

#include <gnome.h>
#include <panel-applet.h>

static time_t starttime;
#define UPDATE_TIMEOUT 1000
/* extern PanelApplet *applet; */
extern GtkWidget *inlabel, *outlabel;

#define NETMON_LAYOUT_HORIZONTAL 0
#define NETMON_LAYOUT_VERTICAL 1

/********** Type definitionss **********/

typedef struct {
  PanelApplet *applet;
  int panel_size;
  int panel_orient;
  gboolean show_frame;
  GtkWidget *propwin;
  char *font;
  char *interface;
  int layout;
} AppData;

/* contains number of outgoing/incoming packets or bytes */
typedef struct {
  float in;    /* incoming packets/bytes */
  float out;   /* outgoing packets/bytes */
} count_t;

/********** Global variables **********/
extern count_t average;   /* average count */
extern count_t max;       /* maximum count */
extern count_t total;     /* total count   */

/* Values for `type' */
#define BYTES_TYPE      0
#define PACKETS_TYPE    1
#define ERROR_TYPE      -1
extern int type;           /* What kind of data is gathered */

/********** Functions **********/

/* Report a fatal error and exit. */
extern void report_error(char *msg);

/* Initialize the data gathering process. Sets the variables `type' and
   `where', for future reference. Returns `type' */
extern int initialize(char *iface, int num_avg/*  , int kb */);
extern int cleanup(void);

/* Read the new counts and update the `average' and `max' and 'total'. */
extern void update_avg(int seconds);

#endif /* _DATA_H */
