/*
 *  Copyright (c) 2000 Jason Petrone <jp@demonseed.net>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 */

#include <gnome.h>
#include <panel-applet.h>
#include <panel-applet-gconf.h>

#include <time.h>

#define GETTEXT_PACKAGE "netmon_applet"

#include "data.h"
#include "config.h"

guint timeout_handle = -1;
PanelApplet *applet = NULL;
GtkWidget *frame = NULL;
GtkWidget *box = NULL;
GtkWidget *fixed = NULL;
GtkWidget *inlabel, *outlabel;
GdkFont *font;
AppData *ad;
static time_t starttime;

gint netmon_draw(void);
/* void about(PanelApplet *widget, gpointer data); */
void about(BonoboUIComponent *ui, gpointer data, const char *cname);
extern void property_load(PanelApplet *applet, AppData *ad);
extern void property_save(PanelApplet *applet, AppData *ad);
extern void property_show(BonoboUIComponent *ui, gpointer data, const char *cname);


static const char netmon_menu_xml [] =
        "<popup name=\"button3\">\n"
        "   <menuitem name=\"Properties Item\" verb=\"NetmonProperties\" _label=\"Properties ...\"\n"
        "             pixtype=\"stock\" pixname=\"gtk-properties\"/>\n"
        "   <menuitem name=\"About Item\" verb=\"NetmonAbout\" _label=\"About ...\"\n"
        "             pixtype=\"stock\" pixname=\"gnome-stock-about\"/>\n"
        "</popup>\n";

static const BonoboUIVerb netmon_menu_verbs[] = {
        BONOBO_UI_VERB("NetmonProperties", property_show),
        BONOBO_UI_VERB("NetmonAbout", about),

        BONOBO_UI_VERB_END
};

void init_ui(){
  char buf[2048];

  if (box) gtk_widget_destroy(box);
  if (frame) gtk_widget_destroy(frame);

  sprintf(buf, "<span font_desc=\"%s\">rx: 0.0k/s</span>", ad->font);
  inlabel = gtk_label_new("");
  gtk_label_set_markup(GTK_LABEL(inlabel), buf);
  sprintf(buf, "<span font_desc=\"%s\">tx: 0.0k/s</span>", ad->font);
  outlabel = gtk_label_new("");
  gtk_label_set_markup(GTK_LABEL(outlabel), buf);
  netmon_draw();
  if (ad->layout == NETMON_LAYOUT_VERTICAL){
    box = gtk_vbox_new(FALSE, FALSE);
  }
  else {
    box = gtk_hbox_new(FALSE, 5);
  }
  gtk_box_pack_start(GTK_BOX(box), inlabel, FALSE, 0, 0);
  gtk_box_pack_start(GTK_BOX(box), outlabel, FALSE, 0, 0);

  if (ad->show_frame){
    frame = gtk_frame_new(ad->interface);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);
    gtk_container_add(GTK_CONTAINER(frame), box);
    gtk_container_add(GTK_CONTAINER(ad->applet), frame);
  }
  else {
    gtk_container_add(GTK_CONTAINER(ad->applet), box);
  }

  gtk_widget_show_all(GTK_WIDGET(ad->applet));
}


static void change_orient_cb(PanelApplet *w, PanelAppletOrient o, gpointer data) {
    AppData *ad = (AppData*)data;
    ad->panel_orient = o;
    init_ui();
}
  
static void change_size_cb(PanelApplet *w, gint s, gpointer data) {
    AppData *ad = (AppData*)data;
    ad->panel_size = s;
    init_ui();
}

gboolean create_netmon_applet(PanelApplet *applet, 
                              const gchar *iid, gpointer data){
  ad = g_new0(AppData, 1);

  ad->applet = applet;

  panel_applet_add_preferences(applet,"/schemas/apps/netmon_applet/prefs",NULL);

  property_load(applet, ad);
  /* property_save(applet, ad); */

  if (initialize(ad->interface, 5) < 0){
    fprintf(stderr, "Cannot init %s!\n", ad->interface);
    fflush(stderr);
  }

  panel_applet_setup_menu(PANEL_APPLET (applet),
                                 netmon_menu_xml,
                                 netmon_menu_verbs,
                                 ad);

  /*
  gtk_signal_connect(GTK_OBJECT(applet),"save_session",
                     GTK_SIGNAL_FUNC(property_save), ad);
  */

  g_signal_connect (G_OBJECT(applet), "change_size",
                       G_CALLBACK(change_size_cb), ad);
  g_signal_connect (G_OBJECT(applet), "change_orient",
                       G_CALLBACK(change_orient_cb), ad);

  /* gtk_signal_connect (GTK_OBJECT(frame), "destroy",          */
  /*                     GTK_SIGNAL_FUNC(gtk_main_quit), NULL); */

  time(&starttime);
  timeout_handle = gtk_timeout_add(UPDATE_TIMEOUT, (void *)netmon_draw, NULL);
  
  init_ui();

  return TRUE;
}

gint netmon_draw(void){
  int i;
  char buf[128];
  char num[16];
  time_t newtime;
  long hr, min, sec;    /* time vars  */
  float ink, outk;

  update_avg(1);
  ink = average.in/1024;
  outk = average.out/1024;

  if (ink < 100.0) sprintf(num, "%.1fk/s", ink);
  else if (ink < 1000.0) sprintf(num, "%ik/s", (int)ink);
  else sprintf(num, "%.1fM/s", ink/1024);
  sprintf(buf, "<span font_desc=\"%s\">rx: %s</span>", ad->font, num);
  gtk_label_set_markup(GTK_LABEL(inlabel), buf);

  if (outk < 100.0) sprintf(num, "%.1fk/s", outk);
  else if (outk < 1000.0) sprintf(num, "%ik/s", (int)outk);
  else sprintf(num, "%.1fM/s", outk/1024);
  sprintf(buf, "<span font_desc=\"%s\">tx: %s</span>", ad->font, num);
  gtk_label_set_markup(GTK_LABEL(outlabel), buf);


  return TRUE;
}

void about(BonoboUIComponent *ui, gpointer data, const char *cname) {
    const gchar *authors[] = {
        "Jason Petrone <jp@demonseed.net>",
        NULL
    };
    static GtkWidget *about_dialog = NULL;

    if (about_dialog != NULL)
    {
      gdk_window_show(about_dialog->window);
      gdk_window_raise(about_dialog->window);
  return;
    }
    about_dialog = gnome_about_new ("GNOME Network Monitor", VERSION,
                                    _("Copyright (c) 2000-2001 Jason Petrone"),
                                    _("GNOME network load monitor applet."),
                                    authors, NULL, NULL, NULL);
    gtk_signal_connect( GTK_OBJECT(about_dialog), "destroy",
            GTK_SIGNAL_FUNC(gtk_widget_destroyed), &about_dialog );
    gtk_widget_show(about_dialog);

    return;
}

PANEL_APPLET_BONOBO_FACTORY("OAFIID:GNOME_NetmonApplet_Factory",
     PANEL_TYPE_APPLET, "netmon_applet", "0", create_netmon_applet, NULL);

