/* an editable string
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static ClassmodelClass *parent_class = NULL;

static void
string_finalize( GObject *gobject )
{
	String *string;

#ifdef DEBUG
	printf( "string_finalize\n" );
#endif /*DEBUG*/

	g_return_if_fail( gobject != NULL );
	g_return_if_fail( IS_STRING( gobject ) );

	string = STRING( gobject );

	IM_FREE( string->value );

	G_OBJECT_CLASS( parent_class )->finalize( gobject );
}

static xmlNode *
string_save( Model *model, xmlNode *xnode )
{
	String *string = STRING( model );

	xmlNode *xthis;

	if( !(xthis = MODEL_CLASS( parent_class )->save( model, xnode )) )
		return( NULL );

	if( CLASSMODEL( model )->edited ) {
		if( !set_prop( xthis, "value", "%s", string->value ) ) 
			return( NULL );
	}

	return( xthis );
}

static gboolean
string_load( Model *model, 
	ModelLoadState *state, Model *parent, xmlNode *xnode )
{
	String *string = STRING( model );
	char value[MAX_STRSIZE];

#ifdef DEBUG
	printf( "string_load: " );
	row_name_print( HEAPMODEL( string )->row );
	printf( "\n" );
#endif /*DEBUG*/

	assert( IS_RHS( parent ) );

	if( get_sprop( xnode, "value", value, MAX_STRSIZE ) ) {
		SETSTR( string->value, value );
		classmodel_set_edited( CLASSMODEL( model ), TRUE );
	}

	return( MODEL_CLASS( parent_class )->load( model, 
		state, parent, xnode ) );
}

/* Update String from heap.
 */
static gboolean
string_class_get( Classmodel *classmodel, PElement *root )
{
        String *string = STRING( classmodel );
	char caption[MAX_STRSIZE];
	char value[MAX_STRSIZE];

#ifdef DEBUG
	printf( "string_class_get: " );
	row_name_print( HEAPMODEL( string )->row );
	printf( "\n" );
#endif /*DEBUG*/

	if( !class_get_member_string( root, MEMBER_CAPTION, 
		caption, MAX_STRSIZE ) ||
		!class_get_member_string( root, MEMBER_VALUE, 
			value, MAX_STRSIZE ) )
		return( FALSE );
	iobject_set( IOBJECT( classmodel ), NULL, caption );
	SETSTR( string->value, value );

	return( TRUE );
}

/* Make a new "fn value" application.
 */
static gboolean
string_class_new( Classmodel *classmodel, PElement *fn, PElement *out )
{
	Heap *heap = reduce_context->heap;
	String *string = STRING( classmodel );
	PElement rhs;

#ifdef DEBUG
	printf( "string_class_new: " );
	row_name_print( HEAPMODEL( string )->row );
	printf( "\n" );
#endif /*DEBUG*/

	/* Make application nodes.
	 */
	heap_appl_init( out, fn );
	if( !heap_appl_add( heap, out, &rhs ) ||
		!heap_string_new( heap, 
			IOBJECT( classmodel )->caption, &rhs ) ||
		!heap_appl_add( heap, out, &rhs ) ||
		!heap_string_new( heap, string->value, &rhs ) )
		return( FALSE );

	return( TRUE );
}

static void
string_class_init( StringClass *class )
{
	GObjectClass *gobject_class = (GObjectClass *) class;
	ModelClass *model_class = (ModelClass *) class;
	ClassmodelClass *classmodel_class = (ClassmodelClass *) class;

	parent_class = g_type_class_peek_parent( class );

	gobject_class->finalize = string_finalize;

	/* Create signals.
	 */

	/* Init methods.
	 */
	model_class->view_new = stringview_new;
	model_class->save = string_save;
	model_class->load = string_load;

	classmodel_class->class_get = string_class_get;
	classmodel_class->class_new = string_class_new;

	/* Static init.
	 */
	model_register_loadable( MODEL_CLASS( class ) );
}

static void
string_init( String *string )
{
	string->value = NULL;
	SETSTR( string->value, "" );

	iobject_set( IOBJECT( string ), CLASS_STRING, NULL );
}

GType
string_get_type( void )
{
	static GType type = 0;

	if( !type ) {
		static const GTypeInfo info = {
			sizeof( StringClass ),
			NULL,           /* base_init */
			NULL,           /* base_finalize */
			(GClassInitFunc) string_class_init,
			NULL,           /* class_finalize */
			NULL,           /* class_data */
			sizeof( String ),
			32,             /* n_pstringlocs */
			(GInstanceInitFunc) string_init,
		};

		type = g_type_register_static( TYPE_CLASSMODEL, 
			"String", &info, 0 );
	}

	return( type );
}

Classmodel *
string_new( Rhs *rhs )
{
	String *string;

	string = STRING( g_object_new( TYPE_STRING, NULL ) );
	icontainer_child_add( ICONTAINER( rhs ), ICONTAINER( string ), -1 );

	return( CLASSMODEL( string ) );
}
