#!/usr/bin/perl
#
# $Id: TCPPacket.pm,v 1.4 2001/10/06 22:19:14 levine Exp $
#
# Copyright (C) 2001  James D. Levine (jdl@vinecorp.com)
#
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation; either version 2
#   of the License, or (at your option) any later version.
# 
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
#   02111-1307, USA.
#
####################################################################

use NWatch::Packet;
use strict;



####################################################################
#
# tcp_packet
#
# Decodes TCP fields
#
####################################################################




package NWatch::tcp_packet;

@NWatch::tcp_packet::ISA = qw( NWatch::packet );

sub protocol_name { "tcp"; }

sub new
{
    my( $type, $data ) = @_;

    # init from base class
    my $self = NWatch::packet::new( $type, $data );


    # unpack fields

    my( $src_port, $dest_port, $seq_number, $ack_number, $offset_control,
	$window, $checksum, $urg_ptr );

    if( length( $data ) > 8 )
    {
	( $src_port, $dest_port, $seq_number, $ack_number, $offset_control,
	    $window, $checksum, $urg_ptr )
	    = unpack "nnNNnnnn", $data;
    }
    elsif( length( $data ) == 8 ) # ICMP payload 
    {
	( $src_port, $dest_port, $seq_number )
	    = unpack "nnN", $data;
    }

    my $data_offset  = $offset_control >> 12;
    my $reserved = ( $offset_control >> 6 ) & 63;
    my $control_bits = $offset_control & 63;
    my $urg = ( $control_bits & 32 ) > 0;
    my $ack = ( $control_bits & 16 ) > 0;
    my $psh = ( $control_bits & 8 ) > 0;
    my $rst = ( $control_bits & 4 ) > 0;
    my $syn = ( $control_bits & 2 ) > 0;
    my $fin = ( $control_bits & 1 ) > 0;


    $self->set( "source_port",       $src_port );
    $self->set( "destination_port",  $dest_port );
    $self->set( "seq_number",        $seq_number );
    $self->set( "ack_number",        $ack_number );

    $self->set( "data_offset",       $data_offset );
    $self->set( "reserved",          $reserved );
    $self->set( "control_bits",      $control_bits );
    $self->set( "urg",       $urg );
    $self->set( "ack",       $ack );
    $self->set( "psh",       $psh );
    $self->set( "rst",       $rst );
    $self->set( "syn",       $syn );
    $self->set( "fin",       $fin );

    $self->set( "window",            $window );
    $self->set( "checksum",          $checksum );
    $self->set( "urg_ptr",           $urg_ptr );

    my $begin = $data_offset * 4;
    my $payload = substr( $data, $begin, length( $data ) - $begin );

    # for any known protocols, stack a packet instance on top
    # check proto ID
    # if known, set next to a new instance of proto with payload

#    print "tcp::source port $src_port    dest port $dest_port \n";

#    print "( flags " .
#	( $urg ? "urg " : "" ) .
#	( $ack ? "ack " : "" ) .
#	( $psh ? "psh " : "" ) .
#	( $rst ? "rst " : "" ) .
#	( $syn ? "syn " : "" ) .
#	( $fin ? "fin " : "" ) .
#	    " ) \n";
	    
    $self;
}

1;














