#!/bin/bash
set -e
export SHAREDIR=/usr/share/odontolinux
export TMPDIR=/tmp
export PATH=$PATH:/usr/lib/postgresql/bin

if psql -ltq |grep 'odontolinux'
then
	echo "                                                 "
	echo "Odontolinux! database exists."
	echo "                                                 "
else
	echo "                                                 "
	echo "Odontolinux! database does not exist. You can choose"
	echo "to create it now, or you can do it lately"
	echo "launching /usr/share/odontolinux/makedb.sh ."
	echo "This script has to be launched by the potgres user."
	echo "Do you want to create the database now (y/N) ?"

               read ANS
                if [ -z "$ANS" -o "$ANS" = "Y" -o "$ANS" = "y" ];
                then
			echo "                                                 "
			createdb odontolinux
                        if (psql -qt -d odontolinux -c "SELECT * FROM pg_shadow where usename = 'www-data';"|grep www-data)
                        then
                                echo "www-data user exists."
                        else
                                psql -qt -d odontolinux -c "create user \"www-data\" createuser;"
                        fi
			if (psql -qt -d odontolinux -c "SELECT * FROM pg_shadow where usename = 'odontolinux';"|grep odontolinux)
			then
				echo "odontolinux user exists."
			else
				psql -qt -d odontolinux -c "create user odontolinux createuser;"
			fi
			echo "                                                 "
			echo "Populating database with tables, sequences, and examples..."
			echo "                                                 "
			psql -t -d odontolinux <$SHAREDIR/odontolinux.dump 2>&1 |tee $TMPDIR/makedb.out | grep ERR
	
			if grep -sq ERR $TMPDIR/makedb.out
			then
				echo -n "An error has occurred. Please check $TMPDIR/makedb.out for more details"
			else 
				rm -f $TMPDIR/makedb.out
			fi
                fi

fi

