///////////////////////////////////////////////////////////////////////////////
// $Id: AboutCommand.hxx,v 1.1 1995/01/08 06:39:14 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// AboutCommand.hxx - Command to tell the user about Oonsoo
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 12,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: AboutCommand.hxx,v $
// Revision 1.1  1995/01/08  06:39:14  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef ABOUTCOMMAND_HXX
#define ABOUTCOMMAND_HXX

#include "Command.hxx"
#include "CommandFlags.hxx"
#include "About.hxx"

class SpriteCollection;

class AboutCommand : public Command {
  private:
    SpriteCollection* mySpriteCollection;

  public:
    // Protected constructor to prevent instantiation
    AboutCommand(SpriteCollection* spriteCollection)
        : mySpriteCollection(spriteCollection)
    {};

    // Destructor
    virtual ~AboutCommand() {};

    // All I do is tell the application to terminate
    virtual void execute(void* argument)
    {
      if(!aboutCurrentlyDisplayedFlag)
      {
        new About(mySpriteCollection);
        aboutCurrentlyDisplayedFlag = 1;
      }
    }
};

#endif

