///////////////////////////////////////////////////////////////////////////////
// $Id: MainDeck.hxx,v 1.1 1995/01/08 06:44:49 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// MainDeck.hxx - Main oonsoo deck of cards (Dealer's deck)
//
//
// Bradford W. Mott
// Copyright (C) 1994
// November 13,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: MainDeck.hxx,v $
// Revision 1.1  1995/01/08  06:44:49  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef MAINDECK_HXX
#define MAINDECK_HXX

#include "Deck.hxx"

class Command;


class MainDeck : public Deck {
  private:
    Command* myCommand;

  protected:
    // Update graphical view of myself
    virtual void updateView();

    // Called whenever an event arrives for me (I need to override the default)
    virtual void handleEvent(XEvent* event);

  public:
    // Construct a complete deck of oonsoo cards
    MainDeck(ContainerWidget* parent, const char *const widgetName,
        int x, int y, int width, int maxHeight, 
        SpriteCollection* sprites, Command* command);

    // Destructor
    virtual ~MainDeck();
};

#endif

