# RPM spec file for Open Office QuickStarter applet
#
# (C) 2002  Kumaran Santhanam  <kumaran@alumni.stanford.org>
# This project is released under the GNU General Public License v2.

%define version    0.8.3
%define release    1

Summary: Open Office QuickStarter applet
Name: ooqstart-gnome
Version: %{version}
Release: %{release}
Copyright: GPL
Group: User Interface/Desktops
Source: ooqstart-%{version}.tgz
URL: http://ooqstart.sourceforge.net/
BuildRoot: /var/tmp/ooqstart-%{version}-%{release}-root
Packager: Kumaran Santhanam <kumaran@alumni.stanford.org>
Requires: gnome-core
Provides: ooqstart

%description
This applet provides a quick launcher for Open Office 641C+
or Star Office 6.0+.  It attempts to mimic the functionality
provided by the quickstarter tray icon on the other operating
system supported by Open Office.

The program attempts to keep a background process alive at
all times, even if that process is terminated by the user.
The four main applications:  Writer, Calc, Draw, and Impress
can be launched directly from the context menu of the applet.

%changelog

* Sun Feb 24 2002 Kumaran Santhanam
  - original version

%prep
echo $RPM_BUILD_DIR
%setup -q -n ooqstart-%{version}
%build
make

%install
make ROOT=$RPM_BUILD_ROOT install-gnome

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(644, root, root)
%attr(755,root,root) /usr/bin/*
/etc/CORBA/servers/*
/usr/share/applets/Utility/*
/usr/share/pixmaps/*
/usr/share/gnome/help/ooqstart_applet/C/*
