/*
 * mb-ps.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/mb/mb-ps.cc,v 1.8 2002/02/03 03:16:30 lim Exp $
 */

#include "mb.h"
#include "mb-ps.h"

#include "tkCanvPS.h"

static class MBPSProcessorClass : public TclClass {
public:
	MBPSProcessorClass() : TclClass("MBPSProcessor") {
        initialized_ = false;
    }

	TclObject* create(int argc, const char*const* argv) {
        if (!initialized_) {
            Tk_CreateItemType(&tkPScriptType);
            initialized_ = true;
        }

		Trace(VERYVERBOSE,("Creating new MBPSProcessor()"));
		if (argc != 5) {
			SignalError(("Wrong Number of arguments\n"));
			return NULL;
		}
		return (new MBPSProcessor(argv[4]));
	}

private:
    bool    initialized_;
} class_mbpsp;

/*virtual*/ void MBPSProcessor::draw()
{
	fprintf(stderr,"draw() called, pixmap_ = %ld\n",pixmap_);
}

Pixmap MBPSProcessor::CreatePixmap(int width, int height)
{
	Trace(ALL,("creating pixmap w=%d h=%d win=%d", width, height,
		   Tk_WindowId(tk_)));
	Pixmap pixmap =
		Tk_GetPixmap(Tk_Display(tk_), Tk_WindowId(tk_), width,
			     height, Tk_Depth(tk_));

	Trace(ALL,("got pixmap: %d",pixmap));
	return pixmap;
}

#ifdef OLD
// called after the postscript gets drawn
void MBPSProcessor::draw(Drawable drawable, int imageX, int imageY,
                         int width, int height,
                         int drawableX, int drawableY)
{
	fprintf(stderr, "in draw, copying from %ld to %ld", pixmap_, drawable);
	fprintf(stderr,
		"ix=%d,iy=%d,w=%d,h=%d,dx=%d,dy=%d\n",imageX,imageY,width,height,
		drawableX,drawableY);
	if (width>width_) width = width_;
	if (width<height_) height=height_;
	XCopyArea(Tk_Display(tk_), pixmap_, drawable,
		  gc_, imageX, imageY, width_, height_, drawableX, drawableY);
}
#endif

/*virtual*/
int MBPSProcessor::command(int argc, const char*const* argv)
{
	MB_DefTcl(tcl);
	if (!strcmp(argv[1], "create_pixmap")) {
		int w = atoi(argv[2]);
		int h = atoi(argv[3]);
		Pixmap p = CreatePixmap(w, h);
		tcl.resultf("%d",p);
		Trace(ALL,("create_pixmap returning %s",MB_Interp->result));
	} else if (!strcmp(argv[1],"set_pixmap")) {
		sscanf(argv[2],"%ld",&pixmap_);
		return TCL_OK;
	} else {
		return (PostscriptWindow::command(argc, argv));
	}
	return TCL_OK;
}
