/*
 * mb-rcvr.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/mb/mb-rcvr.h,v 1.18 2002/02/03 03:16:30 lim Exp $
 */

#ifndef MASH_MB_RCVR_H__
#define MASH_MB_RCVR_H__

#include "mb/mb-cmd.h"

/*
 * The receiver objects handle the translation of network packets
 * into actions performed on local pictures.  There is one recevier
 * object for each remote site.  These objects also handle repair
 * requests and replies, and maintain the drawing history.
 *
 */

class MBReceiver : public MBBaseRcvr {
public:
	MBReceiver(MBManager* pMgr, const SrcId& sid);
	virtual ~MBReceiver() {}

	virtual int executeCmd(MBCmd *pCmd, MBPageObject *pPage,
			       const MBTime& oldTime, const MBTime&
			       newTime);

	virtual void ChangeStatus(const PageId& pgid, Bool isVisible) {
		Page* pPage=(Page*)DefinePage(pgid);
		if (pPage) pPage->ChangeStatus(getSrcId(),isVisible);
	}

	// returns an canvId that is the most recent among those between
	// mostRecen	t and timestamp and update mostRecent;
	// if cannot find a 	more recent one, return zero
	virtual CanvItemId FindMostRecent(PageId pid, n_long& mostRecent,
					  n_long timestamp);
	int warpTime(const PageId& pgId, const MBTime& toTime);
	int timeRange(const PageId &pgId, MBTime& start, MBTime& end);

protected:
	void Swap(MBReceiver *old) {
		Tcl_HashTable *ht = phtPages_;
		*this = *old;
		old->phtPages_ = ht;
	}

};


class MBLocalReceiver: public MBReceiver {
public:
	// note that pageid's start at 1
	// pageid zero is invalid
	MBLocalReceiver(MBManager* pMgr, const SrcId &sid)
		: MBReceiver(pMgr, sid),  pCurrPage_(NULL), next_pg_uid_(1) {}
	virtual ~MBLocalReceiver() {}

	virtual void ChangeStatus(const PageId& pgid, Bool isVisible) {
		MBReceiver::ChangeStatus(pgid, isVisible);
		if (isVisible) {
			int nextAmt = DefinePage(pgid)->RequestSendAmount();
			if (nextAmt) {
				getMgr()->RequestSend(nextAmt +
						      sizeof(Pkt_DataHdr));
				MTrace(trcMB|trcVerbose,
				       ("flushing commands (>%d B)",nextAmt));
			}
		}
	}

	// no need to record the operation in this case
	virtual Bool executeInteractive(MBCmd* pCmd, Page* pPage);

	// excute the command, as a side effect,
	// multicast it
	virtual Bool Dispatch(MBCmd* pCmd, Page* pPage);

	// virtual from MBReceiver
	virtual MBPageObject *DefinePage(const PageId &pageId,
					 Bool *newFlag=FALSE);
	virtual MBPageObject *NewPageObject();

	void SetCurrPage(Page* pPage) { pCurrPage_ = pPage; }
	const PageId& getCurrPgId() {
		if (pCurrPage_)
			return pCurrPage_->getId();
		else return cNullPageId;
	}

	// fills the next ADU into pktbuf
	virtual int NextADU(Byte *pb, u_int len, int& nextSize) {
		return MBBaseRcvr::NextADU(pb, len, nextSize, pCurrPage_);
	}

	// handles a session announce msg, from a remote receiver
	// This means that a remote receiver has detected that this local
	// receiver is outdated.
	virtual void HandleSA(Pkt_PgStatus* aStats, int numStats);
	virtual int FillSA(Byte *pb, int len);

private:
	Page* pCurrPage_;           // current page this receiver is on
	ulong next_pg_uid_;
};

#endif // ifndef MASH_MB_RCVR_H__
