/*
 * rpi.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MASH_RPI_H
#define MASH_RPI_H

#include "mplug-compat.h"
#include <npapi.h>
#include <stdio.h>

#if defined(XP_UNIX)
#define DEFAULT_SELECT_TIMEOUT 8
#elif defined(XP_WIN)
#define DEFAULT_SELECT_TIMEOUT 15
#endif

class RPI {
public:
	class ArgArray {
	public:
		ArgArray();
		~ArgArray();

		void  Append(const char *list) { Insert(list, argc_); }
		void  Insert(const char *list, int pos);
		void  CreateCmdline(char *&cmdline);
		void  Output(FILE *output);
		int   argc() const { return argc_; }
		char * const * argv() const { return argv_; }

	private:
		void GrowToAtLeast(int newArgc);

		int argc_;
		char **argv_;
		int maxArgc_;
	};



	RPI() : sock_(-1) { }
	~RPI();

	NPBool NewProcess(ArgArray *args, const char *stdoutFilename,
			  const char *stderrFilename);
	void   DestroyProcess();

	NPBool Notify(const char *string);
	NPBool Notify(int numElems, ...);
	NPBool NotifyInPieces(int numPieces) {
		uint32 tmp=numPieces;
		return Send_(&tmp, sizeof(uint32));
	}

	NPBool NotifyNextPiece(int len, const void *buffer);

private:

	NPBool Fork(ArgArray *args, const char *stdoutFilename,
		    const char *stderrFilename);
	NPBool CreateServer();
	int    ServerPort();
	NPBool AcceptConnection();
	NPBool Send_(const void *bytes, uint32 len);

	int sock_;
};


#endif /* MASH_RPI_H */
