/*
 * rep-decoder.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef rep_decoder_h
#define rep_decoder_h


#ifndef WIN32
#include <sys/param.h>
#include <sys/uio.h>
#endif
#include "sys-time.h"
#include "inet.h"
#include "tclcl.h"
#include "source.h"
#include "ntp-time.h"
#include "vidreps.h"

class RepDecoder : public PacketHandler {
protected:
  RepDecoder(int hdrlen);

public:
  virtual ~RepDecoder();

  static double gettimeofday();

  virtual int command(int argc, const char*const* argv);

  virtual void recv(pktbuf *pb);
  virtual void post_delay_recv(pktbuf *pb) = 0;
  virtual void set_frame_buffer(VidRep *fb) = 0;
  virtual void resize(int inw, int inh) {
    inw_ = inw;
    inh_ = inh;
  };

protected:
  int inw_;
  int inh_;

  char *callback_;

  int delay_flag_;

  class PktBufDelayQueue {
  public:
    PktBufDelayQueue() : head_(0), tail_(0) {};
    inline void insert (pktbuf *pb) {
      if (tail_ == 0) {
	head_ = tail_ = pb;
	tail_->next = 0;
      } else {
	tail_->next = pb;
	tail_ = tail_->next;
	tail_->next = 0;
      }
    };
    inline pktbuf *get_next () {
      pktbuf *ret;
      if (head_ == 0)
	return 0;
      ret = head_;
      head_ = head_->next;
      if (head_ == 0) {
	tail_ = 0;
      }
      ret->next = 0;
      return ret;
    }
  protected:
    pktbuf *head_;
    pktbuf *tail_;
  } delay_q_;
};

#endif
