/*
 * source-srmv2.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <tcl.h>

#include "tclcl.h"
#include "srmv2.h"
#include "source-srmv2.h"
#include "session-srmv2.h"
#include "ns-srmv2.h"

static class SRMv2_SourceClass : public TclClass {
public:
	SRMv2_SourceClass() : TclClass("SRMv2_Source") { }
	TclObject* create(int , const char*const* argv) {
		return new SRMv2_Source(argv[4]);
	}
} srmv2_source_class;

SRMv2_Source::SRMv2_Source(const char *src_name)
{
	sid_ = new int [4];
	ipaddr_ = 0;
	md5_digest(src_name, (unsigned char *) sid_);
	printf("%s :- 0x%x\n", src_name, sid_[0]);
	namemap_ = new NameMap;
}

SRMv2_Source::SRMv2_Source(const int *sourceID)
{
	sid_ = new int [4];
	for (int i = 0; i < 4; i++)
		sid_[i] = sourceID[i];
	namemap_ = new NameMap;
}

SRMv2_Source::~SRMv2_Source()
{
	delete sid_;
}

int
SRMv2_Source::command(int argc, const char*const* argv)
{
	Tcl& tcl = Tcl::instance();
	char* cp = tcl.buffer();

	if (argc == 2) {
		if (strcmp(argv[1], "source-id") == 0) {
			sprintf(cp, "%s", (char *)sid_);
			tcl.result(cp);
			return (TCL_OK);
		}
	}
	if (argc == 3) {
		if (strcmp(argv[1], "session") == 0) {
			session_ = (SRMv2_Session*)TclObject::lookup(argv[2]);
			return (TCL_OK);
		}
		if (strcmp(argv[1], "host") == 0) {
			ipaddr(LookupHostAddr(argv[2]));
			return (TCL_OK);
		}
	}
	if (argc == 4) {
		if (strcmp(argv[1], "calloc") == 0) {
			int created = 0;
		        unsigned int cid = namemap_->calloc(atoi(argv[2]), argv[3], &created);
			/* Need to advertise the newly created container */
			char* data = namemap_->getname(cid);
			if (created)
				session_->send_adu(this, data, cid, 0, strlen(data),
						   strlen(data), 1, SRMv2_DATA);
			sprintf(cp, "%d", cid);
			tcl.result(cp);
			return (TCL_OK);
		}
	}
	return (TclObject::command(argc, argv));
}

