# main.tcl --
#
#       This is the main entry point for the recorder tool.
#       Tcl source code expansion with tcl-expand.tcl starts here.
#       Tcl execution also starts here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#set V(class) Recorder
#set V(app) recorder

#source tcl/common/mtrace.tcl
#source tcl/srm/cf-srm.tcl
#source tcl/common/application.tcl
#source tcl/common/application-rtp.tcl
#source tcl/common/util.tcl
#source tcl/common/observe.tcl
#source tcl/common/dbg-err.tcl
#source tcl/common/sdp.tcl

#source tcl/net/rtp.tcl
#source tcl/net/agent-rtp.tcl
#source tcl/net/agent-audio.tcl
#source tcl/net/agent-video.tcl
#source tcl/net/network.tcl

#source tcl/ui_tools/ui-primitive.tcl
#source tcl/ui_tools/ui-dropdown.tcl
#source tcl/ui_tools/ui-scroll.tcl
#source tcl/ui_tools/ui-list.tcl
#source tcl/ui_tools/ui-morewidgets.tcl
#source tcl/ui_tools/ui-dialog.tcl
#source tcl/ui_tools/ui-filedlg.tcl
#source tcl/ui_tools/ui-msgbox.tcl
#source tcl/ui_tools/ui-iconlib.tcl
#source tcl/archive/ui-vcricons.tcl

#source tcl/archive/recorder/archive-record.tcl
#source tcl/archive/recorder/mb-record.tcl
#source tcl/archive/recorder/ui-recorder.tcl
#source tcl/archive/recorder/app-recorder.tcl
#source tcl/archive/recorder/rtp-record.tcl
#source tcl/archive/recorder/rtp-record-agent.tcl
#source tcl/archive/catalog.tcl

Import enable
import WidgetClass
WidgetClass transparent_gif

import MTrace Application/Recorder

#[MTrace init {trcArchive}] toggle_window
set app [new Application/Recorder $argv]
if { ! [$app run] } {
	delete $app
	exit
}

