# fca-uimgr.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


Class FCA_UIMgr


# the ui-manager should contain a mapping of floor-types to
# floor names: floor_types_
# also, a mapping of srcId's to cnames: cnames_
#
# objects:
#    admittedList_
#    pendingList_
#    srcList_
#
# instvars:
#    fullRequestInfo_



FCA_UIMgr instproc init { path appMgr } {
    $self next
    $self instvar ui_ cb_ appMgr_ admittedList_ pendingList_ admittedMenu_ \
	    pendingMenu_
    if { [$appMgr localIsModerator] } {
	set ui_ [new FCA_UI/Moderator]
    } else {
	set ui_ [new FCA_UI]
    }

    set cb_ [new FCA_CoordBus $self]
    set appMgr_ $appMgr
    $ui_ attach_appmgr $appMgr
    $ui_ attach_uimgr  $self
    $ui_ build $path

    set admittedList_ [$ui_ admittedList]
    set pendingList_ [$ui_ pendingList]
    $self set srcList_ [$ui_ srcList]
}


# floor is object of class FCAFloor
FCA_UIMgr instproc add_floor { floorType label {icon {}} } {
    $self instvar ui_
    $ui_ add_floor $floorType $label $icon
}



FCA_UIMgr instproc add_admit { request } {
    $self instvar admittedList_
    $admittedList_ insert $request {} end
}


FCA_UIMgr instproc remove_admit { request } {
    $self instvar admittedList_
    $admittedList_ remove $request
}


FCA_UIMgr instproc add_pending { request } {
    $self instvar pendingList_
    $pendingList_ insert $request {} end
}


FCA_UIMgr instproc remove_pending { request } {
    $self instvar pendingList_
    $pendingList_ remove $request
}



FCA_UIMgr instproc new_source { src } {
    $self instvar srcList_ sources_
    $srcList_ insert [$src srcid] [$src cname] end
    set sources_([$src srcid]) $src
    DbgOut "########### Setting [$src srcid]: sources_([$src srcid])=$sources_([$src srcid])"
}


FCA_UIMgr instproc cname_update { src newname } {
    $self instvar srcList_
    $srcList_ update [$src srcid] $newname
}


FCA_UIMgr instproc cname { srcId } {
    $self instvar sources_
    if { [info exists sources_($srcId)] } {
	return [$sources_($srcId) cname]
    } else {
	return ""
    }
}


FCA_UIMgr instproc grant_received { floorType floorInstanceObj } {
    $self instvar ui_ cb_ appMgr_
    $ui_ destroy_floorstatus_entry $floorType $floorInstanceObj
    $ui_ create_floorstatus_entry $floorType $floorInstanceObj

    set srcId [$floorInstanceObj srcId]
    if { [[$appMgr_ localRcvr] srcId]==$srcId } {
	set isMe 1
    } else {
	set isMe 0
    }

    DbgOut "Send floor status for '$floorType' '$srcId'"
    $cb_ send_floor_status [$ui_ get_floor_label $floorType] 0 \
	    [$self cname $srcId] $isMe
}


FCA_UIMgr instproc release_received { floorType floorInstance } {
    $self instvar ui_
    $ui_ destroy_floorstatus_entry $floorType $floorInstance
}



FCA_UIMgr instproc make_floor_request { floors comment } {
    DbgOut "Making floor request for *$floors* ($comment)"
    $self instvar appMgr_
    set localRcvr [$appMgr_ localRcvr]
    $localRcvr sendFloorRequest $floors $comment
}


FCA_UIMgr instproc cancel_floor_request { request } {
    $self instvar appMgr_
    set localRcvr [$appMgr_ localRcvr]
    $localRcvr sendFloorCancel $request
}


FCA_UIMgr instproc grant_floor { request } {
    $self instvar appMgr_
    set localRcvr [$appMgr_ localRcvr]
    $localRcvr uiGrant $request
}


# invoked when the moderator
FCA_UIMgr instproc grant_floor_to_participant { floortypes srcId } {
    $self instvar appMgr_
    set localRcvr [$appMgr_ localRcvr]
    $localRcvr uiGrantParticipant $floortypes $srcId
}


FCA_UIMgr instproc release_floor { floorType floorInstance } {
    $self instvar appMgr_
    set localRcvr [$appMgr_ localRcvr]
    $localRcvr sendFloorRelease $floorType $floorInstance
}


FCA_UIMgr instproc auto_request_floor { floorTypeLabel } {
    $self instvar ui_ appMgr_
    set floorType [$ui_ floortype_from_label $floorTypeLabel]
    if { $floorType=="" } {
	DbgOut "Could not figure out floor type for '$floorTypeLabel'"
	return
    }

    [$appMgr_ localRcvr] auto_request_floor $floorType
}










#FCA_UIMgr instproc build_admittedMenu { } {
#    $self instvar admittedMenu_
#    set admittedMenu_ [menu .admittedMenu_$self]
#    $admittedMenu_ add command -label "Grant floor"
#    $admittedMenu_ add command -label "Cancel request"
#}




#FCA_UIMgr instproc build_floorholder_frame { parent_path floorInstObj } {
#    set path $parent_path.instance_$floorInstance
#    label $path -bg [$parent_path cget -bg] -text \
#	    [$self cname [$floorInstance srcId]]
#    pack  $path -side top
#}





#FCA_UIMgr instproc build_request_item { path request } {
#    frame $path -bd 1
#    $path configure -bg [[winfo parent $path] cget -bg]
#
#    foreach floorType [$request floorTypes] {
#	$self build_floortype_label $path.floortype_$floorType $floorType
#	pack $path.floortype_$floorType -padx 0 -pady 0 -side left
#    }
#
#    label $path.cname -text [$self cname [$request srcId]] -anchor w
#    $path.cname configure -bg [[winfo parent $path.cname] cget -bg]
#    pack $path.cname -side left -anchor w -fill x -expand 1
#    #set comment [$request comment]
#}


#FCA_UIMgr instproc build_floortype_label { path floorType } {
#    $self instvar floorTypes_
#    label $path -image $floorTypes_($floorType,icon) -padx 0 -pady 0 -bd 0 \
#	    -highlightthickness 0 -relief flat
#    $path configure -bg [[winfo parent $path] cget -bg]
#}


#set uimgr [new FCA_UIMgr .f]
#pack .f -fill both -expand 1
#$uimgr add_floor 1 Audio Audio_Icon
#$uimgr add_floor 2 Video Video_Icon
#$uimgr add_floor 3 Mediaboard Mediaboard_Icon
