#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>

// try to keep it always 400 bytes
struct QMHeader
{
  int numPackets;
  int postProcessed;
  int firstTs;
  int lastTs;
  char reserved[384];
};

struct oldQMPacketInfo
{
  u_int16_t flags; // don't think I'll need this, but just in case, and
                   // keeps things word aligned
  u_int16_t seqno;
  u_int32_t ts;  // timestamp
  int index;
  struct timeval sysTime;
};

struct newQMPacketInfo
{
  u_int16_t flags; // don't think I'll need this, but just in case, and
                   // keeps things word aligned
  u_int16_t seqno;
  u_int32_t ts;  // timestamp
  u_int32_t ssrc;  // synchronization source
  int index;
  struct timeval sysTime;
};

int main(int argc, char** argv)
{
  int x;
  FILE* infile;
  FILE* outfile;

  struct QMHeader hdr;
  struct oldQMPacketInfo oldInfo;
  struct newQMPacketInfo newInfo;

  if(argc != 3)
  {
    fprintf(stderr, "Usage: add_ssrc <input filename> <output filename>\n");
    exit(1);
  }

  // FIXME - should check to make sure input and output aren't the same

  infile = fopen(argv[1], "r");

  if(infile == NULL)
  {
    fprintf(stderr, "Unable to open file %s\n", argv[1]);
    exit(1);
  }

  outfile = fopen(argv[2], "w");
  if(outfile == NULL)
  {
    fprintf(stderr, "Unable to open file %s for writing\n", argv[2]);
    fclose(infile);
    exit(1);
  }

  // header
  fread(&hdr, sizeof(struct QMHeader), 1, infile);
  fwrite(&hdr, sizeof(struct QMHeader), 1, outfile);
  printf("numPackets = %d\n", hdr.numPackets);

  // packet infos
  for(x = 0; x < hdr.numPackets; ++x)
  {
    fread(&oldInfo, sizeof(struct oldQMPacketInfo), 1, infile);
    newInfo.flags = oldInfo.flags;
    newInfo.seqno = oldInfo.seqno;
    newInfo.ts = oldInfo.ts;
    // there is no ssrc field in the old ones, so put a flag there
    newInfo.ssrc = 0xDEADDEAD;
    newInfo.index = oldInfo.index;
    newInfo.sysTime = oldInfo.sysTime;
    fwrite(&newInfo, sizeof(struct newQMPacketInfo), 1, outfile);
  }

  fclose(infile);
  fclose(outfile);

  return(0);
}

