# evalarea.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2001-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

source tcl/vd/qm/utils/getkeys.tcl

proc showUsage {} {
    puts stdout "usage: evalarea <mark area file> <sim area file> \[<W1> <W2> <W3> <W4>\]"
    exit
}

proc evalarea {w1 w2 w3 w4} {
    global g_keys

    set mSpkr $g_keys(mark,pctSpeakerArea)
    set mLeft $g_keys(mark,pctLeftArea)
    set mCenter $g_keys(mark,pctCenterArea)
    set mRight $g_keys(mark,pctRightArea)

    set sSpkr $g_keys(sim,pctSpeakerArea)
    set sLeft $g_keys(sim,pctLeftArea)
    set sCenter $g_keys(sim,pctCenterArea)
    set sRight $g_keys(sim,pctRightArea)

    set m $mSpkr
    set s $sSpkr
    set nom [expr abs(double($s) - double($m))]
    set denom [expr (double($s) + double($m))]
    if {$denom == 0} {set denom 1}
    set temp [expr double($nom) / double($denom)]
    set spkr $temp

    set m $mLeft
    set s $sLeft
    set nom [expr abs(double($s) - double($m))]
    set denom [expr (double($s) + double($m))]
    if {$denom == 0} {set denom 1}
    set temp [expr double($nom) / double($denom)]
    set left $temp

    set m $mCenter
    set s $sCenter
    set nom [expr abs(double($s) - double($m))]
    set denom [expr (double($s) + double($m))]
    if {$denom == 0} {set denom 1}
    set temp [expr double($nom) / double($denom)]
    set center $temp

    set m $mRight
    set s $sRight
    set nom [expr abs(double($s) - double($m))]
    set denom [expr (double($s) + double($m))]
    if {$denom == 0} {set denom 1}
    set temp [expr double($nom) / double($denom)]
    set right $temp

    set c1 [expr double($spkr) * double($w1)]
    set c2 [expr double($left) * double($w2)]
    set c3 [expr double($center) * double($w3)]
    set c4 [expr double($right) * double($w4)]
    set val [expr $c1 + $c2 + $c3 + double($c4)]

    # we need to normalize it
    set max [expr double($w1) + $w2 + $w3 + $w4]
    set val [expr double($val) / double($max)]

    puts -nonewline stdout "$val"
}

# main program

# defaults
set w1 1
set w2 1
set w3 1
set w4 1
if {[llength $argv] != 2 && [llength $argv] != 6} {
    showUsage
}
set markFilename [lindex $argv 0]
set simFilename [lindex $argv 1]
if {[llength $argv] == 6} {
    set w1 [lindex $argv 2]
    set w2 [lindex $argv 3]
    set w3 [lindex $argv 4]
    set w4 [lindex $argv 5]
}

getkeys $markFilename "mark"
getkeys $simFilename "sim"

#foreach index [array names g_keys] {
#    puts stdout "index = $index, val = $g_keys($index)"
#}

evalarea $w1 $w2 $w3 $w4

