/*
 * win-2bit.c --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef lint
static const char *rcsid = "@(#) $Header: /usr/mash/src/repository/mash/mash-1/tgmb/client/win-2bit.c,v 1.5 2002/02/03 04:17:39 lim Exp $";
#endif

#include "win-2bit.h"
#include "callback.h"
#include <UI/ScrDriver.h>

#ifndef NOTWOBIT

#define FRAMEBUF_WORD(frameBuf, x, y) \
        (((WordPtr)(frameBuf)) + (((Word)(x)) >> 3) + (160 >> 3) * (y))

#define FRAMEBUF_SET(ptr, clrw, mask) \
        *(ptr) = (((*(ptr)) & ~(mask)) | ((clrw) & (mask)))

#define ABS(X) (((X) > 0) ? (X) : (-(X)))
#define SGN(X) (((X) > 0) ? (1) : (-1))


static int in_2bit = 0;
static WinHandle twobitwindow = NULL, textWindow_ = NULL;
static unsigned short grlmask[8] = {
	0xffff, 0x3fff, 0x0fff, 0x03ff, 0x00ff, 0x003f, 0x000f, 0x0003
};
static unsigned short grrmask[8] = {
	0xc000, 0xf000, 0xfc00, 0xff00, 0xffc0, 0xfff0, 0xfffc, 0xffff
};
static const unsigned short bw2gr[256] = {
	0x0000, 0x0003, 0x000c, 0x000f, 0x0030, 0x0033, 0x003c, 0x003f,
	0x00c0, 0x00c3, 0x00cc, 0x00cf, 0x00f0, 0x00f3, 0x00fc, 0x00ff,
	0x0300, 0x0303, 0x030c, 0x030f, 0x0330, 0x0333, 0x033c, 0x033f,
	0x03c0, 0x03c3, 0x03cc, 0x03cf, 0x03f0, 0x03f3, 0x03fc, 0x03ff,
	0x0c00, 0x0c03, 0x0c0c, 0x0c0f, 0x0c30, 0x0c33, 0x0c3c, 0x0c3f,
	0x0cc0, 0x0cc3, 0x0ccc, 0x0ccf, 0x0cf0, 0x0cf3, 0x0cfc, 0x0cff,
	0x0f00, 0x0f03, 0x0f0c, 0x0f0f, 0x0f30, 0x0f33, 0x0f3c, 0x0f3f,
	0x0fc0, 0x0fc3, 0x0fcc, 0x0fcf, 0x0ff0, 0x0ff3, 0x0ffc, 0x0fff,
	0x3000, 0x3003, 0x300c, 0x300f, 0x3030, 0x3033, 0x303c, 0x303f,
	0x30c0, 0x30c3, 0x30cc, 0x30cf, 0x30f0, 0x30f3, 0x30fc, 0x30ff,
	0x3300, 0x3303, 0x330c, 0x330f, 0x3330, 0x3333, 0x333c, 0x333f,
	0x33c0, 0x33c3, 0x33cc, 0x33cf, 0x33f0, 0x33f3, 0x33fc, 0x33ff,
	0x3c00, 0x3c03, 0x3c0c, 0x3c0f, 0x3c30, 0x3c33, 0x3c3c, 0x3c3f,
	0x3cc0, 0x3cc3, 0x3ccc, 0x3ccf, 0x3cf0, 0x3cf3, 0x3cfc, 0x3cff,
	0x3f00, 0x3f03, 0x3f0c, 0x3f0f, 0x3f30, 0x3f33, 0x3f3c, 0x3f3f,
	0x3fc0, 0x3fc3, 0x3fcc, 0x3fcf, 0x3ff0, 0x3ff3, 0x3ffc, 0x3fff,
	0xc000, 0xc003, 0xc00c, 0xc00f, 0xc030, 0xc033, 0xc03c, 0xc03f,
	0xc0c0, 0xc0c3, 0xc0cc, 0xc0cf, 0xc0f0, 0xc0f3, 0xc0fc, 0xc0ff,
	0xc300, 0xc303, 0xc30c, 0xc30f, 0xc330, 0xc333, 0xc33c, 0xc33f,
	0xc3c0, 0xc3c3, 0xc3cc, 0xc3cf, 0xc3f0, 0xc3f3, 0xc3fc, 0xc3ff,
	0xcc00, 0xcc03, 0xcc0c, 0xcc0f, 0xcc30, 0xcc33, 0xcc3c, 0xcc3f,
	0xccc0, 0xccc3, 0xcccc, 0xcccf, 0xccf0, 0xccf3, 0xccfc, 0xccff,
	0xcf00, 0xcf03, 0xcf0c, 0xcf0f, 0xcf30, 0xcf33, 0xcf3c, 0xcf3f,
	0xcfc0, 0xcfc3, 0xcfcc, 0xcfcf, 0xcff0, 0xcff3, 0xcffc, 0xcfff,
	0xf000, 0xf003, 0xf00c, 0xf00f, 0xf030, 0xf033, 0xf03c, 0xf03f,
	0xf0c0, 0xf0c3, 0xf0cc, 0xf0cf, 0xf0f0, 0xf0f3, 0xf0fc, 0xf0ff,
	0xf300, 0xf303, 0xf30c, 0xf30f, 0xf330, 0xf333, 0xf33c, 0xf33f,
	0xf3c0, 0xf3c3, 0xf3cc, 0xf3cf, 0xf3f0, 0xf3f3, 0xf3fc, 0xf3ff,
	0xfc00, 0xfc03, 0xfc0c, 0xfc0f, 0xfc30, 0xfc33, 0xfc3c, 0xfc3f,
	0xfcc0, 0xfcc3, 0xfccc, 0xfccf, 0xfcf0, 0xfcf3, 0xfcfc, 0xfcff,
	0xff00, 0xff03, 0xff0c, 0xff0f, 0xff30, 0xff33, 0xff3c, 0xff3f,
	0xffc0, 0xffc3, 0xffcc, 0xffcf, 0xfff0, 0xfff3, 0xfffc, 0xffff
};

#define DISABLE_MEMCHECK MemSemaphoreReserve(true)
#define ENABLE_MEMCHECK  MemSemaphoreRelease(true)




#define FTR_2BIT 25  /* two bits :-) */

#define MAGICVAL 0x2b828184

static volatile DWord magic = MAGICVAL;
static DWord appType_=0;

typedef struct {
	const void *SSA;
	unsigned char VPW;
	unsigned char PICF;
	unsigned char LBAR;
	unsigned char FRCM;
	Word GPMR;
	unsigned char POSR;
} DispParams;

static DispParams savedispparams;

typedef void (*ScrLineRoutineType)(WinPtr, SWord, SWord, SWord, SWord);
static ScrLineRoutineType ScrLineRoutine_1bit = NULL;

typedef void (*ScrRectangleRoutineType)(WinPtr, SWord, SWord, SWord, SWord);
static ScrRectangleRoutineType ScrRectangleRoutine_1bit = NULL;

typedef void (*ScrDrawCharsType)(WinPtr, SWord, SWord, SWord, SWord, SWord,
				 SWord, SWord, SWord, CharPtr, Word, FontPtr);
static ScrDrawCharsType ScrDrawChars_1bit = NULL;

typedef Err (*ScrCopyRectangleType)(WinPtr, WinPtr, SWord, SWord, SWord,
				    SWord, SWord, SWord);
static ScrCopyRectangleType ScrCopyRectangle_1bit = NULL;

/*static const unsigned short grlmask[8] = {
    0xffff, 0x3fff, 0x0fff, 0x03ff, 0x00ff, 0x003f, 0x000f, 0x0003 };
static const unsigned short grrmask[8] = {
    0xc000, 0xf000, 0xfc00, 0xff00, 0xffc0, 0xfff0, 0xfffc, 0xffff };*/

WindowType *Win2_GetOnscreenWindow() {
	return WinGetWindowPointer(twobitwindow);
}


static void
Win2Update(unsigned char *base, SWord x1, SWord y1, SWord x2, SWord yextent)
{
	unsigned char *bwstartline = base + y1*20;
	unsigned short *grstartline =
		((unsigned short *)twobitwindow->displayAddr) + y1*20;
	unsigned short lmask = grlmask[x1 & 7];
	unsigned short rmask = grrmask[x2 & 7];

	if (in_2bit) return;
	DISABLE_MEMCHECK;
	for(;yextent;--yextent) {
		if ((x1 >> 3) == (x2 >> 3)) {
			/* Only one byte */
			unsigned short mask = (lmask & rmask);
			unsigned short grval = grstartline[x1 >> 3] & ~mask;
			grval |= (bw2gr[bwstartline[x1>>3]] & mask);
			grstartline[x1 >> 3] = grval;
		} else {
			SWord i;
			/* The first (partial) byte */
			unsigned short grval = grstartline[x1 >> 3] & ~lmask;
			grval |= (bw2gr[bwstartline[x1>>3]] & lmask);
			grstartline[x1 >> 3] = grval;
			/* Middle bytes */
			for(i=(x1>>3)+1;i<(x2>>3);++i) {
				grstartline[i] = bw2gr[bwstartline[i]];
			}
			/* The last (partial) byte */
			grval = grstartline[x2 >> 3] & ~rmask;
			grval |= (bw2gr[bwstartline[x2>>3]] & rmask);
			grstartline[x2 >> 3] = grval;
		}
		bwstartline += 20;
		grstartline += 20;
	}
	ENABLE_MEMCHECK;
}

static void
ScrLineRoutine_2bit(WinPtr pWindow, SWord x1, SWord y1, SWord x2, SWord y2)
{
	CALLBACK_INTERAPP_PROLOGUE(appType_, FTR_2BIT, magic, MAGICVAL);

	ScrLineRoutine_1bit(pWindow, x1, y1, x2, y2);
	if (x1 > x2) {
		SWord t = x1;
		x1 = x2;
		x2 = t;
	}
	if (y1 > y2) {
		SWord t = y1;
		y1 = y2;
		y2 = t;
	}
	if (! pWindow->windowFlags.offscreen) {
		Win2Update(pWindow->displayAddr,x1,y1,x2,y2-y1+1);
	}

	CALLBACK_INTERAPP_EPILOGUE;
}


static void
ScrRectangleRoutine_2bit(WinPtr pWindow, SWord x, SWord y,
			 SWord extentX, SWord extentY)
{
	CALLBACK_INTERAPP_PROLOGUE(appType_, FTR_2BIT, magic, MAGICVAL);

	ScrRectangleRoutine_1bit(pWindow, x, y, extentX, extentY);
	if (! pWindow->windowFlags.offscreen) {
		Win2Update(pWindow->displayAddr,x,y,x+extentX-1,extentY);
	}

	CALLBACK_INTERAPP_EPILOGUE;
}


static void
ScrDrawChars_2bit(WinPtr pWindow, SWord xLoc, SWord yLoc,
		  SWord xExtent, SWord yExtent, SWord clipTop, SWord clipLeft,
		  SWord clipBottom, SWord clipRight, CharPtr chars, Word len,
		  FontPtr fontPtr)
{
	CALLBACK_INTERAPP_PROLOGUE(appType_, FTR_2BIT, magic, MAGICVAL);

	ScrDrawChars_1bit(pWindow, xLoc, yLoc, xExtent, yExtent, clipTop,
			  clipLeft, clipBottom, clipRight, chars, len,fontPtr);
	if (! pWindow->windowFlags.offscreen) {
		Win2Update(pWindow->displayAddr,xLoc,yLoc,xLoc+xExtent-1,
			   yExtent);
	}

	CALLBACK_INTERAPP_EPILOGUE;
}


static Err
ScrCopyRectangle_2bit(WinPtr sourceWindow, WinPtr destWindow,
		      SWord fromX, SWord fromY, SWord toX, SWord toY,
		      SWord bitCount, SWord lineCount)
{
	Err retval;
	CALLBACK_INTERAPP_PROLOGUE(appType_, FTR_2BIT, magic, MAGICVAL);

	retval = ScrCopyRectangle_1bit(sourceWindow, destWindow, fromX, fromY,
				       toX, toY, bitCount, lineCount);
	if (! destWindow->windowFlags.offscreen) {
		Win2Update(destWindow->displayAddr,toX,toY,
			   toX+bitCount-1,lineCount);
	}

	CALLBACK_INTERAPP_EPILOGUE;
	return retval;
}


/* Set up the display in either greyscale or B/W mode.  vpw is the virtual
   page width _in words_ (word = 16 bits).  The info used here was derived
   from code in a _PDA Developers_ article by Edward Keyes. */
static void
setgrey(DispParams *curparams, const void *newSSA,
	DispParams *newparams)
{
	const void * volatile *SSA = (const void**)0xfffffa00;
	volatile unsigned char *CKCON = (unsigned char *)0xfffffa27;
	volatile unsigned char *VPW = (unsigned char *)0xfffffa05;
	volatile unsigned char *PICF = (unsigned char *)0xfffffa20;
	volatile unsigned char *LBAR = (unsigned char *)0xfffffa29;
	volatile unsigned char *FRCM = (unsigned char *)0xfffffa31;
	volatile unsigned char *POSR = (unsigned char *)0xfffffa2d;
	volatile Word *GPMR = (Word *)0xfffffa32;
	unsigned gray0 = 0, gray1 = 3, gray2 = 4, gray3 = 6;

	/* Save the old display parameters */
	if (curparams) {
		curparams->SSA = *SSA;
		curparams->VPW = *VPW;
		curparams->PICF = *PICF;
		curparams->LBAR = *LBAR;
		curparams->FRCM = *FRCM;
		curparams->GPMR = *GPMR;
		curparams->POSR = *POSR;
	}

	if (newparams && !newparams->SSA && !newSSA) return;

	/* Turn off the display while we fiddle */
	*CKCON &= 0x7f;
	SysTaskDelay(2);

	if (newSSA) {
		*SSA = newSSA;
	}

	if (newparams) {
		/* We are restoring parameters */
		if (!newSSA) {
			*SSA = newparams->SSA;
		}
		*VPW = newparams->VPW;
		*PICF = newparams->PICF;
		*LBAR = newparams->LBAR;
		*FRCM = newparams->FRCM;
		*GPMR = newparams->GPMR;
		*POSR = newparams->POSR;
	} else {
		/* We are going to greyscale */
		*VPW = 20;
		*PICF |= 0x01;
		*LBAR = 22;
		*FRCM = 0xb9;
		*GPMR = gray2 + (gray3<<4) + (gray0<<8) + (gray1<<12);
		*POSR &= 0xf0;
	}
	/*
	  If we ever have to forcefully go to b/w mode, do this:

	  *VPW = 10;
	  *PICF &= 0xfe;
	  *LBAR = 10;
	  *POSR &= 0xf0;
	  */

	/* Turn the display back on */
	SysTaskDelay(2);
	*CKCON |= 0x80;
}

static void
Win2DrawHorizontalWord(SWord x1, SWord x2, SWord y, VoidPtr frameBuf,Word word)
{
	/* this routine assumes the line coords have already been clipped
	   and that x1 < x2 */

	WordPtr start = FRAMEBUF_WORD(frameBuf, x1, y);
	WordPtr end   = FRAMEBUF_WORD(frameBuf, x2, y);
	WordPtr ptr;

	Word mask;

	/* check if we are touching only one byte */
	if (start==end) {
		mask = grlmask[x1 & 7] & grrmask[x2 & 7];
		FRAMEBUF_SET(start, word, mask);
		return;
	}

	/* write to the frame buffer */
	mask = grlmask[x1 & 7];
	FRAMEBUF_SET(start, word, mask);
	for (ptr=start+1; ptr<end; ptr++) *ptr = word;
	mask = grrmask[x2 & 7];
	FRAMEBUF_SET(end, word, mask);
}


static void
Win2DrawHorizontal(SWord x1, SWord x2, SWord y, VoidPtr frameBuf, Byte clr)
{
	/* construct the word to write into memory */
	Word clrw = (((~clr)&0x00C0) >> 6);
	clrw = (clrw << 14) | (clrw << 12) | (clrw << 10) |
		(clrw << 8) | (clrw << 6) | (clrw << 4) |
		(clrw << 2) | clrw;
	Win2DrawHorizontalWord(x1, x2, y, frameBuf, clrw);
}


inline void
Win2Plot(SWord x, SWord y, VoidPtr frameBuf, Byte clr)
{
	WordPtr ptr = FRAMEBUF_WORD(frameBuf, x, y);
	Word mask = 3 << ((7 - (x & 7)) << 1);
	Word clrw = (((~clr)&0x00C0) >> 6) << ((7 - (x & 7)) << 1);

	FRAMEBUF_SET(ptr, clrw, mask);
}


static void
Win2DrawXLine(Win2_Context *cxt, int x1, int y1, int x2, int y2)
{
	VoidPtr frameBuf = cxt->window->displayAddr;
	SWord xmin, xmax, ymin, ymax, clipx1, clipy1, clipx2, clipy2, signy, i,
		x, y, dx, dy, d, i1, i2, stop, prevy;
	Byte w=cxt->width;
	xmin = cxt->window->clippingBounds.left;
	xmax = cxt->window->clippingBounds.right;
	ymin = cxt->window->clippingBounds.top;
	ymax = cxt->window->clippingBounds.bottom;

	if (x1 > x2) {
		/* exchange x1 and x2 */
		SWord t;
		t = x1; x1 = x2; x2 = t;
		t = y1; y1 = y2; y2 = t;
	}

	/* check for trivial reject */
	if (x2 < xmin || x1 > xmax || (y1 < ymin && y2 < ymin) ||
	    (y1 > ymax && y2 > ymax)) return;

	x = x1; y = y1;
	dx = x2 - x1; dy = ABS(y2 - y1);
	d = (dy<<1) - dx;
	i1 = (dy<<1);  i2 = ((dy-dx) << 1);
	signy = SGN(y2 - y1);

	while (x < xmin) {
		if (d <= 0) { d += i1; }
		else {
			d += i2; y += signy;
		}
		x++;
	}

	/* plot the first point */
	clipx1 = ((x-(w>>1) < xmin) ? xmin : (x-(w>>1)));
	clipx2 = ((x-(w>>1)+w-1 > xmax) ? xmax:(x-(w>>1)+w-1));
	clipy1 = ((y-(w>>1) < ymin) ? ymin : (y-(w>>1)));
	clipy2 = ((y-(w>>1)+w-1 > ymax) ? ymax:(y-(w>>1)+w-1));

	for (i=clipy1; i<=clipy2; i++)
		Win2DrawHorizontal(clipx1, clipx2, i,frameBuf,cxt->outlineClr);

	/* return if we are already outside the clipping region */
	if (signy > 0) {
		if (clipy1 > ymax) return;
	} else {
		if (clipy2 < ymin) return;
	}

	/* determine the end condition */
	if (x2 < xmax) stop = x2; else stop = xmax;
	while (x < stop) {
		prevy = y;
		if (d <= 0) {
			d += i1;
		}
		else {
			d += i2; y += signy;
		}
		x++;

		/* plot the point (x, y) */
		clipx1 = ((x-(w>>1) < xmin) ? xmin : (x-(w>>1)));
		clipx2 = ((x-(w>>1)+w-1 > xmax) ? xmax:(x-(w>>1)+w-1));
		clipy1 = ((y-(w>>1) < ymin) ? ymin : (y-(w>>1)));
		clipy2 = ((y-(w>>1)+w-1 > ymax) ? ymax:(y-(w>>1)+w-1));

		/* draw the vertical edge */
		for (i=clipy1; i<=clipy2; i++)
			Win2Plot(clipx2, i, frameBuf, cxt->outlineClr);
		/* draw the horizontal edge */
		if (prevy!=y && w > 1) {
			if (signy) {
				if (clipy1 > ymax) break;
				Win2DrawHorizontal(clipx1, clipx2-1, clipy2,
						   frameBuf, cxt->outlineClr);
			} else {
				if (clipy2 < ymin) break;
				Win2DrawHorizontal(clipx1, clipx2-1, clipy1,
						   frameBuf, cxt->outlineClr);
			}
		}
	}
}


static void
Win2DrawYLine(Win2_Context *cxt, int x1, int y1, int x2, int y2)
{
	VoidPtr frameBuf = cxt->window->displayAddr;
	SWord xmin, xmax, ymin, ymax, clipx1, clipy1, clipx2, clipy2, signx, i,
		x, y, dx, dy, d, i1, i2, stop, prevx;
	Byte w=cxt->width;
	xmin = cxt->window->clippingBounds.left;
	xmax = cxt->window->clippingBounds.right;
	ymin = cxt->window->clippingBounds.top;
	ymax = cxt->window->clippingBounds.bottom;

	if (y1 > y2) {
		/* exchange y1 and y2 */
		SWord t;
		t = x1; x1 = x2; x2 = t;
		t = y1; y1 = y2; y2 = t;
	}

	/* check for trivial reject */
	if (x2 < xmin || x1 > xmax || (y1 < ymin && y2 < ymin) ||
	    (y1 > ymax && y2 > ymax)) return;

	x = x1; y = y1;
	dx = ABS(x2 - x1); dy = y2 - y1;
	d = dy - (dx << 1);
	i1 = ((dy-dx) << 1);  i2 = -(dx << 1);
	signx = SGN(x2 - x1);

	while (y < ymin) {
		if (d <= 0) { d += i1; x += signx; }
		else d += i2;
		y++;
	}

	/* plot the first point */
	clipx1 = ((x-(w>>1) < xmin) ? xmin : (x-(w>>1)));
	clipx2 = ((x-(w>>1)+w-1 > xmax) ? xmax:(x-(w>>1)+w-1));
	clipy1 = ((y-(w>>1) < ymin) ? ymin : (y-(w>>1)));
	clipy2 = ((y-(w>>1)+w-1 > ymax) ? ymax:(y-(w>>1)+w-1));

	if (clipx1 <= clipx2) {
		for (i=clipy1; i<=clipy2; i++)
			Win2DrawHorizontal(clipx1, clipx2, i, frameBuf,
					   cxt->outlineClr);
	}

	/* return if we are already outside the clipping region */
	if (signx > 0) {
		if (clipx1 > xmax) return;
	} else {
		if (clipx2 < xmin) return;
	}

	/* determine the end condition */
	if (y2 < ymax) stop = y2; else stop = ymax;
	while (y < stop) {
		prevx = x;
		if (d <= 0) { d += i1; x += signx; }
		else d += i2;
		y++;

		/* plot the point (x, y) */
		clipx1 = ((x-(w>>1) < xmin) ? xmin : (x-(w>>1)));
		clipx2 = ((x-(w>>1)+w-1 > xmax) ? xmax:(x-(w>>1)+w-1));
		clipy1 = ((y-(w>>1) < ymin) ? ymin : (y-(w>>1)));
		clipy2 = ((y-(w>>1)+w-1 > ymax) ? ymax:(y-(w>>1)+w-1));

		/* draw the horizontal edge */
		if (clipx1 <= clipx2)
			Win2DrawHorizontal(clipx1, clipx2, clipy2, frameBuf,
					   cxt->outlineClr);
		/* draw the vertical edge */
		if (prevx!=x) {
			if (signx) {
				if (clipx1 > xmax) break;
				for (i=clipy1; i<clipy2; i++)
					Win2Plot(clipx2, i, frameBuf,
						 cxt->outlineClr);
			} else {
				if (clipx2 < xmin) break;
				for (i=clipy1; i<clipy2; i++)
					Win2Plot(clipx1, i, frameBuf,
						 cxt->outlineClr);
			}
		}
	}
}



void
Win2_DrawLine(Win2_Context *cxt, SWord x1, SWord y1, SWord x2, SWord y2)
{
	if (cxt->width <= 0) return;
	DISABLE_MEMCHECK;
	if (ABS(x2-x1) >= ABS(y2-y1))
		Win2DrawXLine(cxt, x1, y1, x2, y2);
	else
		Win2DrawYLine(cxt, x1, y1, x2, y2);
	ENABLE_MEMCHECK;
}


void
Win2_DrawRectangle(Win2_Context *cxt, SWord x1, SWord y1, SWord x2, SWord y2)
{
	VoidPtr displayAddr = cxt->window->displayAddr;
	AbsRectType *clip = &cxt->window->clippingBounds;
	SWord clipx1, clipx2, clipx3, clipx4, clipy1, clipy2, y;
	SWord t;
	if (x1 > x2) { t = x1; x1 = x2; x2 = t; }
	if (y1 > y2) { t = y1; y1 = y2; y2 = t; }

	if (x1 > clip->right  || x2 < clip->left) return;
	if (y1 > clip->bottom || y2 < clip->top ) return;

	DISABLE_MEMCHECK;
	if (cxt->width > 0) {
		x1 -= cxt->width/2;
		y1 -= cxt->width/2;
		x2 += cxt->width/2;
		y2 += cxt->width/2;

		/* draw the top line */
		clipx1 = ((x1 < clip->left) ? clip->left : x1);
		clipx2 = ((x2 > clip->right)? clip->right: x2);
		clipy1 = ((y1 < clip->top)  ? clip->top  : y1);
		clipy2 = ((y1+cxt->width-1>clip->bottom) ? clip->bottom :
			  (y1+cxt->width-1));
		for (y=clipy1; y<=clipy2; y++)
			Win2DrawHorizontal(clipx1, clipx2, y, displayAddr,
					   cxt->outlineClr);

		/* draw the bottom line */
		clipy1 = ((y2-cxt->width+1 < clip->top)  ? clip->top :
			  (y2-cxt->width+1));
		clipy2 = ((y2 > clip->bottom) ? clip->bottom : y2);
		for (y=clipy1; y<=clipy2; y++)
			Win2DrawHorizontal(clipx1, clipx2, y, displayAddr,
					   cxt->outlineClr);

		/* draw the two vertical sides of the rectangle */
		clipx1 = ((x1 < clip->left) ? clip->left : x1);
		clipx2 = ((x1+cxt->width-1 < clip->left) ? -1 :
			  ((x1+cxt->width-1 > clip->right) ? clip->right :
			   (x1+cxt->width-1)));

		clipx4 = ((x2 > clip->right) ? clip->right : x2);
		clipx3 = ((x2-cxt->width+1 > clip->right) ? -1 :
			  ((x2-cxt->width+1 < clip->left) ? clip->left :
			   (x2-cxt->width+1)));

		clipy1 = ((y1+cxt->width < clip->top)  ? clip->top  :
			  y1+cxt->width);
		clipy2 = ((y2-cxt->width>clip->bottom) ? clip->bottom :
			  (y2-cxt->width));
		for (y=clipy1; y<=clipy2; y++) {
			if (clipx2!=-1) Win2DrawHorizontal(clipx1, clipx2, y,
							   displayAddr,
							   cxt->outlineClr);
			if (clipx3!=-1) Win2DrawHorizontal(clipx3, clipx4, y,
							   displayAddr,
							   cxt->outlineClr);
		}
	}

	/* draw the fill area */
	if (cxt->fill) {
		clipx1 = ((x1+cxt->width < clip->left) ? clip->left :
			  (x1+cxt->width));
		clipx2 = ((x2-cxt->width > clip->right) ? clip->right :
			  (x2-cxt->width));
		clipy1 = ((y1+cxt->width < clip->top) ? clip->top :
			  (y1+cxt->width));
		clipy2 = ((y2-cxt->width > clip->bottom) ? clip->bottom :
			  (y2-cxt->width));

		if (clipx1 <= clipx2 && clipy1 <= clipy2) {
			for (y=clipy1; y<=clipy2; y++)
				Win2DrawHorizontal(clipx1, clipx2, y,
						   displayAddr, cxt->fillClr);
		}
	}
	ENABLE_MEMCHECK;
}


inline void
Win2ClipPlot(SWord x, SWord y, AbsRectType *clip, VoidPtr frameBuf, Byte clr)
{
	if (x >= clip->left && x <= clip->right &&
	    y >= clip->top  && y <= clip->bottom) Win2Plot(x, y, frameBuf,clr);
}


inline void
Win2ClipHorizontal(SWord x1, SWord x2, SWord y, AbsRectType *clip,
		 VoidPtr frameBuf, Byte clr)
{
	if (y >= clip->top && y <= clip->bottom) {
		if (x1 < clip->left)  x1 = clip->left;
		if (x2 > clip->right) x2 = clip->right;
		if (x1 <= x2) Win2DrawHorizontal(x1, x2, y, frameBuf, clr);
	}
}


void
Win2_Plot(Win2_Context *cxt, SWord x, SWord y)
{
	DISABLE_MEMCHECK;
	Win2ClipPlot(x, y, &cxt->window->clippingBounds,
		     cxt->window->displayAddr, cxt->outlineClr);
	ENABLE_MEMCHECK;
}


void
Win2DrawOvalSegments(Win2_Context *cxt, SWord xc, SWord yc, SWord x, SWord y,
		   Boolean flip, Boolean xchanged, Boolean ychanged)
{
	SWord tx, ty, fy1, fy2;
	Byte w=cxt->width;
	VoidPtr displayAddr = cxt->window->displayAddr;
	AbsRectType *clip = &cxt->window->clippingBounds;

	if (flip) {
		tx = x - (w>>1);
		ty = y - (w>>1);
		if (xchanged) {
			Win2ClipHorizontal(xc+ty, xc+ty+w-1, yc+tx, clip,
					   displayAddr, cxt->outlineClr);
			Win2ClipHorizontal(xc+ty, xc+ty+w-1, yc-tx, clip,
					   displayAddr, cxt->outlineClr);
			Win2ClipHorizontal(xc-ty-w+1, xc-ty, yc+tx, clip,
					   displayAddr, cxt->outlineClr);
			Win2ClipHorizontal(xc-ty-w+1, xc-ty, yc-tx, clip,
					   displayAddr, cxt->outlineClr);
		}
		if (ychanged) {
			for(; tx < x-(w>>1)+w; tx++) {
				Win2ClipPlot(xc+ty, yc+tx, clip, displayAddr,
					     cxt->outlineClr);
				Win2ClipPlot(xc+ty, yc-tx, clip, displayAddr,
					     cxt->outlineClr);
				Win2ClipPlot(xc-ty, yc+tx, clip, displayAddr,
					     cxt->outlineClr);
				Win2ClipPlot(xc-ty, yc-tx, clip, displayAddr,
					     cxt->outlineClr);
			}

			if (cxt->fill) {
				tx = x-(w>>1)-1;
				fy1 = ((yc-tx < clip->top) ? clip->top :yc-tx);
				fy2 = ((yc+tx > clip->bottom) ? clip->bottom:
				       yc+tx);
				if (fy1 > fy2) return;

				if (xc+ty>=clip->left && xc+ty<=clip->right) {
					for(tx=fy1; tx<fy2; tx++) {
						Win2Plot(xc+ty, tx,displayAddr,
							 cxt->fillClr);
					}
				}

				if (xc-ty>=clip->left && xc-ty<=clip->right) {
					for(tx=fy1; tx<fy2; tx++) {
						Win2Plot(xc-ty, tx,displayAddr,
							 cxt->fillClr);
					}
				}
			}
		}
	} else {
		tx = x - (w>>1) + w - 1;
		if (xchanged) {
			for (ty=y-(w>>1); ty<y-(w>>1)+w; ty++) {
				Win2ClipPlot(xc+tx, yc+ty, clip, displayAddr,
					     cxt->outlineClr);
				Win2ClipPlot(xc+tx, yc-ty, clip, displayAddr,
					     cxt->outlineClr);
				Win2ClipPlot(xc-tx, yc+ty, clip, displayAddr,
					     cxt->outlineClr);
				Win2ClipPlot(xc-tx, yc-ty, clip, displayAddr,
					     cxt->outlineClr);
			}
		}
		if (ychanged) {
			ty = y - (w>>1);
			Win2ClipHorizontal(xc+tx-w+1, xc+tx, yc+ty, clip,
					   displayAddr, cxt->outlineClr);
			Win2ClipHorizontal(xc+tx-w+1, xc+tx, yc-ty, clip,
					   displayAddr, cxt->outlineClr);
			Win2ClipHorizontal(xc-tx, xc-tx+w-1, yc+ty, clip,
					   displayAddr, cxt->outlineClr);
			Win2ClipHorizontal(xc-tx, xc-tx+w-1, yc-ty, clip,
					   displayAddr, cxt->outlineClr);

			if (cxt->fill) {
				Win2ClipHorizontal(xc-tx+w, xc+tx-w,yc+ty,clip,
						   displayAddr, cxt->fillClr);
				Win2ClipHorizontal(xc-tx+w, xc+tx-w,yc-ty,clip,
						   displayAddr, cxt->fillClr);
			}
		}
	}
}


static void
Win2DrawChars(Win2_Context *cxt, SWord x, SWord y, SWord yextent,
	      const char *string, Word len)
{
	VoidPtr frameBuf = cxt->window->displayAddr;
	int save_2bit = in_2bit;
	unsigned char *bwstartline;
	unsigned short *grstartline;
	unsigned short lmask, rmask;
	unsigned short grval, clrw;

	SWord x1=x, x2=159, y1=y, y2=y+yextent-1;
	AbsRectType *clip = &cxt->window->clippingBounds;
	if (x1 < clip->left)  x1 = clip->left;
	if (x2 > clip->right) x2 = clip->right;
	if (x2 < x1) return;

	if (y1 < clip->top)    y1 = clip->top;
	if (y2 > clip->bottom) y2 = clip->bottom;
	if (y2 < y1) return;

	bwstartline = ((unsigned char *)((WindowType*)textWindow_)->
		       displayAddr) + (y1-y)*20;
	grstartline = ((unsigned short *)frameBuf) + y1*20;
	lmask = grlmask[x1 & 7];
	rmask = grrmask[x2 & 7];
	clrw = (((~cxt->outlineClr)&0x00C0) >> 6);
	clrw = (clrw << 14) | (clrw << 12) | (clrw << 10) |
		(clrw << 8) | (clrw << 6) | (clrw << 4) |
		(clrw << 2) | clrw;

	/* draw the string on the 1bit window */
	in_2bit = 1;
	WinEraseWindow();
	WinDrawChars((char*)string, len, x, 0);
	in_2bit = save_2bit;

	/* copy the bits to the 2bit window */
	DISABLE_MEMCHECK;
	for(;yextent;--yextent) {
		if ((x1 >> 3) == (x2 >> 3)) {
			/* Only one byte */
			unsigned short mask = (lmask & rmask);
			grval = grstartline[x1 >> 3] & \
				~(bw2gr[bwstartline[x1>>3]] & mask);
			grval |= (bw2gr[bwstartline[x1>>3]] & (mask & clrw));
			grstartline[x1 >> 3] = grval;
		} else {
			SWord i;
			/* The first (partial) byte */
			grval = grstartline[x1 >> 3] & \
				~(bw2gr[bwstartline[x1>>3]] & lmask);
			grval |= (bw2gr[bwstartline[x1>>3]] & (lmask & clrw));
			grstartline[x1 >> 3] = grval;
			/* Middle bytes */
			for(i=(x1>>3)+1;i<(x2>>3);++i) {
				grval = grstartline[i] & \
					~(bw2gr[bwstartline[i]]);
				grval |= (bw2gr[bwstartline[i]] & clrw);

				grstartline[i] = grval;
			}
			/* The last (partial) byte */
			grval = grstartline[x2 >> 3] & \
				~(bw2gr[bwstartline[x2>>3]] & rmask);
			grval |= (bw2gr[bwstartline[x2>>3]] & (rmask & clrw));
			grstartline[x2 >> 3] = grval;
		}
		bwstartline += 20;
		grstartline += 20;
	}
	ENABLE_MEMCHECK;
}


void
Win2_DrawText(Win2_Context *cxt, SWord x, SWord y, const char *string)
{
	char *p=(char*)string;
	Word height = FntCharHeight(), len;
	WinHandle oldwin=WinGetDrawWindow();
	WinSetDrawWindow(textWindow_);
	do {
		p = StrChr(string, '\n');
		if (p) len = p - string;
		else len = StrLen(string);
		Win2DrawChars(cxt, x, y, height, string, len);
		y += height;
		if (p) string = p+1;
	} while(p);
	WinSetDrawWindow(oldwin);
}


void
Win2_GetTextBBox(Win2_Context *cxt, SWord *w, SWord *h, const char *string)
{
	Word height = FntCharHeight(), width, len;
	char *p = (char*)string;
	*w = 0; *h = 0;
	do {
		p = StrChr(string, '\n');
		if (p) len = p - string;
		else len = StrLen(string);
		width = FntCharsWidth((char*)string, len);
		if (*w < width) *w = width;
		*h += height;
		if (p) string = p+1;
	} while(p);
}


void
Win2_DrawBitmap(Win2_Context *cxt, SWord x, SWord y, BitmapPtr image)
{
	WinHandle olddraw;
	int save_2bit = in_2bit;

	in_2bit = 1;
	olddraw = WinGetDrawWindow();
	cxt->window->clippingBounds.left  <<= 1;
	cxt->window->clippingBounds.right <<= 1;
	WinSetDrawWindow(cxt->window);
	DISABLE_MEMCHECK;
	WinDrawBitmap(image, (x<<1), y);
	ENABLE_MEMCHECK;
	WinSetDrawWindow(olddraw);
	cxt->window->clippingBounds.left  >>= 1;
	cxt->window->clippingBounds.right >>= 1;
	in_2bit = save_2bit;
}


void
Win2_GrayoutRectangle(Win2_Context *cxt, SWord x1, SWord y1, SWord x2,SWord y2)
{
	AbsRectType *clip = &cxt->window->clippingBounds;
	VoidPtr frameBuf = cxt->window->displayAddr;
	SWord y;
	Word clrw;
	if (clip->left  > x1) x1 = clip->left;
	if (clip->top   > y1) y1 = clip->top;
	if (clip->right < x2) x2 = clip->right;
	if (clip->bottom< y2) y2 = clip->bottom;
	if (x1 > x2 || y1 > y2) return;

	clrw = (((~(cxt->fillClr))&0x00C0) >> 6);
	clrw = (clrw << 14) | (clrw << 12) | (clrw << 10) |
		(clrw << 8) | (clrw << 6) | (clrw << 4) |
		(clrw << 2) | clrw;

	DISABLE_MEMCHECK;
	for (y=y1; y<=y2; y++) {
		Win2DrawHorizontalWord(x1, x2, y, frameBuf,
				       ((y & 0x0001) ? (0xCCCC & clrw) :
					(0x3333 & clrw)));
	}
	ENABLE_MEMCHECK;
}


/*void
Win2_InvertRectangle(WindowType *w, SWord x1, SWord y1, SWord x2, SWord y2)
{
	SWord t;
	RectangleType r;
	if (x1 > x2) { t = x1; x1 = x2; x2 = t; }
	if (y1 > y2) { t = y1; y1 = y2; y2 = t; }
	r.topLeft.x = (x1<<1); r.topLeft.y = y1;
	r.extent.x = ((x2-x1+1)<<1); r.extent.y = (y2-y1+1);
	DISABLE_MEMCHECK;
	WinInvertRectangle(&r, 0);
	ENABLE_MEMCHECK;
}*/

void
Win2_CopyRectangle(WindowType *srcW, WindowType *destW, AbsRectType *bbox,
		   SWord destX, SWord destY, ScrOperation mode)
{
	RectangleType bbox1;
	int save_2bit = in_2bit;

	bbox1.topLeft.x = (bbox->left << 1);
	bbox1.topLeft.y = bbox->top;
	bbox1.extent.x  = ((bbox->right  - bbox->left + 1) << 1);
	bbox1.extent.y  = bbox->bottom - bbox->top  + 1;

	in_2bit = 1;
	DISABLE_MEMCHECK;
	WinCopyRectangle(srcW, destW, &bbox1, destX<<1, destY, mode);
	ENABLE_MEMCHECK;
	in_2bit = save_2bit;
}


void
Win2_CopyOnscreenRectangle(AbsRectType *bbox, SWord destX, SWord destY,
			   ScrOperation mode)
{
	RectangleType bbox1, bbox2;
	WinHandle win = WinGetDrawWindow();
	int save_2bit = in_2bit;

	bbox1.topLeft.x = bbox->left;
	bbox1.topLeft.y = bbox->top;
	bbox1.extent.x  = bbox->right  - bbox->left + 1;
	bbox1.extent.y  = bbox->bottom - bbox->top  + 1;
	bbox2 = bbox1;
	bbox2.topLeft.x <<= 1;
	bbox2.extent.x  <<= 1;

	in_2bit = 1;
	WinCopyRectangle(win, win, &bbox1, destX, destY, mode);
	DISABLE_MEMCHECK;
	WinCopyRectangle(twobitwindow, twobitwindow, &bbox2, destX<<1, destY,
			 mode);
	ENABLE_MEMCHECK;
	in_2bit = save_2bit;
}


typedef struct DmWindowInfo {
	VoidHand handle;
	ULong recordId;
	DmOpenRef db;
} DmWindowInfo;


WindowType *
Win2_CreateOffscreenWindow(SWord width, SWord height, DmOpenRef db,
			   WordPtr errPtr)
{
	if (db==NULL) {
		WinHandle olddraw = WinGetDrawWindow(), w;
		w = WinCreateOffscreenWindow(width<<1, height, screenFormat,
					     errPtr);
		WinSetDrawWindow(w);
		WinEraseWindow();
		WinSetDrawWindow(olddraw);
		/* FIXME */
		((WindowType*)w)->windowFlags.reserved = 0;
		return (WindowType*)w;
	} else {
		/* create a window in database memory */
		VoidPtr wp;
		WindowType *w;
		DmWindowInfo *info;
		UInt index, size;
		wp = MemPtrNew(sizeof(WindowType) + sizeof(GraphicStateType) +
			       sizeof(DmWindowInfo));
		w = (WindowType *)wp;
		w->displayWidth = width<<1;
		w->displayHeight= height;
		*(Word*)(&w->windowFlags) = 0;
		w->windowFlags.offscreen = 1;
		/* FIXME */
		w->windowFlags.reserved = 1;
		w->windowBounds.topLeft.x = w->windowBounds.topLeft.y = 0;
		w->windowBounds.extent.x = width<<1;
		w->windowBounds.extent.y = height;
		w->clippingBounds.left = w->clippingBounds.top = 0;
		w->clippingBounds.right = (width<<1)-1;
		w->clippingBounds.bottom = height-1;
		w->frameType.word = noFrame;
		w->gstate = (GraphicStateType*)(w+1);
		w->gstate->grafMode = scrCopy;
		w->gstate->patternMode = 0;
		w->gstate->pattern = blackPattern;
		w->gstate->fontId = stdFont;
		w->gstate->font = 0;
		w->gstate->underlineMode = noUnderline;
		w->nextWindow= NULL;

		info = (DmWindowInfo*)(w->gstate+1);
		size = width/4;
		if (width % 4) size++;
		size *= height;
		info->handle = DmNewRecord(db, &index, size);
		DmRecordInfo(db, index, NULL, &info->recordId, NULL);
		info->db = db;
		w->displayAddr = MemHandleLock(info->handle);
		DmSet(w->displayAddr, 0, size, 0);
		return w;
	}
}


void
Win2_DeleteWindow(WindowType *w, Boolean erase)
{
	/* FIXME */
	if (w->windowFlags.reserved) {
		/* this is in database memory */
		DmWindowInfo *info;
		UInt index;
		info = (DmWindowInfo*)(w->gstate+1);
		MemHandleUnlock(info->handle);
		DmFindRecordByID(info->db, info->recordId, &index);
		DmReleaseRecord(info->db, index, false);
		DmDeleteRecord(info->db, index);
		MemPtrFree((VoidPtr)w);
	} else {
		WinDeleteWindow(w, erase);
	}
}


void
Win2_Enable(DWord appType, DmOpenRef db)
{
	Err err;
	FontID oldid, id;
	Word height, h;

	appType_ = appType;

	/* Allocate a window */
	twobitwindow = Win2_CreateOffscreenWindow(160,160,db,&err);

	/* Set up trap patches */
	ScrLineRoutine_1bit =
		(ScrLineRoutineType)GSysDispatchTableP[sysTrapScrLineRoutine-
						      sysTrapBase];
	GSysDispatchTableP[sysTrapScrLineRoutine-sysTrapBase] =
		(Ptr)ScrLineRoutine_2bit;

	ScrRectangleRoutine_1bit =
		(ScrRectangleRoutineType)
		GSysDispatchTableP[sysTrapScrRectangleRoutine-sysTrapBase];
	GSysDispatchTableP[sysTrapScrRectangleRoutine-sysTrapBase] =
		(Ptr)ScrRectangleRoutine_2bit;

	ScrDrawChars_1bit =
		(ScrDrawCharsType)
		GSysDispatchTableP[sysTrapScrDrawChars-sysTrapBase];
	GSysDispatchTableP[sysTrapScrDrawChars-sysTrapBase] =
		(Ptr)ScrDrawChars_2bit;

	ScrCopyRectangle_1bit =
		(ScrCopyRectangleType)
		GSysDispatchTableP[sysTrapScrCopyRectangle-sysTrapBase];
	GSysDispatchTableP[sysTrapScrCopyRectangle-sysTrapBase] =
		(Ptr)ScrCopyRectangle_2bit;

	/* Go 2-bit */
	setgrey(&savedispparams, (const void *)twobitwindow->displayAddr,NULL);
	REGISTER_INTERAPP_CALLBACK(appType_, FTR_2BIT);

	/* create an offscreen window for drawing text */
	oldid = FntGetFont();
	height=0;
	for (id=stdFont; id <= ledFont; id++) {
		FntSetFont(id);
		h = FntCharHeight();
		if (h > height) height = h;
	}
	FntSetFont(oldid);
	textWindow_=WinCreateOffscreenWindow(160, height, screenFormat, NULL);
}


void
Win2_Disable(void)
{
	/* Go 1-bit */
	DEREGISTER_INTERAPP_CALLBACK(appType_, FTR_2BIT);
	setgrey(NULL, NULL, &savedispparams);

	/* Restore traps */
	GSysDispatchTableP[sysTrapScrLineRoutine-sysTrapBase] =
		(Ptr)ScrLineRoutine_1bit;

	GSysDispatchTableP[sysTrapScrRectangleRoutine-sysTrapBase] =
		(Ptr)ScrRectangleRoutine_1bit;

	GSysDispatchTableP[sysTrapScrDrawChars-sysTrapBase] =
		(Ptr)ScrDrawChars_1bit;

	GSysDispatchTableP[sysTrapScrCopyRectangle-sysTrapBase] =
		(Ptr)ScrCopyRectangle_1bit;

	/* Delete the windows */
	Win2_DeleteWindow(twobitwindow, false);
	WinDeleteWindow(textWindow_, false);
}


void
Win2_DrawOval(Win2_Context *cxt, SWord x1, SWord y1, SWord x2, SWord y2)
{
	VoidPtr displayAddr = cxt->window->displayAddr;
	AbsRectType *clip = &cxt->window->clippingBounds;
	SDWord x, y, a, b, xc, yc, d, dt, prevx, prevy;
	SWord t;
	Boolean flip;
	Byte w;
	if (x1 > x2) { t = x1; x1 = x2; x2 = t; }
	if (y1 > y2) { t = y1; y1 = y2; y2 = t; }

	if (x1 > clip->right  || x2 < clip->left) return;
	if (y1 > clip->bottom || y2 < clip->top ) return;

	a = (x2-x1) >> 1;
	b = (y2-y1) >> 1;
	xc = x1 + a;
	yc = y1 + b;

	if (a < b) {
		flip = 1;
		dt = a; a = b; b = dt;
	} else flip = 0;

	x = 0; y = b;
	d = 4*b*b - 4*a*a*b + a*a;

	DISABLE_MEMCHECK;
	w=cxt->width;
	if (flip) {
		for (dt=yc-(w>>1); dt<yc-(w>>1)+w; dt++) {
			Win2ClipHorizontal(xc+y-(w>>1), xc+y-(w>>1)+w-1, dt,
					   clip, displayAddr, cxt->outlineClr);
			Win2ClipHorizontal(xc-y+(w>>1), xc-y+(w>>1)-w+1, dt,
					   clip, displayAddr, cxt->outlineClr);
		}
	} else {
		for (dt=y-(w>>1); dt<y-(w>>1)+w; dt++) {
			Win2ClipHorizontal(xc-(w>>1), xc-(w>>1)+w-1, yc+dt,
					   clip, displayAddr, cxt->outlineClr);
			Win2ClipHorizontal(xc-(w>>1), xc-(w>>1)+w-1, yc-dt,
					   clip, displayAddr, cxt->outlineClr);
		}
	}

	while (a*a*y - b*b*x - b*b > (a*a >> 1)) {
		prevy = y;
		if (d < 0) {
			d += 4*b*b*(2*x+3);
		} else {
			d += 4*b*b*(2*x+3) + 4*a*a*(-2*y+2);
			y--;
		}
		x++;

		Win2DrawOvalSegments(cxt,xc,yc,x,y,flip,1,(Boolean)(prevy!=y));
	}

	d = b*b*(2*x+1)*(2*x+1) + 4*a*a*(y-1)*(y-1) - 4*a*a*b*b;
	while (y > 0) {
		prevx = x;
		if (d < 0) {
			d += 4*b*b*(2*x+2) + 4*a*a*(-2*y+3);
			x++;
		} else d += 4*a*a*(-2*y+3);
		y--;

		Win2DrawOvalSegments(cxt,xc,yc,x,y,flip,(Boolean)(prevx!=x),1);
	}
	ENABLE_MEMCHECK;
}

#endif /* !NOTWOBIT */
