/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.ViewId;
import org.javagroups.log.Trace;
import org.javagroups.protocols.PingHeader;
import org.javagroups.protocols.PingRsp;
import org.javagroups.stack.GossipClient;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PING
extends Protocol {
    Vector members;
    Vector initial_members;
    Address local_addr;
    String group_addr;
    long timeout;
    long num_initial_members;
    String gossip_host;
    int gossip_port;
    long gossip_refresh;
    GossipClient client;
    boolean is_server;

    public String getName() {
        return "PING";
    }

    public Vector providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(new Integer(12));
        return ret;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            if (this.timeout <= 0L) {
                Trace.error("PING.setProperties()", "timeout must be > 0");
            }
            props.remove("timeout");
        }
        if ((str = props.getProperty("num_initial_members")) != null) {
            this.num_initial_members = new Integer(str).intValue();
            props.remove("num_initial_members");
        }
        if ((str = props.getProperty("gossip_host")) != null) {
            this.gossip_host = str;
            props.remove("gossip_host");
        }
        if ((str = props.getProperty("gossip_port")) != null) {
            this.gossip_port = new Integer(str);
            props.remove("gossip_port");
        }
        if ((str = props.getProperty("gossip_refresh")) != null) {
            this.gossip_refresh = new Long(str);
            props.remove("gossip_refresh");
        }
        if (this.gossip_host != null && this.gossip_port != 0) {
            try {
                this.client = new GossipClient(new IpAddress(InetAddress.getByName(this.gossip_host), this.gossip_port), this.gossip_refresh);
            }
            catch (Exception e) {
                Trace.error("PING.setProperties()", "creation of GossipClient failed, exception=" + e);
                return false;
            }
        }
        if (props.size() > 0) {
            StringBuffer sb = new StringBuffer();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                sb.append(e.nextElement().toString());
                if (!e.hasMoreElements()) continue;
                sb.append(", ");
            }
            Trace.error("PING.setProperties()", "The following properties are not recognized: " + sb.toString());
            return false;
        }
        return true;
    }

    public void stop() {
        this.is_server = false;
        if (this.client != null) {
            this.client.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof PingHeader)) {
                    this.passUp(evt);
                    return;
                }
                PingHeader hdr = (PingHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 1: {
                        Address coord;
                        if (!this.is_server) {
                            return;
                        }
                        Vector vector = this.members;
                        synchronized (vector) {
                            Address address = this.members.size() > 0 ? (Address)this.members.firstElement() : this.local_addr;
                            coord = address;
                        }
                        Message rsp_msg = new Message(msg.getSrc(), null, null);
                        PingHeader rsp_hdr = new PingHeader(2, new PingRsp(this.local_addr, coord));
                        rsp_msg.putHeader(this.getName(), rsp_hdr);
                        if (Trace.trace) {
                            Trace.info("PING.up()", "received GET_MBRS_REQ from " + msg.getSrc() + ", returning " + rsp_hdr);
                        }
                        this.passDown(new Event(1, rsp_msg));
                        return;
                    }
                    case 2: {
                        PingRsp rsp = (PingRsp)hdr.arg;
                        Vector vector = this.initial_members;
                        synchronized (vector) {
                            if (Trace.trace) {
                                Trace.info("PING.up()", "received FIND_INITAL_MBRS_RSP, rsp=" + rsp);
                            }
                            this.initial_members.addElement(rsp);
                            this.initial_members.notify();
                            return;
                        }
                    }
                }
                Trace.warn("PING.up()", "got PING header with unknown type (" + hdr.type + ')');
                return;
            }
            case 8: {
                this.passUp(evt);
                this.local_addr = (Address)evt.getArg();
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void down(Event evt) {
        gossip_rsps = null;
        switch (evt.getType()) {
            case 12: {
                if (this.client != null) {
                    gossip_rsps = this.client.getMembers(this.group_addr);
                    if (gossip_rsps != null && gossip_rsps.size() > 0) {
                        view_event = new Event(15, this.makeView(gossip_rsps));
                        this.passDown(view_event);
                        Util.sleep(500L);
                    } else {
                        this.passUp(new Event(13, null));
                        return;
                    }
                }
                this.initial_members.removeAllElements();
                if (Trace.trace) {
                    Trace.info("PING.down()", "FIND_INITIAL_MBRS");
                }
                hdr = new PingHeader(1, null);
                msg = new Message(null, null, null);
                msg.putHeader(this.getName(), hdr);
                this.passDown(new Event(1, msg));
                var9_3 = this.initial_members;
                synchronized (var9_3) {
                    start_time = System.currentTimeMillis();
                    time_to_wait = this.timeout;
                    while (true) {
                        if ((long)this.initial_members.size() < this.num_initial_members && time_to_wait > 0L) ** GOTO lbl34
                        // MONITOREXIT @DISABLED, blocks:[4, 5, 6, 15] lbl31 : MonitorExitStatement: MONITOREXIT : var9_3
                        if (Trace.trace) {
                            break;
                        }
                        ** GOTO lbl42
lbl34:
                        // 1 sources

                        try {
                            this.initial_members.wait(time_to_wait);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        time_to_wait -= System.currentTimeMillis() - start_time;
                    }
                }
                Trace.info("PING.down()", "initial mbrs are " + this.initial_members);
lbl42:
                // 2 sources

                this.passUp(new Event(13, this.initial_members));
                return;
            }
            case 6: 
            case 15: {
                tmp = ((View)evt.getArg()).getMembers();
                if (tmp != null) {
                    var12_10 = this.members;
                    synchronized (var12_10) {
                        this.members.removeAllElements();
                        i = 0;
                        while (true) {
                            if (i >= tmp.size()) {
                                break;
                            }
                            this.members.addElement(tmp.elementAt(i));
                            ++i;
                        }
                    }
                }
                this.passDown(evt);
                return;
            }
            case 16: {
                this.passDown(evt);
                this.is_server = true;
                return;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passDown(evt);
                if (this.client == null) return;
                this.client.register(this.group_addr, this.local_addr);
                return;
            }
            case 4: {
                if (this.client != null) {
                    this.client.stop();
                }
                this.passDown(evt);
                return;
            }
        }
        this.passDown(evt);
    }

    private final View makeView(Vector mbrs) {
        Address coord = null;
        long id = 0L;
        ViewId view_id = new ViewId(this.local_addr);
        coord = view_id.getCoordAddress();
        id = view_id.getId();
        return new View(coord, id, mbrs);
    }

    private final /* synthetic */ void this() {
        this.members = new Vector();
        this.initial_members = new Vector();
        this.local_addr = null;
        this.group_addr = null;
        this.timeout = 3000L;
        this.num_initial_members = 2;
        this.gossip_host = null;
        this.gossip_port = 0;
        this.gossip_refresh = 20000L;
        this.is_server = false;
    }

    public PING() {
        this.this();
    }
}

