/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.protocols.PingHeader;
import org.javagroups.protocols.PingRsp;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.Protocol;
import org.javagroups.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TCPPING
extends Protocol {
    Vector members;
    Vector initial_members;
    Address local_addr;
    String group_addr;
    String groupname;
    long timeout;
    long num_initial_members;
    int port_range;
    List initial_hosts;
    boolean is_server;

    public String getName() {
        return "TCPPING";
    }

    public Vector providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(new Integer(12));
        return ret;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("port_range")) != null) {
            this.port_range = new Integer(str);
            props.remove("port_range");
        }
        if ((str = props.getProperty("num_initial_members")) != null) {
            this.num_initial_members = new Integer(str).intValue();
            props.remove("num_initial_members");
        }
        if ((str = props.getProperty("initial_hosts")) != null) {
            props.remove("initial_hosts");
            this.initial_hosts = this.createInitialHosts(str);
        }
        if (props.size() > 0) {
            System.err.println("TCPPING.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof PingHeader)) {
                    this.passUp(evt);
                    return;
                }
                PingHeader hdr = (PingHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 1: {
                        Address coord;
                        if (!this.is_server) {
                            return;
                        }
                        Vector vector = this.members;
                        synchronized (vector) {
                            Address address = this.members.size() > 0 ? (Address)this.members.firstElement() : this.local_addr;
                            coord = address;
                        }
                        Message rsp_msg = new Message(msg.getSrc(), null, null);
                        PingHeader rsp_hdr = new PingHeader(2, new PingRsp(this.local_addr, coord));
                        rsp_msg.putHeader(this.getName(), rsp_hdr);
                        this.passDown(new Event(1, rsp_msg));
                        return;
                    }
                    case 2: {
                        PingRsp rsp = (PingRsp)hdr.arg;
                        Vector vector = this.initial_members;
                        synchronized (vector) {
                            this.initial_members.addElement(rsp);
                            this.initial_members.notify();
                            return;
                        }
                    }
                }
                Trace.warn("TCPPING.up()", "got TCPPING header with unknown type (" + hdr.type + ')');
                return;
            }
            case 8: {
                this.passUp(evt);
                this.local_addr = (Address)evt.getArg();
                if (this.initial_hosts == null) return;
                if (this.local_addr == null) return;
                HostInfo h = new HostInfo(((IpAddress)this.local_addr).getIpAddress().getHostName(), ((IpAddress)this.local_addr).getPort());
                if (this.initial_hosts.contains(h)) return;
                this.initial_hosts.add(h);
                Trace.warn("TCPPING.up()", "[SET_LOCAL_ADDRESS]: adding my own address (" + h + ") to initial_hosts; initial_hosts=" + this.initial_hosts);
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * Exception decompiling
     */
    public void down(Event evt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [2 : 260->325)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final List createInitialHosts(String l) {
        List tmp = new List();
        StringTokenizer tok = new StringTokenizer(l, ",");
        while (tok.hasMoreTokens()) {
            try {
                String t = tok.nextToken();
                HostInfo h = new HostInfo();
                h.host = t.substring(0, t.indexOf(91));
                h.port = new Integer(t.substring(t.indexOf(91) + 1, t.indexOf(93)));
                tmp.add(h);
            }
            catch (NumberFormatException e) {
                Trace.error("TCPPING.createInitialHosts()", "exeption is " + e);
            }
        }
        return tmp;
    }

    private final /* synthetic */ void this() {
        this.members = new Vector();
        this.initial_members = new Vector();
        this.local_addr = null;
        this.group_addr = null;
        this.groupname = null;
        this.timeout = 3000L;
        this.num_initial_members = 2;
        this.port_range = 5;
        this.initial_hosts = null;
        this.is_server = false;
    }

    public TCPPING() {
        this.this();
    }

    class HostInfo {
        public String host;
        public int port;

        public String toString() {
            return this.host + ':' + this.port;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof HostInfo)) {
                return false;
            }
            if (this.host == null || ((HostInfo)obj).host == null) {
                return false;
            }
            return this.host.equals(((HostInfo)obj).host);
        }

        HostInfo() {
        }

        HostInfo(String h, int p) {
            this.host = h;
            this.port = p;
        }
    }
}

