#!/bin/sh

FILE="../modules.h.tmp"
REAL_FILE="../modules.h"

echo "/* generated automatically by modules/genmods.sh */" > ${FILE}
echo "" >> ${FILE}
echo "#ifndef MODULES_H_" >> ${FILE}
echo "#define MODULES_H_" >> ${FILE}

echo "" >> ${FILE}
echo "#include \"libosiris.h\"" >> ${FILE}
echo "#include \"logging.h\"" >> ${FILE}
echo "#include \"scanner.h\"" >> ${FILE}
echo "" >> ${FILE}

for dir in mod_*; do
        if [ -d "$dir" ]; then
        echo "extern void ${dir}( SCANNER *scanner );" >> ${FILE}
        fi
done
echo "" >> ${FILE}

echo "struct modules" >> ${FILE}
echo "{" >> ${FILE}
echo "    char *name;" >> ${FILE}
echo "    void (*module_function)( SCANNER * );" >> ${FILE}
echo "};" >> ${FILE}

echo "" >> ${FILE}
echo "static struct modules active_modules[] =" >> ${FILE}
echo "{" >> ${FILE}

echo ""
echo "======================================"
echo " Found Scan Agent Modules:"
echo ""

for dir in mod_*; do
        if [ -d "$dir" ]; then
                echo "    ==> ${dir}"
		echo "    { \"${dir}\", &${dir} }," >> ${FILE}
        fi
done

echo "======================================"
echo ""

echo "    { NULL, 0 }" >> ${FILE}
echo "};" >> ${FILE}

echo "void execute_module( const char *module_name,\
 SCANNER *scanner );" >> ${FILE}

echo "#endif" >> ${FILE}

# now make sure we really need to update the modules.h file!

if [ -f ${REAL_FILE} ]; then

    DIFFS=`diff ${FILE} ${REAL_FILE}`

	if [ "${DIFFS}" != "" ]; then
		echo "Found new modules, updating ${REAL_FILE}"
		cp ${FILE} ${REAL_FILE}
		rm ${FILE}
	fi
else
	cp ${FILE} ${REAL_FILE}
fi
