// -*- C++ -*-
//========================================================================
//
// ocfile.h
//
// Drop-in replacement for C <stdio.h> FILE 
//
//========================================================================

#ifndef OCFILE_H
#define OCFILE_H

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>

//------------------------------------------------------------------------

class QIODevice;

struct OCFILE {
  QIODevice *iDevice;
};

#ifdef ungetc
#undef ungetc
#endif

extern OCFILE *ocfopen(const char *name, const char *mode);
extern OCFILE *ocfopen(QIODevice *device);
extern void fclose(OCFILE *f);
extern size_t fwrite(const void *buf, size_t size, size_t count, OCFILE *f);
extern size_t fread(void *buf, size_t size, size_t count, OCFILE *f);
extern int fseek(OCFILE *f, long offset, int whence);
extern long ftell(OCFILE *f);
extern int fgetc(OCFILE *f);
extern int fputc(int ch, OCFILE *f);
extern void ungetc(int ch, OCFILE *f);
extern void fputs(const char *s, OCFILE *f);
extern void fprintf(OCFILE *f, const char *fmt, int a1 = 0, int a2 = 0);
extern void fprintf(OCFILE *f, const char *fmt, const char *s);

// Just like fgets, but handles Unix, Mac, and/or DOS end-of-line
// conventions (from Xpdf).
extern char *getLine(char *buf, int size, OCFILE *f);

// --------------------------------------------------------------------
#endif
