/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-2000 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#if defined unicos || defined SunOS
#include <fcntl.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#include <sys/types.h>
#include <sys/wait.h>
#include "main.h"

extern short get_var_from_pftprc(FILE *, const char *, char *, int);


short set_prog(char **pa, char *pname)
{
   char last = '\0', *str=NULL, *tmp=NULL;
   int h=0;

   if (!(str = getenv(pname))) {
      MEM_CHECK((str = (char *) calloc(SONAME, sizeof(char))));
      if (!get_var_from_pftprc((FILE *)NULL, pname, str, 0)) {
         free(str);
         return 0;
      }
   }

   MEM_CHECK((*pa = (char *)calloc(SONAME, sizeof(char))));

   for (tmp=str;*tmp == ' ' && *tmp; tmp++);
   for (h=0; *tmp; tmp++) {
      if (*tmp != ' ') {
         *(*pa+h) = *tmp;
         h++;
      }
      else if (last != ' ') {
         *(*pa+h) = '\0';
         pa++;
         h = 0;
         MEM_CHECK((*pa = (char *)calloc(SONAME, sizeof(char))));
      }
      last = *tmp;
   }
   *(*pa+h) = '\0';
   if (!getenv(pname)) free(str);
   if (!**pa) *pa = NULL;
   else {
      pa++;
      *pa = NULL;
   }

   return 1;
}


char **run_prog(char **pa, char *file)
{
   int pid=0;
   char **tmp;

   for (tmp=pa; *tmp; tmp++);
   *tmp++ = file;
   *tmp-- = NULL;
   if ((pid = fork()) < 0) {
      if (slfp) fprintf(slfp, "** fork: %s\n", _PFTP_ERROR_ARRAY_);
      exit(PFTP_FORK_ERR);
   }
   
   if (!pid) {
      execvp(*pa, pa);
      if (slfp) fprintf(slfp, "** exec: %s: %s\n", *pa, _PFTP_ERROR_ARRAY_);
      exit(PFTP_PROG_ERR);
   }
   while (wait((int *)0) != pid);
   *tmp = NULL;

   return --tmp;
}


void create_data_info(char *data_info)
{
   char *editor[SONAME], **eptr;
   int fd=0;
#if defined Linux
   strcpy(data_info, "/tmp/.pftp.XXXXXX");
   if ((fd = mkstemp(data_info)) < 0) {
      sprintf(data_info, "/tmp/pftp_info_file_%d", getpid());
      if ((fd=open(data_info, O_RDWR | O_CREAT, 0600)) < 0) {
         fprintf(stderr, "** %s: %s\n", data_info, _PFTP_ERROR_ARRAY_);
         exit(PFTP_FILE_OPEN_ERR);
      }
   }
   else fchmod(fd, 0600);
#else
   if (!tmpnam(data_info)) {
      sprintf(data_info, "/tmp/pftp_info_file_%d", getpid());
   }

   /*
    * Set the permissions.
    */
   if ((fd=open(data_info, O_RDWR | O_CREAT, 0600)) < 0) {
      fprintf(stderr, "** %s: %s\n", data_info, _PFTP_ERROR_ARRAY_);
      exit(PFTP_FILE_OPEN_ERR);
   }
#endif
   close(fd);

   /*
    * Set editor.
    */
   if (!set_prog(editor, "PFTPEDITOR")) {
      MEM_CHECK((*editor = (char *)calloc(SONAME, sizeof(char))));
      strcpy(*editor, "vi");
      *(editor+1) = NULL;
   }

   for (eptr=run_prog(editor, data_info); eptr != editor; eptr--) free(*eptr);
   free(*editor);
}
