/*
** pork_screen.h - screen management.
** Copyright (C) 2002-2004 Ryan McCabe <ryan@numb.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License, version 2,
** as published by the Free Software Foundation.
*/

#ifndef __PORK_SCREEN_H
#define __PORK_SCREEN_H

extern struct screen screen;

enum {
	FOCUS_MSG,
	FOCUS_BUDDY
};

struct blist;
struct imwindow;
struct pork_acct;

#include <pork_events.h>
#include <pork_input.h>
#include <pork_bind.h>

struct screen {
	u_int32_t rows;
	u_int32_t cols;
	dlist_t *cur_window;
	dlist_t *window_list;
	dlist_t *timer_list;
	dlist_t *transfer_list;
	struct imwindow *status_win;
	dlist_t *acct_list;
	WINDOW *status_bar;
	u_int32_t quiet:1;
	struct pork_acct *null_acct;
	struct input input;
	struct binds binds;
	hash_t alias_hash;
	struct event events;
};

#define cur_window() ((struct imwindow *) (screen.cur_window->data))

int screen_init(u_int32_t rows, u_int32_t cols);
void screen_destroy(void);

int screen_renumber(struct imwindow *imwindow, u_int32_t refnum);
u_int32_t screen_get_new_refnum(void);
dlist_t *screen_find_refnum(u_int32_t refnum);

void screen_window_list_remove(dlist_t *node);
void screen_window_list_add(dlist_t *new_node);
void screen_add_window(struct imwindow *imwindow);
void screen_resize(u_int32_t rows, u_int32_t cols);
int screen_blist_width(struct blist *blist, u_int32_t new_width);

#endif
