/*
PsTitle.cc
*/

#include "PsTitle.h"
#include <sys/ioctl.h>
#include <sys/param.h>
#include <limits.h>

char *output;
char *DoprEnd;
int  SnprfOverflow;
int  SyslogErrno;

char * xalloc (register int sz)
  {
  register char *p;

  /* some systems can't handle size zero mallocs */
  if (sz <= 0) sz = 1;

  p = (char *)malloc((unsigned) sz);
  if (p == NULL)
    {
    fprintf (stderr, "!Out of memory!!");
    /* exit(EX_UNAVAILABLE); */
    }
  return (p);
  }

void dopr_outch (int c)
  {
#if 0
  if( iscntrl(c) && c != '\n' && c != '\t' ){
          c = '@' + (c & 0x1F);
          if( DoprEnd == 0 || output < DoprEnd )
                  *output++ = '^';
  }
#endif
  if( DoprEnd == 0 || output < DoprEnd )
          *output++ = c;
  else
           SnprfOverflow++;
  }

void fmtstr (char *value, int ljust, int len, int maxwidth)
  {
  int padlen, strlen;     /* amount to pad */

  if( value == 0 ){
          value = "<NULL>";
  }
  for( strlen = 0; value[strlen]; ++ strlen ); /* strlen */
  if (strlen > maxwidth && maxwidth)
    strlen = maxwidth;
  padlen = len - strlen;
  if( padlen < 0 ) padlen = 0;
  if( ljust ) padlen = -padlen;
  while( padlen > 0 ) {
          dopr_outch( ' ' );
          --padlen;
  }
  dostr( value, maxwidth );
  while( padlen < 0 ) {
          dopr_outch( ' ' );
          ++padlen;
    }
  }

void fmtnum (long value, int base, int dosign, int ljust, int len, int zpad)
  {
  int signvalue = 0;
  unsigned long uvalue;
  char convert[20];
  int place = 0;
  int padlen = 0; /* amount to pad */
  int caps = 0;

  /* DEBUGP(("value 0x%x, base %d, dosign %d, ljust %d, len %d, zpad %d\n",
          value, base, dosign, ljust, len, zpad )); */
  uvalue = value;
  if( dosign ){
          if( value < 0 ) {
                  signvalue = '-';
                  uvalue = -value;
          }
  }
  if( base < 0 ){
          caps = 1;
          base = -base;
  }
  do{
          convert[place++] =
                  (caps? "0123456789ABCDEF":"0123456789abcdef")
                   [uvalue % (unsigned)base  ];
          uvalue = (uvalue / (unsigned)base );
  }while(uvalue);
  convert[place] = 0;
  padlen = len - place;
  if( padlen < 0 ) padlen = 0;
  if( ljust ) padlen = -padlen;
  /* DEBUGP(( "str '%s', place %d, sign %c, padlen %d\n",
          convert,place,signvalue,padlen)); */
  if( zpad && padlen > 0 ){
          if( signvalue ){
                  dopr_outch( signvalue );
                  --padlen;
                  signvalue = 0;
          }
          while( padlen > 0 ){
                  dopr_outch( zpad );
                  --padlen;
          }
  }
  while( padlen > 0 ) {
          dopr_outch( ' ' );
          --padlen;
  }
  if( signvalue ) dopr_outch( signvalue );
  while( place > 0 ) dopr_outch( convert[--place] );
  while( padlen < 0 ){
          dopr_outch( ' ' );
          ++padlen;
  }
  }

void dostr (char *str, int cut)
  {
    if (cut) {
      while(*str && cut-- > 0) dopr_outch(*str++);
    } else {
      while(*str) dopr_outch(*str++);
    }
  }

void sm_dopr (char *buffer, const char *format, va_list args)
  {
       int ch;
       long value;
       int longflag  = 0;
       int pointflag = 0;
       int maxwidth  = 0;
       char *strvalue;
       int ljust;
       int len;
       int zpad;
//# if !HASSTRERROR && !defined(ERRLIST_PREDEFINED)
#if defined (HP) || defined (SUN)
        extern char *sys_errlist[];
        extern int sys_nerr;
#endif        
//# endif                

       output = buffer;
       while( (ch = *format++) != '\0' ){
               switch( ch ){
               case '%':
                       ljust = len = zpad = maxwidth = 0;
                       longflag = pointflag = 0;
               nextch:
                       ch = *format++;
                       switch( ch ){
                       case 0:
                               dostr( "**end of format**" , 0);
                               return;
                       case '-': ljust = 1; goto nextch;
                       case '0': /* set zero padding if len not set */
                               if(len==0 && !pointflag) zpad = '0';
                       case '1': case '2': case '3':
                       case '4': case '5': case '6':
                       case '7': case '8': case '9':
                               if (pointflag)
                                 maxwidth = maxwidth*10 + ch - '0';
                               else
                                 len = len*10 + ch - '0';
                               goto nextch;
                       case '*': 
                               if (pointflag)
                                 maxwidth = va_arg( args, int );
                               else
                                 len = va_arg( args, int );
                               goto nextch;
                       case '.': pointflag = 1; goto nextch;
                       case 'l': longflag = 1; goto nextch;
                       case 'u': case 'U':
                               /*fmtnum(value,base,dosign,ljust,len,zpad) */
                               if( longflag ){
                                       value = va_arg( args, long );
                               } else {
                                       value = va_arg( args, int );
                               }
                               fmtnum( value, 10,0, ljust, len, zpad ); break;
                       case 'o': case 'O':
                               /*fmtnum(value,base,dosign,ljust,len,zpad) */
                               if( longflag ){
                                       value = va_arg( args, long );
                               } else {
                                       value = va_arg( args, int );
                               }
                               fmtnum( value, 8,0, ljust, len, zpad ); break;
                       case 'd': case 'D':
                               if( longflag ){
                                       value = va_arg( args, long );
                               } else {
                                       value = va_arg( args, int );
                               }
                               fmtnum( value, 10,1, ljust, len, zpad ); break;
                       case 'x':
                               if( longflag ){
                                       value = va_arg( args, long );
                               } else {
                                       value = va_arg( args, int );
                               }
                               fmtnum( value, 16,0, ljust, len, zpad ); break;
                       case 'X':
                               if( longflag ){
                                       value = va_arg( args, long );
                               } else {
                                       value = va_arg( args, int );
                               }
                               fmtnum( value,-16,0, ljust, len, zpad ); break;
                       case 's':
                               strvalue = va_arg( args, char *);
                               if (maxwidth > 0 || !pointflag) {
                                 if (pointflag && len > maxwidth)
                                   len = maxwidth; /* Adjust padding */
                                 fmtstr( strvalue,ljust,len,maxwidth);
                               }
                               break;
                       case 'c':
                               ch = va_arg( args, int );
                               dopr_outch( ch ); break;
                       case 'm':
#if HASSTRERROR
                               dostr(strerror(SyslogErrno), 0);
#else
                               if (SyslogErrno < 0 || SyslogErrno >= sys_nerr) 
                               {
                                   dostr("Error ", 0);
                                   fmtnum(SyslogErrno, 10, 0, 0, 0, 0);
                               }
                               else
                                 { 
                                 dostr((char *)sys_errlist[SyslogErrno], 0);
                                 }
#endif
                               break;

                       case '%': dopr_outch( ch ); continue;
                       default:
                               dostr(  "???????" , 0);
                       }
                       break;
               default:
                       dopr_outch( ch );
                       break;
               }
       }
       *output = 0;
  }

    
int avsnprintf (char *str, size_t count, const char *fmt, va_list args)
  {
  str[0] = 0;
  DoprEnd = str + count - 1;
  SnprfOverflow = 0;
  sm_dopr( str, fmt, args );
  if (count > 0) DoprEnd[0] = 0;
  //if (SnprfOverflow && tTd(57, 2))
  //        printf("\navsnprintf overflow, len = %ld, str = %s",
  //                (long) count, shortenstring(str, MAXSHORTSTR));
  return strlen(str);
  }
  
/*
**  PROC_LIST_SET -- set pid task in process list
**
**      Parameters:
**              pid -- pid to set
**              task -- task of pid
**
**      Returns:
**              none.
*/
void proc_list_set (pid_t pid, char *task)
  {
  int i;
  static int   ProcListSize    = 0;
  static struct procs  *ProcListVec    = NULL;
  for (i = 0; i < ProcListSize; i++)
    {
    if (ProcListVec[i].proc_pid == pid)
      {
      if (ProcListVec[i].proc_task != NULL) free(ProcListVec[i].proc_task);
      ProcListVec[i].proc_task = newstr(task);
      break;
      }
    }
  }


/*
**  SETPROCTITLE -- set process title for ps
**
**      Parameters:
**              fmt -- a printf style format string.
**              a, b, c -- possible parameters to fmt.
**
**      Returns:
**              none.
**
**      Side Effects:
**              Clobbers argv of our main procedure so ps(1) will
**              display the title.
*/

#define SPT_NONE        0       /* don't use it at all */
#define SPT_REUSEARGV   1       /* cover argv with title information */
#define SPT_BUILTIN     2       /* use libc builtin */
#define SPT_PSTAT       3       /* use pstat(PSTAT_SETCMD, ...) */
#define SPT_PSSTRINGS   4       /* use PS_STRINGS->... */
#define SPT_SYSMIPS     5       /* use sysmips() supported by NEWS-OS 6 */
#define SPT_SCO         6       /* write kernel u. area */
#define SPT_CHANGEARGV  7       /* write our own strings into argv[] */

//PARA hpux
#if defined (HP)
#define SPT_TYPE       SPT_PSTAT
#endif

#ifndef SPT_TYPE
# define SPT_TYPE       SPT_REUSEARGV
#endif

#if SPT_TYPE != SPT_NONE && SPT_TYPE != SPT_BUILTIN

# if SPT_TYPE == SPT_PSTAT
#  include <sys/pstat.h>
# endif
# if SPT_TYPE == SPT_PSSTRINGS
#  include <machine/vmparam.h>
#  include <sys/exec.h>
#  ifndef PS_STRINGS    /* hmmmm....  apparently not available after all */
#   undef SPT_TYPE
#   define SPT_TYPE     SPT_REUSEARGV
#  else
#   ifndef NKPDE                        /* FreeBSD 2.0 */
#    define NKPDE 63
typedef unsigned int    *pt_entry_t;
#   endif
#  endif
# endif
# if SPT_TYPE == SPT_PSSTRINGS || SPT_TYPE == SPT_CHANGEARGV
#  define SETPROC_STATIC        static
# else
#  define SETPROC_STATIC
# endif

# if SPT_TYPE == SPT_SYSMIPS
#  include <sys/sysmips.h>
#  include <sys/sysnews.h>
# endif

# if SPT_TYPE == SPT_SCO
#  include <sys/immu.h>
#  include <sys/dir.h>
#  include <sys/user.h>
#  include <sys/fs/s5param.h>
#  if PSARGSZ > MAXLINE
#   define SPT_BUFSIZE  PSARGSZ
#  endif
# endif

# ifndef SPT_PADCHAR
#  define SPT_PADCHAR   ' '
# endif

#endif /* SPT_TYPE != SPT_NONE && SPT_TYPE != SPT_BUILTIN */

# ifndef SPT_BUFSIZE
#  define SPT_BUFSIZE   MAXLINE
# endif

/*
**  Pointers for setproctitle.
**      This allows "ps" listings to give more useful information.
*/

char            **Argv = NULL;          /* pointer to argument vector */
char            *LastArgv = NULL;       /* end of argv */

void initsetproctitle (int argc, char **argv, char **envp)
  {
  register int i, envpsize = 0;
  extern char **environ;

  /*Move the environment so setproctitle can use the space at the top of memory.*/

  for (i = 0; envp[i] != NULL; i++) envpsize += strlen(envp[i]) + 1;
  environ = (char **) xalloc(sizeof (char *) * (i + 1));
  for (i = 0; envp[i] != NULL; i++) environ[i] = newstr(envp[i]);
  environ[i] = NULL;

  Argv = argv;

  for (i = 0; i < argc; i++)
    {
    if (i==0 || LastArgv + 1 == argv[i]) LastArgv = argv[i] + strlen(argv[i]);
    else continue;
    }     
  for (i=0; envp[i] != NULL; i++)
    {
    if (LastArgv + 1 == envp[i]) LastArgv = envp[i] + strlen(envp[i]);
    else continue;
    }
  }

#if SPT_TYPE != SPT_BUILTIN
void setproctitle (const char *PREFIX, const char *fmt, ...)
{
# if SPT_TYPE != SPT_NONE
        register char *p;
        register int i;
        SETPROC_STATIC char buf[SPT_BUFSIZE];
        VA_LOCAL_DECL
#  if SPT_TYPE == SPT_PSTAT
        union pstun pst;
#  endif
#  if SPT_TYPE == SPT_SCO
        off_t seek_off;
        static int kmem = -1;
        static int kmempid = -1;
        struct user u;
#  endif

        /*AGUSTIN*/for (int h = 0; h < SPT_BUFSIZE; ++h) buf[h] = '\0';
         
        p = buf;

        /* print sendmail: heading for grep */
        (void) strncpy(p, PREFIX, SPT_BUFSIZE); 
        xstrncat (p, SPT_BUFSIZE, " ");
        p += strlen(p);

        /* print the argument string */
        VA_START(fmt);
        (void) avsnprintf(p, SPACELEFT(buf, p), fmt, ap);
        VA_END;

        i = strlen(buf);

#  if SPT_TYPE == SPT_PSTAT
        pst.pst_command = buf;
        pstat(PSTAT_SETCMD, pst, i, 0, 0);
#  endif
#  if SPT_TYPE == SPT_PSSTRINGS
        PS_STRINGS->ps_nargvstr = 1;
        PS_STRINGS->ps_argvstr = buf;
#  endif
#  if SPT_TYPE == SPT_SYSMIPS
        sysmips(SONY_SYSNEWS, NEWS_SETPSARGS, buf);
#  endif
#  if SPT_TYPE == SPT_SCO
        if (kmem < 0 || kmempid != getpid())
        {
                if (kmem >= 0)
                        close(kmem);
                kmem = open(_PATH_KMEM, O_RDWR, 0);
                if (kmem < 0)
                        return;
                (void) fcntl(kmem, F_SETFD, 1);
                kmempid = getpid();
        }
        buf[PSARGSZ - 1] = '\0';
        seek_off = UVUBLK + (off_t) u.u_psargs - (off_t) &u;
        if (lseek(kmem, (off_t) seek_off, SEEK_SET) == seek_off)
                (void) write(kmem, buf, PSARGSZ);
#  endif

#  if SPT_TYPE == SPT_REUSEARGV


        if (i > LastArgv - Argv[0] - 2)
        {
                i = LastArgv - Argv[0] - 2;
                buf[i] = '\0';
        }
        (void) strncpy(Argv[0], buf, strlen(buf)+1);
        p = &Argv[0][strlen(PREFIX) + strlen(buf)];
        
        while (p < LastArgv) *p++ = SPT_PADCHAR;
        
        Argv[1] = NULL;
#  endif



#  if SPT_TYPE == SPT_CHANGEARGV
        Argv[0] = buf;
        Argv[1] = 0;
#  endif
# endif /* SPT_TYPE != SPT_NONE */
}

#endif /* SPT_TYPE != SPT_BUILTIN */

/*
**  SM_SETPROCTITLE -- set process task and set process title for ps
**
**      Possibly set process status and call setproctitle() to
**      change the ps display.
**
**      Parameters:
**              status -- whether or not to store as process status
**              fmt -- a printf style format string.
**              a, b, c -- possible parameters to fmt.
**
**      Returns:
**              none.
*/
void sm_setproctitle (const char *PREFIX, bool status, const char *fmt, ...)
  {
  char buf[SPT_BUFSIZE];
  VA_LOCAL_DECL
  VA_START(fmt);
    
    
  memset (buf, '\0', SPT_BUFSIZE);  
    
  (void) avsnprintf(buf, SPT_BUFSIZE, fmt, ap);
  VA_END;
  if (status == true) proc_list_set(getpid(), buf);
  
  //DEBUG ("--%d--%s--%s--", SPT_BUFSIZE, fmt, buf);
  setproctitle(PREFIX, "%s", buf);
  }

