/* Copyright (C) 1999-2000 Bernhard Trummer
 * Copyright (C) 2003      Benjamin Drieu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: main.h,v $
 * Revision 1.6  2003/03/06 14:54:24  benj
 * Update copyrigth where it is necessary
 *
 * Revision 1.5  2003/02/18 12:56:50  bdrieu
 * - Update to make prestimel compile with g++-3.2
 * - Use Magick++ instead of Magick
 *
 * Revision 1.4  2001/09/02 12:48:00  slash
 * Make use of AM_PATH_XML and AM_PATH_XML2 in configure.in
 *
 * Revision 1.3  2001/04/27 20:02:50  slash
 * Make use of xmlChildrenNode and xmlRootNode.
 *
 * Revision 1.2  2001/04/20 15:40:36  slash
 * Make use of the function xmlGetProp().
 *
 * Revision 1.1.1.1  2001/01/30 18:36:54  slash
 * Initial release.
 *
 */

#ifndef MAIN_H
#define MAIN_H

#include <fstream>
#include <iostream>

#include "imagesize.h"
#include <Magick++.h>
#include <Magick++/Geometry.h>
#include <Magick++/Image.h>

//---------------------------------------------------------------------------
// Defines of some global options.
#define OPTION_VERSION "version"
#define OPTION_HELP "help"
#define OPTION_LATEX_OUTPUT "latex-output"
#define OPTION_PATH_TO_THEMES "path-to-themes"
#define OPTION_THEME "theme"
#define OPTION_CONFIG_FILE "config-file"
#define OPTION_DISABLE_XML_SETTINGS "disable-xml-settings"

//---------------------------------------------------------------------------
// Defines of options for the HTML-output.
#define OPTION_RESOLUTION "resolution"
#define OPTION_DISABLE_BACKGROUND "disable-background"
#define OPTION_DISABLE_HEADER "disable-header"
#define OPTION_DISABLE_FIRST_LAST "disable-first-last"
#define OPTION_DISABLE_NOTE_BUTTON "disable-note-button"
#define OPTION_SLOPPY_BUTTONS "sloppy-buttons"
#define OPTION_TOP_NAVIGATION "top-navigation"

//---------------------------------------------------------------------------
// Defines of the options for the LaTeX-output.
#define OPTION_PRINT_OUTLINE "print-outline"

//---------------------------------------------------------------------------
// The filenames for the navigation-buttons
#define BUTTON_PREV "prev.png"
#define BUTTON_NEXT "next.png"
#define BUTTON_FIRST "first.png"
#define BUTTON_LAST "last.png"
#define BUTTON_NOTE "note.png"

//---------------------------------------------------------------------------
// The filenames of the theme-stylesheets
#define STYLES "styles"
#define STYLES_EXT ".css"

//---------------------------------------------------------------------------
// The filenames of the background-images of the themes
#define BG_SLIDE "bg_slide"
#define BG_HEADER "bg_header"
#define PNG_EXT ".png"
#define JPG_EXT ".jpg"


//---------------------------------------------------------------------------
#define BUFFER_SIZE 256

/**
 * A buffer which will be used for the reading of the inputfile.
 */
extern char Buffer_[BUFFER_SIZE];


//---------------------------------------------------------------------------
/**
 * Defines a cleaner procedure for deleting a pointer.
 */
#define ZapPointer(x) if(x) { delete x; x=0; }

/**
 * Defines a cleaner procedure for deleting an array.
 */
#define ZapArray(x) if(x) { delete [] x; x=0; }

/**
 * A define for the output of a newline.
 */
#define ENDL printf("\n")


//---------------------------------------------------------------------------
/**
 * Count the lines of the inputfile, to produce better error-messages.
 */
extern unsigned int Current_Line_Number_;

/**
 * The number of errors in the inputfile.
 */
extern unsigned int Number_Of_Errors_;

//---------------------------------------------------------------------------
class Parameters;

/**
 * This class holds all parameters.
 */
extern Parameters Parameters_;

//---------------------------------------------------------------------------
class Presentation;

/**
 * A global pointer to the presentation.
 */
extern Presentation Presentation_;


//---------------------------------------------------------------------------
/**
 * A global filestream, where the Node-classes will write their output.
 */
extern std::ofstream Output_;


//---------------------------------------------------------------------------
/**
 * This function lists a short help for all commandline-options.
 */
extern void print_help_text();

//---------------------------------------------------------------------------
/**
 * This function lists all available themes in the current theme-directory.
 */
extern void list_available_themes();

//---------------------------------------------------------------------------
/**
 * This function parses the given commandline-parameters and updates the
 * variables in the class Parameters_.
 *
 * @param argc The number of parameters of the commandline
 * @param argv The parameter-array
 *
 * @return 0, if the parameters are correct, else -1
 */
extern int parse_commandline_options(int argc, char **argv);

//---------------------------------------------------------------------------
/**
 * This is the main function.
 *
 * @param argc The number of parameters of the commandline
 * @param argv The parameter-array
 *
 * @return 0, if the program runs through, else -1
 */
extern int main(int argc,char **argv);

//---------------------------------------------------------------------------
/**
 * This function copies a file.
 *
 * @param src The filename of the source-file
 * @param dst The filename of the destination-file
 *
 * @return 0, if everything is OK, else -1.
 */
extern int fcopy(const char *src, const char *dst);

//---------------------------------------------------------------------------
/**
 * This method extracts the dimension of the given image by calling the
 * function PingImage of the ImageMagick library.
 *
 * @param filename The filename of the image,
 *                 which dimension should be extracted.
 * @param size A pointer to an ImageSize structure,
 *             where the dimension will be written.
 *
 * @return  0, if everything is OK.
 *         -1, if the image doesn't exist.
 */
extern int ping_image(const char *filename, Magick::Geometry *size);

#endif //MAIN_H
