/* 
 * Prospect: a developer's system profiler.
 * GDB-based disassembler.
 *
 * COPYRIGHT (C) 2001-2004 Hewlett-Packard Company
 *
 * Author: Alex Tsariounov, HP
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: testprog.c,v 1.3 2004/01/09 20:29:27 type2 Exp $ */ 
 
/* A test program for dass */

#include <stdlib.h>
#include <stdio.h>
#include "dass.h"

#ifdef __ia64__
/* IA64 function pointers point to a structure like this */
struct fdesc {
    void *ip;
    void *gp;
};
#endif

/* some disassembly targets */
int
sub1()
{
    return 15;
}

int
sub2()
{
    return 31;
}

int
main(int argc, char **argv)
{
    void *handle;
    void *loc;
    char **array, **ptr;
    int  self=0;

    if (argc < 3) {
        if (argc!=1) {
            fprintf(stderr, "usage: %s a.out addr [addr] ...\n", argv[0]);
            exit(1);
        }
        else
            self=1;
    }

    if (!self) {
        if ((handle = dass_open(argv[1])) == NULL) {
            fprintf(stderr, "dass_open %s failed\n", argv[1]);
            perror("errno");
            exit(1);
        }
        argv+=2;
        argc-=2;
        while (argc--) {
            loc = (void *)strtoul(*argv++, NULL, 0);
            array = dass(handle, loc, loc+1);
            printf("dass returns %p\n", array);
            ptr = array;
            while ((ptr != NULL) && (*ptr != NULL)) {
                printf("%s\n", *ptr);
                ptr++;
            }
            dass_free(array);
        }
        printf("dass_close returns %d\n", dass_close(handle));
        return 0;
    }
        
    /* else do self disassembly if no args */
    if ((handle = dass_open(argv[0])) == NULL) {
        fprintf(stderr, "dass_open %s failed\n", argv[0]);
        exit(1);
    }
#ifdef __ia64__
    printf("Self disassembling from main() at %p:\n", 
           ((struct fdesc *)main)->ip);
    array = dass(handle, ((struct fdesc *)main)->ip,
                 ((struct fdesc *)main)->ip + 20);
#else
    printf("Self disassembling from main() at 0x%lx:\n", (long)main);
    array = dass(handle, (void*)main, (void*)main+20);
#endif
    printf("dass returns %p\n", array);
    ptr = array;
    while ((ptr != NULL) && (*ptr != NULL)) {
        printf("%s\n", *ptr);
        ptr++;
    }
    dass_free(array);

#ifdef __ia64__
    printf("Self disassembling from sub1() at %p:\n", 
           ((struct fdesc *)sub1)->ip);
    array = dass(handle, ((struct fdesc *)sub1)->ip,
                 ((struct fdesc *)sub1)->ip + 20);
#else
    printf("Self disassembling from sub1() at 0x%lx:\n", (long)sub1);
    array = dass(handle, (void*)sub1, (void*)sub1+20);
#endif
    printf("dass returns %p\n", array);
    ptr = array;
    while ((ptr != NULL) && (*ptr != NULL)) {
        printf("%s\n", *ptr);
        ptr++;
    }
    dass_free(array);

    printf("Self disassembling from 0x0:\n");
    array = dass(handle, (void*)0x0, (void*)0x0+20);
    printf("dass returns %p\n", array);
    ptr = array;
    while ((ptr != NULL) && (*ptr != NULL)) {
        printf("%s\n", *ptr);
        ptr++;
    }
    dass_free(array);

    printf("dass_close returns %d\n", dass_close(handle));
    return 0;
}
