#ifndef REC_PROC_H_INCLUDED
#define REC_PROC_H_INCLUDED /* allow multiple inclusions */

/* 
 * Prospect: a developer's system profiler.
 *
 * COPYRIGHT (C) 2001-2004 Hewlett-Packard Company
 *
 * Author: Alex Tsariounov, HP
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: rec_proc.h,v 1.6 2004/01/09 20:29:28 type2 Exp $ */

/*
 *  ------------------------ Prototypes --------------------------
 */
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void run_command(void);
void profile_user(process_t *p, unsigned long pc, unsigned int cpu);
void profile_sys(process_t *p, unsigned long pc, unsigned int cpu);
void profile_kernel(process_t *p, unsigned long pc, unsigned int cpu);
int add_map_to_proc(process_t *, char *);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  /* !REC_PROC_H_INCLUDED */

