# -*- perl -*-
# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: loader.t,v 1.3 2001/02/27 18:31:50 muaddie Exp $

use strict;
use Test;
use Data::Dumper;
use PSP::Loader;

my $n_iterations = 1;
my $n_tests = 68;
plan tests => $n_iterations * $n_tests;

my ($loader,$child,$gchild);
for (my $i=0; $i < $n_iterations; $i++) {

ok $loader = PSP::Loader->new("foo");
ok $loader->class_name() eq "foo";

ok $child = $loader->mount("bar");
ok $child->class_name() eq "foo::bar";
ok $child = $loader->mount("baz");
ok $child->class_name() eq "foo::baz";

ok $gchild = $child->mount("erf");
ok $gchild->class_name() eq "foo::erf";
ok $gchild = $child->mount("crunph");
ok $gchild->class_name() eq "foo::crunph";

ok $foo::this_var = ">>foo::this_var<<";
ok $loader->provide('$this_var');

ok $child->expect('$this_var');
ok $child->provide('$this_var');

ok $gchild->expect('$this_var');

ok !defined $foo::crunph::this_var;
ok !defined $foo::baz::this_var;
ok \$foo::baz::this_var ne \$foo::this_var;

ok $child->share();

ok $foo::baz::this_var eq ">>foo::this_var<<";
ok \$foo::baz::this_var eq \$foo::this_var;
ok !defined $foo::crunph::this_var;

ok $gchild->share();

ok $foo::baz::this_var eq ">>foo::this_var<<";
ok $foo::crunph::this_var eq ">>foo::this_var<<";

ok $foo::crunph::this_var = "yo";
ok $foo::baz::this_var eq "yo";
ok $foo::this_var eq "yo";

ok !$loader->unshare();

ok \$foo::baz::this_var ne \$foo::this_var;
ok !defined $foo::baz::this_var;
ok !defined $foo::crunph::this_var;
ok $foo::this_var eq "yo";

$loader->free();

ok $loader = PSP::Loader->new("FooPile","","piles");

ok $child = $loader->mount("hi");
ok $child->mount("subhi","aloha");
ok $child->mount("subhi2","ahoj");

ok $loader->auto_populate();
ok $loader->auto_populate("piles2");
#print $loader->dumper();

my $fake_cgi = {};
bless $fake_cgi, 'CGI';

my ($pile,$page_name) = $loader->map_page($fake_cgi,"/erf");

($pile,$page_name) = $loader->map_page($fake_cgi,"/erf");
ok ref($pile) eq "FooPile::erf";
ok $page_name eq "page__";

($pile,$page_name) = $loader->map_page($fake_cgi,"/erf/howdy/doody");
ok ref($pile) eq "FooPile::erf";
ok $page_name eq "page__howdy__doody";

($pile,$page_name) = $loader->map_page($fake_cgi,"/erf/hahaha.html");
ok ref($pile) eq "FooPile::erf";
ok $page_name eq "page__hahaha";

($pile,$page_name) = $loader->map_page($fake_cgi,"/hi/ahoj/tookytooky/oops");
ok ref($pile) eq "FooPile::subhi2";
ok $page_name eq "page__tookytooky__oops";

($pile,$page_name) = $loader->map_page($fake_cgi,"/hi/axoj/tookytooky/oops");
ok ref($pile) eq "FooPile::hi";
ok $page_name eq "page__axoj__tookytooky__oops";

($pile,$page_name) = $loader->map_page($fake_cgi,"/xi/ahoj/tookytooky/oops");
ok ! $pile;
ok ! $page_name;

($pile,$page_name) = $loader->map_page($fake_cgi,"/there/doobydowap");
ok ref($pile) eq "FooPile::there";
ok $page_name eq "page__doobydowap";

# Here, we now map a pile to "", which catches any URL not more
# specifically mapped to somewhere else.
ok $loader->mount("test","");

# Go ahead and re-test the URLs which previously worked to make sure
# they still work.
($pile,$page_name) = $loader->map_page($fake_cgi,"/erf");
ok ref($pile) eq "FooPile::erf";
ok $page_name eq "page__";

($pile,$page_name) = $loader->map_page($fake_cgi,"/erf/howdy/doody");
ok ref($pile) eq "FooPile::erf";
ok $page_name eq "page__howdy__doody";

($pile,$page_name) = $loader->map_page($fake_cgi,"/erf/hahaha.html");
ok ref($pile) eq "FooPile::erf";
ok $page_name eq "page__hahaha";

($pile,$page_name) = $loader->map_page($fake_cgi,"/hi/ahoj/tookytooky/oops");
ok ref($pile) eq "FooPile::subhi2";
ok $page_name eq "page__tookytooky__oops";

($pile,$page_name) = $loader->map_page($fake_cgi,"/hi/axoj/tookytooky/oops");
ok ref($pile) eq "FooPile::hi";
ok $page_name eq "page__axoj__tookytooky__oops";

($pile,$page_name) = $loader->map_page($fake_cgi,"/xi/ahoj/tookytooky/oops");
ok ref($pile) eq "FooPile::test";
ok $page_name eq "page__xi__ahoj__tookytooky__oops";

($pile,$page_name) = $loader->map_page($fake_cgi,"/there/doobydowap");
ok ref($pile) eq "FooPile::there";
ok $page_name eq "page__doobydowap";

$loader->free();
}
