package AtomicData::Phone;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: Phone.pm,v 1.1 2000/12/29 06:19:49 muaddib Exp $

use strict;

=head1 NAME

AtmoicData::Phone - for storing phone numbers

=head1 SYNOPSIS

see AtomicData.pm

=head1 DESCRIPTION

Implements data encapsulation for phone numbers

=cut

use AtomicData::Text;
@AtomicData::Phone::ISA = qw (AtomicData::Text);

=head1 METHODS

see AtomicData.pm for further methods.

=head2 canonicalize

see parent class for additional documentation.

=head2 _format

  instance
  (string $zip_code) _format (int $can_value)

DESCRIPTION:

Returns a formatted phone number.

=cut

sub _format {
  my ($this, $value) = @_;

  if ($this->{_format}->{numbers}) {
    $value =~ s/[abc]/2/ig;
    $value =~ s/[def]/3/ig;
    $value =~ s/[ghi]/4/ig;
    $value =~ s/[jkl]/5/ig;
    $value =~ s/[mno]/6/ig;
    $value =~ s/[prsq]/7/ig;
    $value =~ s/[tuv]/8/ig;
    $value =~ s/[wxyz]/9/ig;
  }

  if ($this->{_area_code} && $this->{_format}->{parens}) {
    $value =~ s/(\d{3})/\($1\)/;
  }

  if ($this->{_format}->{dots}) {
    $value =~ s/-/\./g;
  }
  if ($this->{_format}->{dash}) {
     $value =~ s/\./-/g;
  }
  
  return $value;
}

1;
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<AtomicData>, L<HTMLIO>, L<Field>.

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
