#!

# This is statement is required by the build system to query build info
if __name__ == '__build__':
	raise Exception

import sys
from OpenGL.GL import *
from OpenGL.GLE import *
from OpenGL.GLUT import *


class GLE_demo:

	def __init__(self):
		# initial mouse position
		self.lastx = 121
		self.lasty = 121

		# set the display mode and create the window
		glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH)
		glutCreateWindow("GLE demo")
		
		# setup the callbacks
		glutDisplayFunc(self.on_display)
		glutMotionFunc(self.on_motion)
		glutReshapeFunc(self.on_reshape)

		# 
		glClearDepth(1.0)
		glEnable(GL_DEPTH_TEST)
		glClearColor(0.0, 0.0, 0.0, 0.0)
		glShadeModel(GL_SMOOTH)

		glMatrixMode(GL_MODELVIEW)
		# initialize lighting */
		glLightfv(GL_LIGHT0, GL_POSITION,  (40.0, 40, 100.0, 0.0))
		glLightfv(GL_LIGHT0, GL_DIFFUSE, (0.99, 0.99, 0.99, 1.0))
		glEnable(GL_LIGHT0)
		glLightfv(GL_LIGHT1, GL_POSITION, (-40.0, 40, 100.0, 0.0))
		glLightfv(GL_LIGHT1, GL_DIFFUSE, (0.99, 0.99, 0.99, 1.0))
		glEnable(GL_LIGHT1)
		glEnable(GL_LIGHTING)
		glColorMaterial(GL_FRONT_AND_BACK, GL_DIFFUSE)
		glEnable(GL_COLOR_MATERIAL)


	def on_motion(self, x, y):
		# store the mouse coordinate
		self.lastx = x
		self.lasty = y
		# redisplay
		glutPostRedisplay()


	def on_reshape(self, width, height):
		# setup the viewport
		glViewport(0, 0, width, height)
		# setup the projection matrix
		glMatrixMode(GL_PROJECTION)
		glLoadIdentity()
		# calculate left/right and top/bottom clipping planes based the smallest square viewport
		a = 9.0/min(width, height)
		clipping_planes = (a*width, a*height)
		# setup the projection
		glFrustum(-clipping_planes[0], clipping_planes[0], -clipping_planes[1], clipping_planes[1], 50.0, 150.0)


	def on_display(self):
		# clear the buffer
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)

		# Set up the model view matrix
		glMatrixMode(GL_MODELVIEW)
		glLoadIdentity()
		glTranslatef(0.0, 0.0, -80.0)
		glRotatef(self.lastx, 0.0, 1.0, 0.0)
		glRotatef(self.lasty, 1.0, 0.0, 0.0)

		# a nice pale lime green
		glColor3f(0.6, 0.8, 0.3)

		# set the join styles for GLE
		gleSetJoinStyle(TUBE_NORM_EDGE | TUBE_JN_ANGLE | TUBE_JN_CAP)
		gleHelicoid(1.0, 6.0, 2.0, -3.0, 4.0, None, None, 0.0, 1080.0)

		# swap the buffer
		glutSwapBuffers()



if __name__ == '__main__':
	# initialize GLUT 
	glutInit(sys.argv)
	# create the demo window
	GLE_demo()
	# enter the event loop
	glutMainLoop ()
