#ifndef VISUAL_EXCEPTIONS_H
#define VISUAL_EXCEPTIONS_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#include <exception>
#include <boost/python/detail/wrap_python.hpp>

namespace visual { namespace python {

/* Base class for pythonic exceptions.  Some functions that check their arguments
 * may throw a subclass of Exception.  All of these exceptions are automatically translated to python
 * at the python/C++ barrier.  If one of these is caught and not propogated, no special action
 * needs to be taken to clear the exception (since python never saw it).
 * Each of these have a direct 1:1 conversion to python. 
 */
class Exception : public std::exception
{
 protected:
	char const* error;
 public:
	inline Exception( char const* str) : error(str) {}
	inline Exception( const Exception& other) : exception(other), error( other.error) {}
	
	inline const char* what( void) const throw()
	{ return error; }
	
	// Called by the translator to raise the appropriate python exception.
	virtual void raise();
};

class ZeroDivisionError : public Exception
{
 public:
 	inline ZeroDivisionError( const char* str) : Exception( str) {}
 	inline ZeroDivisionError() : Exception( NULL){}
 	virtual void raise();
	
};

void translate_exception( Exception e);
	
}} // !namespace visual::python

#endif // !VISUAL_BOOSTEXCEPTION_H
