/***************************************************************************
  style.cpp
  -------------------
  AHA-like style class
  -------------------
  Copyright 1999-2004, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include "style.h"
#include <qstringlist.h>

//////////////////////////////////////////////////////////////////////////////
// Construction, Destruction                                                //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// Style()
// -------
// Constructor

Style::Style(const QString name, const double &oglow, const double &oghi,
             const double &ibulow, const double &ibuhi, const double &srmlow,
             const double &srmhi)
    : name_(name), oglow_(oglow), oghi_(oghi), ibulow_(ibulow),
      ibuhi_(ibuhi), srmlow_(srmlow), srmhi_(srmhi)
{ ; }

//////////////////////////////////////////////////////////////////////////////
// Style(const Style &)
// --------------------
// Copy onstructor

Style::Style(const Style &s)
    : name_(s.name_), oglow_(s.oglow_), oghi_(s.oghi_), ibulow_(s.ibulow_),
      ibuhi_(s.ibuhi_), srmlow_(s.srmlow_), srmhi_(s.srmhi_)
{ ; }

//////////////////////////////////////////////////////////////////////////////
// ~Style()
// --------
// Destructor

Style::~Style() {}

//////////////////////////////////////////////////////////////////////////////
// Miscellaneous                                                            //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// operator=
// ---------
// Assignment operator

Style Style::operator=(const Style &s)
{
    if (&s != this) {
        name_ = s.name_;
        oglow_ = s.oglow_; oghi_ = s.oghi_;
        ibulow_ = s.ibulow_; ibuhi_ = s.ibuhi_;
        srmlow_ = s.srmlow_; srmhi_ = s.srmhi_;
    }
    return *this;
}

//////////////////////////////////////////////////////////////////////////////
// operator==
// ----------
// Equivalence operator

bool Style::operator==(const Style &s) const
{
    return ( (name_ == s.name_) &&
             (oglow_ == s.oglow_) &&
             (oghi_ == s.oghi_) &&
             (ibulow_ == s.ibulow_) &&
             (ibuhi_ == s.ibuhi_) &&
             (srmlow_ == s.srmlow_) &&
             (srmhi_ == s.srmhi_) );
}
