// command.h				emacs, this is written in -*-c++-*-
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

#ifndef COMMAND_H
#define COMMAND_H

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qdialog.h>

class CommandDialog : public QWidget
{
    Q_OBJECT
public:
    CommandDialog();

signals:
    void command_change();

protected slots:
    void edit_command(int);
    void edit_current();
    void add_new();
    void del_current();
    void set_buttons(int);

private:
    QListBox *lb;
    QPushButton *add, *del, *edit;
};

class CommandEditDialog : public QDialog
{
    Q_OBJECT
public:
    CommandEditDialog(QWidget *parent, bool add,
		      QString initial_name, QString initial_command);

    QLineEdit *name, *cmdline;

protected slots:
    void done(int ret);

protected:
    bool newcmd;
};

#endif // COMMAND_H

