#include "vumeter.h"
#include <qframe.h>
#include <qpainter.h>
#include <qdrawutil.h>
#include <qapplication.h>


VUMeter::VUMeter( QWidget *parent, const char *name, WFlags f ): QFrame( parent, name, f ),
	total_steps( 100 ),progress_val( -1 ),percentage( -1 )
{
 	setFrameStyle(QFrame::Panel | QFrame::Sunken);
	setLineWidth( 4);
  Needle=FALSE;
}

VUMeter::VUMeter( int totalSteps,QWidget *parent, const char *name, WFlags f )
    : QFrame( parent, name, f ),total_steps( totalSteps ),progress_val( -1 ),percentage( -1 )
{
 setFrameStyle(QFrame::Panel | QFrame::Sunken);
	setLineWidth( 4 );
 }

void VUMeter::reset()
{
    progress_val = -1;
    percentage = -1;
    update();
}

void VUMeter::setTotalSteps( int totalSteps )
{
  total_steps = totalSteps;
  if ( isVisible() )
    {
      repaint( FALSE );
    }
}

void VUMeter::setProgress( int progress )
{
  if ( progress == progress_val )
  	return;
    progress_val = progress;
    if ( isVisible() )
      {
	repaint( FALSE );
    }
}


void VUMeter::show()
{
  
  setFrameStyle(QFrame::Panel | QFrame::Sunken);
 setLineWidth( 4 );

  QFrame::show();
}


void VUMeter::drawContents( QPainter *p )
{
  int pw=0;
  int ph=0;
  const QRect bar = contentsRect();

  if (!Needle)
    {
      if (bar.width()>bar.height())
	{
	  pw = bar.width() * progress_val / total_steps;
	  p->setClipRect( bar.x(), bar.y(), pw,bar.height());
	}
      else
	{
	  ph = bar.height() * progress_val / total_steps;
	  p->setClipRect( bar.x(), bar.height()-ph,bar.width(), ph );
	}
      p->fillRect(bar,colorGroup().base());  
      if (bar.width()>bar.height())
	{
	  p->setClipRect( bar.x()+pw, bar.y(), bar.width()-pw, bar.height());
	}
      else
	{
	  p->setClipRect( bar.x(), bar.y(), bar.width(), bar.height()-ph);
	}
      p->fillRect(bar,colorGroup().background());
    }
else
  {
    p->setClipRect( bar.x(), bar.y(), bar.width(), bar.height());
    p->fillRect(bar,colorGroup().background());
    pw = bar.height() * progress_val / total_steps;
    p->setClipRect( bar.x(), bar.y()+bar.height()-pw-2, bar.width(),4);
    p->fillRect(bar,colorGroup().base());
  }
}







