/*
 *  appointment-data.c   -
 *
 *  Created: 20020224
 *
 *  Copyright (c) 2001, 2002 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: appointment-data.c,v 1.6 2002/03/09 19:55:03 tomek Exp $
 *
 */

#ifdef HAVE_CONFIG
# include <config.h>
#endif

#include <appointment-data.h>

#include <common.h>

/* Funkcja tworzca list pola wyboru dni. */
void create_days_list(appointment_data *data, gboolean start_entries)
{
    GtkCombo *combo;
    GList *list = NULL;
    gint no_days;
    gint old_day;
    gint i;
    gchar *str;
    
    g_assert(data != NULL);
    g_assert(data->appointment_window != NULL);
    
    /* Pobranie wskanika do pola wyboru dnia. */
    combo = GTK_COMBO(gtk_object_get_data(GTK_OBJECT(data->appointment_window),
	                                    start_entries ? "start_day_combo" : "end_day_combo"));
    g_assert(combo != NULL);
    
    /* Zapamitanie wartoci okrelajcej dzie daty. */
    old_day = (start_entries) ? data->start_day : data->end_day;
    
    /* Usunicie poprzedniej listy. */
    gtk_list_clear_items(GTK_LIST(combo->list), 0, -1);

    /* Ustalenie liczby dni w miesicu. */
    switch ((start_entries) ? data->start_month : data->end_month)
    {
        case 0:
	    g_assert_not_reached();
	case 4: case 6: case 9: case 11:
	    no_days = 30;
	    break;
	case 2:
	    if (((start_entries) ? data->start_year : data->end_year) % 4 == 0 &&
	        ((start_entries) ? data->start_year : data->end_year) % 100 != 0)
	        no_days = 29;
	    else
	        no_days = 28;
	    break;
	default:
	    no_days = 31;
	    break;
    }
    
    /* Utworzenie listy dni. */
    for (i = 1; i <= no_days; i++)
        list = g_list_append(list, (gpointer)g_strdup_printf("%d", i));
    gtk_combo_set_popdown_strings(combo, list);
    
    /* Zwalnianie pamici zajmowanej przez elementy listy. */
    g_list_foreach(list, free_list_item_callback, NULL);
    
    /* Zwalnianie pamici zajmowanej przez list. */
    g_list_free(list);
    
    /* Ustalanie pola edycji pola wyboru dnia. */
    if (old_day > no_days)
	old_day = 1;
	
    str = g_strdup_printf("%d", old_day);
    gtk_entry_set_text(GTK_ENTRY(combo->entry), str);
    g_free(str);
}
