#ifdef WITH_X
#include "shell.h"
#include "sub_process.h"
#include "../../module_registry.h"
#include "../../utils.h"

#include <gtk/gtk.h>

DataSetMap *Shell::moduleInfo = 0;

Module* shell_constructor()
{
        return new Shell();
}

const DataSetMap& Shell::get_module_info_instance()
{
        if (!moduleInfo) {
                moduleInfo = new DataSetMap();
                moduleInfo->set("description", DataSet("Run a shell script and monitor it's output"));
                moduleInfo->set("supported_vars", DataSet("runonce,execute,rerun"));
                moduleInfo->set("supported_var_types", DataSet("file,file,int"));
                moduleInfo->set("supported_var_defaults", DataSet(",,"));
                moduleInfo->set("overridable", DataSet("false,false,false"));
                moduleInfo->set("output_variables", DataSet("textline"));
        }
        return *moduleInfo;
}

extern "C" int shell_plugin_startup()
{
        ModuleRegistry::instance()->add_module("Shell", &shell_constructor, Shell::get_module_info_instance());
        return 0;
}

extern "C" void shell_plugin_shutdown()
{
        ModuleRegistry::instance()->remove_module("Shell");
        Shell::destroy_module_info();
}

static int timeout(Shell* data)
{
        data->execute();
        return true;
}

Shell::Shell()
        : periodic(NULL),
          runonce(NULL),
          timeoutHandle(-1)  
{
}

Shell::~Shell()
{
        if (timeoutHandle != -1)
                gtk_timeout_remove(timeoutHandle);
        
        if (periodic != NULL)
                delete periodic;
        periodic = NULL;
        if (runonce != NULL)
                delete runonce;
        runonce = NULL;
        
        rpdbgmsg(getName() << " module destroyed");
}

void Shell::service()
{
        Module::service();

        if (periodic != NULL) {
                try {
                        string text = read_line(periodic->from_process(), true);
                        if (text.length() > 0) {
                                DataSet msg;
                                msg.addString(text);
                                updateParent("textline", msg);
                        }
                } catch (FileException) {
                        if (!periodic->running()) {
                                delete periodic;
                                periodic = NULL;
                        }       
                }
        }
        
        if (runonce != NULL) {
                try {
                        string text = read_line(runonce->from_process(), true);
                        if (text.length() > 0) {
                                DataSet msg;
                                msg.addString(text);
                                updateParent("textline", msg);
                        }
                } catch (FileException) {
                        if (!runonce->running()) {
                                delete runonce;
                                runonce = NULL;
                        }       
                }
        }
}

void Shell::updated(const string& keyName, const DataSet& data)
{
	if (keyName == "rerun") {
                if (timeoutHandle != -1)
                        gtk_timeout_remove(timeoutHandle);
                int delay = data.getInt() * 1000;
                if (delay > 0)
                        timeoutHandle = gtk_timeout_add(delay, (GtkFunction) &timeout, this);
	}
        if (keyName == "runonce") {
                runonce_cmd = data.toString();
                if (runonce != NULL)
                        delete runonce;
                runonce = NULL;
                if (runonce_cmd != "") {
                        if (verbose)
                                cout << "running: \"" << runonce_cmd << "\"\n";
                        runonce = new SubProcess(runonce_cmd);
                }
        }
        if (keyName == "execute") {
                periodic_cmd = data.toString();
                if (periodic_cmd != "" && runonce == NULL) {
			execute();
		}
        }
//  	if (keyName == "textline") {
//  	    	fputs(data.getString().c_str(),fOut);
//  	}
}

void Shell::execute()
{
        if (periodic != NULL)
                delete periodic;
        periodic = NULL;
        if (periodic_cmd != "")
                periodic = new SubProcess(periodic_cmd);
}
#endif
