#ifdef WITH_X
/* contains code from xroottext http://web.purplefrog.com/~thoth/xroottext.html */

#include "rootwindow.h"
#include "drawing_area_registry.h"

#include <X11/Xutil.h>

#include <iostream>
using namespace std;

static Display *disp = 0;
static int usingDisp = 0; // how many things are using disp -- so we know when to close it
static string display;

static int x_error_handler(Display *dpy, XErrorEvent *ev)
{
        char buf[100];
        XGetErrorText(dpy, ev->type, buf, sizeof(buf) - 1);
        cerr << "X error occured: " << buf << endl;
        return 0;
}

void setDisplay(const string& newDisplay)
{
        display = newDisplay;
}

void openDisplay()
{
        if (usingDisp == 0) {
                XSetErrorHandler(&x_error_handler);
                if (!(disp = XOpenDisplay (display.c_str()))) {
                        cerr << "Error opening display." << endl;
                }
        }
        usingDisp++;
}

void closeDisplay()
{
        usingDisp--;
        if (usingDisp == 0)
                XCloseDisplay(disp);
}

Display *getDisplay()
{
        return disp;
}

void handle_x_events()
{
        if (!displayOpen())
                return;
        
        Display *dpy = getDisplay();
        XEvent ev;

        int num_expose = 0;
        int x_top, y_top, x_bottom, y_bottom;

        while (XPending(dpy) > 0) {
                XNextEvent(dpy, &ev);
                switch (ev.type) {
                        case Expose:
                                if (num_expose == 0) {
                                        x_top = ev.xexpose.x;
                                        y_top = ev.xexpose.y;
                                        x_bottom = x_top + ev.xexpose.width;
                                        y_bottom = y_top + ev.xexpose.height;
                                } else {
                                        x_top = min(ev.xexpose.x, x_top);
                                        y_top = min(ev.xexpose.y, y_top);
                                        x_bottom = max(ev.xexpose.x + ev.xexpose.width, x_bottom);
                                        y_bottom = max(ev.xexpose.y + ev.xexpose.height, y_bottom);
                                }
                                num_expose++;
//                                  DrawingAreaRegistry::instance()->exposed(&ev.xexpose);
                                break;
                        case NoExpose:
                                // no idea what this is about
                                break;
                        case GraphicsExpose:
                                // no idea what this is about either
                                break;
                        default:
                                cerr << "unexpected event type: " << ev.type << endl;
                }
        }
        if (num_expose > 0) {
                XExposeEvent expose;
                expose.x = x_top;
                expose.y = y_top;
                expose.width = x_bottom - x_top;
                expose.height = y_bottom - y_top;
                DrawingAreaRegistry::instance()->exposed(&expose);                
        }
}

bool displayOpen()
{
        return usingDisp != 0;
}
#endif
