#!/bin/sh
[ "$1" = "-h" ] && cat <<tac

This example tests the following features of the sanitizer:

  - Scanning of uuencoded attachments in text parts
  - Recognition of message/rfc822 in uuencoded attachments
  - Recursive scanning of message/rfc822 parts
  - Truncating excessively long words in headers

tac

$ANOMY/bin/sanitizer.pl -nofprot $SAN_CONF \
    'header_rev = 0' \
    'feat_testing = 1' \
    'file_list_2_policy = accept' \
    'file_list_2 = (?i)\.(txt|html)$' \
    'feat_log_inline = 1' \
    'feat_log_stderr = 0' <<EOF 2>test.log >test.out
From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
MIME-Version: 1.0
Sender: xxx@example.com
To: fake@example.com
Content-Type: multipart/mixed; boundary="=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV"

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Transfer-Encoding: 8bit

This is the text part that contains a uuencoded message with
some really evil, icky headers that need truncating.

begin 664 testfile
this is not uuencoded data

begin  testfile
M1G)O;2!X>'A 97AA;7!L92YC;VT@(%1H=2!!=6<@(#,@,#<Z,S(Z,3 @,C P
M, I2971U<FXM4&%T:#H@/'AX>\$!E>&%M<&QE+F-O;3X*4F5C96EV960Z(&9R
M;VT@97AA;7!L92YC;VT@*')O;W1 97AA;7!L92YC;VT@6S\$T.2XQ-#0N,C0U
M+C5=*0H)8GD@97AA;7!L92YC;VT@*#@N.2XS+S@N.2XS*2!W:71H(\$533510
M(&ED(\$A!03 Q,S U"@EF;W(@/&)R94!E>&%M<&QE+F-O;3X[(%1H=2P@,R!!
M=6<@,C P," P-SHS,CHP,R!'350*1G)O;3H@>'AX0&5X86UP;&4N8V]M"D1A
M=&4Z(%1H=2P@,R!!=6<@,C P," P-CHS.3HU.2!)3D-214%\$24),64Q/3D=4
M24U%6D].149)14Q\$"DUE<W-A9V4M260Z(#PR,# P,#@P,S V,SDN1T%!,C,W
M.#! 97AA;7!L92YC;VT^"DU)344M5F5R<VEO;CH@,2XP"E-E;F1E<CH@>'AX
M0&5X86UP;&4N8V]M"E1O.B!F86ME0&5X86UP;&4N8V]M('=I=&AA<F5A;&QY
M<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A
M;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY
M<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A
M;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY
M<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A
M;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY
M<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A
M;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY
M<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A
M;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY
M<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A;&QY<F5A
M;&QY<F5A;&QY<F5A;&QY<F5A;&QY;&]N9VAE861E<@I#;VYT96YT+51Y<&4Z
M(&UU;'1I<&%R="]M:7AE9#L@8F]U;F1A<GD](CUU8VMY(@H*+2T]=6-K>0I#
M;VYT96YT+51Y<&4Z('1E>'0O<&QA:6X[(&-H87)S970](FES;RTX.#4Y+3\$B
M"D-O;G1E;G0M5')A;G-F97(M16YC;V1I;F<Z(&5V:6EI:6EI:6EI:6EI:6EI
M:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI
M:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI
M:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI
M:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI
M:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI
M:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EI:6EL"@HM+3UU8VMY
#+2T*
end

This is a test of text following the uuencoded data.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV--
EOF
